/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.operation;

import java.time.Duration;
import java.time.Instant;

public interface TimeReference {
    public static final long MINIMUM_TICKS = 100L;
    public static final TimeReference DEFAULT = new Default();

    public long ticks();

    public void sleep(long var1) throws InterruptedException;

    public long ticksToMillisCeiling(long var1);

    public long toTicks(Duration var1);

    public Instant ticksToInstant(long var1);

    public static final class Default
    extends Milliseconds {
        private Default() {
        }

        @Override
        public long ticks() {
            return System.currentTimeMillis();
        }

        @Override
        public void sleep(long ticks) throws InterruptedException {
            Thread.sleep(ticks);
        }
    }

    public static abstract class Milliseconds
    implements TimeReference {
        @Override
        public long ticksToMillisCeiling(long ticks) {
            return ticks;
        }

        @Override
        public long toTicks(Duration v) {
            return v.toMillis();
        }

        @Override
        public Instant ticksToInstant(long ticks) {
            return Instant.ofEpochMilli(ticks);
        }
    }
}

