/*
 * Decompiled with CFR 0.152.
 */
package org.bspfsystems.yamlconfiguration.file;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.comments.CommentEventsCollector;
import org.yaml.snakeyaml.comments.CommentType;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.serializer.Serializer;

final class BSPFYaml
extends Yaml {
    private static final Field EVENTS = BSPFYaml.getEmitterField("events");
    private static final Field BLOCK_COMMENTS_COLLECTOR = BSPFYaml.getEmitterField("blockCommentsCollector");
    private static final Field IN_LINE_COMMENTS_COLLECTOR = BSPFYaml.getEmitterField("inlineCommentsCollector");

    private static Field getEmitterField(@NotNull String name) {
        Field field = null;
        try {
            field = Emitter.class.getDeclaredField(name);
            field.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            Logger.getLogger(BSPFYaml.class.getName()).log(Level.SEVERE, "Unable to access Field by name: " + name, e);
        }
        return field;
    }

    BSPFYaml(@NotNull BaseConstructor baseConstructor, @NotNull Representer representer, @NotNull DumperOptions dumperOptions, @NotNull LoaderOptions loaderOptions) {
        super(baseConstructor, representer, dumperOptions, loaderOptions);
    }

    @Override
    public void serialize(@NotNull Node node, @NotNull Writer writer) throws RuntimeException {
        Emitter emitter = new Emitter(writer, this.dumperOptions);
        if (EVENTS != null && BLOCK_COMMENTS_COLLECTOR != null && IN_LINE_COMMENTS_COLLECTOR != null) {
            ArrayDeque<Event> newEvents = new ArrayDeque<Event>(100);
            try {
                EVENTS.set(emitter, newEvents);
                BLOCK_COMMENTS_COLLECTOR.set(emitter, new CommentEventsCollector(newEvents, CommentType.BLANK_LINE, CommentType.BLOCK));
                IN_LINE_COMMENTS_COLLECTOR.set(emitter, new CommentEventsCollector(newEvents, CommentType.IN_LINE));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException("Cannot update Yaml event queue.", e);
            }
        }
        Serializer serializer = new Serializer(emitter, this.resolver, this.dumperOptions, null);
        try {
            serializer.open();
            serializer.serialize(node);
            serializer.close();
        }
        catch (IOException e) {
            throw new YAMLException(e);
        }
    }
}

