/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.signers;

import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptChunk;
import org.bitcoinj.signers.StatelessTransactionSigner;
import org.bitcoinj.signers.TransactionSigner;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.Wallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingSigResolutionSigner
extends StatelessTransactionSigner {
    private static final Logger log = LoggerFactory.getLogger(MissingSigResolutionSigner.class);
    public Wallet.MissingSigsMode missingSigsMode = Wallet.MissingSigsMode.USE_DUMMY_SIG;

    public MissingSigResolutionSigner() {
    }

    public MissingSigResolutionSigner(Wallet.MissingSigsMode missingSigsMode) {
        this.missingSigsMode = missingSigsMode;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public boolean signInputs(TransactionSigner.ProposedTransaction propTx, KeyBag keyBag) {
        if (this.missingSigsMode == Wallet.MissingSigsMode.USE_OP_ZERO) {
            return true;
        }
        int numInputs = propTx.partialTx.getInputs().size();
        byte[] dummySig = TransactionSignature.dummy().encodeToBitcoin();
        for (int i = 0; i < numInputs; ++i) {
            TransactionInput txIn = propTx.partialTx.getInput(i);
            if (txIn.getConnectedOutput() == null) {
                log.warn("Missing connected output, assuming input {} is already signed.", (Object)i);
                continue;
            }
            Script scriptPubKey = txIn.getConnectedOutput().getScriptPubKey();
            Script inputScript = txIn.getScriptSig();
            if (scriptPubKey.isPayToScriptHash() || scriptPubKey.isSentToMultiSig()) {
                int sigSuffixCount = scriptPubKey.isPayToScriptHash() ? 1 : 0;
                for (int j = 1; j < inputScript.getChunks().size() - sigSuffixCount; ++j) {
                    ScriptChunk scriptChunk = inputScript.getChunks().get(j);
                    if (!scriptChunk.equalsOpCode(0)) continue;
                    if (this.missingSigsMode == Wallet.MissingSigsMode.THROW) {
                        throw new TransactionSigner.MissingSignatureException();
                    }
                    if (this.missingSigsMode != Wallet.MissingSigsMode.USE_DUMMY_SIG) continue;
                    txIn.setScriptSig(scriptPubKey.getScriptSigWithSignature(inputScript, dummySig, j - 1));
                }
                continue;
            }
            if (!inputScript.getChunks().get(0).equalsOpCode(0)) continue;
            if (this.missingSigsMode == Wallet.MissingSigsMode.THROW) {
                throw new ECKey.MissingPrivateKeyException();
            }
            if (this.missingSigsMode != Wallet.MissingSigsMode.USE_DUMMY_SIG) continue;
            txIn.setScriptSig(scriptPubKey.getScriptSigWithSignature(inputScript, dummySig, 0));
        }
        return true;
    }
}

