/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.VersionedChecksummedBytes;
import org.bitcoinj.core.WrongNetworkException;

public class DumpedPrivateKey
extends VersionedChecksummedBytes {
    private boolean compressed;

    public static DumpedPrivateKey fromBase58(@Nullable NetworkParameters params, String base58) throws AddressFormatException {
        return new DumpedPrivateKey(params, base58);
    }

    DumpedPrivateKey(NetworkParameters params, byte[] keyBytes, boolean compressed) {
        super(params.getDumpedPrivateKeyHeader(), DumpedPrivateKey.encode(keyBytes, compressed));
        this.compressed = compressed;
    }

    private static byte[] encode(byte[] keyBytes, boolean compressed) {
        Preconditions.checkArgument((keyBytes.length == 32 ? 1 : 0) != 0, (Object)"Private keys must be 32 bytes");
        if (!compressed) {
            return keyBytes;
        }
        byte[] bytes = new byte[33];
        System.arraycopy(keyBytes, 0, bytes, 0, 32);
        bytes[32] = 1;
        return bytes;
    }

    @Deprecated
    public DumpedPrivateKey(@Nullable NetworkParameters params, String encoded) throws AddressFormatException {
        super(encoded);
        if (params != null && this.version != params.getDumpedPrivateKeyHeader()) {
            throw new WrongNetworkException(this.version, new int[]{params.getDumpedPrivateKeyHeader()});
        }
        if (this.bytes.length == 33 && this.bytes[32] == 1) {
            this.compressed = true;
            this.bytes = Arrays.copyOf(this.bytes, 32);
        } else if (this.bytes.length == 32) {
            this.compressed = false;
        } else {
            throw new AddressFormatException("Wrong number of bytes for a private key, not 32 or 33");
        }
    }

    public ECKey getKey() {
        ECKey key = ECKey.fromPrivate(this.bytes);
        return this.compressed ? key : key.decompress();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DumpedPrivateKey other = (DumpedPrivateKey)o;
        return this.version == other.version && this.compressed == other.compressed && Arrays.equals(this.bytes, other.bytes);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.version, this.compressed, Arrays.hashCode(this.bytes)});
    }
}

