/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.AddressMessage;
import org.bitcoinj.core.AlertMessage;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.FilteredBlock;
import org.bitcoinj.core.GetAddrMessage;
import org.bitcoinj.core.GetBlocksMessage;
import org.bitcoinj.core.GetDataMessage;
import org.bitcoinj.core.GetHeadersMessage;
import org.bitcoinj.core.GetUTXOsMessage;
import org.bitcoinj.core.HeadersMessage;
import org.bitcoinj.core.InventoryItem;
import org.bitcoinj.core.InventoryMessage;
import org.bitcoinj.core.MemoryPoolMessage;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.NotFoundMessage;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.PeerSocketHandler;
import org.bitcoinj.core.Ping;
import org.bitcoinj.core.Pong;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.PrunedException;
import org.bitcoinj.core.RejectMessage;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.UTXOsMessage;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.VersionAck;
import org.bitcoinj.core.VersionMessage;
import org.bitcoinj.core.listeners.AbstractPeerEventListener;
import org.bitcoinj.core.listeners.BlocksDownloadedEventListener;
import org.bitcoinj.core.listeners.ChainDownloadStartedEventListener;
import org.bitcoinj.core.listeners.GetDataEventListener;
import org.bitcoinj.core.listeners.OnTransactionBroadcastListener;
import org.bitcoinj.core.listeners.PeerConnectedEventListener;
import org.bitcoinj.core.listeners.PeerDisconnectedEventListener;
import org.bitcoinj.core.listeners.PreMessageReceivedEventListener;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.utils.ListenerRegistration;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.Wallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer
extends PeerSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(Peer.class);
    protected final ReentrantLock lock = Threading.lock("peer");
    private final NetworkParameters params;
    private final AbstractBlockChain blockChain;
    private final Context context;
    private final CopyOnWriteArrayList<ListenerRegistration<BlocksDownloadedEventListener>> blocksDownloadedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<ChainDownloadStartedEventListener>> chainDownloadStartedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<PeerConnectedEventListener>> connectedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<PeerDisconnectedEventListener>> disconnectedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<GetDataEventListener>> getDataEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<PreMessageReceivedEventListener>> preMessageReceivedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<OnTransactionBroadcastListener>> onTransactionEventListeners = new CopyOnWriteArrayList();
    private volatile boolean vDownloadData;
    private final VersionMessage versionMessage;
    private volatile int vDownloadTxDependencyDepth;
    private final AtomicInteger blocksAnnounced = new AtomicInteger();
    private final CopyOnWriteArrayList<Wallet> wallets;
    @GuardedBy(value="lock")
    private long fastCatchupTimeSecs;
    @GuardedBy(value="lock")
    private boolean downloadBlockBodies = true;
    @GuardedBy(value="lock")
    private boolean useFilteredBlocks = false;
    private volatile BloomFilter vBloomFilter;
    private FilteredBlock currentFilteredBlock = null;
    private int filteredBlocksReceived;
    @GuardedBy(value="lock")
    @Nullable
    private List<Sha256Hash> awaitingFreshFilter;
    private static final int RESEND_BLOOM_FILTER_BLOCK_COUNT = 25000;
    private final HashSet<Sha256Hash> pendingBlockDownloads = new HashSet();
    private final HashSet<TransactionConfidence> pendingTxDownloads = new HashSet();
    private volatile int vMinProtocolVersion;
    private final CopyOnWriteArrayList<GetDataRequest> getDataFutures;
    @GuardedBy(value="getAddrFutures")
    private final LinkedList<SettableFuture<AddressMessage>> getAddrFutures;
    @Nullable
    @GuardedBy(value="lock")
    private LinkedList<SettableFuture<UTXOsMessage>> getutxoFutures;
    private final ReentrantLock lastPingTimesLock = new ReentrantLock();
    @GuardedBy(value="lastPingTimesLock")
    private long[] lastPingTimes = null;
    private final CopyOnWriteArrayList<PendingPing> pendingPings;
    private static final int PING_MOVING_AVERAGE_WINDOW = 20;
    private volatile VersionMessage vPeerVersionMessage;
    private final SettableFuture<Peer> connectionOpenFuture = SettableFuture.create();
    private final SettableFuture<Peer> outgoingVersionHandshakeFuture = SettableFuture.create();
    private final SettableFuture<Peer> incomingVersionHandshakeFuture = SettableFuture.create();
    private final ListenableFuture<Peer> versionHandshakeFuture = Futures.transform((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{this.outgoingVersionHandshakeFuture, this.incomingVersionHandshakeFuture}), (Function)new Function<List<Peer>, Peer>(){

        @Nullable
        public Peer apply(@Nullable List<Peer> peers) {
            Preconditions.checkNotNull(peers);
            Preconditions.checkState((peers.size() == 2 && peers.get(0) == peers.get(1) ? 1 : 0) != 0);
            return peers.get(0);
        }
    });
    @GuardedBy(value="lock")
    private Sha256Hash lastGetBlocksBegin;
    @GuardedBy(value="lock")
    private Sha256Hash lastGetBlocksEnd;

    public Peer(NetworkParameters params, VersionMessage ver, @Nullable AbstractBlockChain chain, PeerAddress remoteAddress) {
        this(params, ver, remoteAddress, chain);
    }

    public Peer(NetworkParameters params, VersionMessage ver, PeerAddress remoteAddress, @Nullable AbstractBlockChain chain) {
        this(params, ver, remoteAddress, chain, Integer.MAX_VALUE);
    }

    public Peer(NetworkParameters params, VersionMessage ver, PeerAddress remoteAddress, @Nullable AbstractBlockChain chain, int downloadTxDependencyDepth) {
        super(params, remoteAddress);
        this.params = (NetworkParameters)Preconditions.checkNotNull((Object)params);
        this.versionMessage = (VersionMessage)Preconditions.checkNotNull((Object)ver);
        this.vDownloadTxDependencyDepth = chain != null ? downloadTxDependencyDepth : 0;
        this.blockChain = chain;
        this.vDownloadData = chain != null;
        this.getDataFutures = new CopyOnWriteArrayList();
        this.getAddrFutures = new LinkedList();
        this.fastCatchupTimeSecs = params.getGenesisBlock().getTimeSeconds();
        this.pendingPings = new CopyOnWriteArrayList();
        this.vMinProtocolVersion = params.getProtocolVersionNum(NetworkParameters.ProtocolVersion.PONG);
        this.wallets = new CopyOnWriteArrayList();
        this.context = Context.get();
        this.versionHandshakeFuture.addListener(new Runnable(){

            @Override
            public void run() {
                Peer.this.versionHandshakeComplete();
            }
        }, Threading.SAME_THREAD);
    }

    public Peer(NetworkParameters params, AbstractBlockChain blockChain, PeerAddress peerAddress, String thisSoftwareName, String thisSoftwareVersion) {
        this(params, new VersionMessage(params, blockChain.getBestChainHeight()), blockChain, peerAddress);
        this.versionMessage.appendToSubVer(thisSoftwareName, thisSoftwareVersion, null);
    }

    @Deprecated
    public void addEventListener(AbstractPeerEventListener listener) {
        this.addBlocksDownloadedEventListener(Threading.USER_THREAD, listener);
        this.addChainDownloadStartedEventListener(Threading.USER_THREAD, listener);
        this.addConnectedEventListener(Threading.USER_THREAD, listener);
        this.addDisconnectedEventListener(Threading.USER_THREAD, listener);
        this.addGetDataEventListener(Threading.USER_THREAD, listener);
        this.addOnTransactionBroadcastListener(Threading.USER_THREAD, listener);
        this.addPreMessageReceivedEventListener(Threading.USER_THREAD, listener);
    }

    @Deprecated
    public void addEventListener(AbstractPeerEventListener listener, Executor executor) {
        this.addBlocksDownloadedEventListener(executor, listener);
        this.addChainDownloadStartedEventListener(executor, listener);
        this.addConnectedEventListener(executor, listener);
        this.addDisconnectedEventListener(executor, listener);
        this.addGetDataEventListener(executor, listener);
        this.addOnTransactionBroadcastListener(executor, listener);
        this.addPreMessageReceivedEventListener(executor, listener);
    }

    @Deprecated
    public void removeEventListener(AbstractPeerEventListener listener) {
        this.removeBlocksDownloadedEventListener(listener);
        this.removeChainDownloadStartedEventListener(listener);
        this.removeConnectedEventListener(listener);
        this.removeDisconnectedEventListener(listener);
        this.removeGetDataEventListener(listener);
        this.removeOnTransactionBroadcastListener(listener);
        this.removePreMessageReceivedEventListener(listener);
    }

    public void addBlocksDownloadedEventListener(BlocksDownloadedEventListener listener) {
        this.addBlocksDownloadedEventListener(Threading.USER_THREAD, listener);
    }

    public void addBlocksDownloadedEventListener(Executor executor, BlocksDownloadedEventListener listener) {
        this.blocksDownloadedEventListeners.add(new ListenerRegistration<BlocksDownloadedEventListener>(listener, executor));
    }

    public void addChainDownloadStartedEventListener(ChainDownloadStartedEventListener listener) {
        this.addChainDownloadStartedEventListener(Threading.USER_THREAD, listener);
    }

    public void addChainDownloadStartedEventListener(Executor executor, ChainDownloadStartedEventListener listener) {
        this.chainDownloadStartedEventListeners.add(new ListenerRegistration<ChainDownloadStartedEventListener>(listener, executor));
    }

    public void addConnectedEventListener(PeerConnectedEventListener listener) {
        this.addConnectedEventListener(Threading.USER_THREAD, listener);
    }

    public void addConnectedEventListener(Executor executor, PeerConnectedEventListener listener) {
        this.connectedEventListeners.add(new ListenerRegistration<PeerConnectedEventListener>(listener, executor));
    }

    public void addDisconnectedEventListener(PeerDisconnectedEventListener listener) {
        this.addDisconnectedEventListener(Threading.USER_THREAD, listener);
    }

    public void addDisconnectedEventListener(Executor executor, PeerDisconnectedEventListener listener) {
        this.disconnectedEventListeners.add(new ListenerRegistration<PeerDisconnectedEventListener>(listener, executor));
    }

    public void addGetDataEventListener(GetDataEventListener listener) {
        this.addGetDataEventListener(Threading.USER_THREAD, listener);
    }

    public void addGetDataEventListener(Executor executor, GetDataEventListener listener) {
        this.getDataEventListeners.add(new ListenerRegistration<GetDataEventListener>(listener, executor));
    }

    public void addOnTransactionBroadcastListener(OnTransactionBroadcastListener listener) {
        this.addOnTransactionBroadcastListener(Threading.USER_THREAD, listener);
    }

    public void addOnTransactionBroadcastListener(Executor executor, OnTransactionBroadcastListener listener) {
        this.onTransactionEventListeners.add(new ListenerRegistration<OnTransactionBroadcastListener>(listener, executor));
    }

    public void addPreMessageReceivedEventListener(PreMessageReceivedEventListener listener) {
        this.addPreMessageReceivedEventListener(Threading.USER_THREAD, listener);
    }

    public void addPreMessageReceivedEventListener(Executor executor, PreMessageReceivedEventListener listener) {
        this.preMessageReceivedEventListeners.add(new ListenerRegistration<PreMessageReceivedEventListener>(listener, executor));
    }

    public boolean removeBlocksDownloadedEventListener(BlocksDownloadedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.blocksDownloadedEventListeners);
    }

    public boolean removeChainDownloadStartedEventListener(ChainDownloadStartedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.chainDownloadStartedEventListeners);
    }

    public boolean removeConnectedEventListener(PeerConnectedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.connectedEventListeners);
    }

    public boolean removeDisconnectedEventListener(PeerDisconnectedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.disconnectedEventListeners);
    }

    public boolean removeGetDataEventListener(GetDataEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.getDataEventListeners);
    }

    public boolean removeOnTransactionBroadcastListener(OnTransactionBroadcastListener listener) {
        return ListenerRegistration.removeFromList(listener, this.onTransactionEventListeners);
    }

    public boolean removePreMessageReceivedEventListener(PreMessageReceivedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.preMessageReceivedEventListeners);
    }

    public String toString() {
        PeerAddress addr = this.getAddress();
        return addr == null ? "Peer()" : addr.toString();
    }

    @Override
    protected void timeoutOccurred() {
        super.timeoutOccurred();
        if (!this.connectionOpenFuture.isDone()) {
            this.connectionClosed();
        }
    }

    @Override
    public void connectionClosed() {
        for (final ListenerRegistration<PeerDisconnectedEventListener> registration : this.disconnectedEventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((PeerDisconnectedEventListener)registration.listener).onPeerDisconnected(Peer.this, 0);
                }
            });
        }
    }

    @Override
    public void connectionOpened() {
        PeerAddress address = this.getAddress();
        log.info("Announcing to {} as: {}", address == null ? "Peer" : address.toSocketAddress(), (Object)this.versionMessage.subVer);
        this.sendMessage(this.versionMessage);
        this.connectionOpenFuture.set((Object)this);
    }

    public ListenableFuture<Peer> getConnectionOpenFuture() {
        return this.connectionOpenFuture;
    }

    public ListenableFuture<Peer> getVersionHandshakeFuture() {
        return this.versionHandshakeFuture;
    }

    @Override
    protected void processMessage(Message m) throws Exception {
        for (ListenerRegistration<PreMessageReceivedEventListener> registration : this.preMessageReceivedEventListeners) {
            if (registration.executor != Threading.SAME_THREAD || (m = ((PreMessageReceivedEventListener)registration.listener).onPreMessageReceived(this, m)) != null) continue;
            break;
        }
        if (m == null) {
            return;
        }
        if (this.currentFilteredBlock != null && !(m instanceof Transaction)) {
            this.endFilteredBlock(this.currentFilteredBlock);
            this.currentFilteredBlock = null;
        }
        if (!(m instanceof VersionMessage || m instanceof VersionAck || this.versionHandshakeFuture.isDone() && !this.versionHandshakeFuture.isCancelled())) {
            throw new ProtocolException("Received " + m.getClass().getSimpleName() + " before version handshake is complete.");
        }
        if (m instanceof Ping) {
            this.processPing((Ping)m);
        } else if (m instanceof Pong) {
            this.processPong((Pong)m);
        } else if (m instanceof NotFoundMessage) {
            this.processNotFoundMessage((NotFoundMessage)m);
        } else if (m instanceof InventoryMessage) {
            this.processInv((InventoryMessage)m);
        } else if (m instanceof Block) {
            this.processBlock((Block)m);
        } else if (m instanceof FilteredBlock) {
            this.startFilteredBlock((FilteredBlock)m);
        } else if (m instanceof Transaction) {
            this.processTransaction((Transaction)m);
        } else if (m instanceof GetDataMessage) {
            this.processGetData((GetDataMessage)m);
        } else if (m instanceof AddressMessage) {
            this.processAddressMessage((AddressMessage)m);
        } else if (m instanceof HeadersMessage) {
            this.processHeaders((HeadersMessage)m);
        } else if (m instanceof AlertMessage) {
            this.processAlert((AlertMessage)m);
        } else if (m instanceof VersionMessage) {
            this.processVersionMessage((VersionMessage)m);
        } else if (m instanceof VersionAck) {
            this.processVersionAck((VersionAck)m);
        } else if (m instanceof UTXOsMessage) {
            this.processUTXOMessage((UTXOsMessage)m);
        } else if (m instanceof RejectMessage) {
            log.error("{} {}: Received {}", new Object[]{this, this.getPeerVersionMessage().subVer, m});
        } else {
            log.warn("{}: Received unhandled message: {}", (Object)this, (Object)m);
        }
    }

    protected void processUTXOMessage(UTXOsMessage m) {
        SettableFuture<UTXOsMessage> future = null;
        this.lock.lock();
        try {
            if (this.getutxoFutures != null) {
                future = this.getutxoFutures.pollFirst();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (future != null) {
            future.set((Object)m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAddressMessage(AddressMessage m) {
        SettableFuture<AddressMessage> future;
        LinkedList<SettableFuture<AddressMessage>> linkedList = this.getAddrFutures;
        synchronized (linkedList) {
            future = this.getAddrFutures.poll();
            if (future == null) {
                return;
            }
        }
        future.set((Object)m);
    }

    private void processVersionMessage(VersionMessage m) throws ProtocolException {
        if (this.vPeerVersionMessage != null) {
            throw new ProtocolException("Got two version messages from peer");
        }
        this.vPeerVersionMessage = m;
        long peerTime = this.vPeerVersionMessage.time * 1000L;
        log.info("{}: Got version={}, subVer='{}', services=0x{}, time={}, blocks={}", new Object[]{this, this.vPeerVersionMessage.clientVersion, this.vPeerVersionMessage.subVer, this.vPeerVersionMessage.localServices, String.format(Locale.US, "%tF %tT", peerTime, peerTime), this.vPeerVersionMessage.bestHeight});
        if (!this.vPeerVersionMessage.hasBlockChain() || !this.params.allowEmptyPeerChain() && this.vPeerVersionMessage.bestHeight == 0L) {
            log.info("{}: Peer does not have a copy of the block chain.", (Object)this);
            this.close();
            return;
        }
        if (this.vPeerVersionMessage.bestHeight < 0L) {
            throw new ProtocolException("Peer reports invalid best height: " + this.vPeerVersionMessage.bestHeight);
        }
        this.sendMessage(new VersionAck());
        log.debug("{}: Incoming version handshake complete.", (Object)this);
        this.incomingVersionHandshakeFuture.set((Object)this);
    }

    private void processVersionAck(VersionAck m) throws ProtocolException {
        if (this.vPeerVersionMessage == null) {
            throw new ProtocolException("got a version ack before version");
        }
        if (this.outgoingVersionHandshakeFuture.isDone()) {
            throw new ProtocolException("got more than one version ack");
        }
        log.debug("{}: Outgoing version handshake complete.", (Object)this);
        this.outgoingVersionHandshakeFuture.set((Object)this);
    }

    private void versionHandshakeComplete() {
        log.debug("{}: Handshake complete.", (Object)this);
        this.setTimeoutEnabled(false);
        for (final ListenerRegistration<PeerConnectedEventListener> registration : this.connectedEventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((PeerConnectedEventListener)registration.listener).onPeerConnected(Peer.this, 1);
                }
            });
        }
        int version = this.vMinProtocolVersion;
        if (this.vPeerVersionMessage.clientVersion < version) {
            log.warn("Connected to a peer speaking protocol version {} but need {}, closing", (Object)this.vPeerVersionMessage.clientVersion, (Object)version);
            this.close();
        }
    }

    protected void startFilteredBlock(FilteredBlock m) {
        this.currentFilteredBlock = m;
        ++this.filteredBlocksReceived;
        if (this.filteredBlocksReceived % 25000 == 24999) {
            this.sendMessage(this.vBloomFilter);
        }
    }

    protected void processNotFoundMessage(NotFoundMessage m) {
        block0: for (GetDataRequest req : this.getDataFutures) {
            for (InventoryItem item : m.getItems()) {
                if (!item.hash.equals(req.hash)) continue;
                log.info("{}: Bottomed out dep tree at {}", (Object)this, (Object)req.hash);
                req.future.cancel(true);
                this.getDataFutures.remove(req);
                continue block0;
            }
        }
    }

    protected void processAlert(AlertMessage m) {
        try {
            if (m.isSignatureValid()) {
                log.info("Received alert from peer {}: {}", (Object)this, (Object)m.getStatusBar());
            } else {
                log.warn("Received alert with invalid signature from peer {}: {}", (Object)this, (Object)m.getStatusBar());
            }
        }
        catch (Throwable t) {
            log.error("Failed to check signature: bug in platform libraries?", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processHeaders(HeadersMessage m) throws ProtocolException {
        block21: {
            boolean downloadBlockBodies;
            long fastCatchupTimeSecs;
            this.lock.lock();
            try {
                if (this.blockChain == null) {
                    log.warn("Received headers when Peer is not configured with a chain.");
                    return;
                }
                fastCatchupTimeSecs = this.fastCatchupTimeSecs;
                downloadBlockBodies = this.downloadBlockBodies;
            }
            finally {
                this.lock.unlock();
            }
            try {
                Preconditions.checkState((!downloadBlockBodies ? 1 : 0) != 0, (Object)this.toString());
                for (int i = 0; i < m.getBlockHeaders().size(); ++i) {
                    boolean reachedTop;
                    Block header = m.getBlockHeaders().get(i);
                    boolean passedTime = header.getTimeSeconds() >= fastCatchupTimeSecs;
                    boolean bl = reachedTop = (long)this.blockChain.getBestChainHeight() >= this.vPeerVersionMessage.bestHeight;
                    if (!passedTime && !reachedTop) {
                        if (!this.vDownloadData) {
                            log.info("Lost download peer status, throwing away downloaded headers.");
                            return;
                        }
                        if (!this.blockChain.add(header)) {
                            throw new ProtocolException("Got unconnected header from peer: " + header.getHashAsString());
                        }
                    } else {
                        this.lock.lock();
                        try {
                            log.info("Passed the fast catchup time, discarding {} headers and requesting full blocks", (Object)(m.getBlockHeaders().size() - i));
                            this.downloadBlockBodies = true;
                            this.lastGetBlocksBegin = Sha256Hash.ZERO_HASH;
                            this.blockChainDownloadLocked(Sha256Hash.ZERO_HASH);
                        }
                        finally {
                            this.lock.unlock();
                        }
                        return;
                    }
                    this.invokeOnBlocksDownloaded(header, null);
                }
                if (m.getBlockHeaders().size() < 2000) break block21;
                this.lock.lock();
                try {
                    this.blockChainDownloadLocked(Sha256Hash.ZERO_HASH);
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (VerificationException e) {
                log.warn("Block header verification failed", (Throwable)e);
            }
            catch (PrunedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void processGetData(GetDataMessage getdata) {
        log.info("{}: Received getdata message: {}", (Object)this.getAddress(), (Object)getdata.toString());
        ArrayList<Message> items = new ArrayList<Message>();
        for (ListenerRegistration<GetDataEventListener> registration : this.getDataEventListeners) {
            List<Message> listenerItems;
            if (registration.executor != Threading.SAME_THREAD || (listenerItems = ((GetDataEventListener)registration.listener).getData(this, getdata)) == null) continue;
            items.addAll(listenerItems);
        }
        if (items.isEmpty()) {
            return;
        }
        log.info("{}: Sending {} items gathered from listeners to peer", (Object)this.getAddress(), (Object)items.size());
        for (Message item : items) {
            this.sendMessage(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTransaction(final Transaction tx) throws VerificationException {
        tx.verify();
        this.lock.lock();
        try {
            log.debug("{}: Received tx {}", (Object)this.getAddress(), (Object)tx.getHashAsString());
            TransactionConfidence confidence = tx.getConfidence();
            confidence.setSource(TransactionConfidence.Source.NETWORK);
            this.pendingTxDownloads.remove(confidence);
            if (this.maybeHandleRequestedData(tx)) {
                return;
            }
            if (this.currentFilteredBlock != null) {
                if (!this.currentFilteredBlock.provideTransaction(tx)) {
                    this.endFilteredBlock(this.currentFilteredBlock);
                    this.currentFilteredBlock = null;
                }
                return;
            }
            for (final Wallet wallet : this.wallets) {
                try {
                    if (!wallet.isPendingTransactionRelevant(tx)) continue;
                    if (this.vDownloadTxDependencyDepth > 0) {
                        Futures.addCallback(this.downloadDependencies(tx), (FutureCallback)new FutureCallback<List<Transaction>>(){

                            public void onSuccess(List<Transaction> dependencies) {
                                try {
                                    log.info("{}: Dependency download complete!", (Object)Peer.this.getAddress());
                                    wallet.receivePending(tx, dependencies);
                                }
                                catch (VerificationException e) {
                                    log.error("{}: Wallet failed to process pending transaction {}", (Object)Peer.this.getAddress(), (Object)tx.getHash());
                                    log.error("Error was: ", (Throwable)e);
                                }
                            }

                            public void onFailure(Throwable throwable) {
                                log.error("Could not download dependencies of tx {}", (Object)tx.getHashAsString());
                                log.error("Error was: ", throwable);
                            }
                        });
                        continue;
                    }
                    wallet.receivePending(tx, null);
                }
                catch (VerificationException e) {
                    log.error("Wallet failed to verify tx", (Throwable)e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        for (final ListenerRegistration<OnTransactionBroadcastListener> registration : this.onTransactionEventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((OnTransactionBroadcastListener)registration.listener).onTransaction(Peer.this, tx);
                }
            });
        }
    }

    public ListenableFuture<List<Transaction>> downloadDependencies(Transaction tx) {
        TransactionConfidence.ConfidenceType txConfidence = tx.getConfidence().getConfidenceType();
        Preconditions.checkArgument((txConfidence != TransactionConfidence.ConfidenceType.BUILDING ? 1 : 0) != 0);
        log.info("{}: Downloading dependencies of {}", (Object)this.getAddress(), (Object)tx.getHashAsString());
        final LinkedList<Transaction> results = new LinkedList<Transaction>();
        ListenableFuture<Object> future = this.downloadDependenciesInternal(this.vDownloadTxDependencyDepth, 0, tx, new Object(), results);
        final SettableFuture resultFuture = SettableFuture.create();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object ignored) {
                resultFuture.set((Object)results);
            }

            public void onFailure(Throwable throwable) {
                resultFuture.setException(throwable);
            }
        });
        return resultFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListenableFuture<Object> downloadDependenciesInternal(final int maxDepth, final int depth, Transaction tx, final Object marker, final List<Transaction> results) {
        final SettableFuture resultFuture = SettableFuture.create();
        final Sha256Hash rootTxHash = tx.getHash();
        CopyOnWriteArraySet<Sha256Hash> needToRequest = new CopyOnWriteArraySet<Sha256Hash>();
        for (TransactionInput input : tx.getInputs()) {
            needToRequest.add(input.getOutpoint().getHash());
        }
        this.lock.lock();
        try {
            ArrayList futures = Lists.newArrayList();
            GetDataMessage getdata = new GetDataMessage(this.params);
            if (needToRequest.size() > 1) {
                log.info("{}: Requesting {} transactions for depth {} dep resolution", new Object[]{this.getAddress(), needToRequest.size(), depth + 1});
            }
            for (Sha256Hash hash : needToRequest) {
                getdata.addTransaction(hash);
                GetDataRequest req = new GetDataRequest(hash, SettableFuture.create());
                futures.add(req.future);
                this.getDataFutures.add(req);
            }
            ListenableFuture successful = Futures.successfulAsList((Iterable)futures);
            Futures.addCallback((ListenableFuture)successful, (FutureCallback)new FutureCallback<List<Transaction>>(){

                public void onSuccess(List<Transaction> transactions) {
                    LinkedList childFutures = Lists.newLinkedList();
                    for (Transaction tx : transactions) {
                        if (tx == null) continue;
                        log.info("{}: Downloaded dependency of {}: {}", new Object[]{Peer.this.getAddress(), rootTxHash, tx.getHashAsString()});
                        results.add(tx);
                        if (depth + 1 >= maxDepth) continue;
                        childFutures.add(Peer.this.downloadDependenciesInternal(maxDepth, depth + 1, tx, marker, results));
                    }
                    if (childFutures.size() == 0) {
                        resultFuture.set(marker);
                    } else {
                        Futures.addCallback((ListenableFuture)Futures.successfulAsList((Iterable)childFutures), (FutureCallback)new FutureCallback<List<Object>>(){

                            public void onSuccess(List<Object> objects) {
                                resultFuture.set(marker);
                            }

                            public void onFailure(Throwable throwable) {
                                resultFuture.setException(throwable);
                            }
                        });
                    }
                }

                public void onFailure(Throwable throwable) {
                    resultFuture.setException(throwable);
                }
            });
            this.sendMessage(getdata);
        }
        catch (Exception e) {
            log.error("{}: Couldn't send getdata in downloadDependencies({})", (Object)this, (Object)tx.getHash());
            resultFuture.setException((Throwable)e);
            SettableFuture settableFuture = resultFuture;
            return settableFuture;
        }
        finally {
            this.lock.unlock();
        }
        return resultFuture;
    }

    protected void processBlock(Block m) {
        block13: {
            if (log.isDebugEnabled()) {
                log.debug("{}: Received broadcast block {}", (Object)this.getAddress(), (Object)m.getHashAsString());
            }
            if (this.maybeHandleRequestedData(m)) {
                return;
            }
            if (this.blockChain == null) {
                log.debug("Received block but was not configured with an AbstractBlockChain");
                return;
            }
            if (!this.vDownloadData) {
                log.debug("{}: Received block we did not ask for: {}", (Object)this.getAddress(), (Object)m.getHashAsString());
                return;
            }
            this.pendingBlockDownloads.remove(m.getHash());
            try {
                if (this.blockChain.add(m)) {
                    this.invokeOnBlocksDownloaded(m, null);
                    break block13;
                }
                this.lock.lock();
                try {
                    if (this.downloadBlockBodies) {
                        Block orphanRoot = (Block)Preconditions.checkNotNull((Object)this.blockChain.getOrphanRoot(m.getHash()));
                        this.blockChainDownloadLocked(orphanRoot.getHash());
                    } else {
                        log.info("Did not start chain download on solved block due to in-flight header download.");
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (VerificationException e) {
                log.warn("{}: Block verification failed", (Object)this.getAddress(), (Object)e);
            }
            catch (PrunedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void endFilteredBlock(FilteredBlock m) {
        block17: {
            if (log.isDebugEnabled()) {
                log.debug("{}: Received broadcast filtered block {}", (Object)this.getAddress(), (Object)m.getHash().toString());
            }
            if (!this.vDownloadData) {
                log.debug("{}: Received block we did not ask for: {}", (Object)this.getAddress(), (Object)m.getHash().toString());
                return;
            }
            if (this.blockChain == null) {
                log.debug("Received filtered block but was not configured with an AbstractBlockChain");
                return;
            }
            this.pendingBlockDownloads.remove(m.getBlockHeader().getHash());
            try {
                this.lock.lock();
                try {
                    if (this.awaitingFreshFilter != null) {
                        log.info("Discarding block {} because we're still waiting for a fresh filter", (Object)m.getHash());
                        this.awaitingFreshFilter.add(m.getHash());
                        return;
                    }
                    if (this.checkForFilterExhaustion(m)) {
                        log.info("Bloom filter exhausted whilst processing block {}, discarding", (Object)m.getHash());
                        this.awaitingFreshFilter = new LinkedList<Sha256Hash>();
                        this.awaitingFreshFilter.add(m.getHash());
                        this.awaitingFreshFilter.addAll(this.blockChain.drainOrphanBlocks());
                        return;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                if (this.blockChain.add(m)) {
                    this.invokeOnBlocksDownloaded(m.getBlockHeader(), m);
                    break block17;
                }
                this.lock.lock();
                try {
                    Block orphanRoot = (Block)Preconditions.checkNotNull((Object)this.blockChain.getOrphanRoot(m.getHash()));
                    this.blockChainDownloadLocked(orphanRoot.getHash());
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (VerificationException e) {
                log.warn("{}: FilteredBlock verification failed", (Object)this.getAddress(), (Object)e);
            }
            catch (PrunedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean checkForFilterExhaustion(FilteredBlock m) {
        boolean exhausted = false;
        for (Wallet wallet : this.wallets) {
            exhausted |= wallet.checkForFilterExhaustion(m);
        }
        return exhausted;
    }

    private boolean maybeHandleRequestedData(Message m) {
        boolean found = false;
        Sha256Hash hash = m.getHash();
        for (GetDataRequest req : this.getDataFutures) {
            if (!hash.equals(req.hash)) continue;
            req.future.set((Object)m);
            this.getDataFutures.remove(req);
            found = true;
        }
        return found;
    }

    private void invokeOnBlocksDownloaded(final Block block, final @Nullable FilteredBlock fb) {
        final int blocksLeft = Math.max(0, (int)this.vPeerVersionMessage.bestHeight - ((AbstractBlockChain)Preconditions.checkNotNull((Object)this.blockChain)).getBestChainHeight());
        for (final ListenerRegistration<BlocksDownloadedEventListener> registration : this.blocksDownloadedEventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((BlocksDownloadedEventListener)registration.listener).onBlocksDownloaded(Peer.this, block, fb, blocksLeft);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInv(InventoryMessage inv) {
        List<InventoryItem> items = inv.getItems();
        LinkedList<InventoryItem> transactions = new LinkedList<InventoryItem>();
        LinkedList<InventoryItem> blocks = new LinkedList<InventoryItem>();
        block7: for (InventoryItem item : items) {
            switch (item.type) {
                case Transaction: {
                    transactions.add(item);
                    continue block7;
                }
                case Block: {
                    blocks.add(item);
                    continue block7;
                }
            }
            throw new IllegalStateException("Not implemented: " + (Object)((Object)item.type));
        }
        boolean downloadData = this.vDownloadData;
        if (transactions.size() == 0 && blocks.size() == 1) {
            if (downloadData && this.blockChain != null) {
                if (!this.blockChain.isOrphan(((InventoryItem)blocks.get((int)0)).hash)) {
                    this.blocksAnnounced.incrementAndGet();
                }
            } else {
                this.blocksAnnounced.incrementAndGet();
            }
        }
        GetDataMessage getdata = new GetDataMessage(this.params);
        Iterator it = transactions.iterator();
        while (it.hasNext()) {
            InventoryItem item = (InventoryItem)it.next();
            TransactionConfidence conf = this.context.getConfidenceTable().seen(item.hash, this.getAddress());
            if (conf.numBroadcastPeers() > 1) {
                it.remove();
                continue;
            }
            if (conf.getSource().equals((Object)TransactionConfidence.Source.SELF)) {
                it.remove();
                continue;
            }
            log.debug("{}: getdata on tx {}", (Object)this.getAddress(), (Object)item.hash);
            getdata.addItem(item);
            this.pendingTxDownloads.add(conf);
        }
        boolean pingAfterGetData = false;
        this.lock.lock();
        try {
            if (blocks.size() > 0 && downloadData && this.blockChain != null) {
                for (InventoryItem item : blocks) {
                    if (this.blockChain.isOrphan(item.hash) && this.downloadBlockBodies) {
                        Block orphanRoot = (Block)Preconditions.checkNotNull((Object)this.blockChain.getOrphanRoot(item.hash));
                        this.blockChainDownloadLocked(orphanRoot.getHash());
                        continue;
                    }
                    if (this.pendingBlockDownloads.contains(item.hash)) continue;
                    if (this.vPeerVersionMessage.isBloomFilteringSupported() && this.useFilteredBlocks) {
                        getdata.addFilteredBlock(item.hash);
                        pingAfterGetData = true;
                    } else {
                        getdata.addItem(item);
                    }
                    this.pendingBlockDownloads.add(item.hash);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!getdata.getItems().isEmpty()) {
            this.sendMessage(getdata);
        }
        if (pingAfterGetData) {
            this.sendMessage(new Ping((long)(Math.random() * 9.223372036854776E18)));
        }
    }

    public ListenableFuture<Block> getBlock(Sha256Hash blockHash) {
        log.info("Request to fetch block {}", (Object)blockHash);
        GetDataMessage getdata = new GetDataMessage(this.params);
        getdata.addBlock(blockHash);
        return this.sendSingleGetData(getdata);
    }

    public ListenableFuture<Transaction> getPeerMempoolTransaction(Sha256Hash hash) {
        log.info("Request to fetch peer mempool tx  {}", (Object)hash);
        GetDataMessage getdata = new GetDataMessage(this.params);
        getdata.addTransaction(hash);
        return this.sendSingleGetData(getdata);
    }

    private ListenableFuture sendSingleGetData(GetDataMessage getdata) {
        Preconditions.checkArgument((getdata.getItems().size() == 1 ? 1 : 0) != 0);
        GetDataRequest req = new GetDataRequest(getdata.getItems().get((int)0).hash, SettableFuture.create());
        this.getDataFutures.add(req);
        this.sendMessage(getdata);
        return req.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<AddressMessage> getAddr() {
        SettableFuture future = SettableFuture.create();
        LinkedList<SettableFuture<AddressMessage>> linkedList = this.getAddrFutures;
        synchronized (linkedList) {
            this.getAddrFutures.add((SettableFuture<AddressMessage>)future);
        }
        this.sendMessage(new GetAddrMessage(this.params));
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDownloadParameters(long secondsSinceEpoch, boolean useFilteredBlocks) {
        this.lock.lock();
        try {
            if (secondsSinceEpoch == 0L) {
                this.fastCatchupTimeSecs = this.params.getGenesisBlock().getTimeSeconds();
                this.downloadBlockBodies = true;
            } else {
                this.fastCatchupTimeSecs = secondsSinceEpoch;
                if (this.blockChain != null && this.fastCatchupTimeSecs > this.blockChain.getChainHead().getHeader().getTimeSeconds()) {
                    this.downloadBlockBodies = false;
                }
            }
            this.useFilteredBlocks = useFilteredBlocks;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addWallet(Wallet wallet) {
        this.wallets.add(wallet);
    }

    public void removeWallet(Wallet wallet) {
        this.wallets.remove(wallet);
    }

    @GuardedBy(value="lock")
    private void blockChainDownloadLocked(Sha256Hash toHash) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        ArrayList<Sha256Hash> blockLocator = new ArrayList<Sha256Hash>(51);
        BlockStore store = ((AbstractBlockChain)Preconditions.checkNotNull((Object)this.blockChain)).getBlockStore();
        StoredBlock chainHead = this.blockChain.getChainHead();
        Sha256Hash chainHeadHash = chainHead.getHeader().getHash();
        if (Objects.equal((Object)this.lastGetBlocksBegin, (Object)chainHeadHash) && Objects.equal((Object)this.lastGetBlocksEnd, (Object)toHash)) {
            log.info("blockChainDownloadLocked({}): ignoring duplicated request: {}", (Object)toHash, (Object)chainHeadHash);
            for (Sha256Hash hash : this.pendingBlockDownloads) {
                log.info("Pending block download: {}", (Object)hash);
            }
            log.info(Throwables.getStackTraceAsString((Throwable)new Throwable()));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: blockChainDownloadLocked({}) current head = {}", new Object[]{this, toHash, chainHead.getHeader().getHashAsString()});
        }
        StoredBlock cursor = chainHead;
        for (int i = 100; cursor != null && i > 0; cursor = cursor.getPrev(store), --i) {
            blockLocator.add(cursor.getHeader().getHash());
            try {
                continue;
            }
            catch (BlockStoreException e) {
                log.error("Failed to walk the block chain whilst constructing a locator");
                throw new RuntimeException(e);
            }
        }
        if (cursor != null) {
            blockLocator.add(this.params.getGenesisBlock().getHash());
        }
        this.lastGetBlocksBegin = chainHeadHash;
        this.lastGetBlocksEnd = toHash;
        if (this.downloadBlockBodies) {
            GetBlocksMessage message = new GetBlocksMessage(this.params, blockLocator, toHash);
            this.sendMessage(message);
        } else {
            GetHeadersMessage message = new GetHeadersMessage(this.params, blockLocator, toHash);
            this.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlockChainDownload() {
        this.setDownloadData(true);
        final int blocksLeft = this.getPeerBlockHeightDifference();
        if (blocksLeft >= 0) {
            for (final ListenerRegistration<ChainDownloadStartedEventListener> registration : this.chainDownloadStartedEventListeners) {
                registration.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ((ChainDownloadStartedEventListener)registration.listener).onChainDownloadStarted(Peer.this, blocksLeft);
                    }
                });
            }
            this.lock.lock();
            try {
                this.blockChainDownloadLocked(Sha256Hash.ZERO_HASH);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void addPingTimeData(long sample) {
        this.lastPingTimesLock.lock();
        try {
            if (this.lastPingTimes == null) {
                this.lastPingTimes = new long[20];
                Arrays.fill(this.lastPingTimes, sample);
            } else {
                System.arraycopy(this.lastPingTimes, 1, this.lastPingTimes, 0, this.lastPingTimes.length - 1);
                this.lastPingTimes[this.lastPingTimes.length - 1] = sample;
            }
        }
        finally {
            this.lastPingTimesLock.unlock();
        }
    }

    public ListenableFuture<Long> ping() throws ProtocolException {
        return this.ping((long)(Math.random() * 9.223372036854776E18));
    }

    protected ListenableFuture<Long> ping(long nonce) throws ProtocolException {
        VersionMessage ver = this.vPeerVersionMessage;
        if (!ver.isPingPongSupported()) {
            throw new ProtocolException("Peer version is too low for measurable pings: " + ver);
        }
        PendingPing pendingPing = new PendingPing(nonce);
        this.pendingPings.add(pendingPing);
        this.sendMessage(new Ping(pendingPing.nonce));
        return pendingPing.future;
    }

    public long getLastPingTime() {
        this.lastPingTimesLock.lock();
        try {
            if (this.lastPingTimes == null) {
                long l = Long.MAX_VALUE;
                return l;
            }
            long l = this.lastPingTimes[this.lastPingTimes.length - 1];
            return l;
        }
        finally {
            this.lastPingTimesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPingTime() {
        this.lastPingTimesLock.lock();
        try {
            if (this.lastPingTimes == null) {
                long l = Long.MAX_VALUE;
                return l;
            }
            long sum = 0L;
            for (long i : this.lastPingTimes) {
                sum += i;
            }
            long l = (long)((double)sum / (double)this.lastPingTimes.length);
            return l;
        }
        finally {
            this.lastPingTimesLock.unlock();
        }
    }

    private void processPing(Ping m) {
        if (m.hasNonce()) {
            this.sendMessage(new Pong(m.getNonce()));
        }
    }

    protected void processPong(Pong m) {
        for (PendingPing ping : this.pendingPings) {
            if (m.getNonce() != ping.nonce) continue;
            this.pendingPings.remove(ping);
            ping.complete();
            return;
        }
    }

    public int getPeerBlockHeightDifference() {
        Preconditions.checkNotNull((Object)this.blockChain, (Object)"No block chain configured");
        int chainHeight = (int)this.getBestHeight();
        Preconditions.checkState((this.params.allowEmptyPeerChain() || chainHeight > 0 ? 1 : 0) != 0, (String)"Connected to peer with zero/negative chain height", (Object[])new Object[]{chainHeight});
        return chainHeight - this.blockChain.getBestChainHeight();
    }

    private boolean isNotFoundMessageSupported() {
        return this.vPeerVersionMessage.clientVersion >= NotFoundMessage.MIN_PROTOCOL_VERSION;
    }

    public boolean isDownloadData() {
        return this.vDownloadData;
    }

    public void setDownloadData(boolean downloadData) {
        this.vDownloadData = downloadData;
    }

    public VersionMessage getPeerVersionMessage() {
        return this.vPeerVersionMessage;
    }

    public VersionMessage getVersionMessage() {
        return this.versionMessage;
    }

    public long getBestHeight() {
        return this.vPeerVersionMessage.bestHeight + (long)this.blocksAnnounced.get();
    }

    public boolean setMinProtocolVersion(int minProtocolVersion) {
        this.vMinProtocolVersion = minProtocolVersion;
        VersionMessage ver = this.getPeerVersionMessage();
        if (ver != null && ver.clientVersion < minProtocolVersion) {
            log.warn("{}: Disconnecting due to new min protocol version {}, got: {}", new Object[]{this, minProtocolVersion, ver.clientVersion});
            this.close();
            return true;
        }
        return false;
    }

    public void setBloomFilter(BloomFilter filter) {
        this.setBloomFilter(filter, true);
    }

    public void setBloomFilter(BloomFilter filter, boolean andQueryMemPool) {
        Preconditions.checkNotNull((Object)filter, (Object)"Clearing filters is not currently supported");
        VersionMessage ver = this.vPeerVersionMessage;
        if (ver == null || !ver.isBloomFilteringSupported()) {
            return;
        }
        this.vBloomFilter = filter;
        log.debug("{}: Sending Bloom filter{}", (Object)this, (Object)(andQueryMemPool ? " and querying mempool" : ""));
        this.sendMessage(filter);
        if (andQueryMemPool) {
            this.sendMessage(new MemoryPoolMessage());
        }
        this.maybeRestartChainDownload();
    }

    private void maybeRestartChainDownload() {
        this.lock.lock();
        try {
            if (this.awaitingFreshFilter == null) {
                return;
            }
            if (!this.vDownloadData) {
                log.warn("Lost download peer status whilst awaiting fresh filter.");
                return;
            }
            this.ping().addListener(new Runnable(){

                @Override
                public void run() {
                    Peer.this.lock.lock();
                    Preconditions.checkNotNull((Object)Peer.this.awaitingFreshFilter);
                    GetDataMessage getdata = new GetDataMessage(Peer.this.params);
                    for (Sha256Hash hash : Peer.this.awaitingFreshFilter) {
                        getdata.addFilteredBlock(hash);
                    }
                    Peer.this.awaitingFreshFilter = null;
                    Peer.this.lock.unlock();
                    log.info("Restarting chain download");
                    Peer.this.sendMessage(getdata);
                    Peer.this.sendMessage(new Ping((long)(Math.random() * 9.223372036854776E18)));
                }
            }, Threading.SAME_THREAD);
        }
        finally {
            this.lock.unlock();
        }
    }

    public BloomFilter getBloomFilter() {
        return this.vBloomFilter;
    }

    public ListenableFuture<UTXOsMessage> getUTXOs(List<TransactionOutPoint> outPoints) {
        return this.getUTXOs(outPoints, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<UTXOsMessage> getUTXOs(List<TransactionOutPoint> outPoints, boolean includeMempool) {
        this.lock.lock();
        try {
            VersionMessage peerVer = this.getPeerVersionMessage();
            if (peerVer.clientVersion < 70002) {
                throw new ProtocolException("Peer does not support getutxos protocol version");
            }
            if ((peerVer.localServices & 3L) != 3L) {
                throw new ProtocolException("Peer does not support getutxos protocol flag: find Bitcoin XT nodes.");
            }
            SettableFuture future = SettableFuture.create();
            if (this.getutxoFutures == null) {
                this.getutxoFutures = new LinkedList();
            }
            this.getutxoFutures.add((SettableFuture<UTXOsMessage>)future);
            this.sendMessage(new GetUTXOsMessage(this.params, outPoints, includeMempool));
            SettableFuture settableFuture = future;
            return settableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDownloadTxDependencies() {
        return this.vDownloadTxDependencyDepth > 0;
    }

    public void setDownloadTxDependencies(boolean enable) {
        this.vDownloadTxDependencyDepth = enable ? Integer.MAX_VALUE : 0;
    }

    public void setDownloadTxDependencies(int depth) {
        this.vDownloadTxDependencyDepth = depth;
    }

    private class PendingPing {
        public SettableFuture<Long> future = SettableFuture.create();
        public final long nonce;
        public final long startTimeMsec;

        public PendingPing(long nonce) {
            this.nonce = nonce;
            this.startTimeMsec = Utils.currentTimeMillis();
        }

        public void complete() {
            if (!this.future.isDone()) {
                Long elapsed = Utils.currentTimeMillis() - this.startTimeMsec;
                Peer.this.addPingTimeData(elapsed);
                log.debug("{}: ping time is {} msec", (Object)Peer.this.toString(), (Object)elapsed);
                this.future.set((Object)elapsed);
            }
        }
    }

    private static class GetDataRequest {
        final Sha256Hash hash;
        final SettableFuture future;

        public GetDataRequest(Sha256Hash hash, SettableFuture future) {
            this.hash = hash;
            this.future = future;
        }
    }
}

