/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.core.ReadOnlyList;
import com.strobel.core.StrongBox;
import com.strobel.core.VerifyArgument;
import com.strobel.expressions.AssignBinaryExpression;
import com.strobel.expressions.BinaryExpression;
import com.strobel.expressions.BlockExpression;
import com.strobel.expressions.BlockN;
import com.strobel.expressions.CatchBlock;
import com.strobel.expressions.ConditionalExpression;
import com.strobel.expressions.Error;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionList;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.GotoExpression;
import com.strobel.expressions.IArgumentProvider;
import com.strobel.expressions.InvocationExpression;
import com.strobel.expressions.LabelExpression;
import com.strobel.expressions.LambdaExpression;
import com.strobel.expressions.LoopExpression;
import com.strobel.expressions.MemberExpression;
import com.strobel.expressions.MethodCallExpression;
import com.strobel.expressions.NewArrayExpression;
import com.strobel.expressions.NewExpression;
import com.strobel.expressions.ParameterExpression;
import com.strobel.expressions.ParameterExpressionList;
import com.strobel.expressions.SwitchCase;
import com.strobel.expressions.SwitchExpression;
import com.strobel.expressions.TryExpression;
import com.strobel.expressions.TypeBinaryExpression;
import com.strobel.expressions.UnaryExpression;
import com.strobel.reflection.Type;
import com.strobel.util.ContractUtils;
import com.strobel.util.TypeUtils;
import java.util.ArrayList;
import java.util.List;

final class StackSpiller {
    private final TempMaker _tm = new TempMaker();
    private final Stack _startingStack;
    private RewriteAction _lambdaRewrite;

    private StackSpiller(Stack stack) {
        this._startingStack = stack;
    }

    private void verifyTemps() {
        this._tm.verifyTemps();
    }

    private ParameterExpression makeTemp(Type type) {
        return this._tm.temp(type);
    }

    private int mark() {
        return this._tm.mark();
    }

    private void free(int mark) {
        this._tm.free(mark);
    }

    private ParameterExpression toTemp(Expression expression, StrongBox<Expression> save) {
        ParameterExpression temp = this.makeTemp(expression.getType());
        save.value = Expression.assign(temp, expression);
        return temp;
    }

    private static Expression makeBlock(ExpressionList<? extends Expression> expressions) {
        return new SpilledExpressionBlock(expressions);
    }

    private static void verifyRewrite(Result result, Expression node) {
        assert (result.Node != null);
        assert (result.Action == RewriteAction.None ^ node != result.Node) : "rewrite action does not match node object identity";
        assert (result.Node.getNodeType() != ExpressionType.Extension) : "extension nodes must be rewritten";
        assert (result.Action != RewriteAction.Copy || node.getNodeType() == result.Node.getNodeType() || node.canReduce()) : "rewrite action does not match node object kind";
        assert (TypeUtils.areReferenceAssignable(node.getType(), result.Node.getType())) : "rewritten object must be reference assignable to the original type";
    }

    private static <T extends Expression> T[] clone(ExpressionList<T> original, int max) {
        assert (original != null);
        assert (max < original.size());
        Expression[] clone = original.toArray();
        for (int i = max; i < clone.length; ++i) {
            clone[i] = null;
        }
        return clone;
    }

    private static <T> T[] clone(ReadOnlyList<T> original, int max) {
        assert (original != null);
        assert (max < original.size());
        Object[] clone = original.toArray();
        for (int i = max; i < clone.length; ++i) {
            clone[i] = null;
        }
        return clone;
    }

    static <T> LambdaExpression<T> analyzeLambda(LambdaExpression<T> lambda) {
        return lambda.accept(new StackSpiller(Stack.Empty));
    }

    <T> LambdaExpression<T> rewrite(LambdaExpression<T> lambda) {
        this.verifyTemps();
        Result body = this.rewriteExpressionFreeTemps(lambda.getBody(), this._startingStack);
        this._lambdaRewrite = body.getAction();
        this.verifyTemps();
        if (body.getAction() != RewriteAction.None) {
            Expression newBody = body.Node;
            if (!this._tm.getTemps().isEmpty()) {
                newBody = Expression.block(this._tm.getTempsList(), newBody);
            }
            return lambda.update(newBody, lambda.getParameters());
        }
        return lambda;
    }

    private Result rewriteExpressionFreeTemps(Expression expression, Stack stack) {
        int mark = this.mark();
        Result result = this.rewriteExpression(expression, stack);
        this.free(mark);
        return result;
    }

    private Result rewriteExpression(Expression node, Stack stack) {
        Result result;
        if (node == null) {
            return new Result(RewriteAction.None, null);
        }
        if (node.canReduce()) {
            return this.rewriteReducibleExpression(node, stack);
        }
        switch (node.getNodeType()) {
            case Add: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case And: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case AndAlso: {
                result = this.rewriteLogicalBinaryExpression(node, stack);
                break;
            }
            case ArrayLength: {
                result = this.rewriteUnaryExpression(node, stack);
                break;
            }
            case ArrayIndex: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case Call: {
                result = this.rewriteMethodCallExpression(node, stack);
                break;
            }
            case Coalesce: {
                result = this.rewriteLogicalBinaryExpression(node, stack);
                break;
            }
            case Conditional: {
                result = this.rewriteConditionalExpression(node, stack);
                break;
            }
            case Convert: {
                result = this.rewriteUnaryExpression(node, stack);
                break;
            }
            case ConvertChecked: {
                result = this.rewriteUnaryExpression(node, stack);
                break;
            }
            case Divide: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case Equal: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case ExclusiveOr: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case GreaterThan: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case GreaterThanOrEqual: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case Invoke: {
                result = this.rewriteInvocationExpression(node, stack);
                break;
            }
            case Lambda: {
                result = this.rewriteLambdaExpression(node, stack);
                break;
            }
            case LeftShift: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case LessThan: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case LessThanOrEqual: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case MemberAccess: {
                result = this.rewriteMemberExpression(node, stack);
                break;
            }
            case Modulo: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case Multiply: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case Negate: {
                result = this.rewriteUnaryExpression(node, stack);
                break;
            }
            case UnaryPlus: {
                result = this.rewriteUnaryExpression(node, stack);
                break;
            }
            case New: {
                result = this.rewriteNewExpression(node, stack);
                break;
            }
            case NewArrayInit: {
                result = this.rewriteNewArrayExpression(node, stack);
                break;
            }
            case NewArrayBounds: {
                result = this.rewriteNewArrayExpression(node, stack);
                break;
            }
            case Not: {
                result = this.rewriteUnaryExpression(node, stack);
                break;
            }
            case NotEqual: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case Or: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case OrElse: {
                result = this.rewriteLogicalBinaryExpression(node, stack);
                break;
            }
            case RightShift: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case UnsignedRightShift: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case Subtract: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case InstanceOf: {
                result = this.rewriteTypeBinaryExpression(node, stack);
                break;
            }
            case Assign: {
                result = this.rewriteAssignBinaryExpression(node, stack);
                break;
            }
            case Block: {
                result = this.rewriteBlockExpression(node, stack);
                break;
            }
            case Decrement: {
                result = this.rewriteUnaryExpression(node, stack);
                break;
            }
            case Extension: {
                result = this.rewriteExtensionExpression(node, stack);
                break;
            }
            case Goto: {
                result = this.rewriteGotoExpression(node, stack);
                break;
            }
            case Increment: {
                result = this.rewriteUnaryExpression(node, stack);
                break;
            }
            case Label: {
                result = this.rewriteLabelExpression(node, stack);
                break;
            }
            case Loop: {
                result = this.rewriteLoopExpression(node, stack);
                break;
            }
            case Switch: {
                result = this.rewriteSwitchExpression(node, stack);
                break;
            }
            case Throw: {
                result = this.rewriteThrowUnaryExpression(node, stack);
                break;
            }
            case Try: {
                result = this.rewriteTryExpression(node, stack);
                break;
            }
            case Unbox: {
                result = this.rewriteUnaryExpression(node, stack);
                break;
            }
            case TypeEqual: {
                result = this.rewriteTypeBinaryExpression(node, stack);
                break;
            }
            case OnesComplement: {
                result = this.rewriteUnaryExpression(node, stack);
                break;
            }
            case IsTrue: {
                result = this.rewriteUnaryExpression(node, stack);
                break;
            }
            case IsFalse: {
                result = this.rewriteUnaryExpression(node, stack);
                break;
            }
            case ReferenceEqual: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case ReferenceNotEqual: {
                result = this.rewriteBinaryExpression(node, stack);
                break;
            }
            case IsNull: {
                result = this.rewriteUnaryExpression(node, stack);
                break;
            }
            case IsNotNull: {
                result = this.rewriteUnaryExpression(node, stack);
                break;
            }
            case AddAssign: 
            case AndAssign: 
            case DivideAssign: 
            case ExclusiveOrAssign: 
            case LeftShiftAssign: 
            case ModuloAssign: 
            case MultiplyAssign: 
            case OrAssign: 
            case RightShiftAssign: 
            case UnsignedRightShiftAssign: 
            case SubtractAssign: 
            case PreIncrementAssign: 
            case PreDecrementAssign: 
            case PostIncrementAssign: 
            case PostDecrementAssign: {
                result = this.rewriteReducibleExpression(node, stack);
                break;
            }
            case Quote: 
            case Parameter: 
            case Constant: 
            case RuntimeVariables: 
            case DefaultValue: {
                return new Result(RewriteAction.None, node);
            }
            default: {
                throw ContractUtils.unreachable();
            }
        }
        StackSpiller.verifyRewrite(result, node);
        return result;
    }

    private Result rewriteReducibleExpression(Expression expr, Stack stack) {
        Result result = this.rewriteExpression(expr.reduce(), stack);
        return new Result(result.Action.or(RewriteAction.Copy), result.Node);
    }

    private Result rewriteTryExpression(Expression expr, Stack stack) {
        TryExpression node = (TryExpression)expr;
        Result body = this.rewriteExpression(node.getBody(), Stack.Empty);
        ReadOnlyList handlers = node.getHandlers();
        CatchBlock[] clone = null;
        RewriteAction action = body.Action;
        if (handlers != null) {
            int n = handlers.size();
            for (int i = 0; i < n; ++i) {
                RewriteAction currentAction = body.Action;
                CatchBlock handler = (CatchBlock)handlers.get(i);
                Expression filter = handler.getFilter();
                if (handler.getFilter() != null) {
                    Result rFault = this.rewriteExpression(handler.getFilter(), Stack.Empty);
                    action = action.or(rFault.Action);
                    currentAction = currentAction.or(rFault.Action);
                    filter = rFault.Node;
                }
                Result rBody = this.rewriteExpression(handler.getBody(), Stack.Empty);
                action = action.or(rBody.Action);
                if ((currentAction = currentAction.or(rBody.Action)) != RewriteAction.None) {
                    handler = Expression.makeCatch(handler.getTest(), handler.getVariable(), rBody.Node, filter);
                    if (clone == null) {
                        clone = (CatchBlock[])StackSpiller.clone(handlers, i);
                    }
                }
                if (clone == null) continue;
                clone[i] = handler;
            }
        }
        Result rFinally = this.rewriteExpression(node.getFinallyBlock(), Stack.Empty);
        action = action.or(rFinally.Action);
        if (stack != Stack.Empty) {
            action = RewriteAction.SpillStack;
        }
        if (action != RewriteAction.None) {
            if (clone != null) {
                handlers = new ReadOnlyList(clone);
            }
            return new Result(action, new TryExpression(node.getType(), body.Node, (ReadOnlyList<CatchBlock>)handlers, rFinally.Node));
        }
        return new Result(action, expr);
    }

    private Result rewriteThrowUnaryExpression(Expression expr, Stack stack) {
        UnaryExpression node = (UnaryExpression)expr;
        Result value = this.rewriteExpressionFreeTemps(node.getOperand(), Stack.Empty);
        RewriteAction action = value.Action;
        if (stack != Stack.Empty) {
            action = RewriteAction.SpillStack;
        }
        if (action != RewriteAction.None) {
            return new Result(action, Expression.makeThrow(value.Node, node.getType()));
        }
        return new Result(action, expr);
    }

    private Result rewriteSwitchExpression(Expression expr, Stack stack) {
        SwitchExpression node = (SwitchExpression)expr;
        Result switchValue = this.rewriteExpressionFreeTemps(node.getSwitchValue(), stack);
        RewriteAction action = switchValue.Action;
        ReadOnlyList cases = node.getCases();
        SwitchCase[] clone = null;
        int n = cases.size();
        for (int i = 0; i < n; ++i) {
            Expression[] cloneTests = null;
            SwitchCase switchCase = (SwitchCase)cases.get(i);
            ExpressionList testValues = switchCase.getTestValues();
            int m = testValues.size();
            for (int j = 0; j < m; ++j) {
                Result test = this.rewriteExpression(testValues.get(j), stack);
                action = action.or(test.Action);
                if (cloneTests == null && test.Action != RewriteAction.None) {
                    cloneTests = StackSpiller.clone(testValues, (int)j);
                }
                if (cloneTests == null) continue;
                cloneTests[j] = test.Node;
            }
            Result body = this.rewriteExpression(switchCase.getBody(), stack);
            action = action.or(body.Action);
            if (body.Action != RewriteAction.None || cloneTests != null) {
                if (cloneTests != null) {
                    testValues = new ExpressionList(cloneTests);
                }
                switchCase = new SwitchCase(body.Node, testValues);
                if (clone == null) {
                    clone = (SwitchCase[])StackSpiller.clone(cases, i);
                }
            }
            if (clone == null) continue;
            clone[i] = switchCase;
        }
        Result defaultBody = this.rewriteExpression(node.getDefaultBody(), stack);
        if ((action = action.or(defaultBody.Action)) != RewriteAction.None) {
            if (clone != null) {
                cases = new ReadOnlyList(clone);
            }
            return new Result(action, new SwitchExpression(node.getType(), switchValue.Node, defaultBody.Node, node.getComparison(), (ReadOnlyList<SwitchCase>)cases, node.getOptions()));
        }
        return new Result(action, expr);
    }

    private Result rewriteLoopExpression(Expression expr, Stack stack) {
        LoopExpression node = (LoopExpression)expr;
        Result body = this.rewriteExpression(node.getBody(), Stack.Empty);
        RewriteAction action = body.Action;
        if (stack != Stack.Empty) {
            action = RewriteAction.SpillStack;
        }
        if (action != RewriteAction.None) {
            return new Result(action, new LoopExpression(body.getNode(), node.getBreakTarget(), node.getContinueTarget()));
        }
        return new Result(action, expr);
    }

    private Result rewriteLabelExpression(Expression expr, Stack stack) {
        LabelExpression node = (LabelExpression)expr;
        Result expression = this.rewriteExpression(node.getDefaultValue(), stack);
        if (expression.Action != RewriteAction.None) {
            return new Result(expression.Action, Expression.label(node.getTarget(), expression.Node));
        }
        return new Result(expression.Action, expr);
    }

    private Result rewriteGotoExpression(Expression expr, Stack stack) {
        GotoExpression node = (GotoExpression)expr;
        Result value = this.rewriteExpressionFreeTemps(node.getValue(), Stack.Empty);
        RewriteAction action = value.Action;
        if (stack != Stack.Empty) {
            action = RewriteAction.SpillStack;
        }
        if (action != RewriteAction.None) {
            return new Result(action, Expression.makeGoto(node.getKind(), node.getTarget(), value.Node, node.getType()));
        }
        return new Result(action, expr);
    }

    private Result rewriteExtensionExpression(Expression expr, Stack stack) {
        Result result = this.rewriteExpression(expr.reduceExtensions(), stack);
        return new Result(result.Action.or(RewriteAction.Copy), result.Node);
    }

    private Result rewriteBlockExpression(Expression expr, Stack stack) {
        BlockExpression node = (BlockExpression)expr;
        int count = node.getExpressionCount();
        RewriteAction action = RewriteAction.None;
        Expression[] clone = null;
        for (int i = 0; i < count; ++i) {
            Expression expression = node.getExpression(i);
            Result rewritten = this.rewriteExpression(expression, stack);
            action = action.or(rewritten.Action);
            if (clone == null && rewritten.Action != RewriteAction.None) {
                clone = StackSpiller.clone(node.getExpressions(), (int)i);
            }
            if (clone == null) continue;
            clone[i] = rewritten.Node;
        }
        if (action != RewriteAction.None) {
            return new Result(action, node.rewrite(null, clone));
        }
        return new Result(action, expr);
    }

    private Result rewriteAssignBinaryExpression(Expression expr, Stack stack) {
        BinaryExpression node = (BinaryExpression)expr;
        switch (node.getLeft().getNodeType()) {
            case MemberAccess: {
                return this.rewriteMemberAssignment(node, stack);
            }
            case Parameter: {
                return this.rewriteVariableAssignment(node, stack);
            }
            case Extension: {
                return this.rewriteExtensionAssignment(node, stack);
            }
        }
        throw Error.invalidLValue(node.getLeft().getNodeType());
    }

    private Result rewriteExtensionAssignment(BinaryExpression node, Stack stack) {
        Result result = this.rewriteAssignBinaryExpression(Expression.assign(node.getLeft().reduceExtensions(), node.getRight()), stack);
        return new Result(result.Action.or(RewriteAction.Copy), result.Node);
    }

    private Result rewriteVariableAssignment(BinaryExpression node, Stack stack) {
        Result right = this.rewriteExpression(node.getRight(), stack);
        if (right.Action != RewriteAction.None) {
            return new Result(right.Action, Expression.assign(node.getLeft(), right.Node));
        }
        return new Result(right.Action, node);
    }

    private Result rewriteMemberAssignment(BinaryExpression node, Stack stack) {
        MemberExpression lValue = (MemberExpression)node.getLeft();
        ChildRewriter cr = new ChildRewriter(stack, 2);
        cr.add(lValue.getTarget());
        cr.add(node.getRight());
        if (cr.didRewrite()) {
            return cr.Finish(new AssignBinaryExpression(MemberExpression.make(cr.get(0), lValue.getMember()), cr.get(1)));
        }
        return new Result(RewriteAction.None, node);
    }

    private Result rewriteNewArrayExpression(Expression expr, Stack stack) {
        NewArrayExpression node = (NewArrayExpression)expr;
        Stack newStack = node.getNodeType() == ExpressionType.NewArrayInit ? Stack.NonEmpty : stack;
        ChildRewriter cr = new ChildRewriter(newStack, node.getExpressions().size());
        cr.add(node.getExpressions());
        if (cr.didRewrite()) {
            Type element = node.getType().getElementType();
            if (node.getNodeType() == ExpressionType.NewArrayInit) {
                return cr.Finish(Expression.newArrayInit(element, cr.get(0, -1)));
            }
            return cr.Finish(Expression.newArrayBounds(element, cr.get(0)));
        }
        return cr.Finish(expr);
    }

    private Result rewriteNewExpression(Expression expr, Stack stack) {
        NewExpression node = (NewExpression)expr;
        ChildRewriter cr = new ChildRewriter(stack, node.getArgumentCount());
        cr.addArguments(node);
        return cr.Finish(cr.didRewrite() ? new NewExpression(node.getConstructor(), cr.get(0, -1)) : expr);
    }

    private Result rewriteMemberExpression(Expression expr, Stack stack) {
        MemberExpression node = (MemberExpression)expr;
        Result expression = this.rewriteExpression(node.getTarget(), stack);
        if (expression.Action != RewriteAction.None) {
            return new Result(expression.Action, MemberExpression.make(expression.Node, node.getMember()));
        }
        return new Result(expression.Action, expr);
    }

    private Result rewriteLambdaExpression(Expression expr, Stack stack) {
        LambdaExpression node = (LambdaExpression)expr;
        LambdaExpression analyzedLambda = StackSpiller.analyzeLambda(node);
        RewriteAction action = analyzedLambda == node ? RewriteAction.None : RewriteAction.Copy;
        return new Result(action, analyzedLambda);
    }

    private Result rewriteInvocationExpression(Expression expr, Stack stack) {
        InvocationExpression node = (InvocationExpression)expr;
        LambdaExpression<?> lambda = node.getLambdaOperand();
        if (lambda != null) {
            ChildRewriter cr = new ChildRewriter(stack, node.getArgumentCount());
            cr.add(node.getArguments());
            StackSpiller spiller = new StackSpiller(stack);
            lambda = lambda.accept(spiller);
            if (cr.didRewrite() || spiller._lambdaRewrite != RewriteAction.None) {
                node = new InvocationExpression(lambda, cr.get(0, -1), node.getType());
            }
            Result result = cr.Finish(node);
            return new Result(result.Action.or(spiller._lambdaRewrite), result.Node);
        }
        ChildRewriter cr = new ChildRewriter(stack, node.getArgumentCount() + 1);
        cr.add(node.getExpression());
        cr.add(node.getArguments());
        return cr.Finish(cr.didRewrite() ? new InvocationExpression(cr.get(0), cr.get(1, -1), node.getType()) : expr);
    }

    private Result rewriteTypeBinaryExpression(Expression expr, Stack stack) {
        TypeBinaryExpression node = (TypeBinaryExpression)expr;
        Result expression = this.rewriteExpression(node.getOperand(), stack);
        if (expression.Action != RewriteAction.None) {
            if (node.getNodeType() == ExpressionType.InstanceOf) {
                return new Result(expression.Action, Expression.instanceOf(expression.Node, node.getTypeOperand()));
            }
            return new Result(expression.Action, Expression.typeEqual(expression.Node, node.getTypeOperand()));
        }
        return new Result(expression.Action, expr);
    }

    private Result rewriteConditionalExpression(Expression expr, Stack stack) {
        ConditionalExpression node = (ConditionalExpression)expr;
        Result test = this.rewriteExpression(node.getTest(), stack);
        Result ifTrue = this.rewriteExpression(node.getIfTrue(), stack);
        Result ifFalse = this.rewriteExpression(node.getIfFalse(), stack);
        RewriteAction action = test.Action.or(ifTrue.Action).or(ifFalse.Action);
        if (action != RewriteAction.None) {
            return new Result(action, Expression.condition(test.Node, ifTrue.Node, ifFalse.Node, node.getType()));
        }
        return new Result(action, expr);
    }

    private Result rewriteMethodCallExpression(Expression expr, Stack stack) {
        MethodCallExpression node = (MethodCallExpression)expr;
        ChildRewriter cr = new ChildRewriter(stack, node.getArgumentCount() + 1);
        cr.add(node.getTarget());
        cr.addArguments(node);
        return cr.Finish(cr.didRewrite() ? node.rewrite(cr.get(0), cr.get(1, -1)) : expr);
    }

    private Result rewriteUnaryExpression(Expression expr, Stack stack) {
        UnaryExpression node = (UnaryExpression)expr;
        assert (node.getNodeType() != ExpressionType.Quote) : "unexpected Quote";
        assert (node.getNodeType() != ExpressionType.Throw) : "unexpected Throw";
        Result expression = this.rewriteExpression(node.getOperand(), stack);
        if (expression.Action != RewriteAction.None) {
            return new Result(expression.Action, new UnaryExpression(node.getNodeType(), expression.Node, node.getType(), node.getMethod()));
        }
        return new Result(expression.Action, expr);
    }

    private Result rewriteLogicalBinaryExpression(Expression expr, Stack stack) {
        BinaryExpression node = (BinaryExpression)expr;
        Result left = this.rewriteExpression(node.getLeft(), stack);
        Result right = this.rewriteExpression(node.getRight(), stack);
        Result conversion = this.rewriteExpression(node.getConversion(), stack);
        RewriteAction action = left.Action.or(right.Action).or(conversion.Action);
        if (action != RewriteAction.None) {
            return new Result(action, BinaryExpression.create(node.getNodeType(), left.Node, right.Node, node.getType(), node.getMethod(), (LambdaExpression)conversion.Node));
        }
        return new Result(action, expr);
    }

    private Result rewriteBinaryExpression(Expression expr, Stack stack) {
        BinaryExpression node = (BinaryExpression)expr;
        ChildRewriter cr = new ChildRewriter(stack, 3);
        cr.add(node.getLeft());
        cr.add(node.getRight());
        cr.add(node.getConversion());
        if (cr.didRewrite()) {
            return cr.Finish(BinaryExpression.create(node.getNodeType(), cr.get(0), cr.get(1), node.getType(), node.getMethod(), (LambdaExpression)cr.get(2)));
        }
        return cr.Finish(expr);
    }

    private final class ChildRewriter {
        private final Expression[] _expressions;
        private int _expressionsCount;
        private List<Expression> _comma;
        private RewriteAction _action = RewriteAction.None;
        private Stack _stack;
        private boolean _done;

        ChildRewriter(Stack stack, int count) {
            this._stack = stack;
            this._expressions = new Expression[count];
        }

        void add(Expression node) {
            assert (!this._done);
            if (node == null) {
                this._expressions[this._expressionsCount++] = null;
                return;
            }
            Result exp = StackSpiller.this.rewriteExpression(node, this._stack);
            this._action = this._action.or(exp.Action);
            this._stack = Stack.NonEmpty;
            this._expressions[this._expressionsCount++] = exp.Node;
        }

        void add(ExpressionList expressions) {
            int count = expressions.size();
            for (int i = 0; i < count; ++i) {
                this.add((Expression)expressions.get(i));
            }
        }

        void addArguments(IArgumentProvider expressions) {
            int count = expressions.getArgumentCount();
            for (int i = 0; i < count; ++i) {
                this.add(expressions.getArgument(i));
            }
        }

        private void ensureDone() {
            if (!this._done) {
                this._done = true;
                if (this._action == RewriteAction.SpillStack) {
                    Expression[] clone = this._expressions;
                    int count = clone.length;
                    ArrayList<Expression> comma = new ArrayList<Expression>(count + 1);
                    for (int i = 0; i < count; ++i) {
                        if (clone[i] == null) continue;
                        StrongBox temp = new StrongBox();
                        clone[i] = StackSpiller.this.toTemp(clone[i], (StrongBox<Expression>)temp);
                        comma.add((Expression)temp.value);
                    }
                    this._comma = comma;
                }
            }
        }

        boolean didRewrite() {
            return this._action != RewriteAction.None;
        }

        RewriteAction getAction() {
            return this._action;
        }

        Result Finish(Expression expr) {
            this.ensureDone();
            if (this._action == RewriteAction.SpillStack) {
                assert (this._comma.size() == this._expressions.length + 1);
                this._comma.add(expr);
                Expression[] expressions = this._comma.toArray(new Expression[this._comma.size()]);
                expr = StackSpiller.makeBlock(new ExpressionList(expressions));
            }
            return new Result(this._action, expr);
        }

        Expression get(int index) {
            this.ensureDone();
            if (index < 0) {
                index += this._expressions.length;
            }
            return this._expressions[index];
        }

        ExpressionList<? extends Expression> get(int first, int last) {
            this.ensureDone();
            int end = last;
            if (end < 0) {
                end += this._expressions.length;
            }
            int count = end - first + 1;
            VerifyArgument.validElementRange((int)this._expressions.length, (int)first, (int)(first + count));
            if (count == this._expressions.length) {
                assert (first == 0);
                return new ExpressionList(this._expressions);
            }
            Expression[] clone = new Expression[count];
            System.arraycopy(this._expressions, first, clone, 0, count);
            return new ExpressionList(clone);
        }
    }

    static final class SpilledExpressionBlock
    extends BlockN {
        SpilledExpressionBlock(ExpressionList<? extends Expression> expressions) {
            super(expressions);
        }

        @Override
        BlockExpression rewrite(ParameterExpressionList variables, Expression[] args) {
            throw ContractUtils.unreachable();
        }
    }

    private static class TempMaker {
        private int _temp;
        private ArrayList<ParameterExpression> _freeTemps;
        private java.util.Stack<ParameterExpression> _usedTemps;
        private final ArrayList<ParameterExpression> _temps = new ArrayList();

        private TempMaker() {
        }

        List<ParameterExpression> getTemps() {
            return this._temps;
        }

        ParameterExpressionList getTempsList() {
            ParameterExpression[] temps = new ParameterExpression[this._temps.size()];
            this._temps.toArray(temps);
            return new ParameterExpressionList(temps);
        }

        ParameterExpression temp(Type type) {
            ParameterExpression temp;
            if (this._freeTemps != null) {
                for (int i = this._freeTemps.size() - 1; i >= 0; --i) {
                    temp = this._freeTemps.get(i);
                    if (temp.getType() != type) continue;
                    this._freeTemps.remove(i);
                    return this.useTemp(temp);
                }
            }
            temp = Expression.variable(type, "$temp$" + this._temp++);
            this._temps.add(temp);
            return this.useTemp(temp);
        }

        private ParameterExpression useTemp(ParameterExpression temp) {
            assert (this._freeTemps == null || !this._freeTemps.contains(temp));
            assert (this._usedTemps == null || !this._usedTemps.contains(temp));
            if (this._usedTemps == null) {
                this._usedTemps = new java.util.Stack();
            }
            this._usedTemps.push(temp);
            return temp;
        }

        private void freeTemp(ParameterExpression temp) {
            assert (this._freeTemps == null || !this._freeTemps.contains(temp));
            if (this._freeTemps == null) {
                this._freeTemps = new ArrayList();
            }
            this._freeTemps.add(temp);
        }

        int mark() {
            return this._usedTemps != null ? this._usedTemps.size() : 0;
        }

        void free(int mark) {
            assert (this._usedTemps == null || mark <= this._usedTemps.size());
            assert (mark == 0 || this._usedTemps != null);
            if (this._usedTemps != null) {
                while (mark < this._usedTemps.size()) {
                    this.freeTemp(this._usedTemps.pop());
                }
            }
        }

        void verifyTemps() {
            assert (this._usedTemps == null || this._usedTemps.isEmpty());
        }
    }

    private static class Result {
        private final RewriteAction Action;
        private final Expression Node;

        Result(RewriteAction action, Expression node) {
            this.Action = action;
            this.Node = node;
        }

        public RewriteAction getAction() {
            return this.Action;
        }

        public Expression getNode() {
            return this.Node;
        }
    }

    private static enum RewriteAction {
        None(0),
        Copy(1),
        SpillStack(3);

        private final int _flags;

        private RewriteAction(int flags) {
            this._flags = flags;
        }

        public RewriteAction or(RewriteAction action) {
            int flags = action._flags | this._flags;
            switch (flags) {
                case 0: {
                    return None;
                }
                case 1: {
                    return Copy;
                }
                case 3: {
                    return SpillStack;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    private static enum Stack {
        Empty,
        NonEmpty;

    }
}

