/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.core.CollectionUtilities;
import com.strobel.core.delegates.Func1;
import com.strobel.expressions.Error;
import com.strobel.expressions.Helpers;
import com.strobel.expressions.LabelScopeInfo;
import com.strobel.expressions.LabelScopeKind;
import com.strobel.expressions.LabelTarget;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.emit.CodeGenerator;
import com.strobel.reflection.emit.Label;
import com.strobel.reflection.emit.LocalBuilder;
import com.strobel.reflection.emit.OpCode;
import java.util.ArrayList;
import java.util.HashSet;

final class LabelInfo {
    private final LabelTarget _node;
    private Label _label;
    private boolean _labelDefined;
    private LocalBuilder _value;
    private final HashSet<LabelScopeInfo> _definitions = new HashSet();
    private final ArrayList<LabelScopeInfo> _references = new ArrayList();
    private final boolean _canReturn;
    private boolean _acrossBlockJump;
    private OpCode _opCode = OpCode.GOTO;
    private final CodeGenerator _generator;

    public LabelInfo(CodeGenerator generator, LabelTarget label, boolean canReturn) {
        this._generator = generator;
        this._node = label;
        this._canReturn = canReturn;
    }

    final Label getLabel() {
        this.ensureLabelAndValue();
        return this._label;
    }

    final boolean canReturn() {
        return this._canReturn;
    }

    final boolean canBranch() {
        return this._opCode != OpCode.RETURN;
    }

    final void reference(LabelScopeInfo block) {
        this._references.add(block);
        if (this._definitions.size() > 0) {
            this.validateJump(block);
        }
    }

    final void define(LabelScopeInfo block) {
        LabelScopeInfo j = block;
        while (j != null) {
            if (j.containsTarget(this._node)) {
                throw Error.labelTargetAlreadyDefined(this._node.getName());
            }
            j = j.parent;
        }
        this._definitions.add(block);
        assert (block != null);
        block.addLabelInfo(this._node, this);
        if (this._definitions.size() == 1) {
            for (LabelScopeInfo r : this._references) {
                this.validateJump(r);
            }
        } else {
            if (this._acrossBlockJump) {
                throw Error.ambiguousJump(this._node.getName());
            }
            this._labelDefined = false;
        }
    }

    private void validateJump(LabelScopeInfo reference) {
        this._opCode = this._canReturn ? OpCode.RETURN : OpCode.GOTO;
        LabelScopeInfo j = reference;
        while (j != null) {
            if (this._definitions.contains(j)) {
                return;
            }
            if (j.kind == LabelScopeKind.Finally || j.kind == LabelScopeKind.Filter) {
                // empty if block
            }
            if (j.kind == LabelScopeKind.Try || j.kind == LabelScopeKind.Catch) {
                // empty if block
            }
            j = j.parent;
        }
        this._acrossBlockJump = true;
        if (this._node != null && this._node.getType() != PrimitiveTypes.Void) {
            throw Error.nonLocalJumpWithValue(this._node.getName());
        }
        if (this._definitions.size() > 1) {
            assert (this._node != null);
            throw Error.ambiguousJump(this._node.getName());
        }
        LabelScopeInfo def = (LabelScopeInfo)CollectionUtilities.first(this._definitions);
        LabelScopeInfo common = Helpers.commonNode(def, reference, new Func1<LabelScopeInfo, LabelScopeInfo>(){

            public LabelScopeInfo apply(LabelScopeInfo s) {
                return s.parent;
            }
        });
        this._opCode = this._canReturn ? OpCode.RETURN : OpCode.GOTO;
        LabelScopeInfo j2 = reference;
        while (j2 != common) {
            assert (j2 != null);
            if (j2.kind == LabelScopeKind.Try || j2.kind == LabelScopeKind.Catch || j2.kind == LabelScopeKind.Finally) {
                this._opCode = OpCode.GOTO;
            }
            j2 = j2.parent;
        }
        j2 = def;
        while (j2 != common) {
            if (!j2.canJumpInto()) {
                if (j2.kind == LabelScopeKind.Expression) {
                    throw Error.controlCannotEnterExpression();
                }
                throw Error.controlCannotEnterTry();
            }
            j2 = j2.parent;
        }
    }

    void validateFinish() {
        if (this._references.size() > 0 && this._definitions.size() == 0) {
            throw Error.labelTargetUndefined(this._node.getName());
        }
    }

    void emitJump() {
        if (this._opCode == OpCode.RETURN) {
            this._generator.emitReturn(this._node.getType());
        } else {
            this.storeValue();
            this._generator.emit(this._opCode, this.getLabel());
        }
    }

    private void storeValue() {
        this.ensureLabelAndValue();
        if (this._value != null) {
            this._generator.emitStore(this._value);
        }
    }

    final void mark() {
        if (this._canReturn) {
            if (!this._labelDefined) {
                return;
            }
            this._generator.emitReturn(this._node.getType());
        } else {
            this.storeValue();
        }
        this.markWithEmptyStack();
    }

    final void markWithEmptyStack() {
        this._generator.markLabel(this.getLabel());
        if (this._value == null) {
            return;
        }
        this._generator.emitLoad(this._value);
    }

    private void ensureLabelAndValue() {
        if (this._labelDefined) {
            return;
        }
        this._labelDefined = true;
        this._label = this._generator.defineLabel();
        if (this._node != null && this._node.getType() != PrimitiveTypes.Void) {
            this._value = this._generator.declareLocal(this._node.getType());
        }
    }
}

