/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.core.ReadOnlyList;
import com.strobel.expressions.BinaryExpression;
import com.strobel.expressions.BlockExpression;
import com.strobel.expressions.CatchBlock;
import com.strobel.expressions.ConcatExpression;
import com.strobel.expressions.ConditionalExpression;
import com.strobel.expressions.ConstantExpression;
import com.strobel.expressions.DefaultValueExpression;
import com.strobel.expressions.Error;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionList;
import com.strobel.expressions.ForEachExpression;
import com.strobel.expressions.ForExpression;
import com.strobel.expressions.GotoExpression;
import com.strobel.expressions.IArgumentProvider;
import com.strobel.expressions.InvocationExpression;
import com.strobel.expressions.LabelExpression;
import com.strobel.expressions.LabelTarget;
import com.strobel.expressions.LambdaExpression;
import com.strobel.expressions.LoopExpression;
import com.strobel.expressions.MemberExpression;
import com.strobel.expressions.MethodCallExpression;
import com.strobel.expressions.NewArrayExpression;
import com.strobel.expressions.NewExpression;
import com.strobel.expressions.ParameterExpression;
import com.strobel.expressions.ParameterExpressionList;
import com.strobel.expressions.RuntimeVariablesExpression;
import com.strobel.expressions.SwitchCase;
import com.strobel.expressions.SwitchExpression;
import com.strobel.expressions.TryExpression;
import com.strobel.expressions.TypeBinaryExpression;
import com.strobel.expressions.UnaryExpression;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.Type;

public abstract class ExpressionVisitor {
    public Expression visit(Expression node) {
        if (node != null) {
            return node.accept(this);
        }
        return null;
    }

    protected Expression visitDefaultValue(DefaultValueExpression node) {
        return node;
    }

    protected Expression visitExtension(Expression node) {
        return node.visitChildren(this);
    }

    protected Expression visitLabel(LabelExpression node) {
        return node.update(this.visitLabelTarget(node.getTarget()), this.visit(node.getDefaultValue()));
    }

    protected LabelTarget visitLabelTarget(LabelTarget node) {
        return node;
    }

    protected Expression visitConcat(ConcatExpression node) {
        return node.update(this.visit(node.getOperands()));
    }

    protected Expression visitGoto(GotoExpression node) {
        return node.update(this.visitLabelTarget(node.getTarget()), this.visit(node.getValue()));
    }

    protected Expression visitLoop(LoopExpression node) {
        return node.update(this.visitLabelTarget(node.getBreakTarget()), this.visitLabelTarget(node.getContinueTarget()), this.visit(node.getBody()));
    }

    protected Expression visitForEach(ForEachExpression node) {
        return node.update((ParameterExpression)this.visit(node.getVariable()), this.visit(node.getSequence()), this.visit(node.getBody()), this.visitLabelTarget(node.getBreakTarget()), this.visitLabelTarget(node.getContinueTarget()));
    }

    protected Expression visitFor(ForExpression node) {
        return node.update((ParameterExpression)this.visit(node.getVariable()), this.visit(node.getInitializer()), this.visit(node.getTest()), this.visit(node.getStep()), this.visit(node.getBody()), this.visitLabelTarget(node.getBreakTarget()), this.visitLabelTarget(node.getContinueTarget()));
    }

    protected Expression visitMember(MemberExpression node) {
        return node.update(this.visit(node.getTarget()));
    }

    protected Expression visitConstant(ConstantExpression node) {
        return node;
    }

    protected Expression visitParameter(ParameterExpression node) {
        return node;
    }

    protected Expression visitUnary(UnaryExpression node) {
        return ExpressionVisitor.validateUnary(node, node.update(this.visit(node.getOperand())));
    }

    protected Expression visitBinary(BinaryExpression node) {
        return ExpressionVisitor.validateBinary(node, node.update(this.visit(node.getLeft()), this.visitAndConvert(node.getConversion(), "visitBinary"), this.visit(node.getRight())));
    }

    protected Expression visitTypeBinary(TypeBinaryExpression node) {
        return node.update(this.visit(node.getOperand()));
    }

    protected Expression visitBlock(BlockExpression node) {
        int count = node.getExpressionCount();
        Expression[] nodes = null;
        for (int i = 0; i < count; ++i) {
            Expression oldNode = node.getExpression(i);
            Expression newNode = this.visit(oldNode);
            if (newNode == oldNode) continue;
            if (nodes == null) {
                nodes = new Expression[count];
            }
            nodes[i] = newNode;
        }
        ParameterExpressionList v = this.visitAndConvertList(node.getVariables(), "visitBlock");
        if (v == node.getVariables() && nodes == null) {
            return node;
        }
        if (nodes != null) {
            for (int i = 0; i < count; ++i) {
                if (nodes[i] != null) continue;
                nodes[i] = node.getExpression(i);
            }
        }
        return node.rewrite(v, nodes);
    }

    protected Expression visitInvocation(InvocationExpression node) {
        Expression e = this.visit(node.getExpression());
        ExpressionList<? extends Expression> a = this.visitArguments(node);
        if (e == node.getExpression() && a == null) {
            return node;
        }
        return node.rewrite((LambdaExpression)e, a);
    }

    protected Expression visitMethodCall(MethodCallExpression node) {
        Expression target = this.visit(node.getTarget());
        ExpressionList<? extends Expression> arguments = this.visitArguments(node);
        if (target == node.getTarget() && arguments == null) {
            return node;
        }
        return node.rewrite(target, arguments);
    }

    protected Expression visitNew(NewExpression node) {
        return node.update(this.visit(node.getArguments()));
    }

    protected Expression visitNewArray(NewArrayExpression node) {
        return node.update(this.visit(node.getExpressions()));
    }

    protected <T> LambdaExpression<T> visitLambda(LambdaExpression<T> node) {
        return node.update(this.visit(node.getBody()), this.visitAndConvertList(node.getParameters(), "visitLambda"));
    }

    protected Expression visitConditional(ConditionalExpression node) {
        return node.update(this.visit(node.getTest()), this.visit(node.getIfTrue()), this.visit(node.getIfFalse()));
    }

    protected Expression visitRuntimeVariables(RuntimeVariablesExpression node) {
        return node.update(this.visitAndConvertList(node.getVariables(), "visitRuntimeVariables"));
    }

    protected Expression visitTry(TryExpression node) {
        return node.update(this.visit(node.getBody()), ExpressionVisitor.visit(node.getHandlers(), new ElementVisitor<CatchBlock>(){

            @Override
            public CatchBlock visit(CatchBlock node) {
                return ExpressionVisitor.this.visitCatchBlock(node);
            }
        }), this.visit(node.getFinallyBlock()));
    }

    protected CatchBlock visitCatchBlock(CatchBlock node) {
        return node.update(this.visitAndConvert(node.getVariable(), "visitCatchBlock"), this.visit(node.getFilter()), this.visit(node.getBody()));
    }

    protected SwitchCase visitSwitchCase(SwitchCase node) {
        return node.update(this.visit(node.getTestValues()), this.visit(node.getBody()));
    }

    protected Expression visitSwitch(SwitchExpression node) {
        return ExpressionVisitor.validateSwitch(node, node.update(this.visit(node.getSwitchValue()), ExpressionVisitor.visit(node.getCases(), new ElementVisitor<SwitchCase>(){

            @Override
            public SwitchCase visit(SwitchCase node) {
                return ExpressionVisitor.this.visitSwitchCase(node);
            }
        }), this.visit(node.getDefaultBody()), node.getOptions()));
    }

    protected static <T> ReadOnlyList<T> visit(ReadOnlyList<T> nodes, ElementVisitor<T> elementVisitor) {
        Object[] newNodes = null;
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            Object node = nodes.get(i);
            Object newNode = elementVisitor.visit(node);
            if (newNode == node) continue;
            if (newNodes == null) {
                newNodes = nodes.toArray();
            }
            newNodes[i] = newNode;
        }
        if (newNodes == null) {
            return nodes;
        }
        return new ReadOnlyList(newNodes);
    }

    final ExpressionList<? extends Expression> visit(ExpressionList<? extends Expression> nodes) {
        Expression[] newNodes = null;
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            Expression oldNode = nodes.get(i);
            Expression node = this.visit(oldNode);
            if (newNodes != null) {
                newNodes[i] = node;
                continue;
            }
            if (node == oldNode) continue;
            newNodes = nodes.toArray();
            newNodes[i] = node;
        }
        return newNodes == null ? nodes : new ExpressionList(newNodes);
    }

    final ExpressionList<? extends Expression> visitArguments(IArgumentProvider nodes) {
        Expression[] newNodes = null;
        int n = nodes.getArgumentCount();
        for (int i = 0; i < n; ++i) {
            Expression node = nodes.getArgument(i);
            Expression newNode = this.visit(node);
            if (newNodes != null) {
                newNodes[i] = newNode;
                continue;
            }
            if (newNode == node) continue;
            newNodes = new Expression[n];
            for (int j = 0; j < i; ++j) {
                newNodes[j] = nodes.getArgument(j);
            }
            newNodes[i] = newNode;
        }
        return newNodes == null ? null : new ExpressionList(newNodes);
    }

    protected <T extends Expression> T visitAndConvert(T node, String callerName) {
        if (node == null) {
            return null;
        }
        Expression newNode = this.visit(node);
        if (!node.getClass().isInstance(newNode)) {
            throw Error.mustRewriteToSameNode(callerName, node.getClass(), callerName);
        }
        return (T)newNode;
    }

    protected <T extends Expression> ExpressionList<T> visitAndConvertList(ExpressionList<T> nodes, String callerName) {
        Expression[] newNodes = null;
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            T oldNode = nodes.get(i);
            Expression node = this.visit((Expression)oldNode);
            if (node == null) {
                throw Error.mustRewriteToSameNode(callerName, oldNode.getClass(), callerName);
            }
            if (newNodes != null) {
                newNodes[i] = node;
                continue;
            }
            if (node == oldNode) continue;
            newNodes = nodes.toArray();
            newNodes[i] = node;
        }
        if (newNodes == null) {
            return nodes;
        }
        return new ExpressionList(newNodes);
    }

    protected ParameterExpressionList visitAndConvertList(ParameterExpressionList nodes, String callerName) {
        ParameterExpression[] newNodes = null;
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            ParameterExpression oldNode = (ParameterExpression)nodes.get(i);
            ParameterExpression node = (ParameterExpression)this.visit(oldNode);
            if (node == null) {
                throw Error.mustRewriteToSameNode(callerName, oldNode.getClass(), callerName);
            }
            if (newNodes != null) {
                newNodes[i] = node;
                continue;
            }
            if (node == oldNode) continue;
            newNodes = (ParameterExpression[])nodes.toArray();
            newNodes[i] = node;
        }
        if (newNodes == null) {
            return nodes;
        }
        return new ParameterExpressionList(newNodes);
    }

    private static UnaryExpression validateUnary(UnaryExpression before, UnaryExpression after) {
        if (before != after && before.getMethod() == null) {
            if (after.getMethod() != null) {
                throw Error.mustRewriteWithoutMethod((MethodBase)after.getMethod(), "visitUnary");
            }
            if (before.getOperand() != null && after.getOperand() != null) {
                ExpressionVisitor.validateChildType(before.getOperand().getType(), after.getOperand().getType(), "visitUnary");
            }
        }
        return after;
    }

    private static BinaryExpression validateBinary(BinaryExpression before, BinaryExpression after) {
        if (before != after && before.getMethod() == null) {
            if (after.getMethod() != null) {
                throw Error.mustRewriteWithoutMethod((MethodBase)after.getMethod(), "VisitBinary");
            }
            ExpressionVisitor.validateChildType(before.getLeft().getType(), after.getLeft().getType(), "VisitBinary");
            ExpressionVisitor.validateChildType(before.getRight().getType(), after.getRight().getType(), "VisitBinary");
        }
        return after;
    }

    private static void validateChildType(Type before, Type after, String methodName) {
        if (before.isPrimitive() ? before == after : !after.isPrimitive()) {
            return;
        }
        throw Error.mustRewriteChildToSameType(before, after, methodName);
    }

    private static SwitchExpression validateSwitch(SwitchExpression before, SwitchExpression after) {
        if (before.getComparison() == null && after.getComparison() != null) {
            throw Error.mustRewriteWithoutMethod((MethodBase)after.getComparison(), "visitSwitch");
        }
        return after;
    }

    public static interface ElementVisitor<T> {
        public T visit(T var1);
    }
}

