/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.LanguageFeature;
import com.strobel.core.CollectionUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentOperatorType;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.DefiniteAssignmentAnalysis;
import com.strobel.decompiler.languages.java.ast.DefiniteAssignmentStatus;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.NullReferenceExpression;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.ThrowStatement;
import com.strobel.decompiler.languages.java.ast.TryCatchStatement;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.transforms.ConvertLoopsTransform;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.IdentifierBackReference;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.semantics.ResolveResult;

public class TryWithResourcesTransform
extends ContextTrackingVisitor<Void> {
    private static final INode J7_RESOURCE_INIT_PATTERN;
    private static final INode J7_CLEAR_SAVED_EXCEPTION_PATTERN;
    private final TryCatchStatement _tryPattern;
    private final AstBuilder _astBuilder;
    private final JavaResolver _resolver;

    public TryWithResourcesTransform(DecompilerContext context) {
        super(context);
        this._astBuilder = (AstBuilder)context.getUserData(Keys.AST_BUILDER);
        if (this._astBuilder == null) {
            this._tryPattern = null;
            this._resolver = null;
            return;
        }
        this._resolver = new JavaResolver(context);
        TryCatchStatement tryPattern = new TryCatchStatement(-34);
        tryPattern.setTryBlock(new AnyNode("tryContent").toBlockStatement());
        CatchClause catchClause = new CatchClause(new BlockStatement(new ExpressionStatement(new AssignmentExpression(new IdentifierBackReference("savedException").toExpression(), new NamedNode("caughtException", new IdentifierExpression(-34, "$any$")).toExpression())), new ThrowStatement(new IdentifierBackReference("caughtException").toExpression())));
        catchClause.setVariableName("$any$");
        catchClause.getExceptionTypes().add(new SimpleType("Throwable"));
        tryPattern.getCatchClauses().add(catchClause);
        TryCatchStatement disposeTry = new TryCatchStatement(-34);
        disposeTry.setTryBlock(new BlockStatement(new ExpressionStatement(new IdentifierBackReference("resource").toExpression().invoke("close", new Expression[0]))));
        CatchClause disposeCatch = new CatchClause(new BlockStatement(new ExpressionStatement(new IdentifierBackReference("savedException").toExpression().invoke("addSuppressed", new NamedNode("caughtOnClose", new IdentifierExpression(-34, "$any$")).toExpression()))));
        disposeCatch.setVariableName("$any$");
        disposeCatch.getExceptionTypes().add(new SimpleType("Throwable"));
        disposeTry.getCatchClauses().add(disposeCatch);
        tryPattern.setFinallyBlock(new BlockStatement(new IfElseStatement(-34, new BinaryOperatorExpression(new IdentifierBackReference("resource").toExpression(), BinaryOperatorType.INEQUALITY, new NullReferenceExpression(-34)), (Statement)new BlockStatement(new IfElseStatement(-34, new BinaryOperatorExpression(new IdentifierBackReference("savedException").toExpression(), BinaryOperatorType.INEQUALITY, new NullReferenceExpression(-34)), new BlockStatement(disposeTry), new BlockStatement(new ExpressionStatement(new IdentifierBackReference("resource").toExpression().invoke("close", new Expression[0]))))))));
        this._tryPattern = tryPattern;
    }

    @Override
    public void run(AstNode compilationUnit) {
        if (this._tryPattern == null || !this.context.isSupported(LanguageFeature.TRY_WITH_RESOURCES)) {
            return;
        }
        super.run(compilationUnit);
    }

    @Override
    public Void visitTryCatchStatement(TryCatchStatement node, Void data) {
        Statement initializeResource;
        super.visitTryCatchStatement(node, data);
        if (!(node.getParent() instanceof BlockStatement)) {
            return null;
        }
        BlockStatement parent = (BlockStatement)node.getParent();
        Statement clearCaughtException = node.getPreviousSibling(BlockStatement.STATEMENT_ROLE);
        Statement statement = initializeResource = clearCaughtException != null ? clearCaughtException.getPreviousSibling(BlockStatement.STATEMENT_ROLE) : null;
        if (initializeResource == null) {
            return null;
        }
        Match m = Match.createNew();
        if (J7_RESOURCE_INIT_PATTERN.matches(initializeResource, m) && J7_CLEAR_SAVED_EXCEPTION_PATTERN.matches(clearCaughtException, m) && this._tryPattern.matches(node, m)) {
            IdentifierExpression resource = (IdentifierExpression)CollectionUtilities.first(m.get("resource"));
            ResolveResult resourceResult = this._resolver.apply(resource);
            if (resourceResult == null || resourceResult.getType() == null) {
                return null;
            }
            BlockStatement tryContent = (BlockStatement)CollectionUtilities.first(m.get("tryContent"));
            Expression resourceInitializer = (Expression)CollectionUtilities.first(m.get("resourceInitializer"));
            IdentifierExpression caughtException = (IdentifierExpression)CollectionUtilities.first(m.get("caughtException"));
            IdentifierExpression caughtOnClose = (IdentifierExpression)CollectionUtilities.first(m.get("caughtOnClose"));
            CatchClause caughtParent = (CatchClause)CollectionUtilities.first(caughtException.getAncestors(CatchClause.class));
            CatchClause caughtOnCloseParent = (CatchClause)CollectionUtilities.first(caughtOnClose.getAncestors(CatchClause.class));
            if (caughtParent == null || caughtOnCloseParent == null || !Pattern.matchString(caughtException.getIdentifier(), caughtParent.getVariableName()) || !Pattern.matchString(caughtOnClose.getIdentifier(), caughtOnCloseParent.getVariableName())) {
                return null;
            }
            VariableDeclarationStatement resourceDeclaration = ConvertLoopsTransform.findVariableDeclaration(node, resource.getIdentifier());
            if (resourceDeclaration == null || !(resourceDeclaration.getParent() instanceof BlockStatement)) {
                return null;
            }
            BlockStatement outerTemp = new BlockStatement();
            BlockStatement temp = new BlockStatement();
            initializeResource.remove();
            clearCaughtException.remove();
            node.replaceWith(outerTemp);
            temp.add(initializeResource);
            temp.add(clearCaughtException);
            temp.add(node);
            outerTemp.add(temp);
            Statement declarationPoint = ConvertLoopsTransform.canMoveVariableDeclarationIntoStatement(this.context, resourceDeclaration, node);
            node.remove();
            outerTemp.replaceWith(node);
            if (declarationPoint != outerTemp) {
                initializeResource.remove();
                clearCaughtException.remove();
                parent.insertChildBefore(node, initializeResource, BlockStatement.STATEMENT_ROLE);
                parent.insertChildBefore(node, clearCaughtException, BlockStatement.STATEMENT_ROLE);
                return null;
            }
            tryContent.remove();
            resource.remove();
            resourceInitializer.remove();
            VariableDeclarationStatement newResourceDeclaration = new VariableDeclarationStatement(this._astBuilder.convertType(resourceResult.getType()), resource.getIdentifier(), resourceInitializer);
            Statement firstStatement = (Statement)CollectionUtilities.firstOrDefault(tryContent.getStatements());
            Statement lastStatement = (Statement)CollectionUtilities.lastOrDefault(tryContent.getStatements());
            if (firstStatement != null) {
                DefiniteAssignmentAnalysis analysis = new DefiniteAssignmentAnalysis(this.context, tryContent);
                analysis.setAnalyzedRange(firstStatement, lastStatement);
                analysis.analyze(resource.getIdentifier(), DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED);
                if (!analysis.isPotentiallyAssigned()) {
                    newResourceDeclaration.addModifier(Flags.Flag.FINAL);
                }
            } else {
                newResourceDeclaration.addModifier(Flags.Flag.FINAL);
            }
            node.setTryBlock(tryContent);
            node.getDeclaredResources().add(newResourceDeclaration);
            node.getCatchClauses().clear();
            node.setFinallyBlock(null);
        }
        return null;
    }

    static {
        Expression resource = new NamedNode("resource", new IdentifierExpression(-34, "$any$")).toExpression();
        Expression savedException = new NamedNode("savedException", new IdentifierExpression(-34, "$any$")).toExpression();
        J7_RESOURCE_INIT_PATTERN = new ExpressionStatement(new AssignmentExpression(resource, AssignmentOperatorType.ASSIGN, new AnyNode("resourceInitializer").toExpression()));
        J7_CLEAR_SAVED_EXCEPTION_PATTERN = new ExpressionStatement(new AssignmentExpression(savedException, AssignmentOperatorType.ASSIGN, new NullReferenceExpression(-34)));
    }
}

