/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.LanguageFeature;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Comparer;
import com.strobel.core.Predicate;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.DefiniteAssignmentAnalysis;
import com.strobel.decompiler.languages.java.ast.DefiniteAssignmentStatus;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.JavaNameResolver;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.NameResolveResult;
import com.strobel.decompiler.languages.java.ast.NullReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.ThrowStatement;
import com.strobel.decompiler.languages.java.ast.TryCatchStatement;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.transforms.ConvertLoopsTransform;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.BackReference;
import com.strobel.decompiler.patterns.Choice;
import com.strobel.decompiler.patterns.DeclaredVariableBackReference;
import com.strobel.decompiler.patterns.IdentifierBackReference;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.OptionalNode;
import com.strobel.decompiler.patterns.Repeat;
import com.strobel.decompiler.semantics.ResolveResult;

public class NewTryWithResourcesTransform
extends ContextTrackingVisitor<Void> {
    private final Statement _resourceDeclaration;
    private final TryCatchStatement _tryPattern;
    private final JavaResolver _resolver;
    private AstBuilder _builder;

    public NewTryWithResourcesTransform(DecompilerContext context) {
        super(context);
        this._resolver = new JavaResolver(context);
        VariableDeclarationStatement rv = new VariableDeclarationStatement(new AnyNode().toType(), "$any$", new AnyNode().toExpression());
        rv.setAnyModifiers(true);
        this._resourceDeclaration = new Choice(new NamedNode("resource", rv), new NamedNode("assignment", new ExpressionStatement(new AssignmentExpression(new NamedNode("resource", new IdentifierExpression("$any$")).toExpression(), new NamedNode("resourceInitializer", new AnyNode()).toExpression())))).toStatement();
        TryCatchStatement tryPattern = new TryCatchStatement(-34);
        TryCatchStatement nestedTryWithResourceDisposal = new TryCatchStatement();
        nestedTryWithResourceDisposal.setTryBlock(new AnyNode().toBlockStatement());
        nestedTryWithResourceDisposal.getCatchClauses().add(new Repeat(new AnyNode()).toCatchClause());
        Expression resourceReference = new Choice(new DeclaredVariableBackReference("resource"), new IdentifierBackReference("resource")).toExpression();
        nestedTryWithResourceDisposal.setFinallyBlock(new BlockStatement(new Repeat(new AnyNode()).toStatement(), new NamedNode("resourceDisposal", new Choice(new ExpressionStatement(resourceReference.invoke("close", new Expression[0])), new IfElseStatement(-34, new BinaryOperatorExpression(resourceReference.clone(), BinaryOperatorType.INEQUALITY, new NullReferenceExpression()), (Statement)new BlockStatement(new ExpressionStatement(resourceReference.clone().invoke("close", new Expression[0])))))).toStatement()));
        BlockStatement tryContent = new NamedNode("tryContent", new BlockStatement(new Repeat(new AnyNode()).toStatement(), new Choice(new NamedNode("resourceDisposal", new Choice(new ExpressionStatement(resourceReference.clone().invoke("close", new Expression[0])), new IfElseStatement(-34, new BinaryOperatorExpression(resourceReference.clone(), BinaryOperatorType.INEQUALITY, new NullReferenceExpression()), (Statement)new BlockStatement(new ExpressionStatement(resourceReference.clone().invoke("close", new Expression[0])))))), nestedTryWithResourceDisposal).toStatement(), new Repeat(new NamedNode("outerResourceDisposal", new Choice(new IfElseStatement(-34, new BinaryOperatorExpression(new NamedNode("otherId", new IdentifierExpression("$any$")).toExpression(), BinaryOperatorType.INEQUALITY, new NullReferenceExpression()), (Statement)new BlockStatement(new ExpressionStatement(new IdentifierBackReference("otherId").toExpression().invoke("close", new Expression[0])))), new ExpressionStatement(new IdentifierExpression("$any$").invoke("close", new Expression[0]))).toStatement())).toStatement(), new OptionalNode(new AnyNode("finalStatement")).toStatement())).toBlockStatement();
        tryPattern.setTryBlock(tryContent);
        TryCatchStatement disposeTry = new TryCatchStatement(-34);
        disposeTry.setTryBlock(new BlockStatement(new ExpressionStatement(new NamedNode("resourceToDispose", resourceReference.clone()).toExpression().invoke("close", new Expression[0]))));
        Expression outerException = new NamedNode("error", new IdentifierExpression("$any$")).toExpression();
        CatchClause disposeCatch = new CatchClause(new BlockStatement(new ExpressionStatement(outerException.invoke("addSuppressed", new NamedNode("innerError", new IdentifierExpression("$any$")).toExpression()))));
        disposeCatch.setVariableName("$any$");
        disposeCatch.getExceptionTypes().add(new SimpleType("Throwable"));
        disposeTry.getCatchClauses().add(disposeCatch);
        CatchClause catchClause = new CatchClause(new BlockStatement(new Choice(new NamedNode("disposeTry", disposeTry), new IfElseStatement(-34, new BinaryOperatorExpression(new NamedNode("resourceToDispose", resourceReference.clone()).toExpression(), BinaryOperatorType.INEQUALITY, new NullReferenceExpression()), (Statement)new BlockStatement(new NamedNode("disposeTry", disposeTry).toStatement()))).toStatement(), new ThrowStatement(new BackReference("error").toExpression())));
        catchClause.setVariableName("$any$");
        catchClause.getExceptionTypes().add(new SimpleType("Throwable"));
        tryPattern.getCatchClauses().add(catchClause);
        this._tryPattern = tryPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(AstNode compilationUnit) {
        if (this._tryPattern == null || !this.context.isSupported(LanguageFeature.TRY_WITH_RESOURCES)) {
            return;
        }
        AstBuilder builder = (AstBuilder)this.context.getUserData(Keys.AST_BUILDER);
        if (builder == null) {
            return;
        }
        AstBuilder oldBuilder = this._builder;
        this._builder = builder;
        try {
            super.run(compilationUnit);
            new EmptyTryWithResourcesRewriter().run(compilationUnit);
        }
        finally {
            this._builder = oldBuilder;
        }
    }

    @Override
    public Void visitTryCatchStatement(TryCatchStatement node, Void data) {
        super.visitTryCatchStatement(node, data);
        if (!(node.getParent() instanceof BlockStatement) || node.getCatchClauses().firstOrNullObject().isNull()) {
            return null;
        }
        BlockStatement parent = (BlockStatement)node.getParent();
        Statement initResource = node.getPreviousSibling(BlockStatement.STATEMENT_ROLE);
        Match m = Match.createNew();
        m.add("resource", new IdentifierExpression("$any$"));
        if (this._tryPattern.getCatchClauses().firstOrNullObject().matches(node.getCatchClauses().firstOrNullObject(), m)) {
            TypeReference resourceType;
            Statement declarationStatement;
            boolean isParameter;
            AstNode declaration;
            IdentifierExpression resource = (IdentifierExpression)CollectionUtilities.firstOrDefault(m.get("resourceToDispose"));
            if (resource == null) {
                return null;
            }
            m = Match.createNew();
            m.add("resource", resource);
            if (!this._tryPattern.matches(node, m)) {
                return null;
            }
            if (initResource != null && this._resourceDeclaration.matches(initResource, m)) {
                declaration = (AstNode)CollectionUtilities.firstOrDefault((Iterable)CollectionUtilities.skip(m.get("resource"), (int)1));
                isParameter = false;
            } else {
                ParameterDeclaration p = NewTryWithResourcesTransform.findDeclaration(resource, node);
                if (p == null || !this.context.isSupported(LanguageFeature.TRY_EXPRESSION_RESOURCE)) {
                    return null;
                }
                declaration = p;
                isParameter = true;
            }
            if (isParameter) {
                declarationStatement = null;
                resourceType = ((ParameterDeclaration)declaration).getType().toTypeReference();
            } else {
                if (!(declaration instanceof VariableDeclarationStatement) && !(declaration instanceof IdentifierExpression)) {
                    return null;
                }
                Statement statement = declarationStatement = declaration instanceof Statement ? (Statement)declaration : declaration.getParent(Statement.class);
                if (declarationStatement == null || declarationStatement.isNull() || !(declarationStatement.getParent() instanceof BlockStatement) || !this.canMoveVariableDeclaration(declarationStatement, resource, node)) {
                    return null;
                }
                ResolveResult resourceResult = this._resolver.apply(declaration);
                if (resourceResult == null) {
                    return null;
                }
                resourceType = resourceResult.getType();
            }
            if (resourceType == null) {
                return null;
            }
            BlockStatement tryContent = (BlockStatement)CollectionUtilities.first(m.get("tryContent"));
            final IdentifierExpression caughtException = (IdentifierExpression)CollectionUtilities.first(m.get("error"));
            final IdentifierExpression innerError = (IdentifierExpression)CollectionUtilities.first(m.get("innerError"));
            CatchClause caughtParent = (CatchClause)CollectionUtilities.firstOrDefault(caughtException.getAncestors(CatchClause.class), (Predicate)new Predicate<CatchClause>(){

                public boolean test(CatchClause clause) {
                    return StringUtilities.equals((String)caughtException.getIdentifier(), (String)clause.getVariableName());
                }
            });
            CatchClause innerErrorParent = (CatchClause)CollectionUtilities.firstOrDefault(innerError.getAncestors(CatchClause.class), (Predicate)new Predicate<CatchClause>(){

                public boolean test(CatchClause clause) {
                    return StringUtilities.equals((String)innerError.getIdentifier(), (String)clause.getVariableName());
                }
            });
            if (caughtParent == null || innerErrorParent == null || !caughtParent.isAncestorOf(innerErrorParent)) {
                return null;
            }
            if (this.notEffectivelyFinal(resource.getIdentifier(), tryContent, null)) {
                return null;
            }
            if (isParameter) {
                ParameterDeclaration pd = (ParameterDeclaration)declaration;
                IdentifierExpression resourceId = new IdentifierExpression(pd.getName());
                ParameterDefinition p = pd.getUserData(Keys.PARAMETER_DEFINITION);
                Variable v = pd.getUserData(Keys.VARIABLE);
                if (p != null) {
                    resourceId.putUserData(Keys.PARAMETER_DEFINITION, p);
                }
                if (v != null) {
                    resourceId.putUserData(Keys.VARIABLE, v);
                }
                node.getExternalResources().add(resourceId);
            } else {
                VariableDeclarationStatement vd;
                if (declaration instanceof VariableDeclarationStatement) {
                    vd = (VariableDeclarationStatement)declaration;
                } else {
                    IdentifierExpression identifier = (IdentifierExpression)declaration;
                    AssignmentExpression assignment = declaration.getParent(AssignmentExpression.class);
                    if (assignment == null || assignment.isNull()) {
                        return null;
                    }
                    Expression initializer = assignment.getRight();
                    initializer.remove();
                    vd = new VariableDeclarationStatement(this._builder.convertType(resourceType), identifier.getIdentifier(), initializer);
                }
                vd.addModifier(Flags.Flag.FINAL);
                declarationStatement.remove();
                node.getDeclaredResources().add(vd);
            }
            caughtParent.remove();
            AstNode resourceDisposal = (AstNode)CollectionUtilities.firstOrDefault(m.get("resourceDisposal"));
            if (resourceDisposal != null) {
                resourceDisposal.remove();
            }
            for (Statement outerResourceDisposal : m.get("outerResourceDisposal")) {
                outerResourceDisposal.remove();
                parent.getStatements().insertAfter(node, outerResourceDisposal);
            }
        }
        return null;
    }

    private boolean notEffectivelyFinal(String resourceName, BlockStatement scope, Statement startingPoint) {
        Statement lastStatement;
        Statement firstStatement = (Statement)Comparer.coalesce((Object)startingPoint, (Object)CollectionUtilities.firstOrDefault(scope.getStatements()));
        if (firstStatement == null || (lastStatement = (Statement)CollectionUtilities.lastOrDefault(scope.getStatements())) == null) {
            return false;
        }
        DefiniteAssignmentAnalysis analysis = new DefiniteAssignmentAnalysis(this.context, scope);
        analysis.setAnalyzedRange(firstStatement, lastStatement);
        analysis.analyze(resourceName, DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED);
        return analysis.isPotentiallyAssigned();
    }

    private boolean canMoveVariableDeclaration(Statement initializeResource, IdentifierExpression resource, Statement node) {
        AstNode parent = node.getParent();
        VariableDeclarationStatement resourceDeclaration = ConvertLoopsTransform.findVariableDeclaration(node, resource.getIdentifier());
        if (resourceDeclaration == null || !(resourceDeclaration.getParent() instanceof BlockStatement) || !(parent instanceof BlockStatement)) {
            return false;
        }
        BlockStatement outerTemp = new BlockStatement();
        BlockStatement temp = new BlockStatement();
        BlockStatement placeholder = new BlockStatement();
        initializeResource.replaceWith(placeholder);
        node.replaceWith(outerTemp);
        temp.add(initializeResource);
        temp.add(node);
        outerTemp.add(temp);
        Statement declarationPoint = ConvertLoopsTransform.canMoveVariableDeclarationIntoStatement(this.context, resourceDeclaration, node);
        node.remove();
        outerTemp.replaceWith(node);
        initializeResource.remove();
        placeholder.replaceWith(initializeResource);
        return declarationPoint == outerTemp;
    }

    private static ParameterDeclaration findDeclaration(IdentifierExpression id, AstNode source) {
        if (id == null || StringUtilities.isNullOrEmpty((String)id.getIdentifier()) || "$any$".equals(id.getIdentifier())) {
            return null;
        }
        NameResolveResult rr = JavaNameResolver.resolve(id.getIdentifier(), source);
        if (!rr.hasMatch() || rr.isAmbiguous()) {
            return null;
        }
        Object c = CollectionUtilities.first(rr.getCandidates());
        boolean isParameter = c instanceof ParameterDefinition;
        if (!isParameter) {
            return null;
        }
        for (MethodDeclaration md : source.getAncestors(MethodDeclaration.class)) {
            for (ParameterDeclaration pd : md.getParameters()) {
                if (pd.getUserData(Keys.PARAMETER_DEFINITION) != c) continue;
                return pd;
            }
        }
        return null;
    }

    protected final class EmptyTryWithResourcesRewriter
    extends ContextTrackingVisitor<Void> {
        private final IfElseStatement _emptyPattern;

        public EmptyTryWithResourcesRewriter() {
            super(NewTryWithResourcesTransform.this.context);
            this._emptyPattern = new IfElseStatement(new BinaryOperatorExpression(new NamedNode("resource", new IdentifierExpression("$any$")).toExpression(), BinaryOperatorType.INEQUALITY, new NullReferenceExpression()), new BlockStatement(new ExpressionStatement(new IdentifierBackReference("resource").toExpression().invoke("close", new Expression[0]))));
        }

        @Override
        public Void visitIfElseStatement(IfElseStatement node, Void data) {
            boolean isExternal;
            Statement declaration;
            BlockStatement body;
            super.visitIfElseStatement(node, data);
            Match m = Match.createNew();
            if (!this._emptyPattern.matches(node, m)) {
                return null;
            }
            IdentifierExpression resource = (IdentifierExpression)CollectionUtilities.first(m.get("resource"));
            String resourceId = resource.getIdentifier();
            MethodDeclaration md = node.getParent(MethodDeclaration.class);
            BlockStatement blockStatement = body = md != null ? md.getBody() : null;
            if (body == null || body.isNull()) {
                return null;
            }
            VariableDeclarationStatement vd = ConvertLoopsTransform.findVariableDeclaration(node, resourceId);
            Expression initializer = null;
            if (vd != null) {
                Statement prev = node.getPreviousStatement();
                Match m2 = Match.createNew();
                if (NewTryWithResourcesTransform.this._resourceDeclaration.matches(prev, m2)) {
                    declaration = (Statement)Comparer.coalesce((Object)CollectionUtilities.firstOrDefault(m2.get("assignment")), (Object)CollectionUtilities.firstOrDefault(m2.get("resource")));
                    initializer = (Expression)CollectionUtilities.firstOrDefault(m2.get("resourceInitializer"));
                } else {
                    declaration = vd;
                }
                if (!NewTryWithResourcesTransform.this.canMoveVariableDeclaration(declaration, resource, node) || NewTryWithResourcesTransform.this.notEffectivelyFinal(resourceId, body, node)) {
                    return null;
                }
                isExternal = false;
            } else {
                if (!this.context.isSupported(LanguageFeature.TRY_EXPRESSION_RESOURCE)) {
                    return null;
                }
                NameResolveResult rr = JavaNameResolver.resolve(resourceId, node);
                if (!rr.hasMatch() || rr.isAmbiguous()) {
                    return null;
                }
                Object d = CollectionUtilities.first(rr.getCandidates());
                if (!(d instanceof ParameterDefinition) || NewTryWithResourcesTransform.this.notEffectivelyFinal(resourceId, body, null)) {
                    return null;
                }
                declaration = null;
                isExternal = true;
            }
            resource.remove();
            if (declaration != null) {
                declaration.remove();
            }
            TryCatchStatement tryCatch = new TryCatchStatement();
            tryCatch.setTryBlock(new BlockStatement());
            if (isExternal) {
                tryCatch.getExternalResources().add(resource);
            } else {
                if (initializer != null) {
                    initializer.remove();
                    vd.getVariables().firstOrNullObject().setInitializer(initializer);
                }
                vd.remove();
                vd.addModifier(Flags.Flag.FINAL);
                tryCatch.getDeclaredResources().add(vd);
            }
            node.replaceWith(tryCatch);
            return null;
        }
    }
}

