/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.ThrowStatement;
import com.strobel.decompiler.patterns.BacktrackingInfo;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.patterns.Role;

public abstract class Expression
extends AstNode {
    public static final Expression[] EMPTY_EXPESSIONS = new Expression[0];
    public static final Expression NULL = new NullExpression();
    public static final int MYSTERY_OFFSET = -34;
    private int _offset;

    protected Expression(int offset) {
        this._offset = offset;
    }

    public int getOffset() {
        return this._offset;
    }

    public void setOffset(int offset) {
        this._offset = offset;
    }

    @Override
    public Expression clone() {
        return (Expression)super.clone();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.EXPRESSION;
    }

    public Role<? extends Expression> getRole() {
        return super.getRole();
    }

    public static Expression forPattern(Pattern pattern) {
        return new PatternPlaceholder((Pattern)VerifyArgument.notNull((Object)pattern, (String)"pattern"));
    }

    public InvocationExpression invoke(Expression ... arguments) {
        return new InvocationExpression(this.getOffset(), this, arguments);
    }

    public InvocationExpression invoke(Iterable<Expression> arguments) {
        return new InvocationExpression(this.getOffset(), this, arguments);
    }

    public InvocationExpression invoke(String methodName, Expression ... arguments) {
        return this.invoke(methodName, (Iterable<AstType>)null, arguments);
    }

    public InvocationExpression invoke(String methodName, Iterable<Expression> arguments) {
        return this.invoke(methodName, null, arguments);
    }

    public InvocationExpression invoke(String methodName, Iterable<AstType> typeArguments, Expression ... arguments) {
        MemberReferenceExpression mre = new MemberReferenceExpression(this.getOffset(), this, methodName, typeArguments);
        return new InvocationExpression(this.getOffset(), (Expression)mre, arguments);
    }

    public InvocationExpression invoke(String methodName, Iterable<AstType> typeArguments, Iterable<Expression> arguments) {
        MemberReferenceExpression mre = new MemberReferenceExpression(this.getOffset(), this, methodName, typeArguments);
        return new InvocationExpression(this.getOffset(), (Expression)mre, arguments);
    }

    public InvocationExpression invoke(MethodReference methodReference, Expression ... arguments) {
        return this.invoke(methodReference, (Iterable<AstType>)null, arguments);
    }

    public InvocationExpression invoke(MethodReference methodReference, Iterable<Expression> arguments) {
        return this.invoke(methodReference, null, arguments);
    }

    public InvocationExpression invoke(MethodReference methodReference, Iterable<AstType> typeArguments, Expression ... arguments) {
        MemberReferenceExpression mre = new MemberReferenceExpression(this.getOffset(), this, methodReference.getName(), typeArguments);
        MethodDefinition methodDefinition = methodReference.resolve();
        mre.putUserData(Keys.MEMBER_REFERENCE, methodReference);
        if (methodDefinition != null) {
            mre.putUserData(Keys.METHOD_DEFINITION, methodDefinition);
        }
        return new InvocationExpression(this.getOffset(), (Expression)mre, arguments);
    }

    public InvocationExpression invoke(MethodReference methodReference, Iterable<AstType> typeArguments, Iterable<Expression> arguments) {
        MemberReferenceExpression mre = new MemberReferenceExpression(this.getOffset(), this, methodReference.getName(), typeArguments);
        MethodDefinition methodDefinition = methodReference.resolve();
        mre.putUserData(Keys.MEMBER_REFERENCE, methodReference);
        if (methodDefinition != null) {
            mre.putUserData(Keys.METHOD_DEFINITION, methodDefinition);
        }
        return new InvocationExpression(this.getOffset(), (Expression)mre, arguments);
    }

    public MemberReferenceExpression member(String memberName) {
        return new MemberReferenceExpression(this.getOffset(), this, memberName, new AstType[0]);
    }

    public MemberReferenceExpression member(FieldReference member) {
        MemberReferenceExpression r = this.member(member.getName());
        r.putUserData(Keys.MEMBER_REFERENCE, member);
        return r;
    }

    public CastExpression cast(AstType type) {
        return new CastExpression(type, this);
    }

    public ReturnStatement makeReturn() {
        return new ReturnStatement(this.getOffset(), this);
    }

    public ThrowStatement makeThrow() {
        return new ThrowStatement(this);
    }

    private static final class PatternPlaceholder
    extends Expression {
        final Pattern child;

        PatternPlaceholder(Pattern child) {
            super(-34);
            this.child = child;
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.PATTERN;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return visitor.visitPatternPlaceholder(this, this.child, data);
        }

        @Override
        public boolean matchesCollection(Role<?> role, INode position, Match match, BacktrackingInfo backtrackingInfo) {
            return this.child.matchesCollection(role, position, match, backtrackingInfo);
        }

        @Override
        public boolean matches(INode other, Match match) {
            return this.child.matches(other, match);
        }
    }

    private static final class NullExpression
    extends Expression {
        public NullExpression() {
            super(-34);
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }
}

