/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.ast;

import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.LanguageFeature;
import com.strobel.assembler.metadata.MetadataFilters;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.MethodBody;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodHandle;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.VariableDefinition;
import com.strobel.core.BooleanBox;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.MutableInteger;
import com.strobel.core.Predicate;
import com.strobel.core.Predicates;
import com.strobel.core.StringComparison;
import com.strobel.core.StringUtilities;
import com.strobel.core.StrongBox;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ast.AstBuilder;
import com.strobel.decompiler.ast.AstCode;
import com.strobel.decompiler.ast.AstKeys;
import com.strobel.decompiler.ast.AstOptimizationStep;
import com.strobel.decompiler.ast.BasicBlock;
import com.strobel.decompiler.ast.Block;
import com.strobel.decompiler.ast.CatchBlock;
import com.strobel.decompiler.ast.Condition;
import com.strobel.decompiler.ast.DefaultMap;
import com.strobel.decompiler.ast.Error;
import com.strobel.decompiler.ast.Expression;
import com.strobel.decompiler.ast.GotoRemoval;
import com.strobel.decompiler.ast.Inlining;
import com.strobel.decompiler.ast.Label;
import com.strobel.decompiler.ast.Lambda;
import com.strobel.decompiler.ast.LockInfo;
import com.strobel.decompiler.ast.LoopsAndConditions;
import com.strobel.decompiler.ast.Node;
import com.strobel.decompiler.ast.PatternMatching;
import com.strobel.decompiler.ast.Range;
import com.strobel.decompiler.ast.TryCatchBlock;
import com.strobel.decompiler.ast.TypeAnalysis;
import com.strobel.decompiler.ast.Variable;
import com.strobel.functions.Consumer;
import com.strobel.functions.Function;
import com.strobel.functions.Supplier;
import com.strobel.functions.Suppliers;
import com.strobel.util.ContractUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AstOptimizer {
    private static final Logger LOG = Logger.getLogger(AstOptimizer.class.getSimpleName());
    private int _nextLabelIndex;
    private static final BooleanBox SCRATCH_BOOLEAN_BOX = new BooleanBox();

    public static void optimize(DecompilerContext context, Block method) {
        AstOptimizer.optimize(context, method, AstOptimizationStep.None);
    }

    public static void optimize(DecompilerContext context, Block method, AstOptimizationStep abortBeforeStep) {
        boolean bl;
        VerifyArgument.notNull((Object)((Object)context), (String)"context");
        VerifyArgument.notNull((Object)method, (String)"method");
        LOG.fine("Beginning bytecode AST optimization...");
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.RemoveRedundantCode)) {
            return;
        }
        AstOptimizer optimizer = new AstOptimizer();
        AstOptimizer.removeRedundantCode(method, context.getSettings());
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.ReduceBranchInstructionSet)) {
            return;
        }
        AstOptimizer.introducePreIncrementOptimization(context, method);
        for (Block block : method.getSelfAndChildrenRecursive(Block.class)) {
            AstOptimizer.reduceBranchInstructionSet(block);
        }
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.InlineVariables)) {
            return;
        }
        Inlining inliningPhase1 = new Inlining(context, method);
        while (inliningPhase1.inlineAllVariables()) {
            inliningPhase1.analyzeMethod();
        }
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.CopyPropagation)) {
            return;
        }
        inliningPhase1.copyPropagation();
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.RewriteFinallyBlocks)) {
            return;
        }
        AstOptimizer.rewriteFinallyBlocks(method);
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.SplitToMovableBlocks)) {
            return;
        }
        for (Block block : method.getSelfAndChildrenRecursive(Block.class)) {
            optimizer.splitToMovableBlocks(block);
        }
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.RemoveUnreachableBlocks)) {
            return;
        }
        AstOptimizer.removeUnreachableBlocks(method);
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.TypeInference)) {
            return;
        }
        TypeAnalysis.run(context, method);
        boolean bl2 = false;
        LOG.fine("Performing block-level bytecode AST optimizations (enable FINER for more detail)...");
        int blockNumber = 0;
        block3: for (Block block : method.getSelfAndChildrenRecursive(Block.class)) {
            int blockRound = 0;
            ++blockNumber;
            do {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Optimizing block #" + blockNumber + ", round " + ++blockRound + "...");
                }
                boolean modified = false;
                if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.RemoveInnerClassAccessNullChecks)) {
                    bl = true;
                    continue block3;
                }
                modified |= AstOptimizer.runOptimization(block, new RemoveInnerClassAccessNullChecksOptimization(context, method));
                if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.PreProcessShortCircuitAssignments)) {
                    bl = true;
                    continue block3;
                }
                modified |= AstOptimizer.runOptimization(block, new PreProcessShortCircuitAssignmentsOptimization(context, method));
                if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.SimplifyShortCircuit)) {
                    bl = true;
                    continue block3;
                }
                modified |= AstOptimizer.runOptimization(block, new SimplifyShortCircuitOptimization(context, method));
                if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.JoinBranchConditions)) {
                    bl = true;
                    continue block3;
                }
                modified |= AstOptimizer.runOptimization(block, new JoinBranchConditionsOptimization(context, method));
                if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.SimplifyTernaryOperator)) {
                    bl = true;
                    continue block3;
                }
                modified |= AstOptimizer.runOptimization(block, new SimplifyTernaryOperatorOptimization(context, method));
                modified |= AstOptimizer.runOptimization(block, new SimplifyTernaryOperatorRoundTwoOptimization(context, method));
                if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.JoinBasicBlocks)) {
                    bl = true;
                    continue block3;
                }
                modified |= AstOptimizer.runOptimization(block, new JoinBasicBlocksOptimization(context, method));
                if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.SimplifyLogicalNot)) {
                    bl = true;
                    continue block3;
                }
                modified |= AstOptimizer.runOptimization(block, new SimplifyLogicalNotOptimization(context, method));
                if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.TransformObjectInitializers)) {
                    bl = true;
                    continue block3;
                }
                modified |= AstOptimizer.runOptimization(block, new TransformObjectInitializersOptimization(context, method));
                if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.TransformArrayInitializers)) {
                    bl = true;
                    continue block3;
                }
                modified |= new Inlining(context, method, true).inlineAllInBlock(block);
                modified |= AstOptimizer.runOptimization(block, new TransformArrayInitializersOptimization(context, method));
                if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.IntroducePostIncrement)) {
                    bl = true;
                    continue block3;
                }
                modified |= AstOptimizer.runOptimization(block, new IntroducePostIncrementOptimization(context, method));
                if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.InlineConditionalAssignments)) {
                    bl = true;
                    continue block3;
                }
                modified |= AstOptimizer.runOptimization(block, new InlineConditionalAssignmentsOptimization(context, method));
                if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.MakeAssignmentExpressions)) {
                    bl = true;
                    continue block3;
                }
                modified |= AstOptimizer.runOptimization(block, new MakeAssignmentExpressionsOptimization(context, method));
                if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.InlineLambdas)) {
                    return;
                }
                modified |= AstOptimizer.runOptimization(block, new InlineLambdasOptimization(context, method));
                if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.InlineVariables2)) {
                    bl = true;
                    continue block3;
                }
                modified |= new Inlining(context, method, true).inlineAllInBlock(block);
                new Inlining(context, method).copyPropagation();
                if (AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.MergeDisparateObjectInitializations)) continue;
                bl = true;
                continue block3;
            } while (modified |= AstOptimizer.mergeDisparateObjectInitializations(context, block));
        }
        if (bl) {
            return;
        }
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.FindLoops)) {
            return;
        }
        for (Block block : method.getSelfAndChildrenRecursive(Block.class)) {
            new LoopsAndConditions(context).findLoops(block);
        }
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.FindConditions)) {
            return;
        }
        for (Block block : method.getSelfAndChildrenRecursive(Block.class)) {
            new LoopsAndConditions(context).findConditions(block);
        }
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.FlattenNestedMovableBlocks)) {
            return;
        }
        AstOptimizer.flattenBasicBlocks(method);
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.RemoveRedundantCode2)) {
            return;
        }
        AstOptimizer.removeRedundantCode(method, context.getSettings());
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.GotoRemoval)) {
            return;
        }
        new GotoRemoval().removeGotos(method);
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.DuplicateReturns)) {
            return;
        }
        AstOptimizer.duplicateReturnStatements(method);
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.ReduceIfNesting)) {
            return;
        }
        AstOptimizer.reduceIfNesting(method);
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.GotoRemoval2)) {
            return;
        }
        new GotoRemoval().removeGotos(method);
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.ReduceComparisonInstructionSet)) {
            return;
        }
        for (Expression e : method.getChildrenAndSelfRecursive(Expression.class)) {
            AstOptimizer.reduceComparisonInstructionSet(e);
        }
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.RecombineVariables)) {
            return;
        }
        AstOptimizer.recombineVariables(method);
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.RemoveRedundantCode3)) {
            return;
        }
        GotoRemoval.removeRedundantCode(method, 3);
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.CleanUpTryBlocks)) {
            return;
        }
        AstOptimizer.cleanUpTryBlocks(method);
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.InlineVariables3)) {
            return;
        }
        Inlining inliningPhase3 = new Inlining(context, method, true);
        inliningPhase3.inlineAllVariables();
        if (!AstOptimizer.shouldPerformStep(abortBeforeStep, AstOptimizationStep.TypeInference2)) {
            return;
        }
        TypeAnalysis.reset(context, method);
        TypeAnalysis.run(context, method);
        LOG.fine("Finished bytecode AST optimization.");
    }

    private static boolean shouldPerformStep(AstOptimizationStep abortBeforeStep, AstOptimizationStep nextStep) {
        if (abortBeforeStep == nextStep) {
            return false;
        }
        if (nextStep.isBlockLevelOptimization()) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Performing block-level optimization: " + (Object)((Object)nextStep) + ".");
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Performing optimization: " + (Object)((Object)nextStep) + ".");
        }
        return true;
    }

    private static void removeUnreachableBlocks(Block method) {
        BasicBlock entryBlock = (BasicBlock)CollectionUtilities.firstOrDefault((Iterable)CollectionUtilities.ofType(method.getBody(), BasicBlock.class));
        if (entryBlock == null) {
            return;
        }
        LinkedHashSet<Label> liveLabels = new LinkedHashSet<Label>();
        DefaultMap embeddedLabels = new DefaultMap(new Supplier<List<Label>>(){

            public List<Label> get() {
                return new ArrayList<Label>();
            }
        });
        for (BasicBlock basicBlock : method.getChildrenAndSelfRecursive(BasicBlock.class)) {
            for (Label label : basicBlock.getChildrenAndSelfRecursive(Label.class)) {
                ((List)embeddedLabels.get(basicBlock)).add(label);
            }
        }
        for (Expression e : method.getChildrenAndSelfRecursive(Expression.class)) {
            if (e.getOperand() instanceof Label) {
                liveLabels.add((Label)e.getOperand());
                continue;
            }
            if (!(e.getOperand() instanceof Label[])) continue;
            Collections.addAll(liveLabels, (Label[])e.getOperand());
        }
        block3: for (BasicBlock basicBlock : method.getChildrenAndSelfRecursive(BasicBlock.class)) {
            List<Node> body = basicBlock.getBody();
            Label entryLabel = (Label)body.get(0);
            if (basicBlock == entryBlock || liveLabels.contains(entryLabel)) continue;
            for (Label label : (List)embeddedLabels.get(basicBlock)) {
                if (!liveLabels.contains(label)) continue;
                continue block3;
            }
            while (body.size() > 1) {
                body.remove(body.size() - 1);
            }
        }
    }

    private static void cleanUpTryBlocks(Block method) {
        for (Block block : method.getChildrenAndSelfRecursive(Block.class)) {
            List<Node> body = block.getBody();
            for (int i = 0; i < body.size(); ++i) {
                TryCatchBlock innerTryCatch;
                if (!(body.get(i) instanceof TryCatchBlock)) continue;
                TryCatchBlock tryCatch = (TryCatchBlock)body.get(i);
                if (tryCatch.getTryBlock().getBody().isEmpty() && (tryCatch.getFinallyBlock() == null || tryCatch.getFinallyBlock().getBody().isEmpty())) {
                    body.remove(i--);
                    continue;
                }
                if (tryCatch.getFinallyBlock() == null || !tryCatch.getCatchBlocks().isEmpty() || tryCatch.getTryBlock().getBody().size() != 1 || !(tryCatch.getTryBlock().getBody().get(0) instanceof TryCatchBlock) || (innerTryCatch = (TryCatchBlock)tryCatch.getTryBlock().getBody().get(0)).getFinallyBlock() != null) continue;
                tryCatch.setTryBlock(innerTryCatch.getTryBlock());
                tryCatch.getCatchBlocks().addAll(innerTryCatch.getCatchBlocks());
            }
        }
    }

    private static void rewriteFinallyBlocks(Block method) {
        AstOptimizer.rewriteSynchronized(method);
        ArrayList<Expression> a = new ArrayList<Expression>();
        StrongBox v = new StrongBox();
        int endFinallyCount = 0;
        for (TryCatchBlock tryCatch : method.getChildrenAndSelfRecursive(TryCatchBlock.class)) {
            Label endFinallyLabel;
            Block finallyBlock = tryCatch.getFinallyBlock();
            if (finallyBlock == null || finallyBlock.getBody().size() < 2) continue;
            List<Node> body = finallyBlock.getBody();
            ArrayList<Variable> exceptionCopies = new ArrayList<Variable>();
            Node lastInFinally = (Node)CollectionUtilities.last(finallyBlock.getBody());
            if (!PatternMatching.matchGetArguments(body.get(0), AstCode.Store, v, a) || !PatternMatching.match((Node)a.get(0), AstCode.LoadException)) continue;
            body.remove(0);
            exceptionCopies.add((Variable)v.get());
            if (body.isEmpty() || !PatternMatching.matchLoadStore(body.get(0), (Variable)v.get(), (StrongBox<Variable>)v)) {
                v.set(null);
            } else {
                exceptionCopies.add((Variable)v.get());
            }
            if (body.size() > 1 && body.get(body.size() - 2) instanceof Label) {
                endFinallyLabel = (Label)body.get(body.size() - 2);
            } else {
                endFinallyLabel = new Label();
                endFinallyLabel.setName("EndFinally_" + endFinallyCount++);
                body.add(body.size() - 1, endFinallyLabel);
            }
            for (Block b : finallyBlock.getSelfAndChildrenRecursive(Block.class)) {
                List<Node> blockBody = b.getBody();
                for (int i = 0; i < blockBody.size(); ++i) {
                    Node node = blockBody.get(i);
                    if (!(node instanceof Expression)) continue;
                    Expression e = (Expression)node;
                    if (PatternMatching.matchLoadStoreAny(node, exceptionCopies, (StrongBox<Variable>)v)) {
                        exceptionCopies.add((Variable)v.get());
                        continue;
                    }
                    if (e == lastInFinally || !PatternMatching.matchGetArguments(e, AstCode.AThrow, a) || !PatternMatching.matchLoadAny((Node)a.get(0), exceptionCopies)) continue;
                    e.setCode(AstCode.Goto);
                    e.setOperand(endFinallyLabel);
                    e.getArguments().clear();
                }
            }
            if (body.size() < 1 || !PatternMatching.matchGetArguments(body.get(body.size() - 1), AstCode.AThrow, a) || !PatternMatching.matchLoadAny((Node)a.get(0), exceptionCopies)) continue;
            body.set(body.size() - 1, new Expression(AstCode.EndFinally, null, -34, new Expression[0]));
        }
    }

    private static void rewriteSynchronized(Block method) {
        StrongBox lockInfoBox = new StrongBox();
        for (Block block : method.getSelfAndChildrenRecursive(Block.class)) {
            List<Node> body = block.getBody();
            for (int i = 0; i < body.size() - 1; ++i) {
                Block finallyBlock;
                TryCatchBlock tryCatch;
                if (!PatternMatching.matchLock(body, i, (Consumer<? super LockInfo>)lockInfoBox) || i + ((LockInfo)lockInfoBox.get()).operationCount >= body.size() || !(body.get(i + ((LockInfo)lockInfoBox.get()).operationCount) instanceof TryCatchBlock) || (tryCatch = (TryCatchBlock)body.get(i + ((LockInfo)lockInfoBox.get()).operationCount)).isSynchronized() || (finallyBlock = tryCatch.getFinallyBlock()) == null) continue;
                List<Node> finallyBody = finallyBlock.getBody();
                LockInfo lockInfo = (LockInfo)lockInfoBox.get();
                if (finallyBody.size() != 3 || !PatternMatching.matchUnlock(finallyBody.get(1), lockInfo)) continue;
                if (AstOptimizer.rewriteSynchronizedCore(tryCatch, lockInfo.operationCount)) {
                    tryCatch.setSynchronized(true);
                } else {
                    StrongBox v = new StrongBox();
                    ArrayList<Variable> lockCopies = new ArrayList<Variable>();
                    if (lockInfo.lockCopy != null) {
                        lockCopies.add(lockInfo.lockCopy);
                    }
                    for (Expression e : tryCatch.getChildrenAndSelfRecursive(Expression.class)) {
                        if (PatternMatching.matchLoadAny(e, lockCopies)) {
                            e.setOperand(lockInfo.lock);
                            continue;
                        }
                        if (!PatternMatching.matchLoadStore(e, lockInfo.lock, (StrongBox<Variable>)v) || v.get() == lockInfo.lock) continue;
                        lockCopies.add((Variable)v.get());
                    }
                }
                AstOptimizer.inlineLockAccess(tryCatch, body, lockInfo);
            }
        }
    }

    private static boolean rewriteSynchronizedCore(TryCatchBlock tryCatch, int depth) {
        List<Node> monitorExitNodes;
        LockInfo lockInfo;
        Block tryBlock = tryCatch.getTryBlock();
        List<Node> tryBody = tryBlock.getBody();
        StrongBox lockInfoBox = new StrongBox();
        switch (tryBody.size()) {
            case 0: {
                return false;
            }
            case 1: {
                lockInfo = null;
                break;
            }
            default: {
                if (PatternMatching.matchLock(tryBody, 0, (Consumer<? super LockInfo>)lockInfoBox)) {
                    lockInfo = (LockInfo)lockInfoBox.get();
                    if (lockInfo.operationCount >= tryBody.size() || !(tryBody.get(lockInfo.operationCount) instanceof TryCatchBlock)) break;
                    TryCatchBlock nestedTry = (TryCatchBlock)tryBody.get(lockInfo.operationCount);
                    Block finallyBlock = nestedTry.getFinallyBlock();
                    if (finallyBlock == null) {
                        return false;
                    }
                    List<Node> finallyBody = finallyBlock.getBody();
                    if (finallyBody.size() != 3 || !PatternMatching.matchUnlock(finallyBody.get(1), lockInfo) || !AstOptimizer.rewriteSynchronizedCore(nestedTry, depth + 1)) break;
                    tryCatch.setSynchronized(true);
                    AstOptimizer.inlineLockAccess(tryCatch, tryBody, lockInfo);
                    return true;
                }
                lockInfo = null;
            }
        }
        boolean skipTrailingBranch = PatternMatching.matchUnconditionalBranch(tryBody.get(tryBody.size() - 1));
        if (tryBody.size() < (skipTrailingBranch ? depth + 1 : depth)) {
            return false;
        }
        int removeTail = tryBody.size() - (skipTrailingBranch ? 1 : 0);
        if (removeTail > 0 && tryBody.get(removeTail - 1) instanceof TryCatchBlock) {
            TryCatchBlock innerTry = (TryCatchBlock)tryBody.get(removeTail - 1);
            List<Node> innerTryBody = innerTry.getTryBlock().getBody();
            if (PatternMatching.matchLock(innerTryBody, 0, (Consumer<? super LockInfo>)lockInfoBox) && AstOptimizer.rewriteSynchronizedCore(innerTry, depth)) {
                AstOptimizer.inlineLockAccess(tryCatch, tryBody, lockInfo);
                tryCatch.setSynchronized(true);
                return true;
            }
            boolean skipInnerTrailingBranch = PatternMatching.matchUnconditionalBranch(innerTryBody.get(innerTryBody.size() - 1));
            if (innerTryBody.size() < (skipInnerTrailingBranch ? depth + 1 : depth)) {
                return false;
            }
            int innerRemoveTail = innerTryBody.size() - (skipInnerTrailingBranch ? 1 : 0);
            monitorExitNodes = innerTryBody.subList(innerRemoveTail - depth, innerRemoveTail);
        } else {
            monitorExitNodes = tryBody.subList(removeTail - depth, removeTail);
        }
        boolean removeAll = CollectionUtilities.all(monitorExitNodes, (Predicate)new Predicate<Node>(){

            public boolean test(Node node) {
                return PatternMatching.match(node, AstCode.MonitorExit);
            }
        });
        if (removeAll) {
            monitorExitNodes.clear();
            if (!tryCatch.getCatchBlocks().isEmpty()) {
                TryCatchBlock newTryCatch = new TryCatchBlock();
                newTryCatch.setTryBlock(tryCatch.getTryBlock());
                newTryCatch.getCatchBlocks().addAll(tryCatch.getCatchBlocks());
                tryCatch.getCatchBlocks().clear();
                tryCatch.setTryBlock(new Block(newTryCatch));
            }
            AstOptimizer.inlineLockAccess(tryCatch, tryBody, lockInfo);
            tryCatch.setSynchronized(true);
            return true;
        }
        return false;
    }

    private static void inlineLockAccess(Node owner, List<Node> body, LockInfo lockInfo) {
        if (lockInfo == null || lockInfo.lockInit == null) {
            return;
        }
        boolean lockCopyUsed = false;
        StrongBox a = new StrongBox();
        ArrayList<Expression> lockAccesses = new ArrayList<Expression>();
        HashSet<Object> lockAccessLoads = new HashSet<Object>();
        for (Expression e : owner.getSelfAndChildrenRecursive(Expression.class)) {
            if (PatternMatching.matchLoad((Node)e, lockInfo.lock) && !lockAccessLoads.contains(e)) {
                return;
            }
            if (lockInfo.lockCopy != null && PatternMatching.matchLoad((Node)e, lockInfo.lockCopy) && !lockAccessLoads.contains(e)) {
                lockCopyUsed = true;
                continue;
            }
            if (!PatternMatching.matchGetArgument(e, AstCode.MonitorEnter, (StrongBox<Expression>)a) && !PatternMatching.matchGetArgument(e, AstCode.MonitorExit, (StrongBox<Expression>)a) || !PatternMatching.matchLoad((Node)a.get(), lockInfo.lock) && (lockInfo.lockCopy == null || !PatternMatching.matchLoad((Node)a.get(), lockInfo.lockCopy))) continue;
            lockAccesses.add(e);
            lockAccessLoads.add(a.get());
        }
        for (Expression e : lockAccesses) {
            e.getArguments().set(0, lockInfo.lockInit.clone());
        }
        body.remove(lockInfo.lockStore);
        lockInfo.lockAcquire.getArguments().set(0, lockInfo.lockInit.clone());
        if (lockInfo.lockCopy != null && !lockCopyUsed) {
            body.remove(lockInfo.lockStoreCopy);
        }
    }

    static void removeRedundantCode(Block method, DecompilerSettings settings) {
        IdentityHashMap<Label, MutableInteger> labelReferenceCount = new IdentityHashMap<Label, MutableInteger>();
        List<Expression> branchExpressions = method.getSelfAndChildrenRecursive(Expression.class, new Predicate<Expression>(){

            public boolean test(Expression e) {
                return e.isBranch();
            }
        });
        for (Expression e : branchExpressions) {
            for (Label branchTarget : e.getBranchTargets()) {
                MutableInteger referenceCount = (MutableInteger)labelReferenceCount.get(branchTarget);
                if (referenceCount == null) {
                    labelReferenceCount.put(branchTarget, new MutableInteger(1));
                    continue;
                }
                referenceCount.increment();
            }
        }
        for (Block block : method.getSelfAndChildrenRecursive(Block.class)) {
            List<Node> body = block.getBody();
            ArrayList<Node> newBody = new ArrayList<Node>(body.size());
            int n = body.size();
            for (int i = 0; i < n; ++i) {
                Node node = body.get(i);
                StrongBox target = new StrongBox();
                ArrayList<Expression> args = new ArrayList<Expression>();
                if (PatternMatching.matchGetOperand(node, AstCode.Goto, target) && i + 1 < body.size() && body.get(i + 1) == target.get()) {
                    if (((MutableInteger)labelReferenceCount.get(target.get())).getValue() != 1) continue;
                    ++i;
                    continue;
                }
                if (PatternMatching.match(node, AstCode.Nop) || PatternMatching.match(node, AstCode.Load)) continue;
                if (PatternMatching.matchGetArguments(node, AstCode.Pop, args)) {
                    StrongBox variable = new StrongBox();
                    if (!PatternMatching.matchGetOperand((Node)args.get(0), AstCode.Load, variable)) {
                        throw new IllegalStateException("Pop should just have Load at this stage.");
                    }
                    StrongBox previousVariable = new StrongBox();
                    StrongBox previousExpression = new StrongBox();
                    if (i - 1 < 0 || !PatternMatching.matchGetArgument(body.get(i - 1), AstCode.Store, previousVariable, (StrongBox<Expression>)previousExpression) || previousVariable.get() != variable.get()) continue;
                    ((Expression)previousExpression.get()).getRanges().addAll(((Expression)node).getRanges());
                    continue;
                }
                if (PatternMatching.matchGetArguments(node, AstCode.Pop2, args)) {
                    StrongBox v1 = new StrongBox();
                    StrongBox v2 = new StrongBox();
                    StrongBox pv1 = new StrongBox();
                    StrongBox pe1 = new StrongBox();
                    if (args.size() == 1) {
                        if (!PatternMatching.matchGetOperand((Node)args.get(0), AstCode.Load, v1)) {
                            throw new IllegalStateException("Pop2 should just have Load arguments at this stage.");
                        }
                        if (!((Variable)v1.get()).getType().getSimpleType().isDoubleWord()) {
                            throw new IllegalStateException("Pop2 instruction has only one single-word operand.");
                        }
                        if (i - 1 < 0 || !PatternMatching.matchGetArgument(body.get(i - 1), AstCode.Store, pv1, (StrongBox<Expression>)pe1) || pv1.get() != v1.get()) continue;
                        ((Expression)pe1.get()).getRanges().addAll(((Expression)node).getRanges());
                        continue;
                    }
                    if (!PatternMatching.matchGetOperand((Node)args.get(0), AstCode.Load, v1) || !PatternMatching.matchGetOperand((Node)args.get(1), AstCode.Load, v2)) {
                        throw new IllegalStateException("Pop2 should just have Load arguments at this stage.");
                    }
                    StrongBox pv2 = new StrongBox();
                    StrongBox pe2 = new StrongBox();
                    if (i - 2 < 0 || !PatternMatching.matchGetArgument(body.get(i - 2), AstCode.Store, pv1, (StrongBox<Expression>)pe1) || pv1.get() != v1.get() || !PatternMatching.matchGetArgument(body.get(i - 1), AstCode.Store, pv2, (StrongBox<Expression>)pe2) || pv2.get() != v2.get()) continue;
                    ((Expression)pe1.get()).getRanges().addAll(((Expression)node).getRanges());
                    ((Expression)pe2.get()).getRanges().addAll(((Expression)node).getRanges());
                    continue;
                }
                if (node instanceof Label) {
                    Label label = (Label)node;
                    MutableInteger referenceCount = (MutableInteger)labelReferenceCount.get(label);
                    if (referenceCount == null || referenceCount.getValue() <= 0) continue;
                    newBody.add(label);
                    continue;
                }
                if (node instanceof TryCatchBlock) {
                    TryCatchBlock tryCatch = (TryCatchBlock)node;
                    if (AstOptimizer.isEmptyTryCatch(tryCatch)) continue;
                    newBody.add(node);
                    continue;
                }
                if (PatternMatching.match(node, AstCode.Switch) && !settings.getRetainPointlessSwitches()) {
                    Expression e = (Expression)node;
                    Label[] targets = (Label[])e.getOperand();
                    if (targets.length == 1) {
                        Expression test = e.getArguments().get(0);
                        e.setCode(AstCode.Goto);
                        e.setOperand(targets[0]);
                        if (Inlining.canBeExpressionStatement(test)) {
                            newBody.add(test);
                        }
                        e.getArguments().clear();
                    }
                    newBody.add(node);
                    continue;
                }
                newBody.add(node);
            }
            body.clear();
            body.addAll(newBody);
        }
        for (Expression e : method.getSelfAndChildrenRecursive(Expression.class)) {
            List<Expression> arguments = e.getArguments();
            int n = arguments.size();
            for (int i = 0; i < n; ++i) {
                Expression argument = arguments.get(i);
                switch (argument.getCode()) {
                    case Dup: 
                    case Dup2: 
                    case DupX1: 
                    case DupX2: 
                    case Dup2X1: 
                    case Dup2X2: {
                        Expression firstArgument = argument.getArguments().get(0);
                        firstArgument.getRanges().addAll(argument.getRanges());
                        arguments.set(i, firstArgument);
                    }
                }
            }
        }
        AstOptimizer.cleanUpTryBlocks(method);
    }

    private static boolean isEmptyTryCatch(TryCatchBlock tryCatch) {
        if (tryCatch.getFinallyBlock() != null && !tryCatch.getFinallyBlock().getBody().isEmpty()) {
            return false;
        }
        if (PatternMatching.matchEmptyBlockOrLeave(tryCatch.getTryBlock())) {
            return true;
        }
        List<Node> body = tryCatch.getTryBlock().getBody();
        StrongBox label = new StrongBox();
        return body.size() == 3 && PatternMatching.matchGetOperand(body.get(0), AstCode.Goto, label) && body.get(1) == label.get() && PatternMatching.match(body.get(2), AstCode.EndFinally);
    }

    private static void introducePreIncrementOptimization(DecompilerContext context, Block method) {
        Inlining inlining = new Inlining(context, method);
        inlining.analyzeMethod();
        for (Block block : method.getSelfAndChildrenRecursive(Block.class)) {
            List<Node> body = block.getBody();
            MutableInteger position = new MutableInteger();
            while (position.getValue() < body.size() - 1) {
                if (!AstOptimizer.introducePreIncrementForVariables(body, position) && !AstOptimizer.introducePreIncrementForStaticFields(body, position, inlining)) {
                    AstOptimizer.introducePreIncrementForInstanceFields(body, position, inlining);
                }
                position.increment();
            }
        }
    }

    private static boolean introducePreIncrementForVariables(List<Node> body, MutableInteger position) {
        int i = position.getValue();
        if (i >= body.size() - 1) {
            return false;
        }
        Node node = body.get(i);
        Node next = body.get(i + 1);
        StrongBox v = new StrongBox();
        StrongBox t = new StrongBox();
        StrongBox d = new StrongBox();
        if (!(node instanceof Expression) || !(next instanceof Expression)) {
            return false;
        }
        Expression e = (Expression)node;
        Expression n = (Expression)next;
        if (PatternMatching.matchGetArgument(e, AstCode.Inc, v, (StrongBox<Expression>)t) && PatternMatching.matchGetOperand((Node)t.get(), AstCode.LdC, Integer.class, d) && Math.abs((Integer)d.get()) == 1 && PatternMatching.match(n, AstCode.Store) && PatternMatching.matchLoad((Node)n.getArguments().get(0), (Variable)v.get())) {
            n.getArguments().set(0, new Expression(AstCode.PreIncrement, d.get(), n.getArguments().get(0).getOffset(), n.getArguments().get(0)));
            body.remove(i);
            position.decrement();
            return true;
        }
        return false;
    }

    private static boolean introducePreIncrementForStaticFields(List<Node> body, MutableInteger position, Inlining inlining) {
        Variable v;
        Variable u;
        int i = position.getValue();
        if (i >= body.size() - 3) {
            return false;
        }
        Node n1 = body.get(i);
        Node n2 = body.get(i + 1);
        Node n3 = body.get(i + 2);
        Node n4 = body.get(i + 3);
        StrongBox tAny = new StrongBox();
        ArrayList<Expression> a = new ArrayList<Expression>();
        if (!PatternMatching.matchGetArguments(n1, AstCode.Store, tAny, a)) {
            return false;
        }
        Variable t = (Variable)tAny.get();
        if (!PatternMatching.matchGetOperand((Node)a.get(0), AstCode.GetStatic, tAny)) {
            return false;
        }
        FieldReference f = (FieldReference)tAny.get();
        if (!(PatternMatching.matchGetArguments(n2, AstCode.Store, tAny, a) && (u = (Variable)tAny.get()) != null && PatternMatching.matchGetOperand((Node)a.get(0), AstCode.LdC, tAny) && tAny.get() instanceof Integer && Math.abs((Integer)tAny.get()) == 1)) {
            return false;
        }
        int amount = (Integer)tAny.get();
        if (PatternMatching.matchGetArguments(n3, AstCode.Store, tAny, a) && inlining.loadCounts.get(v = (Variable)tAny.get()).getValue() > 1 && PatternMatching.matchGetArguments((Node)a.get(0), AstCode.Add, a) && PatternMatching.matchLoad((Node)a.get(0), t) && PatternMatching.matchLoad((Node)a.get(1), u) && PatternMatching.matchGetArguments(n4, AstCode.PutStatic, tAny, a) && tAny.get() instanceof FieldReference && StringUtilities.equals((String)f.getFullName(), (String)((FieldReference)tAny.get()).getFullName()) && PatternMatching.matchLoad((Node)a.get(0), v)) {
            ((Expression)n3).getArguments().set(0, new Expression(AstCode.PreIncrement, (Object)amount, ((Expression)n1).getArguments().get(0).getOffset(), ((Expression)n1).getArguments().get(0)));
            body.remove(i);
            body.remove(i);
            body.remove(i + 1);
            position.decrement();
            return true;
        }
        return false;
    }

    private static boolean introducePreIncrementForInstanceFields(List<Node> body, MutableInteger position, Inlining inlining) {
        boolean field;
        int i = position.getValue();
        if (i < 1 || i >= body.size() - 3) {
            return false;
        }
        if (!(body.get(i) instanceof Expression && body.get(i - 1) instanceof Expression && body.get(i + 1) instanceof Expression && body.get(i + 2) instanceof Expression && body.get(i + 3) instanceof Expression)) {
            return false;
        }
        Expression e0 = (Expression)body.get(i - 1);
        Expression e1 = (Expression)body.get(i);
        StrongBox tVar = new StrongBox();
        ArrayList<Expression> a = new ArrayList<Expression>();
        if (!PatternMatching.matchGetArguments(e0, AstCode.Store, tVar, a)) {
            return false;
        }
        Variable n = (Variable)tVar.get();
        StrongBox unused = new StrongBox();
        if (!(PatternMatching.matchGetArguments(e1, AstCode.Store, tVar, a) && ((field = PatternMatching.match((Node)a.get(0), AstCode.GetField)) ? PatternMatching.matchGetArguments((Node)a.get(0), AstCode.GetField, unused, a) : PatternMatching.matchGetArguments((Node)a.get(0), AstCode.LoadElement, a)) && PatternMatching.matchLoad((Node)a.get(field ? 0 : 1), n))) {
            return false;
        }
        Variable t = (Variable)tVar.get();
        Variable o = field ? null : (Variable)((Expression)a.get(0)).getOperand();
        FieldReference f = field ? (FieldReference)unused.get() : null;
        Expression e2 = (Expression)body.get(i + 1);
        StrongBox amount = new StrongBox();
        if (!PatternMatching.matchGetArguments(e2, AstCode.Store, tVar, a) || !PatternMatching.matchGetOperand((Node)a.get(0), AstCode.LdC, Integer.class, amount) || Math.abs((Integer)amount.get()) != 1) {
            return false;
        }
        Variable u = (Variable)tVar.get();
        Expression e3 = (Expression)body.get(i + 2);
        if (!PatternMatching.matchGetArguments(e3, AstCode.Store, tVar, a) || ((Variable)tVar.get()).isGenerated() && inlining.loadCounts.get(tVar.get()).getValue() <= 1 || !PatternMatching.matchGetArguments((Node)a.get(0), AstCode.Add, a) || !PatternMatching.matchLoad((Node)a.get(0), t) || !PatternMatching.matchLoad((Node)a.get(1), u)) {
            return false;
        }
        Variable v = (Variable)tVar.get();
        Expression e4 = (Expression)body.get(i + 3);
        if (!((field ? PatternMatching.matchGetArguments(e4, AstCode.PutField, unused, a) : PatternMatching.matchGetArguments(e4, AstCode.StoreElement, a)) && (field ? StringUtilities.equals((String)f.getFullName(), (String)((FieldReference)unused.get()).getFullName()) : PatternMatching.matchLoad((Node)a.get(0), o)) && PatternMatching.matchLoad((Node)a.get(field ? 0 : 1), n) && PatternMatching.matchLoad((Node)a.get(field ? 1 : 2), v))) {
            return false;
        }
        Expression newExpression = new Expression(AstCode.PreIncrement, amount.get(), e1.getArguments().get(0).getOffset(), e1.getArguments().get(0));
        e3.getArguments().set(0, newExpression);
        body.remove(i);
        body.remove(i);
        body.remove(i + 1);
        position.decrement();
        return true;
    }

    private static void reduceBranchInstructionSet(Block block) {
        List<Node> body = block.getBody();
        block28: for (int i = 0; i < body.size(); ++i) {
            AstCode code;
            Node node = body.get(i);
            if (!(node instanceof Expression)) continue;
            Expression e = (Expression)node;
            switch (e.getCode()) {
                case __TableSwitch: 
                case __LookupSwitch: 
                case Switch: {
                    e.getArguments().get(0).getRanges().addAll(e.getRanges());
                    e.getRanges().clear();
                    continue block28;
                }
                case __LCmp: 
                case __FCmpL: 
                case __FCmpG: 
                case __DCmpL: 
                case __DCmpG: {
                    if (i == body.size() - 1 || !(body.get(i + 1) instanceof Expression)) continue block28;
                    Expression next = (Expression)body.get(i + 1);
                    switch (next.getCode()) {
                        case __IfEq: {
                            code = AstCode.CmpEq;
                            break;
                        }
                        case __IfNe: {
                            code = AstCode.CmpNe;
                            break;
                        }
                        case __IfLt: {
                            code = AstCode.CmpLt;
                            break;
                        }
                        case __IfGe: {
                            code = AstCode.CmpGe;
                            break;
                        }
                        case __IfGt: {
                            code = AstCode.CmpGt;
                            break;
                        }
                        case __IfLe: {
                            code = AstCode.CmpLe;
                            break;
                        }
                        default: {
                            continue block28;
                        }
                    }
                    body.remove(i);
                    break;
                }
                case __IfEq: {
                    e.getArguments().add(new Expression(AstCode.LdC, (Object)0, e.getOffset(), new Expression[0]));
                    code = AstCode.CmpEq;
                    break;
                }
                case __IfNe: {
                    e.getArguments().add(new Expression(AstCode.LdC, (Object)0, e.getOffset(), new Expression[0]));
                    code = AstCode.CmpNe;
                    break;
                }
                case __IfLt: {
                    e.getArguments().add(new Expression(AstCode.LdC, (Object)0, e.getOffset(), new Expression[0]));
                    code = AstCode.CmpLt;
                    break;
                }
                case __IfGe: {
                    e.getArguments().add(new Expression(AstCode.LdC, (Object)0, e.getOffset(), new Expression[0]));
                    code = AstCode.CmpGe;
                    break;
                }
                case __IfGt: {
                    e.getArguments().add(new Expression(AstCode.LdC, (Object)0, e.getOffset(), new Expression[0]));
                    code = AstCode.CmpGt;
                    break;
                }
                case __IfLe: {
                    e.getArguments().add(new Expression(AstCode.LdC, (Object)0, e.getOffset(), new Expression[0]));
                    code = AstCode.CmpLe;
                    break;
                }
                case __IfICmpEq: {
                    code = AstCode.CmpEq;
                    break;
                }
                case __IfICmpNe: {
                    code = AstCode.CmpNe;
                    break;
                }
                case __IfICmpLt: {
                    code = AstCode.CmpLt;
                    break;
                }
                case __IfICmpGe: {
                    code = AstCode.CmpGe;
                    break;
                }
                case __IfICmpGt: {
                    code = AstCode.CmpGt;
                    break;
                }
                case __IfICmpLe: {
                    code = AstCode.CmpLe;
                    break;
                }
                case __IfACmpEq: {
                    code = AstCode.CmpEq;
                    break;
                }
                case __IfACmpNe: {
                    code = AstCode.CmpNe;
                    break;
                }
                case __IfNull: {
                    e.getArguments().add(new Expression(AstCode.AConstNull, null, e.getOffset(), new Expression[0]));
                    code = AstCode.CmpEq;
                    break;
                }
                case __IfNonNull: {
                    e.getArguments().add(new Expression(AstCode.AConstNull, null, e.getOffset(), new Expression[0]));
                    code = AstCode.CmpNe;
                    break;
                }
                default: {
                    continue block28;
                }
            }
            Expression newExpression = new Expression(code, null, e.getOffset(), e.getArguments());
            body.set(i, new Expression(AstCode.IfTrue, e.getOperand(), newExpression.getOffset(), newExpression));
            newExpression.getRanges().addAll(e.getRanges());
        }
    }

    private static void reduceComparisonInstructionSet(Expression expression) {
        Expression firstArgument;
        List<Expression> arguments = expression.getArguments();
        Expression expression2 = firstArgument = arguments.isEmpty() ? null : arguments.get(0);
        if (PatternMatching.matchSimplifiableComparison(expression)) {
            arguments.clear();
            arguments.addAll(firstArgument.getArguments());
            expression.getRanges().addAll(firstArgument.getRanges());
        }
        if (PatternMatching.matchReversibleComparison(expression)) {
            AstCode reversedCode;
            switch (firstArgument.getCode()) {
                case CmpEq: {
                    reversedCode = AstCode.CmpNe;
                    break;
                }
                case CmpNe: {
                    reversedCode = AstCode.CmpEq;
                    break;
                }
                case CmpLt: {
                    reversedCode = AstCode.CmpGe;
                    break;
                }
                case CmpGe: {
                    reversedCode = AstCode.CmpLt;
                    break;
                }
                case CmpGt: {
                    reversedCode = AstCode.CmpLe;
                    break;
                }
                case CmpLe: {
                    reversedCode = AstCode.CmpGt;
                    break;
                }
                default: {
                    throw ContractUtils.unreachable();
                }
            }
            expression.setCode(reversedCode);
            expression.getRanges().addAll(firstArgument.getRanges());
            arguments.clear();
            arguments.addAll(firstArgument.getArguments());
        }
    }

    private void splitToMovableBlocks(Block block) {
        Label entryLabel;
        ArrayList<BasicBlock> basicBlocks = new ArrayList<BasicBlock>();
        List<Node> body = block.getBody();
        Object firstNode = CollectionUtilities.firstOrDefault(body);
        if (firstNode instanceof Label) {
            entryLabel = (Label)firstNode;
        } else {
            entryLabel = new Label();
            entryLabel.setName("Block_" + this._nextLabelIndex++);
        }
        BasicBlock basicBlock = new BasicBlock();
        List<Node> basicBlockBody = basicBlock.getBody();
        basicBlocks.add(basicBlock);
        basicBlockBody.add(entryLabel);
        block.setEntryGoto(new Expression(AstCode.Goto, (Object)entryLabel, -34, new Expression[0]));
        if (!body.isEmpty()) {
            if (body.get(0) != entryLabel) {
                basicBlockBody.add(body.get(0));
            }
            for (int i = 1; i < body.size(); ++i) {
                Node lastNode = body.get(i - 1);
                Node currentNode = body.get(i);
                if (currentNode instanceof Label || currentNode instanceof TryCatchBlock || lastNode.isConditionalControlFlow() || lastNode.isUnconditionalControlFlow()) {
                    Label exitLabel;
                    Label label;
                    Label label2 = label = currentNode instanceof Label ? (Label)currentNode : new Label("Block_" + this._nextLabelIndex++);
                    if (!lastNode.isUnconditionalControlFlow()) {
                        basicBlockBody.add(new Expression(AstCode.Goto, (Object)label, -34, new Expression[0]));
                    }
                    basicBlock = new BasicBlock();
                    basicBlocks.add(basicBlock);
                    basicBlockBody = basicBlock.getBody();
                    basicBlockBody.add(label);
                    if (currentNode != label) {
                        basicBlockBody.add(currentNode);
                    }
                    if (!(currentNode instanceof TryCatchBlock) || (exitLabel = this.checkExit(currentNode)) == null) continue;
                    body.add(i + 1, new Expression(AstCode.Goto, (Object)exitLabel, -34, new Expression[0]));
                    continue;
                }
                basicBlockBody.add(currentNode);
            }
        }
        body.clear();
        body.addAll(basicBlocks);
    }

    private Label checkExit(Node node) {
        Expression expression;
        AstCode code;
        if (node == null) {
            return null;
        }
        if (node instanceof BasicBlock) {
            return this.checkExit((Node)CollectionUtilities.lastOrDefault(((BasicBlock)node).getBody()));
        }
        if (node instanceof TryCatchBlock) {
            TryCatchBlock tryCatch = (TryCatchBlock)node;
            Label exitLabel = this.checkExit((Node)CollectionUtilities.lastOrDefault(tryCatch.getTryBlock().getBody()));
            if (exitLabel == null) {
                return null;
            }
            for (CatchBlock catchBlock : tryCatch.getCatchBlocks()) {
                if (this.checkExit((Node)CollectionUtilities.lastOrDefault(catchBlock.getBody())) == exitLabel) continue;
                return null;
            }
            Block finallyBlock = tryCatch.getFinallyBlock();
            if (finallyBlock != null && this.checkExit((Node)CollectionUtilities.lastOrDefault(finallyBlock.getBody())) != exitLabel) {
                return null;
            }
            return exitLabel;
        }
        if (node instanceof Expression && (code = (expression = (Expression)node).getCode()) == AstCode.Goto) {
            return (Label)expression.getOperand();
        }
        return null;
    }

    private static boolean mergeDisparateObjectInitializations(DecompilerContext context, Block method) {
        Inlining inlining = new Inlining(context, method);
        IdentityHashMap<Node, Node> parentLookup = new IdentityHashMap<Node, Node>();
        IdentityHashMap<Object, Expression> newExpressions = new IdentityHashMap<Object, Expression>();
        StrongBox variable = new StrongBox();
        StrongBox ctor = new StrongBox();
        ArrayList<Expression> args = new ArrayList<Expression>();
        boolean anyChanged = false;
        parentLookup.put(method, Node.NULL);
        for (Node node : method.getSelfAndChildrenRecursive(Node.class)) {
            if (PatternMatching.matchStore(node, (StrongBox<Variable>)variable, args) && PatternMatching.match((Node)CollectionUtilities.single(args), AstCode.__New)) {
                newExpressions.put(variable.get(), (Expression)node);
            }
            for (Node child : node.getChildren()) {
                if (parentLookup.containsKey(child)) {
                    throw Error.expressionLinkedFromMultipleLocations(child);
                }
                parentLookup.put(child, node);
            }
        }
        for (Expression e : method.getSelfAndChildrenRecursive(Expression.class)) {
            Node parent;
            Expression storeNew;
            if (!PatternMatching.matchGetArguments(e, AstCode.InvokeSpecial, ctor, args) || !((MethodReference)ctor.get()).isConstructor() || args.size() <= 0 || !PatternMatching.matchLoad((Node)CollectionUtilities.first(args), (Consumer<? super Variable>)variable) || (storeNew = (Expression)newExpressions.get(variable.value)) == null || Inlining.count(inlining.storeCounts, (Variable)variable.value) != 1 || !((parent = (Node)parentLookup.get(storeNew)) instanceof Block) && !(parent instanceof BasicBlock)) continue;
            List<Node> body = parent instanceof Block ? ((Block)parent).getBody() : ((BasicBlock)parent).getBody();
            boolean moveInitToNew = false;
            if (parentLookup.get(e) == parent) {
                int newIndex = body.indexOf(storeNew);
                int initIndex = body.indexOf(e);
                if (initIndex > newIndex) {
                    for (int i = newIndex + 1; i < initIndex; ++i) {
                        if (!AstOptimizer.references(body.get(i), (Variable)variable.value)) continue;
                        moveInitToNew = true;
                        break;
                    }
                }
            }
            Expression toRemove = moveInitToNew ? e : storeNew;
            Expression toRewrite = moveInitToNew ? storeNew : e;
            List<Expression> arguments = e.getArguments();
            Expression initExpression = new Expression(AstCode.InitObject, ctor.get(), storeNew.getOffset(), new Expression[0]);
            arguments.remove(0);
            initExpression.getArguments().addAll(arguments);
            initExpression.getRanges().addAll(e.getRanges());
            body.remove(toRemove);
            toRewrite.setCode(AstCode.Store);
            toRewrite.setOperand(variable.value);
            toRewrite.getArguments().clear();
            toRewrite.getArguments().add(initExpression);
            anyChanged = true;
        }
        return anyChanged;
    }

    private static boolean flattenBasicBlocks(Node node) {
        if (node instanceof Block) {
            Block block = (Block)node;
            ArrayList<Node> flatBody = new ArrayList<Node>();
            boolean rerunChildren = false;
            for (Node child : block.getChildren()) {
                rerunChildren |= AstOptimizer.flattenBasicBlocks(child);
                if (child instanceof BasicBlock) {
                    BasicBlock childBasicBlock = (BasicBlock)child;
                    Node firstChild = (Node)CollectionUtilities.firstOrDefault(childBasicBlock.getBody());
                    Node lastChild = (Node)CollectionUtilities.lastOrDefault(childBasicBlock.getBody());
                    if (!(firstChild instanceof Label)) {
                        throw new IllegalStateException("Basic block must start with a label.");
                    }
                    if (lastChild instanceof Expression && !lastChild.isUnconditionalControlFlow()) {
                        throw new IllegalStateException("Basic block must end with an unconditional branch.");
                    }
                    flatBody.addAll(childBasicBlock.getBody());
                    continue;
                }
                flatBody.add(child);
            }
            block.setEntryGoto(null);
            block.getBody().clear();
            block.getBody().addAll(flatBody);
            if (rerunChildren) {
                AstOptimizer.flattenBasicBlocks(block);
            }
            return false;
        }
        if (node != null) {
            for (Node child : node.getChildren()) {
                AstOptimizer.flattenBasicBlocks(child);
            }
            return node instanceof BasicBlock;
        }
        return false;
    }

    private static void duplicateReturnStatements(Block method) {
        int i;
        List<Node> body;
        List<Node> methodBody = method.getBody();
        IdentityHashMap<Node, Node> nextSibling = new IdentityHashMap<Node, Node>();
        StrongBox constant = new StrongBox();
        StrongBox localVariable = new StrongBox();
        StrongBox targetLabel = new StrongBox();
        ArrayList<Expression> returnArguments = new ArrayList<Expression>();
        for (Block block : method.getSelfAndChildrenRecursive(Block.class)) {
            body = block.getBody();
            for (i = 0; i < body.size() - 1; ++i) {
                Node current = body.get(i);
                if (!(current instanceof Label)) continue;
                nextSibling.put(current, body.get(i + 1));
            }
        }
        for (Block block : method.getSelfAndChildrenRecursive(Block.class)) {
            body = block.getBody();
            for (i = 0; i < body.size(); ++i) {
                Node node = body.get(i);
                if (!PatternMatching.matchGetOperand(node, AstCode.Goto, targetLabel)) continue;
                while (nextSibling.get(targetLabel.get()) instanceof Label) {
                    targetLabel.accept((Object)((Label)nextSibling.get(targetLabel.get())));
                }
                Node target = (Node)nextSibling.get(targetLabel.get());
                if (target != null && PatternMatching.matchGetArguments(target, AstCode.Return, returnArguments)) {
                    if (returnArguments.isEmpty()) {
                        body.set(i, new Expression(AstCode.Return, null, -34, new Expression[0]));
                        continue;
                    }
                    if (PatternMatching.matchGetOperand((Node)returnArguments.get(0), AstCode.Load, localVariable)) {
                        body.set(i, new Expression(AstCode.Return, null, -34, new Expression(AstCode.Load, localVariable.get(), -34, new Expression[0])));
                        continue;
                    }
                    if (!PatternMatching.matchGetOperand((Node)returnArguments.get(0), AstCode.LdC, constant)) continue;
                    body.set(i, new Expression(AstCode.Return, null, -34, new Expression(AstCode.LdC, constant.get(), -34, new Expression[0])));
                    continue;
                }
                if (methodBody.isEmpty() || methodBody.get(methodBody.size() - 1) != targetLabel.get()) continue;
                body.set(i, new Expression(AstCode.Return, null, -34, new Expression[0]));
            }
        }
    }

    private static void reduceIfNesting(Node node) {
        if (node instanceof Block) {
            Block block = (Block)node;
            List<Node> blockBody = block.getBody();
            for (int i = 0; i < blockBody.size(); ++i) {
                boolean falseExits;
                Node n = blockBody.get(i);
                if (!(n instanceof Condition)) continue;
                Condition condition = (Condition)n;
                Node trueEnd = (Node)CollectionUtilities.lastOrDefault(condition.getTrueBlock().getBody());
                Node falseEnd = (Node)CollectionUtilities.lastOrDefault(condition.getFalseBlock().getBody());
                boolean trueExits = trueEnd != null && trueEnd.isUnconditionalControlFlow();
                boolean bl = falseExits = falseEnd != null && falseEnd.isUnconditionalControlFlow();
                if (trueExits) {
                    blockBody.addAll(i + 1, condition.getFalseBlock().getChildren());
                    condition.setFalseBlock(new Block());
                } else if (falseExits) {
                    blockBody.addAll(i + 1, condition.getTrueBlock().getChildren());
                    condition.setTrueBlock(new Block());
                }
                if (!condition.getTrueBlock().getChildren().isEmpty() || condition.getFalseBlock().getChildren().isEmpty()) continue;
                Block temp = condition.getTrueBlock();
                Expression conditionExpression = condition.getCondition();
                condition.setTrueBlock(condition.getFalseBlock());
                condition.setFalseBlock(temp);
                condition.setCondition(AstOptimizer.simplifyLogicalNot(new Expression(AstCode.LogicalNot, null, conditionExpression.getOffset(), conditionExpression)));
            }
        }
        for (Node child : node.getChildren()) {
            if (child == null || child instanceof Expression) continue;
            AstOptimizer.reduceIfNesting(child);
        }
    }

    private static void recombineVariables(Block method) {
        final IdentityHashMap map = new IdentityHashMap();
        AstOptimizer.replaceVariables(method, new Function<Variable, Variable>(){

            public final Variable apply(Variable v) {
                VariableDefinition originalVariable = v.getOriginalVariable();
                if (originalVariable == null) {
                    return v;
                }
                Variable combinedVariable = (Variable)map.get(originalVariable);
                if (combinedVariable == null) {
                    map.put(originalVariable, v);
                    combinedVariable = v;
                }
                return combinedVariable;
            }
        });
    }

    private static boolean runOptimization(Block block, BasicBlockOptimization optimization) {
        boolean modified = false;
        List<Node> body = block.getBody();
        for (int i = body.size() - 1; i >= 0; --i) {
            if (i >= body.size() || !optimization.run(body, (BasicBlock)body.get(i), i)) continue;
            modified = true;
            ++i;
        }
        return modified;
    }

    private static boolean runOptimization(Block block, ExpressionOptimization optimization) {
        boolean modified = false;
        for (Node node : block.getBody()) {
            BasicBlock basicBlock = (BasicBlock)node;
            List<Node> body = basicBlock.getBody();
            for (int i = body.size() - 1; i >= 0; --i) {
                Node n;
                if (i >= body.size() || !((n = body.get(i)) instanceof Expression) || !optimization.run(body, (Expression)n, i)) continue;
                modified = true;
                ++i;
            }
        }
        return modified;
    }

    public static void replaceVariables(Node node, Function<Variable, Variable> mapping) {
        if (node instanceof Expression) {
            Expression expression = (Expression)node;
            Object operand = expression.getOperand();
            if (operand instanceof Variable) {
                expression.setOperand(mapping.apply((Object)((Variable)operand)));
            }
            for (Expression argument : expression.getArguments()) {
                AstOptimizer.replaceVariables(argument, mapping);
            }
        } else {
            CatchBlock catchBlock;
            Variable exceptionVariable;
            if (node instanceof CatchBlock && (exceptionVariable = (catchBlock = (CatchBlock)node).getExceptionVariable()) != null) {
                catchBlock.setExceptionVariable((Variable)mapping.apply((Object)exceptionVariable));
            }
            for (Node child : node.getChildren()) {
                AstOptimizer.replaceVariables(child, mapping);
            }
        }
    }

    static <T> void removeOrThrow(Collection<T> collection, T item) {
        if (!collection.remove(item)) {
            throw new IllegalStateException("The item was not found in the collection.");
        }
    }

    static void removeTail(List<Node> body, AstCode ... codes) {
        for (int i = 0; i < codes.length; ++i) {
            if (((Expression)body.get(body.size() - codes.length + i)).getCode() == codes[i]) continue;
            throw new IllegalStateException("Tailing code does not match expected.");
        }
        for (AstCode code : codes) {
            body.remove(body.size() - 1);
        }
    }

    static Expression makeLeftAssociativeShortCircuit(AstCode code, Expression left, Expression right) {
        if (PatternMatching.match(right, code)) {
            Expression current = right;
            while (PatternMatching.match(current.getArguments().get(0), code)) {
                current = current.getArguments().get(0);
            }
            Expression newArgument = new Expression(code, null, left.getOffset(), left, current.getArguments().get(0));
            newArgument.setInferredType(BuiltinTypes.Boolean);
            current.getArguments().set(0, newArgument);
            return right;
        }
        Expression newExpression = new Expression(code, null, left.getOffset(), left, right);
        newExpression.setInferredType(BuiltinTypes.Boolean);
        return newExpression;
    }

    static Expression simplifyLogicalNot(Expression expression) {
        Expression result = AstOptimizer.simplifyLogicalNot(expression, SCRATCH_BOOLEAN_BOX);
        return result != null ? result : expression;
    }

    static Expression simplifyLogicalNot(Expression expression, BooleanBox modified) {
        Expression condition;
        Expression a;
        Expression operand;
        Expression e = expression;
        List<Expression> arguments = e.getArguments();
        StrongBox b = new StrongBox();
        Expression expression2 = operand = arguments.isEmpty() ? null : arguments.get(0);
        if (e.getCode() == AstCode.CmpEq && TypeAnalysis.isBoolean(operand.getInferredType()) && PatternMatching.matchBooleanConstant(a = arguments.get(1), (Consumer<? super Boolean>)b) && Boolean.FALSE.equals(b.get())) {
            e.setCode(AstCode.LogicalNot);
            e.getRanges().addAll(a.getRanges());
            arguments.remove(1);
            modified.set((Object)true);
        }
        Expression result = null;
        if (e.getCode() == AstCode.CmpNe && TypeAnalysis.isBoolean(operand.getInferredType()) && PatternMatching.matchBooleanConstant(arguments.get(1), (Consumer<? super Boolean>)b) && Boolean.FALSE.equals(b.get())) {
            modified.set((Object)true);
            return e.getArguments().get(0);
        }
        if (e.getCode() == AstCode.TernaryOp && PatternMatching.match(condition = arguments.get(0), AstCode.LogicalNot)) {
            Expression temp = arguments.get(1);
            arguments.set(0, condition.getArguments().get(0));
            arguments.set(1, arguments.get(2));
            arguments.set(2, temp);
        }
        while (e.getCode() == AstCode.LogicalNot) {
            a = operand;
            if (a.getCode() == AstCode.LogicalNot) {
                result = a.getArguments().get(0);
                result.getRanges().addAll(e.getRanges());
                result.getRanges().addAll(a.getRanges());
                e = result;
                arguments = e.getArguments();
                continue;
            }
            if (!AstOptimizer.simplifyLogicalNotArgument(a)) break;
            result = e = a;
            arguments = e.getArguments();
            modified.set((Object)true);
            break;
        }
        for (int i = 0; i < arguments.size(); ++i) {
            a = AstOptimizer.simplifyLogicalNot(arguments.get(i), modified);
            if (a == null) continue;
            arguments.set(i, a);
            modified.set((Object)true);
        }
        return result;
    }

    static boolean simplifyLogicalNotArgument(Expression e) {
        if (!AstOptimizer.canSimplifyLogicalNotArgument(e)) {
            return false;
        }
        List<Expression> arguments = e.getArguments();
        switch (e.getCode()) {
            case CmpEq: 
            case CmpNe: 
            case CmpLt: 
            case CmpGe: 
            case CmpGt: 
            case CmpLe: {
                e.setCode(e.getCode().reverse());
                return true;
            }
            case LogicalNot: {
                Expression a = arguments.get(0);
                e.setCode(a.getCode());
                e.setOperand(a.getOperand());
                arguments.clear();
                arguments.addAll(a.getArguments());
                e.getRanges().addAll(a.getRanges());
                return true;
            }
            case LogicalAnd: 
            case LogicalOr: {
                if (!AstOptimizer.simplifyLogicalNotArgument(arguments.get(0))) {
                    AstOptimizer.negate(arguments.get(0));
                }
                if (!AstOptimizer.simplifyLogicalNotArgument(arguments.get(1))) {
                    AstOptimizer.negate(arguments.get(1));
                }
                e.setCode(e.getCode().reverse());
                return true;
            }
            case TernaryOp: {
                AstOptimizer.simplifyLogicalNotArgument(arguments.get(1));
                AstOptimizer.simplifyLogicalNotArgument(arguments.get(2));
                return true;
            }
        }
        return TypeAnalysis.isBoolean(e.getInferredType()) && AstOptimizer.negate(e);
    }

    private static boolean negate(Expression e) {
        if (TypeAnalysis.isBoolean(e.getInferredType())) {
            Expression copy = e.clone();
            e.setCode(AstCode.LogicalNot);
            e.setOperand(null);
            e.getArguments().clear();
            e.getArguments().add(copy);
            return true;
        }
        return false;
    }

    private static boolean canSimplifyLogicalNotArgument(Expression e) {
        switch (e.getCode()) {
            case CmpEq: 
            case CmpNe: 
            case CmpLt: 
            case CmpGe: 
            case CmpGt: 
            case CmpLe: {
                return true;
            }
            case LogicalNot: {
                return true;
            }
            case LogicalAnd: 
            case LogicalOr: {
                List<Expression> arguments = e.getArguments();
                return AstOptimizer.canSimplifyLogicalNotArgument(arguments.get(0)) || AstOptimizer.canSimplifyLogicalNotArgument(arguments.get(1));
            }
            case TernaryOp: {
                return TypeAnalysis.isBoolean(e.getInferredType()) && AstOptimizer.canSimplifyLogicalNotArgument(e.getArguments().get(1)) && AstOptimizer.canSimplifyLogicalNotArgument(e.getArguments().get(2));
            }
        }
        return false;
    }

    static boolean references(Node node, Variable v) {
        for (Expression e : node.getSelfAndChildrenRecursive(Expression.class)) {
            if (!PatternMatching.matchLoad((Node)e, v)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsMatch(Node node, Expression pattern) {
        for (Expression e : node.getSelfAndChildrenRecursive(Expression.class)) {
            if (!e.isEquivalentTo(pattern)) continue;
            return true;
        }
        return false;
    }

    private static abstract class AbstractBranchBlockOptimization
    extends AbstractBasicBlockOptimization {
        protected final StrongBox<Expression> expression = new StrongBox();
        protected final StrongBox<Label> label1 = new StrongBox();
        protected final StrongBox<Label> label2 = new StrongBox();

        public AbstractBranchBlockOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        public final boolean run(List<Node> body, BasicBlock head, int position) {
            if (PatternMatching.matchLastAndBreak(head, AstCode.IfTrue, this.label1, this.expression, this.label2)) {
                Label thenLabel = (Label)this.label1.get();
                Label elseLabel = (Label)this.label2.get();
                Expression condition = (Expression)this.expression.get();
                return this.run(body, head, condition, thenLabel, elseLabel, false) || this.run(body, head, condition, elseLabel, thenLabel, true);
            }
            return false;
        }

        protected abstract boolean run(List<Node> var1, BasicBlock var2, Expression var3, Label var4, Label var5, boolean var6);
    }

    private static abstract class AbstractExpressionOptimization
    implements ExpressionOptimization {
        protected final DecompilerContext context;
        protected final MetadataSystem metadataSystem;
        protected final Block method;

        protected AbstractExpressionOptimization(DecompilerContext context, Block method) {
            this.context = (DecompilerContext)((Object)VerifyArgument.notNull((Object)((Object)context), (String)"context"));
            this.metadataSystem = MetadataSystem.instance();
            this.method = (Block)VerifyArgument.notNull((Object)method, (String)"method");
        }
    }

    private static abstract class AbstractBasicBlockOptimization
    implements BasicBlockOptimization {
        protected static final BasicBlock EMPTY_BLOCK = new BasicBlock();
        protected final Map<Label, MutableInteger> labelGlobalRefCount = new DefaultMap<Label, MutableInteger>(MutableInteger.SUPPLIER);
        protected final Map<Label, BasicBlock> labelToBasicBlock = new DefaultMap<Label, BasicBlock>(Suppliers.forValue((Object)EMPTY_BLOCK));
        protected final DecompilerContext context;
        protected final IMetadataResolver resolver;
        protected final Block method;

        protected AbstractBasicBlockOptimization(DecompilerContext context, Block method) {
            this.context = (DecompilerContext)((Object)VerifyArgument.notNull((Object)((Object)context), (String)"context"));
            this.resolver = context.getCurrentType().getResolver();
            this.method = (Block)VerifyArgument.notNull((Object)method, (String)"method");
            for (Expression e : method.getSelfAndChildrenRecursive(Expression.class)) {
                if (!e.isBranch()) continue;
                for (Label target : e.getBranchTargets()) {
                    this.labelGlobalRefCount.get(target).increment();
                }
            }
            for (BasicBlock basicBlock : method.getSelfAndChildrenRecursive(BasicBlock.class)) {
                for (Node child : basicBlock.getChildren()) {
                    if (!(child instanceof Label)) continue;
                    this.labelToBasicBlock.put((Label)child, basicBlock);
                }
            }
        }
    }

    private static interface ExpressionOptimization {
        public boolean run(List<Node> var1, Expression var2, int var3);
    }

    private static interface BasicBlockOptimization {
        public boolean run(List<Node> var1, BasicBlock var2, int var3);
    }

    private static final class JoinBranchConditionsOptimization
    extends AbstractBranchBlockOptimization {
        public JoinBranchConditionsOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        protected boolean run(List<Node> body, BasicBlock branchBlock, Expression branchCondition, Label thenLabel, Label elseLabel, boolean negate) {
            if (((MutableInteger)this.labelGlobalRefCount.get(elseLabel)).getValue() != 1) {
                return false;
            }
            BasicBlock elseBlock = (BasicBlock)this.labelToBasicBlock.get(elseLabel);
            if (PatternMatching.matchSingleAndBreak(elseBlock, AstCode.IfTrue, this.label1, (StrongBox<Expression>)this.expression, (StrongBox<Label>)this.label2)) {
                Label elseThenLabel = (Label)this.label1.get();
                Label elseElseLabel = (Label)this.label2.get();
                Expression elseCondition = (Expression)this.expression.get();
                return this.runCore(body, branchBlock, branchCondition, thenLabel, elseLabel, elseCondition, negate, elseThenLabel, elseElseLabel, false) || this.runCore(body, branchBlock, branchCondition, thenLabel, elseLabel, elseCondition, negate, elseElseLabel, elseThenLabel, true);
            }
            return false;
        }

        private boolean runCore(List<Node> body, BasicBlock branchBlock, Expression branchCondition, Label thenLabel, Label elseLabel, Expression elseCondition, boolean negateFirst, Label elseThenLabel, Label elseElseLabel, boolean negateSecond) {
            BasicBlock thenBlock = (BasicBlock)this.labelToBasicBlock.get(thenLabel);
            BasicBlock elseThenBlock = (BasicBlock)this.labelToBasicBlock.get(elseThenLabel);
            BasicBlock alsoRemove = null;
            Label alsoDecrement = null;
            if (elseThenBlock != thenBlock) {
                if (PatternMatching.matchSimpleBreak(elseThenBlock, (StrongBox<Label>)this.label1) && ((MutableInteger)this.labelGlobalRefCount.get(this.label1.get())).getValue() <= 2) {
                    BasicBlock intermediateBlock = (BasicBlock)this.labelToBasicBlock.get(this.label1.get());
                    if (intermediateBlock != thenBlock) {
                        return false;
                    }
                    alsoRemove = elseThenBlock;
                    alsoDecrement = (Label)this.label1.get();
                } else {
                    return false;
                }
            }
            BasicBlock elseBlock = (BasicBlock)this.labelToBasicBlock.get(elseLabel);
            Expression[] expressionArray = new Expression[2];
            Expression expression = negateFirst ? (AstOptimizer.simplifyLogicalNotArgument(branchCondition) ? branchCondition : new Expression(AstCode.LogicalNot, null, branchCondition.getOffset(), branchCondition)) : (expressionArray[0] = branchCondition);
            expressionArray[1] = negateSecond ? (AstOptimizer.simplifyLogicalNotArgument(elseCondition) ? elseCondition : new Expression(AstCode.LogicalNot, null, elseCondition.getOffset(), elseCondition)) : elseCondition;
            Expression logicExpression = new Expression(AstCode.LogicalOr, null, -34, expressionArray);
            List<Node> branchBody = branchBlock.getBody();
            AstOptimizer.removeTail(branchBody, AstCode.IfTrue, AstCode.Goto);
            branchBody.add(new Expression(AstCode.IfTrue, (Object)thenLabel, logicExpression.getOffset(), logicExpression));
            branchBody.add(new Expression(AstCode.Goto, (Object)elseElseLabel, -34, new Expression[0]));
            ((MutableInteger)this.labelGlobalRefCount.get(elseLabel)).decrement();
            ((MutableInteger)this.labelGlobalRefCount.get(elseThenLabel)).decrement();
            body.remove(elseBlock);
            if (alsoRemove != null) {
                body.remove(alsoRemove);
            }
            if (alsoDecrement != null) {
                ((MutableInteger)this.labelGlobalRefCount.get(alsoDecrement)).decrement();
            }
            return true;
        }
    }

    private static final class InlineLambdasOptimization
    extends AbstractExpressionOptimization {
        private final MutableInteger _lambdaCount = new MutableInteger();

        protected InlineLambdasOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        public boolean run(List<Node> body, Expression head, int position) {
            if (!this.context.isSupported(LanguageFeature.LAMBDA_EXPRESSIONS)) {
                return false;
            }
            StrongBox c = new StrongBox();
            ArrayList<Expression> a = new ArrayList<Expression>();
            boolean modified = false;
            for (Expression e : head.getChildrenAndSelfRecursive(Expression.class)) {
                Lambda lambda;
                if (!PatternMatching.matchGetArguments(e, AstCode.InvokeDynamic, c, a) || (lambda = this.tryInlineLambda(e, (DynamicCallSite)c.value)) == null) continue;
                modified = true;
            }
            return modified;
        }

        private Lambda tryInlineLambda(Expression site, DynamicCallSite callSite) {
            MethodReference bootstrapMethod = callSite.getBootstrapMethod();
            if ("java/lang/invoke/LambdaMetafactory".equals(bootstrapMethod.getDeclaringType().getInternalName()) && (StringUtilities.equals((String)"metafactory", (String)bootstrapMethod.getName(), (StringComparison)StringComparison.OrdinalIgnoreCase) || StringUtilities.equals((String)"altMetafactory", (String)bootstrapMethod.getName(), (StringComparison)StringComparison.OrdinalIgnoreCase)) && callSite.getBootstrapArguments().size() >= 3 && callSite.getBootstrapArguments().get(1) instanceof MethodHandle) {
                MethodHandle targetMethodHandle = (MethodHandle)callSite.getBootstrapArguments().get(1);
                MethodReference targetMethod = targetMethodHandle.getMethod();
                MethodDefinition resolvedMethod = targetMethod.resolve();
                if (resolvedMethod == null || resolvedMethod.getBody() == null || !resolvedMethod.isSynthetic()) {
                    return null;
                }
                TypeReference functionType = callSite.getMethodType().getReturnType();
                List<MethodReference> methods = MetadataHelper.findMethods(functionType, MetadataFilters.matchName(callSite.getMethodName()));
                MethodDefinition functionMethod = null;
                for (MethodReference m : methods) {
                    MethodDefinition r = m.resolve();
                    if (r == null || !r.isAbstract() || r.isStatic() || r.isDefault()) continue;
                    functionMethod = r;
                    break;
                }
                if (functionMethod == null) {
                    return null;
                }
                DecompilerContext innerContext = new DecompilerContext(this.context.getSettings());
                innerContext.setCurrentType(resolvedMethod.getDeclaringType());
                innerContext.setCurrentMethod(resolvedMethod);
                MethodBody methodBody = resolvedMethod.getBody();
                List<ParameterDefinition> parameters = resolvedMethod.getParameters();
                ArrayList<Node> nodes = new ArrayList<Node>();
                Block body = new Block();
                Lambda lambda = new Lambda(body, functionType);
                lambda.setMethod(functionMethod);
                lambda.setCallSite(callSite);
                List<Variable> lambdaParameters = lambda.getParameters();
                if (resolvedMethod.hasThis()) {
                    Variable variable = new Variable();
                    variable.setName("this");
                    variable.setType(this.context.getCurrentMethod().getDeclaringType());
                    variable.setOriginalParameter(this.context.getCurrentMethod().getBody().getThisParameter());
                    lambdaParameters.add(variable);
                }
                for (ParameterDefinition p : parameters) {
                    Variable variable = new Variable();
                    variable.setName(p.getName());
                    variable.setType(p.getParameterType());
                    variable.setOriginalParameter(p);
                    variable.setLambdaParameter(true);
                    lambdaParameters.add(variable);
                }
                List<Expression> arguments = site.getArguments();
                for (int i = 0; i < arguments.size(); ++i) {
                    Variable v = lambdaParameters.get(0);
                    v.setOriginalParameter(null);
                    v.setGenerated(true);
                    Expression argument = arguments.get(i).clone();
                    nodes.add(new Expression(AstCode.Store, (Object)v, argument.getOffset(), argument));
                    lambdaParameters.remove(0);
                }
                arguments.clear();
                nodes.addAll(AstBuilder.build(methodBody, true, innerContext));
                body.getBody().addAll(nodes);
                AstOptimizer.optimize(innerContext, body, AstOptimizationStep.InlineVariables2);
                int lambdaId = this._lambdaCount.increment().getValue();
                HashSet<Label> renamedLabels = new HashSet<Label>();
                for (Node n : body.getSelfAndChildrenRecursive()) {
                    if (n instanceof Label) {
                        Label label = (Label)n;
                        if (!renamedLabels.add(label)) continue;
                        label.setName(label.getName() + "_" + lambdaId);
                        continue;
                    }
                    if (!(n instanceof Expression)) continue;
                    Expression e = (Expression)n;
                    Object operand = e.getOperand();
                    if (operand instanceof Label) {
                        Label label = (Label)operand;
                        if (renamedLabels.add(label)) {
                            label.setName(label.getName() + "_" + lambdaId);
                        }
                    } else if (operand instanceof Label[]) {
                        for (Label label : (Label[])operand) {
                            if (!renamedLabels.add(label)) continue;
                            label.setName(label.getName() + "_" + lambdaId);
                        }
                    }
                    if (!PatternMatching.match(e, AstCode.Return)) continue;
                    e.putUserData(AstKeys.PARENT_LAMBDA_BINDING, site);
                }
                site.setCode(AstCode.Bind);
                site.setOperand(lambda);
                List<Range> ranges = site.getRanges();
                for (Expression e : lambda.getSelfAndChildrenRecursive(Expression.class)) {
                    ranges.addAll(e.getRanges());
                }
                return lambda;
            }
            return null;
        }
    }

    private static final class IntroducePostIncrementOptimization
    extends AbstractExpressionOptimization {
        protected IntroducePostIncrementOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        public boolean run(List<Node> body, Expression head, int position) {
            Expression newExpression;
            boolean modified = this.introducePostIncrementForVariables(body, head, position);
            assert (body.get(position) == head);
            if (position > 0 && (newExpression = this.introducePostIncrementForInstanceFields(head, body.get(position - 1))) != null) {
                modified = true;
                body.remove(position);
                new Inlining(this.context, this.method).inlineIfPossible(body, new MutableInteger(position - 1));
            }
            return modified;
        }

        private boolean introducePostIncrementForVariables(List<Node> body, Expression e, int position) {
            StrongBox incrementAmount;
            Expression add;
            AstCode incrementCode;
            StrongBox variable = new StrongBox();
            final StrongBox initializer = new StrongBox();
            if (!PatternMatching.matchGetArgument(e, AstCode.Store, variable, (StrongBox<Expression>)initializer) || !((Variable)variable.get()).isGenerated()) {
                return false;
            }
            Node next = (Node)CollectionUtilities.getOrDefault(body, (int)(position + 1));
            if (!(next instanceof Expression)) {
                return false;
            }
            final Expression nextExpression = (Expression)next;
            AstCode loadCode = ((Expression)initializer.get()).getCode();
            AstCode storeCode = nextExpression.getCode();
            boolean recombineVariables = false;
            switch (loadCode) {
                case Load: {
                    Variable storeVariable;
                    if (storeCode != AstCode.Inc && storeCode != AstCode.Store) {
                        return false;
                    }
                    Variable loadVariable = (Variable)((Expression)initializer.get()).getOperand();
                    if (loadVariable == (storeVariable = (Variable)nextExpression.getOperand())) break;
                    if (loadVariable.getOriginalVariable() != null && loadVariable.getOriginalVariable() == storeVariable.getOriginalVariable()) {
                        recombineVariables = true;
                        break;
                    }
                    return false;
                }
                case GetStatic: {
                    if (storeCode != AstCode.PutStatic) {
                        return false;
                    }
                    FieldReference initializerOperand = (FieldReference)((Expression)initializer.get()).getOperand();
                    FieldReference nextOperand = (FieldReference)nextExpression.getOperand();
                    if (initializerOperand != null && nextOperand != null && StringUtilities.equals((String)initializerOperand.getFullName(), (String)nextOperand.getFullName())) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            if ((incrementCode = this.getIncrementCode(add = storeCode == AstCode.Inc ? nextExpression : nextExpression.getArguments().get(0), (StrongBox<Number>)(incrementAmount = new StrongBox()))) == AstCode.Nop || !PatternMatching.match(add, AstCode.Inc) && !PatternMatching.match(add.getArguments().get(0), AstCode.Load)) {
                return false;
            }
            if (recombineVariables) {
                AstOptimizer.replaceVariables(this.method, new Function<Variable, Variable>(){

                    public Variable apply(Variable old) {
                        return old == nextExpression.getOperand() ? (Variable)((Expression)initializer.get()).getOperand() : old;
                    }
                });
            }
            e.getArguments().set(0, new Expression(incrementCode, incrementAmount.get(), ((Expression)initializer.get()).getOffset(), (Expression)initializer.get()));
            body.remove(position + 1);
            return true;
        }

        private Expression introducePostIncrementForInstanceFields(Expression e, Node previous) {
            if (!(previous instanceof Expression)) {
                return null;
            }
            Expression p = (Expression)previous;
            StrongBox t = new StrongBox();
            StrongBox initialValue = new StrongBox();
            if (!PatternMatching.matchGetArgument(p, AstCode.Store, t, (StrongBox<Expression>)initialValue) || ((Expression)initialValue.get()).getCode() != AstCode.GetField && ((Expression)initialValue.get()).getCode() != AstCode.LoadElement) {
                return null;
            }
            AstCode code = e.getCode();
            Variable tempVariable = (Variable)t.get();
            if (code != AstCode.PutField && code != AstCode.StoreElement) {
                return null;
            }
            List<Expression> arguments = e.getArguments();
            int n = arguments.size() - 1;
            for (int i = 0; i < n; ++i) {
                if (arguments.get(i).getCode() == AstCode.Load) continue;
                return null;
            }
            StrongBox incrementAmount = new StrongBox();
            Expression add = arguments.get(arguments.size() - 1);
            AstCode incrementCode = this.getIncrementCode(add, (StrongBox<Number>)incrementAmount);
            if (incrementCode == AstCode.Nop) {
                return null;
            }
            List<Expression> addArguments = add.getArguments();
            if (!PatternMatching.matchGetOperand(addArguments.get(0), AstCode.Load, t) || t.get() != tempVariable) {
                return null;
            }
            if (e.getCode() == AstCode.PutField) {
                if (((Expression)initialValue.get()).getCode() != AstCode.GetField) {
                    return null;
                }
                FieldReference getField = (FieldReference)((Expression)initialValue.get()).getOperand();
                FieldReference setField = (FieldReference)e.getOperand();
                if (!StringUtilities.equals((String)getField.getFullName(), (String)setField.getFullName())) {
                    return null;
                }
            } else if (((Expression)initialValue.get()).getCode() != AstCode.LoadElement) {
                return null;
            }
            List<Expression> initialValueArguments = ((Expression)initialValue.get()).getArguments();
            assert (arguments.size() - 1 == initialValueArguments.size());
            int n2 = initialValueArguments.size();
            for (int i = 0; i < n2; ++i) {
                if (PatternMatching.matchLoad((Node)initialValueArguments.get(i), (Variable)arguments.get(i).getOperand())) continue;
                return null;
            }
            p.getArguments().set(0, new Expression(AstCode.PostIncrement, incrementAmount.get(), ((Expression)initialValue.get()).getOffset(), (Expression)initialValue.get()));
            return p;
        }

        private AstCode getIncrementCode(Expression add, StrongBox<Number> incrementAmount) {
            boolean decrement;
            Expression amountArgument;
            AstCode incrementCode;
            switch (add.getCode()) {
                case Add: {
                    incrementCode = AstCode.PostIncrement;
                    amountArgument = add.getArguments().get(1);
                    decrement = false;
                    break;
                }
                case Sub: {
                    incrementCode = AstCode.PostIncrement;
                    amountArgument = add.getArguments().get(1);
                    decrement = true;
                    break;
                }
                case Inc: {
                    incrementCode = AstCode.PostIncrement;
                    amountArgument = add.getArguments().get(0);
                    decrement = false;
                    break;
                }
                default: {
                    return AstCode.Nop;
                }
            }
            if (!(!PatternMatching.matchGetOperand(amountArgument, AstCode.LdC, incrementAmount) || incrementAmount.get() instanceof Float || incrementAmount.get() instanceof Double || ((Number)incrementAmount.get()).longValue() != 1L && ((Number)incrementAmount.get()).longValue() != -1L)) {
                incrementAmount.set((Object)(decrement ? -((Number)incrementAmount.get()).intValue() : ((Number)incrementAmount.get()).intValue()));
                return incrementCode;
            }
            return AstCode.Nop;
        }
    }

    private static final class MakeAssignmentExpressionsOptimization
    extends AbstractExpressionOptimization {
        protected MakeAssignmentExpressionsOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        public boolean run(List<Node> body, Expression head, int position) {
            StrongBox ev = new StrongBox();
            StrongBox initializer = new StrongBox();
            Node next = (Node)CollectionUtilities.getOrDefault(body, (int)(position + 1));
            StrongBox v = new StrongBox();
            StrongBox storeArgument = new StrongBox();
            if (PatternMatching.matchGetArgument(head, AstCode.Store, ev, (StrongBox<Expression>)initializer) && !PatternMatching.match((Node)initializer.value, AstCode.__New)) {
                Expression nextExpression;
                if (PatternMatching.matchGetArgument(next, AstCode.Store, v, (StrongBox<Expression>)storeArgument) && PatternMatching.matchLoad((Node)storeArgument.get(), (Variable)ev.get())) {
                    Expression nextExpression2 = (Expression)next;
                    Node store2 = (Node)CollectionUtilities.getOrDefault(body, (int)(position + 2));
                    if (this.canConvertStoreToAssignment(store2, (Variable)ev.get())) {
                        Inlining inlining = new Inlining(this.context, this.method);
                        MutableInteger loadCounts = inlining.loadCounts.get(ev.get());
                        MutableInteger storeCounts = inlining.storeCounts.get(ev.get());
                        if (loadCounts != null && loadCounts.getValue() == 2 && storeCounts != null && storeCounts.getValue() == 1) {
                            Expression storeExpression = (Expression)store2;
                            body.remove(position + 2);
                            body.remove(position);
                            nextExpression2.getArguments().set(0, storeExpression);
                            storeExpression.getArguments().set(storeExpression.getArguments().size() - 1, (Expression)initializer.get());
                            inlining.inlineIfPossible(body, new MutableInteger(position));
                            return true;
                        }
                    }
                    body.remove(position + 1);
                    nextExpression2.getArguments().set(0, (Expression)initializer.get());
                    ((Expression)body.get(position)).getArguments().set(0, nextExpression2);
                    return true;
                }
                if (PatternMatching.match(next, AstCode.PutStatic) && PatternMatching.matchLoad((Node)(nextExpression = (Expression)next).getArguments().get(0), (Variable)ev.get())) {
                    body.remove(position + 1);
                    nextExpression.getArguments().set(0, (Expression)initializer.get());
                    ((Expression)body.get(position)).getArguments().set(0, nextExpression);
                    return true;
                }
                return false;
            }
            StrongBox equivalentLoad = new StrongBox();
            if (PatternMatching.matchAssignment(head, (StrongBox<Expression>)initializer, (StrongBox<Expression>)equivalentLoad) && next instanceof Expression) {
                Expression e;
                if (((Expression)equivalentLoad.get()).getCode() == AstCode.GetField) {
                    FieldDefinition resolvedField;
                    FieldReference field = (FieldReference)((Expression)equivalentLoad.get()).getOperand();
                    FieldDefinition fieldDefinition = resolvedField = field != null ? field.resolve() : null;
                    if (resolvedField != null && resolvedField.isSynthetic()) {
                        return false;
                    }
                }
                boolean isLoad = PatternMatching.matchLoad((Node)initializer.value, (Consumer<? super Variable>)v);
                ArrayDeque<Expression> agenda = new ArrayDeque<Expression>();
                agenda.push((Expression)next);
                block0: while (!(agenda.isEmpty() || (e = (Expression)agenda.removeFirst()).getCode().isShortCircuiting() || e.getCode().isStore() || e.getCode().isFieldWrite())) {
                    List<Expression> arguments = e.getArguments();
                    for (int i = 0; i < arguments.size(); ++i) {
                        Expression a = arguments.get(i);
                        if (a.isEquivalentTo((Expression)equivalentLoad.value) || isLoad && PatternMatching.matchLoad((Node)a, (Variable)v.get()) || Inlining.hasNoSideEffect((Expression)initializer.get()) && a.isEquivalentTo((Expression)initializer.get()) && ((Expression)initializer.get()).getInferredType() != null && MetadataHelper.isSameType(((Expression)initializer.get()).getInferredType(), a.getInferredType(), true)) {
                            arguments.set(i, head);
                            body.remove(position);
                            return true;
                        }
                        if (!Inlining.isSafeForInlineOver(a, head)) break block0;
                        agenda.push(a);
                    }
                }
            }
            return false;
        }

        private boolean canConvertStoreToAssignment(Node store, Variable variable) {
            if (store instanceof Expression) {
                Expression storeExpression = (Expression)store;
                switch (storeExpression.getCode()) {
                    case Store: 
                    case PutStatic: 
                    case PutField: 
                    case StoreElement: {
                        return PatternMatching.matchLoad((Node)CollectionUtilities.lastOrDefault(storeExpression.getArguments()), variable);
                    }
                }
            }
            return false;
        }
    }

    private static final class TransformArrayInitializersOptimization
    extends AbstractExpressionOptimization {
        protected TransformArrayInitializersOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        public boolean run(List<Node> body, Expression head, int position) {
            StrongBox v = new StrongBox();
            StrongBox newArray = new StrongBox();
            if (PatternMatching.matchGetArgument(head, AstCode.Store, v, (StrongBox<Expression>)newArray) && PatternMatching.match((Node)newArray.get(), AstCode.InitArray)) {
                return this.tryRefineArrayInitialization(body, head, position);
            }
            StrongBox v3 = new StrongBox();
            StrongBox elementType = new StrongBox();
            StrongBox lengthExpression = new StrongBox();
            StrongBox arrayLength = new StrongBox();
            if (PatternMatching.matchGetArgument(head, AstCode.Store, v, (StrongBox<Expression>)newArray) && PatternMatching.matchGetArgument((Node)newArray.get(), AstCode.NewArray, elementType, (StrongBox<Expression>)lengthExpression) && PatternMatching.matchGetOperand((Node)lengthExpression.get(), AstCode.LdC, Number.class, arrayLength) && ((Number)arrayLength.get()).intValue() > 0) {
                boolean hasInnocuousStackAssignment;
                int actualArrayLength = ((Number)arrayLength.get()).intValue();
                StrongBox arrayPosition = new StrongBox();
                ArrayList<Expression> initializers = new ArrayList<Expression>();
                int instructionsToRemove = 0;
                if (position < body.size() - 1) {
                    StrongBox stackVariable = new StrongBox();
                    StrongBox stackAssignment = new StrongBox();
                    hasInnocuousStackAssignment = PatternMatching.matchStore(body.get(position + 1), (StrongBox<Variable>)stackVariable, (StrongBox<Expression>)stackAssignment) && PatternMatching.matchLoad((Node)stackAssignment.value, (Variable)v.value) && ((Variable)stackVariable.value).isGeneratedStackVariable();
                } else {
                    hasInnocuousStackAssignment = false;
                }
                int storeElementStart = hasInnocuousStackAssignment ? 2 : 1;
                for (int j = position + storeElementStart; j < body.size(); ++j) {
                    Node node = body.get(j);
                    if (!(node instanceof Expression)) continue;
                    Expression next = (Expression)node;
                    if (next.getCode() != AstCode.StoreElement || !PatternMatching.matchGetOperand(next.getArguments().get(0), AstCode.Load, v3) || v3.get() != v.get() || !PatternMatching.matchGetOperand(next.getArguments().get(1), AstCode.LdC, Number.class, arrayPosition) || ((Number)arrayPosition.get()).intValue() < initializers.size() || next.getArguments().get(2).containsReferenceTo((Variable)v3.get())) break;
                    while (initializers.size() < ((Number)arrayPosition.get()).intValue()) {
                        initializers.add(new Expression(AstCode.DefaultValue, elementType.get(), next.getOffset(), new Expression[0]));
                    }
                    initializers.add(next.getArguments().get(2));
                    ++instructionsToRemove;
                }
                if (initializers.size() < actualArrayLength && initializers.size() >= actualArrayLength / 2) {
                    while (initializers.size() < actualArrayLength) {
                        initializers.add(new Expression(AstCode.DefaultValue, elementType.get(), head.getOffset(), new Expression[0]));
                    }
                }
                if (initializers.size() == actualArrayLength) {
                    TypeReference arrayType = ((TypeReference)elementType.get()).makeArrayType();
                    head.getArguments().set(0, new Expression(AstCode.InitArray, (Object)arrayType, head.getOffset(), initializers));
                    for (int i = 0; i < instructionsToRemove; ++i) {
                        body.remove(position + storeElementStart);
                    }
                    new Inlining(this.context, this.method).inlineIfPossible(body, new MutableInteger(position));
                    return true;
                }
            }
            return false;
        }

        private boolean tryRefineArrayInitialization(List<Node> body, Expression head, int position) {
            StrongBox v = new StrongBox();
            ArrayList<Expression> a = new ArrayList<Expression>();
            StrongBox arrayType = new StrongBox();
            if (PatternMatching.matchGetArguments(head, AstCode.Store, v, a) && PatternMatching.matchGetArguments((Node)a.get(0), AstCode.InitArray, arrayType, a)) {
                Node node;
                Expression initArray = head.getArguments().get(0);
                List<Expression> initializers = initArray.getArguments();
                int actualArrayLength = initializers.size();
                StrongBox arrayPosition = new StrongBox();
                for (int j = position + 1; j < body.size() && PatternMatching.matchGetArguments(node = body.get(j), AstCode.StoreElement, a) && PatternMatching.matchLoad((Node)a.get(0), (Variable)v.get()) && !((Expression)a.get(2)).containsReferenceTo((Variable)v.get()) && PatternMatching.matchGetOperand((Node)a.get(1), AstCode.LdC, Integer.class, arrayPosition) && (Integer)arrayPosition.get() >= 0 && (Integer)arrayPosition.get() < actualArrayLength && PatternMatching.match(initializers.get((Integer)arrayPosition.get()), AstCode.DefaultValue); ++j) {
                    initializers.set((Integer)arrayPosition.get(), (Expression)a.get(2));
                    body.remove(j--);
                }
            }
            return false;
        }
    }

    private static final class TransformObjectInitializersOptimization
    extends AbstractExpressionOptimization {
        protected TransformObjectInitializersOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        public boolean run(List<Node> body, Expression head, int position) {
            Node next;
            if (position >= body.size() - 1) {
                return false;
            }
            StrongBox v = new StrongBox();
            StrongBox newObject = new StrongBox();
            StrongBox objectType = new StrongBox();
            StrongBox constructor = new StrongBox();
            ArrayList<Expression> arguments = new ArrayList<Expression>();
            if (position < body.size() - 1 && PatternMatching.matchGetArgument(head, AstCode.Store, v, (StrongBox<Expression>)newObject) && PatternMatching.matchGetOperand((Node)newObject.get(), AstCode.__New, objectType) && PatternMatching.matchGetArguments(next = body.get(position + 1), AstCode.InvokeSpecial, constructor, arguments) && !arguments.isEmpty() && PatternMatching.matchLoad((Node)arguments.get(0), (Variable)v.get())) {
                Expression initExpression = new Expression(AstCode.InitObject, constructor.get(), ((Expression)next).getOffset(), new Expression[0]);
                arguments.remove(0);
                initExpression.getArguments().addAll(arguments);
                initExpression.getRanges().addAll(((Expression)next).getRanges());
                head.getArguments().set(0, initExpression);
                body.remove(position + 1);
                return true;
            }
            if (PatternMatching.matchGetArguments(head, AstCode.InvokeSpecial, constructor, arguments) && ((MethodReference)constructor.get()).isConstructor() && !arguments.isEmpty() && PatternMatching.matchGetArgument((Node)arguments.get(0), AstCode.Store, v, (StrongBox<Expression>)newObject) && PatternMatching.matchGetOperand((Node)newObject.get(), AstCode.__New, objectType)) {
                Expression initExpression = new Expression(AstCode.InitObject, constructor.get(), ((Expression)newObject.get()).getOffset(), new Expression[0]);
                arguments.remove(0);
                initExpression.getArguments().addAll(arguments);
                initExpression.getRanges().addAll(head.getRanges());
                body.set(position, new Expression(AstCode.Store, v.get(), initExpression.getOffset(), initExpression));
                return true;
            }
            return false;
        }
    }

    private static final class SimplifyLogicalNotOptimization
    extends AbstractExpressionOptimization {
        protected SimplifyLogicalNotOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        public final boolean run(List<Node> body, Expression head, int position) {
            BooleanBox modified = new BooleanBox();
            Expression simplified = AstOptimizer.simplifyLogicalNot(head, modified);
            assert (simplified == null);
            return modified.get();
        }
    }

    private static final class SimplifyTernaryOperatorRoundTwoOptimization
    extends AbstractExpressionOptimization {
        protected SimplifyTernaryOperatorRoundTwoOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        public boolean run(List<Node> body, Expression head, int position) {
            BooleanBox modified = new BooleanBox();
            Expression simplified = SimplifyTernaryOperatorRoundTwoOptimization.simplify(head, modified);
            if (simplified != head) {
                body.set(position, simplified);
            }
            return modified.get();
        }

        private static Expression simplify(Expression head, BooleanBox modified) {
            if (PatternMatching.match(head, AstCode.TernaryOp)) {
                return SimplifyTernaryOperatorRoundTwoOptimization.simplifyTernaryDirect(head);
            }
            List<Expression> arguments = head.getArguments();
            for (int i = 0; i < arguments.size(); ++i) {
                Expression argument = arguments.get(i);
                Expression simplified = SimplifyTernaryOperatorRoundTwoOptimization.simplify(argument, modified);
                if (simplified == argument) continue;
                arguments.set(i, simplified);
                modified.set((Object)true);
            }
            AstCode opType = head.getCode();
            if (opType != AstCode.CmpEq && opType != AstCode.CmpNe) {
                return head;
            }
            Boolean right = PatternMatching.matchBooleanConstant(arguments.get(1));
            if (right == null) {
                return head;
            }
            Expression ternary = arguments.get(0);
            if (ternary.getCode() != AstCode.TernaryOp) {
                return head;
            }
            Boolean ifTrue = PatternMatching.matchBooleanConstant(ternary.getArguments().get(1));
            Boolean ifFalse = PatternMatching.matchBooleanConstant(ternary.getArguments().get(2));
            if (ifTrue == null || ifFalse == null || ifTrue.equals(ifFalse)) {
                return head;
            }
            boolean invert = !ifTrue.equals(right) ^ opType == AstCode.CmpNe;
            Expression condition = ternary.getArguments().get(0);
            condition.getRanges().addAll(ternary.getRanges());
            modified.set((Object)true);
            return invert ? new Expression(AstCode.LogicalNot, null, condition.getOffset(), condition) : condition;
        }

        private static Expression simplifyTernaryDirect(Expression head) {
            ArrayList<Expression> a = new ArrayList<Expression>();
            if (PatternMatching.matchGetArguments(head, AstCode.TernaryOp, a)) {
                StrongBox v = new StrongBox();
                StrongBox left = new StrongBox();
                if (PatternMatching.matchGetArgument((Node)a.get(1), AstCode.Store, v, (StrongBox<Expression>)left)) {
                    StrongBox right = new StrongBox();
                    if (PatternMatching.matchStore((Node)a.get(2), (Variable)v.get(), (StrongBox<Expression>)right)) {
                        Expression condition = (Expression)a.get(0);
                        Expression leftValue = (Expression)left.value;
                        Expression rightValue = (Expression)right.value;
                        Expression newTernary = new Expression(AstCode.TernaryOp, null, condition.getOffset(), condition, leftValue, rightValue);
                        head.setCode(AstCode.Store);
                        head.setOperand(v.get());
                        head.getArguments().clear();
                        head.getArguments().add(newTernary);
                        newTernary.getRanges().addAll(head.getRanges());
                        return head;
                    }
                }
                Boolean ifTrue = PatternMatching.matchBooleanConstant(head.getArguments().get(1));
                Boolean ifFalse = PatternMatching.matchBooleanConstant(head.getArguments().get(2));
                if (ifTrue == null || ifFalse == null || ifTrue.equals(ifFalse)) {
                    return head;
                }
                boolean invert = Boolean.FALSE.equals(ifTrue);
                Expression condition = head.getArguments().get(0);
                condition.getRanges().addAll(head.getRanges());
                return invert ? new Expression(AstCode.LogicalNot, null, condition.getOffset(), condition) : condition;
            }
            return head;
        }
    }

    private static final class SimplifyTernaryOperatorOptimization
    extends AbstractBasicBlockOptimization {
        protected SimplifyTernaryOperatorOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        public final boolean run(List<Node> body, BasicBlock head, int position) {
            StrongBox condition = new StrongBox();
            StrongBox trueLabel = new StrongBox();
            StrongBox falseLabel = new StrongBox();
            StrongBox trueVariable = new StrongBox();
            StrongBox trueExpression = new StrongBox();
            StrongBox trueFall = new StrongBox();
            StrongBox falseVariable = new StrongBox();
            StrongBox falseExpression = new StrongBox();
            StrongBox falseFall = new StrongBox();
            StrongBox unused = new StrongBox();
            if (PatternMatching.matchLastAndBreak(head, AstCode.IfTrue, trueLabel, (StrongBox<Expression>)condition, (StrongBox<Label>)falseLabel) && ((MutableInteger)this.labelGlobalRefCount.get(trueLabel.value)).getValue() == 1 && ((MutableInteger)this.labelGlobalRefCount.get(falseLabel.value)).getValue() == 1 && body.contains(this.labelToBasicBlock.get(trueLabel.value)) && body.contains(this.labelToBasicBlock.get(falseLabel.value))) {
                if (PatternMatching.matchSingleAndBreak((BasicBlock)this.labelToBasicBlock.get(trueLabel.value), AstCode.Store, trueVariable, (StrongBox<Expression>)trueExpression, (StrongBox<Label>)trueFall) && PatternMatching.matchSingleAndBreak((BasicBlock)this.labelToBasicBlock.get(falseLabel.value), AstCode.Store, falseVariable, (StrongBox<Expression>)falseExpression, (StrongBox<Label>)falseFall) && trueVariable.value == falseVariable.value && trueFall.value == falseFall.value || PatternMatching.matchSingle((BasicBlock)this.labelToBasicBlock.get(trueLabel.value), AstCode.Return, unused, (StrongBox<Expression>)trueExpression) && PatternMatching.matchSingle((BasicBlock)this.labelToBasicBlock.get(falseLabel.value), AstCode.Return, unused, (StrongBox<Expression>)falseExpression)) {
                    Expression newExpression;
                    boolean isStore = trueVariable.value != null;
                    AstCode opCode = isStore ? AstCode.Store : AstCode.Return;
                    TypeReference returnType = isStore ? ((Variable)trueVariable.value).getType() : this.context.getCurrentMethod().getReturnType();
                    boolean returnTypeIsBoolean = TypeAnalysis.isBoolean(returnType);
                    StrongBox leftBooleanValue = new StrongBox();
                    StrongBox rightBooleanValue = new StrongBox();
                    if (returnTypeIsBoolean && PatternMatching.matchBooleanConstant((Node)trueExpression.value, (Consumer<? super Boolean>)leftBooleanValue) && PatternMatching.matchBooleanConstant((Node)falseExpression.value, (Consumer<? super Boolean>)rightBooleanValue) && (((Boolean)leftBooleanValue.value).booleanValue() && !((Boolean)rightBooleanValue.value).booleanValue() || !((Boolean)leftBooleanValue.value).booleanValue() && ((Boolean)rightBooleanValue.value).booleanValue())) {
                        if (((Boolean)leftBooleanValue.value).booleanValue()) {
                            newExpression = (Expression)condition.value;
                        } else {
                            newExpression = new Expression(AstCode.LogicalNot, null, ((Expression)condition.value).getOffset(), (Expression)condition.value);
                            newExpression.setInferredType(BuiltinTypes.Boolean);
                        }
                    } else if ((returnTypeIsBoolean || TypeAnalysis.isBoolean(((Expression)falseExpression.value).getInferredType())) && PatternMatching.matchBooleanConstant((Node)trueExpression.value, (Consumer<? super Boolean>)leftBooleanValue)) {
                        newExpression = ((Boolean)leftBooleanValue.value).booleanValue() ? AstOptimizer.makeLeftAssociativeShortCircuit(AstCode.LogicalOr, (Expression)condition.value, (Expression)falseExpression.value) : AstOptimizer.makeLeftAssociativeShortCircuit(AstCode.LogicalAnd, new Expression(AstCode.LogicalNot, null, ((Expression)condition.value).getOffset(), (Expression)condition.value), (Expression)falseExpression.value);
                    } else if ((returnTypeIsBoolean || TypeAnalysis.isBoolean(((Expression)trueExpression.value).getInferredType())) && PatternMatching.matchBooleanConstant((Node)falseExpression.value, (Consumer<? super Boolean>)rightBooleanValue)) {
                        newExpression = ((Boolean)rightBooleanValue.value).booleanValue() ? AstOptimizer.makeLeftAssociativeShortCircuit(AstCode.LogicalOr, new Expression(AstCode.LogicalNot, null, ((Expression)condition.value).getOffset(), (Expression)condition.value), (Expression)trueExpression.value) : AstOptimizer.makeLeftAssociativeShortCircuit(AstCode.LogicalAnd, (Expression)condition.value, (Expression)trueExpression.value);
                    } else {
                        if (opCode == AstCode.Return) {
                            return false;
                        }
                        if (opCode == AstCode.Store && !((Variable)trueVariable.value).isGenerated()) {
                            return false;
                        }
                        newExpression = AstOptimizer.simplifyLogicalNotArgument((Expression)condition.value) ? new Expression(AstCode.TernaryOp, null, ((Expression)condition.value).getOffset(), (Expression)condition.value, (Expression)falseExpression.value, (Expression)trueExpression.value) : new Expression(AstCode.TernaryOp, null, ((Expression)condition.value).getOffset(), (Expression)condition.value, (Expression)trueExpression.value, (Expression)falseExpression.value);
                    }
                    List<Node> headBody = head.getBody();
                    AstOptimizer.removeTail(headBody, AstCode.IfTrue, AstCode.Goto);
                    headBody.add(new Expression(opCode, trueVariable.value, newExpression.getOffset(), newExpression));
                    if (isStore) {
                        headBody.add(new Expression(AstCode.Goto, trueFall.value, ((Label)trueFall.value).getOffset(), new Expression[0]));
                    }
                    AstOptimizer.removeOrThrow(body, this.labelToBasicBlock.get(trueLabel.value));
                    AstOptimizer.removeOrThrow(body, this.labelToBasicBlock.get(falseLabel.value));
                    return true;
                }
                StrongBox innerTrue = new StrongBox();
                StrongBox innerFalse = new StrongBox();
                StrongBox trueBreak = new StrongBox();
                StrongBox falseBreak = new StrongBox();
                StrongBox intermediateJump = new StrongBox();
                if (PatternMatching.matchSingleAndBreak((BasicBlock)this.labelToBasicBlock.get(trueLabel.value), AstCode.IfTrue, innerTrue, (StrongBox<Expression>)trueExpression, (StrongBox<Label>)trueFall) && PatternMatching.matchSingleAndBreak((BasicBlock)this.labelToBasicBlock.get(falseLabel.value), AstCode.IfTrue, unused, (StrongBox<Expression>)falseExpression, (StrongBox<Label>)falseFall) && unused.value == innerTrue.value && PatternMatching.matchLast((BasicBlock)this.labelToBasicBlock.get(falseFall.value), AstCode.Goto, innerFalse)) {
                    StrongBox innerTrueExpression = new StrongBox();
                    StrongBox innerFalseExpression = new StrongBox();
                    if (((MutableInteger)this.labelGlobalRefCount.get(innerTrue.value)).getValue() == 2 && ((MutableInteger)this.labelGlobalRefCount.get(innerFalse.value)).getValue() == 2 && PatternMatching.matchSingleAndBreak((BasicBlock)this.labelToBasicBlock.get(innerTrue.value), AstCode.Store, trueVariable, (StrongBox<Expression>)innerTrueExpression, (StrongBox<Label>)trueBreak) && PatternMatching.matchSingleAndBreak((BasicBlock)this.labelToBasicBlock.get(innerFalse.value), AstCode.Store, falseVariable, (StrongBox<Expression>)innerFalseExpression, (StrongBox<Label>)falseBreak) && trueVariable.value == falseVariable.value && trueFall.value == innerFalse.value && trueBreak.value == falseBreak.value) {
                        boolean negateInner = AstOptimizer.simplifyLogicalNotArgument((Expression)trueExpression.value);
                        if (negateInner && !AstOptimizer.simplifyLogicalNotArgument((Expression)falseExpression.value)) {
                            Expression newFalseExpression = new Expression(AstCode.LogicalNot, null, ((Expression)falseExpression.value).getOffset(), (Expression)falseExpression.value);
                            newFalseExpression.getRanges().addAll(((Expression)falseExpression.value).getRanges());
                            falseExpression.set((Object)newFalseExpression);
                        }
                        Expression newCondition = AstOptimizer.simplifyLogicalNotArgument((Expression)condition.value) ? new Expression(AstCode.TernaryOp, null, ((Expression)condition.value).getOffset(), (Expression)condition.value, (Expression)falseExpression.value, (Expression)trueExpression.value) : new Expression(AstCode.TernaryOp, null, ((Expression)condition.value).getOffset(), (Expression)condition.value, (Expression)trueExpression.value, (Expression)falseExpression.value);
                        Expression newExpression = negateInner ? new Expression(AstCode.TernaryOp, null, newCondition.getOffset(), newCondition, (Expression)innerFalseExpression.value, (Expression)innerTrueExpression.value) : new Expression(AstCode.TernaryOp, null, newCondition.getOffset(), newCondition, (Expression)innerTrueExpression.value, (Expression)innerFalseExpression.value);
                        List<Node> headBody = head.getBody();
                        AstOptimizer.removeTail(headBody, AstCode.IfTrue, AstCode.Goto);
                        headBody.add(new Expression(AstCode.Store, trueVariable.value, newExpression.getOffset(), newExpression));
                        headBody.add(new Expression(AstCode.Goto, trueBreak.value, ((Label)trueBreak.value).getOffset(), new Expression[0]));
                        AstOptimizer.removeOrThrow(body, this.labelToBasicBlock.get(trueLabel.value));
                        AstOptimizer.removeOrThrow(body, this.labelToBasicBlock.get(falseLabel.value));
                        AstOptimizer.removeOrThrow(body, this.labelToBasicBlock.get(falseFall.value));
                        AstOptimizer.removeOrThrow(body, this.labelToBasicBlock.get(innerTrue.value));
                        AstOptimizer.removeOrThrow(body, this.labelToBasicBlock.get(innerFalse.value));
                        return true;
                    }
                    if (PatternMatching.matchSingleAndBreak((BasicBlock)this.labelToBasicBlock.get(innerTrue.value), AstCode.Store, trueVariable, (StrongBox<Expression>)innerTrueExpression, (StrongBox<Label>)trueBreak) && (PatternMatching.matchSingleAndBreak((BasicBlock)this.labelToBasicBlock.get(falseFall.value), AstCode.Store, falseVariable, (StrongBox<Expression>)innerFalseExpression, (StrongBox<Label>)falseBreak) || PatternMatching.matchSimpleBreak((BasicBlock)this.labelToBasicBlock.get(falseFall.value), (StrongBox<Label>)intermediateJump) && PatternMatching.matchSingleAndBreak((BasicBlock)this.labelToBasicBlock.get(intermediateJump.value), AstCode.Store, falseVariable, (StrongBox<Expression>)innerFalseExpression, (StrongBox<Label>)falseBreak)) && trueVariable.value == falseVariable.value && trueBreak.value == falseBreak.value) {
                        List<Expression> arguments = ((Expression)condition.value).getArguments();
                        Expression oldCondition = ((Expression)condition.value).clone();
                        ((Expression)condition.value).setCode(AstCode.TernaryOp);
                        arguments.clear();
                        Collections.addAll(arguments, AstOptimizer.simplifyLogicalNot(oldCondition), AstOptimizer.simplifyLogicalNot((Expression)trueExpression.value), AstOptimizer.simplifyLogicalNot((Expression)falseExpression.value));
                        List<Node> headBody = head.getBody();
                        ((Expression)headBody.get(headBody.size() - 2)).setOperand(innerTrue.value);
                        if (PatternMatching.matchSimpleBreak((BasicBlock)this.labelToBasicBlock.get(falseFall.value), (StrongBox<Label>)intermediateJump)) {
                            if (((MutableInteger)this.labelGlobalRefCount.get(falseFall.value)).getValue() == 1) {
                                AstOptimizer.removeOrThrow(body, this.labelToBasicBlock.get(falseFall.value));
                            }
                            ((Expression)headBody.get(headBody.size() - 1)).setOperand(intermediateJump.value);
                        } else {
                            ((Expression)headBody.get(headBody.size() - 1)).setOperand(falseFall.value);
                        }
                        if (((MutableInteger)this.labelGlobalRefCount.get(trueFall.value)).getValue() == 1) {
                            AstOptimizer.removeOrThrow(body, this.labelToBasicBlock.get(trueFall.value));
                        }
                        AstOptimizer.removeOrThrow(body, this.labelToBasicBlock.get(trueLabel.value));
                        AstOptimizer.removeOrThrow(body, this.labelToBasicBlock.get(falseLabel.value));
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static final class JoinBasicBlocksOptimization
    extends AbstractBasicBlockOptimization {
        protected JoinBasicBlocksOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        public final boolean run(List<Node> body, BasicBlock head, int position) {
            StrongBox nextLabel = new StrongBox();
            List<Node> headBody = head.getBody();
            Node secondToLast = (Node)CollectionUtilities.getOrDefault(headBody, (int)(headBody.size() - 2));
            if (secondToLast != null && !secondToLast.isConditionalControlFlow() && PatternMatching.matchGetOperand(headBody.get(headBody.size() - 1), AstCode.Goto, nextLabel)) {
                BasicBlock nextBlock = (BasicBlock)this.labelToBasicBlock.get(nextLabel.get());
                if (((MutableInteger)this.labelGlobalRefCount.get(nextLabel.get())).getValue() == 1 & nextBlock != null && nextBlock != EMPTY_BLOCK && body.contains(nextBlock) && nextBlock.getBody().get(0) == nextLabel.get() && !CollectionUtilities.any(nextBlock.getBody(), (Predicate)Predicates.instanceOf(BasicBlock.class))) {
                    Node firstInTryBody;
                    Block tryBlock;
                    Node firstInTry;
                    Node secondInNext = (Node)CollectionUtilities.getOrDefault(nextBlock.getBody(), (int)1);
                    if (secondInNext instanceof TryCatchBlock && (firstInTry = (Node)CollectionUtilities.firstOrDefault((tryBlock = ((TryCatchBlock)secondInNext).getTryBlock()).getBody())) instanceof BasicBlock && (firstInTryBody = (Node)CollectionUtilities.firstOrDefault(((BasicBlock)firstInTry).getBody())) instanceof Label && ((MutableInteger)this.labelGlobalRefCount.get(firstInTryBody)).getValue() > 1) {
                        return false;
                    }
                    AstOptimizer.removeTail(headBody, AstCode.Goto);
                    nextBlock.getBody().remove(0);
                    headBody.addAll(nextBlock.getBody());
                    AstOptimizer.removeOrThrow(body, nextBlock);
                    return true;
                }
            }
            return false;
        }
    }

    private static final class InlineConditionalAssignmentsOptimization
    extends AbstractBasicBlockOptimization {
        public InlineConditionalAssignmentsOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        public final boolean run(List<Node> body, BasicBlock head, int position) {
            assert (body.contains(head));
            StrongBox trueLabel = new StrongBox();
            StrongBox condition = new StrongBox();
            StrongBox falseLabel = new StrongBox();
            if (PatternMatching.matchLastAndBreak(head, AstCode.IfTrue, trueLabel, (StrongBox<Expression>)condition, (StrongBox<Label>)falseLabel)) {
                List<Node> b;
                StrongBox sourceVariable = new StrongBox();
                StrongBox assignedValue = new StrongBox();
                StrongBox equivalentLoad = new StrongBox();
                StrongBox left = new StrongBox();
                StrongBox right = new StrongBox();
                Label thenLabel = (Label)trueLabel.value;
                Label elseLabel = (Label)falseLabel.value;
                BasicBlock thenSuccessor = (BasicBlock)this.labelToBasicBlock.get(thenLabel);
                BasicBlock elseSuccessor = (BasicBlock)this.labelToBasicBlock.get(elseLabel);
                boolean modified = false;
                if (PatternMatching.matchAssignmentAndConditionalBreak(elseSuccessor, (StrongBox<Expression>)assignedValue, (StrongBox<Expression>)condition, (StrongBox<Label>)trueLabel, (StrongBox<Label>)falseLabel, (StrongBox<Expression>)equivalentLoad) && PatternMatching.matchLoad((Node)assignedValue.value, (Consumer<? super Variable>)sourceVariable) && PatternMatching.matchComparison((Node)condition.value, (StrongBox<Expression>)left, (StrongBox<Expression>)right)) {
                    b = elseSuccessor.getBody();
                    if (PatternMatching.matchLoad((Node)left.value, (Variable)sourceVariable.value)) {
                        ((Expression)condition.value).getArguments().set(0, (Expression)b.get(b.size() - 3));
                        b.remove(b.size() - 3);
                        modified = true;
                    } else if (PatternMatching.matchLoad((Node)right.value, (Variable)sourceVariable.value) && !AstOptimizer.containsMatch((Node)left.value, (Expression)equivalentLoad.value)) {
                        ((Expression)condition.value).getArguments().set(1, (Expression)b.get(b.size() - 3));
                        b.remove(b.size() - 3);
                        modified = true;
                    }
                }
                if (PatternMatching.matchAssignmentAndConditionalBreak(thenSuccessor, (StrongBox<Expression>)assignedValue, (StrongBox<Expression>)condition, (StrongBox<Label>)trueLabel, (StrongBox<Label>)falseLabel, (StrongBox<Expression>)equivalentLoad) && PatternMatching.matchLoad((Node)assignedValue.value, (Consumer<? super Variable>)sourceVariable) && PatternMatching.matchComparison((Node)condition.value, (StrongBox<Expression>)left, (StrongBox<Expression>)right)) {
                    b = thenSuccessor.getBody();
                    if (PatternMatching.matchLoad((Node)left.value, (Variable)sourceVariable.value)) {
                        ((Expression)condition.value).getArguments().set(0, (Expression)b.get(b.size() - 3));
                        b.remove(b.size() - 3);
                        modified = true;
                    } else if (PatternMatching.matchLoad((Node)right.value, (Variable)sourceVariable.value) && !AstOptimizer.containsMatch((Node)left.value, (Expression)equivalentLoad.value)) {
                        ((Expression)condition.value).getArguments().set(1, (Expression)b.get(b.size() - 3));
                        b.remove(b.size() - 3);
                        modified = true;
                    }
                }
                return modified;
            }
            return false;
        }
    }

    private static final class PreProcessShortCircuitAssignmentsOptimization
    extends AbstractBasicBlockOptimization {
        public PreProcessShortCircuitAssignmentsOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        public final boolean run(List<Node> body, BasicBlock head, int position) {
            assert (body.contains(head));
            StrongBox trueLabel = new StrongBox();
            StrongBox condition = new StrongBox();
            StrongBox falseLabel = new StrongBox();
            if (PatternMatching.matchLastAndBreak(head, AstCode.IfTrue, trueLabel, (StrongBox<Expression>)condition, (StrongBox<Label>)falseLabel)) {
                StrongBox nextTrueLabel = new StrongBox();
                StrongBox nextFalseLabel = new StrongBox();
                StrongBox sourceVariable = new StrongBox();
                StrongBox assignedValue = new StrongBox();
                StrongBox equivalentLoad = new StrongBox();
                StrongBox left = new StrongBox();
                StrongBox right = new StrongBox();
                boolean modified = false;
                for (int pass = 0; pass < 2; ++pass) {
                    Label nextLabel = pass == 0 ? (Label)trueLabel.get() : (Label)falseLabel.get();
                    Label otherLabel = pass == 0 ? (Label)falseLabel.get() : (Label)trueLabel.get();
                    BasicBlock next = (BasicBlock)this.labelToBasicBlock.get(nextLabel);
                    BasicBlock other = (BasicBlock)this.labelToBasicBlock.get(otherLabel);
                    if (!body.contains(next) || next == head || ((MutableInteger)this.labelGlobalRefCount.get(nextLabel)).getValue() != 1 || !PatternMatching.matchLastAndBreak(next, AstCode.IfTrue, nextTrueLabel, (StrongBox<Expression>)condition, (StrongBox<Label>)nextFalseLabel) || otherLabel != nextFalseLabel.get() && otherLabel != nextTrueLabel.get()) continue;
                    List<Node> nextBody = next.getBody();
                    List<Node> otherBody = other.getBody();
                    while (nextBody.size() > 3 && PatternMatching.matchAssignment(nextBody.get(nextBody.size() - 3), (StrongBox<Expression>)assignedValue, (StrongBox<Expression>)equivalentLoad) && PatternMatching.matchLoad((Node)assignedValue.value, (Consumer<? super Variable>)sourceVariable) && PatternMatching.matchComparison((Node)condition.value, (StrongBox<Expression>)left, (StrongBox<Expression>)right)) {
                        if (PatternMatching.matchLoad((Node)left.value, (Variable)sourceVariable.value)) {
                            ((Expression)condition.value).getArguments().set(0, (Expression)nextBody.get(nextBody.size() - 3));
                            nextBody.remove(nextBody.size() - 3);
                            modified = true;
                            continue;
                        }
                        if (!PatternMatching.matchLoad((Node)right.value, (Variable)sourceVariable.value) || AstOptimizer.containsMatch((Node)left.value, (Expression)equivalentLoad.value)) break;
                        ((Expression)condition.value).getArguments().set(1, (Expression)nextBody.get(nextBody.size() - 3));
                        nextBody.remove(nextBody.size() - 3);
                        modified = true;
                    }
                    boolean modifiedNext = modified;
                    modified = false;
                    while (PatternMatching.matchAssignmentAndConditionalBreak(other, (StrongBox<Expression>)assignedValue, (StrongBox<Expression>)condition, (StrongBox<Label>)trueLabel, (StrongBox<Label>)falseLabel, (StrongBox<Expression>)equivalentLoad) && PatternMatching.matchLoad((Node)assignedValue.value, (Consumer<? super Variable>)sourceVariable) && PatternMatching.matchComparison((Node)condition.value, (StrongBox<Expression>)left, (StrongBox<Expression>)right)) {
                        if (PatternMatching.matchLoad((Node)left.value, (Variable)sourceVariable.value)) {
                            ((Expression)condition.value).getArguments().set(0, (Expression)otherBody.get(otherBody.size() - 3));
                            otherBody.remove(otherBody.size() - 3);
                            modified = true;
                            continue;
                        }
                        if (!PatternMatching.matchLoad((Node)right.value, (Variable)sourceVariable.value) || AstOptimizer.containsMatch((Node)left.value, (Expression)equivalentLoad.value)) break;
                        ((Expression)condition.value).getArguments().set(1, (Expression)otherBody.get(otherBody.size() - 3));
                        otherBody.remove(otherBody.size() - 3);
                        modified = true;
                    }
                    boolean modifiedOther = modified;
                    if (modifiedNext || modifiedOther) {
                        Inlining inlining = new Inlining(this.context, this.method);
                        if (modifiedNext) {
                            inlining.inlineAllInBasicBlock(next);
                        }
                        if (modifiedOther) {
                            inlining.inlineAllInBasicBlock(other);
                        }
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
    }

    private static final class SimplifyShortCircuitOptimization
    extends AbstractBasicBlockOptimization {
        public SimplifyShortCircuitOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        public final boolean run(List<Node> body, BasicBlock head, int position) {
            assert (body.contains(head));
            StrongBox condition = new StrongBox();
            StrongBox trueLabel = new StrongBox();
            StrongBox falseLabel = new StrongBox();
            StrongBox nextCondition = new StrongBox();
            StrongBox nextTrueLabel = new StrongBox();
            StrongBox nextFalseLabel = new StrongBox();
            if (PatternMatching.matchLastAndBreak(head, AstCode.IfTrue, trueLabel, (StrongBox<Expression>)condition, (StrongBox<Label>)falseLabel)) {
                for (int pass = 0; pass < 2; ++pass) {
                    Label nextLabel = pass == 0 ? (Label)trueLabel.get() : (Label)falseLabel.get();
                    Label otherLabel = pass == 0 ? (Label)falseLabel.get() : (Label)trueLabel.get();
                    boolean negate = pass == 1;
                    BasicBlock next = (BasicBlock)this.labelToBasicBlock.get(nextLabel);
                    if (!body.contains(next) || next == head || ((MutableInteger)this.labelGlobalRefCount.get(nextLabel)).getValue() != 1 || !PatternMatching.matchSingleAndBreak(next, AstCode.IfTrue, nextTrueLabel, (StrongBox<Expression>)nextCondition, (StrongBox<Label>)nextFalseLabel) || otherLabel != nextFalseLabel.get() && otherLabel != nextTrueLabel.get()) continue;
                    Expression logicExpression = otherLabel == nextFalseLabel.get() ? AstOptimizer.makeLeftAssociativeShortCircuit(AstCode.LogicalAnd, negate ? new Expression(AstCode.LogicalNot, null, ((Expression)condition.get()).getOffset(), (Expression)condition.get()) : (Expression)condition.get(), (Expression)nextCondition.get()) : AstOptimizer.makeLeftAssociativeShortCircuit(AstCode.LogicalOr, negate ? (Expression)condition.get() : new Expression(AstCode.LogicalNot, null, ((Expression)condition.get()).getOffset(), (Expression)condition.get()), (Expression)nextCondition.get());
                    List<Node> headBody = head.getBody();
                    AstOptimizer.removeTail(headBody, AstCode.IfTrue, AstCode.Goto);
                    headBody.add(new Expression(AstCode.IfTrue, nextTrueLabel.get(), logicExpression.getOffset(), logicExpression));
                    headBody.add(new Expression(AstCode.Goto, nextFalseLabel.get(), logicExpression.getOffset(), new Expression[0]));
                    ((MutableInteger)this.labelGlobalRefCount.get(trueLabel.get())).decrement();
                    ((MutableInteger)this.labelGlobalRefCount.get(falseLabel.get())).decrement();
                    AstOptimizer.removeOrThrow(body, next);
                    return true;
                }
            }
            return false;
        }
    }

    private static final class RemoveInnerClassAccessNullChecksOptimization
    extends AbstractExpressionOptimization {
        protected RemoveInnerClassAccessNullChecksOptimization(DecompilerContext context, Block method) {
            super(context, method);
        }

        @Override
        public boolean run(List<Node> body, Expression head, int position) {
            StrongBox getClassArgument = new StrongBox();
            StrongBox getClassArgumentVariable = new StrongBox();
            StrongBox constructorTargetVariable = new StrongBox();
            StrongBox constructorArgumentVariable = new StrongBox();
            StrongBox constructor = new StrongBox();
            StrongBox getClassMethod = new StrongBox();
            ArrayList<Expression> arguments = new ArrayList<Expression>();
            if (position > 0) {
                Node previous = body.get(position - 1);
                if (PatternMatching.matchGetArguments(head, AstCode.InvokeSpecial, constructor, arguments) && arguments.size() > 1 && PatternMatching.matchGetOperand((Node)arguments.get(0), AstCode.Load, constructorTargetVariable) && PatternMatching.matchGetOperand((Node)arguments.get(1), AstCode.Load, constructorArgumentVariable) && (PatternMatching.matchGetArgument(previous, AstCode.InvokeVirtual, getClassMethod, (StrongBox<Expression>)getClassArgument) && RemoveInnerClassAccessNullChecksOptimization.isGetClassMethod((MethodReference)getClassMethod.get()) || PatternMatching.matchGetArgument(previous, AstCode.InvokeStatic, getClassMethod, (StrongBox<Expression>)getClassArgument) && RemoveInnerClassAccessNullChecksOptimization.isRequireNonNull((MethodReference)getClassMethod.get())) && PatternMatching.matchGetOperand((Node)getClassArgument.get(), AstCode.Load, getClassArgumentVariable) && getClassArgumentVariable.get() == constructorArgumentVariable.get()) {
                    TypeReference constructorTargetType = ((Variable)constructorTargetVariable.get()).getType();
                    TypeReference constructorArgumentType = ((Variable)constructorArgumentVariable.get()).getType();
                    if (constructorTargetType != null && constructorArgumentType != null) {
                        TypeDefinition resolvedConstructorTargetType = constructorTargetType.resolve();
                        TypeDefinition resolvedConstructorArgumentType = constructorArgumentType.resolve();
                        if (resolvedConstructorTargetType != null && resolvedConstructorArgumentType != null && resolvedConstructorTargetType.isNested() && (!resolvedConstructorArgumentType.isNested() || RemoveInnerClassAccessNullChecksOptimization.isEnclosedBy(resolvedConstructorTargetType, resolvedConstructorArgumentType))) {
                            body.remove(position - 1);
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private static boolean isGetClassMethod(MethodReference method) {
            return method.getParameters().isEmpty() && "getClass".equals(method.getName());
        }

        private static boolean isRequireNonNull(MethodReference method) {
            return "requireNonNull".equals(method.getName()) && "java/util/Objects".equals(method.getDeclaringType().getInternalName()) && method.getParameters().size() == 1;
        }

        private static boolean isEnclosedBy(TypeReference innerType, TypeReference outerType) {
            if (innerType == null) {
                return false;
            }
            for (TypeReference current = innerType.getDeclaringType(); current != null; current = current.getDeclaringType()) {
                if (!MetadataResolver.areEquivalent(current, outerType)) continue;
                return true;
            }
            TypeDefinition resolvedInnerType = innerType.resolve();
            return resolvedInnerType != null && RemoveInnerClassAccessNullChecksOptimization.isEnclosedBy(resolvedInnerType.getBaseType(), outerType);
        }
    }
}

