/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.Collection;
import com.strobel.assembler.ir.ConstantPool;
import com.strobel.assembler.ir.MetadataReader;
import com.strobel.assembler.ir.attributes.AnnotationsAttribute;
import com.strobel.assembler.ir.attributes.BlobAttribute;
import com.strobel.assembler.ir.attributes.BootstrapMethodsAttribute;
import com.strobel.assembler.ir.attributes.BootstrapMethodsTableEntry;
import com.strobel.assembler.ir.attributes.CodeAttribute;
import com.strobel.assembler.ir.attributes.ConstantValueAttribute;
import com.strobel.assembler.ir.attributes.EnclosingMethodAttribute;
import com.strobel.assembler.ir.attributes.ExceptionTableEntry;
import com.strobel.assembler.ir.attributes.ExceptionsAttribute;
import com.strobel.assembler.ir.attributes.InnerClassEntry;
import com.strobel.assembler.ir.attributes.InnerClassesAttribute;
import com.strobel.assembler.ir.attributes.LineNumberTableAttribute;
import com.strobel.assembler.ir.attributes.LineNumberTableEntry;
import com.strobel.assembler.ir.attributes.LocalVariableTableAttribute;
import com.strobel.assembler.ir.attributes.LocalVariableTableEntry;
import com.strobel.assembler.ir.attributes.MethodParameterEntry;
import com.strobel.assembler.ir.attributes.MethodParametersAttribute;
import com.strobel.assembler.ir.attributes.ModuleAttribute;
import com.strobel.assembler.ir.attributes.ModuleDependency;
import com.strobel.assembler.ir.attributes.ModuleMainClassAttribute;
import com.strobel.assembler.ir.attributes.ModulePackagesAttribute;
import com.strobel.assembler.ir.attributes.ModuleTargetAttribute;
import com.strobel.assembler.ir.attributes.PackageInfo;
import com.strobel.assembler.ir.attributes.ParameterAnnotationsAttribute;
import com.strobel.assembler.ir.attributes.PermittedSubclassesAttribute;
import com.strobel.assembler.ir.attributes.RecordAttribute;
import com.strobel.assembler.ir.attributes.RecordComponentInfo;
import com.strobel.assembler.ir.attributes.ServiceInfo;
import com.strobel.assembler.ir.attributes.SignatureAttribute;
import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.ir.attributes.SourceFileAttribute;
import com.strobel.assembler.metadata.AnonymousLocalTypeCollection;
import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.IClassSignature;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.IMetadataScope;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.IResolverFrame;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MethodBody;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodHandle;
import com.strobel.assembler.metadata.MethodHandleType;
import com.strobel.assembler.metadata.MethodReader;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.ParameterDefinitionCollection;
import com.strobel.assembler.metadata.ParameterReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.annotations.CustomAnnotation;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Comparer;
import com.strobel.core.ExceptionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.SafeCloseable;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.util.EmptyArrayCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public final class ClassFileReader
extends MetadataReader {
    public static final int OPTION_PROCESS_ANNOTATIONS = 1;
    public static final int OPTION_PROCESS_CODE = 2;
    public static final int OPTIONS_DEFAULT = 1;
    static final long MAGIC = 3405691582L;
    private final int _options;
    private final IMetadataResolver _resolver;
    private final Buffer _buffer;
    private final ConstantPool _constantPool;
    private final ConstantPool.TypeInfoEntry _baseClassEntry;
    private final ConstantPool.TypeInfoEntry[] _interfaceEntries;
    private final List<FieldInfo> _fields;
    private final List<MethodInfo> _methods;
    private final List<SourceAttribute> _attributes;
    private final String _internalName;
    private final TypeDefinition _typeDefinition;
    private final MetadataParser _parser;
    private final ResolverFrame _resolverFrame;
    private final Scope _scope;
    private static final MethodHandleType[] METHOD_HANDLE_TYPES = MethodHandleType.values();

    private ClassFileReader(int options, IMetadataResolver resolver, int majorVersion, int minorVersion, Buffer buffer, ConstantPool constantPool, int accessFlags, ConstantPool.TypeInfoEntry thisClassEntry, ConstantPool.TypeInfoEntry baseClassEntry, ConstantPool.TypeInfoEntry[] interfaceEntries) {
        this._options = options;
        this._resolver = resolver;
        this._resolverFrame = new ResolverFrame();
        this._internalName = thisClassEntry.getName();
        this._buffer = buffer;
        this._constantPool = constantPool;
        this._baseClassEntry = baseClassEntry;
        this._interfaceEntries = (ConstantPool.TypeInfoEntry[])VerifyArgument.notNull((Object)interfaceEntries, (String)"interfaceEntries");
        this._fields = new ArrayList<FieldInfo>();
        this._methods = new ArrayList<MethodInfo>();
        this._typeDefinition = new TypeDefinition();
        this._typeDefinition.setResolver(this._resolver);
        this._typeDefinition.setFlags(accessFlags);
        this._typeDefinition.setCompilerVersion(majorVersion, minorVersion);
        int delimiter = this._internalName.lastIndexOf(47);
        if (delimiter < 0) {
            this._typeDefinition.setPackageName("");
            this._typeDefinition.setName(this._internalName);
        } else {
            this._typeDefinition.setPackageName(this._internalName.substring(0, delimiter).replace('/', '.'));
            this._typeDefinition.setName(this._internalName.substring(delimiter + 1));
        }
        this._attributes = this._typeDefinition.getSourceAttributesInternal();
        int delimiterIndex = this._internalName.lastIndexOf(47);
        if (delimiterIndex < 0) {
            this._typeDefinition.setName(this._internalName);
        } else {
            this._typeDefinition.setPackageName(this._internalName.substring(0, delimiterIndex).replace('/', '.'));
            this._typeDefinition.setName(this._internalName.substring(delimiterIndex + 1));
        }
        this._resolverFrame.addType(this._typeDefinition);
        this._parser = new MetadataParser(this._typeDefinition);
        this._scope = new Scope(this._parser, this._typeDefinition, constantPool);
        this._constantPool.freezeIfUnfrozen();
        this._typeDefinition.setConstantPool(this._constantPool);
    }

    protected boolean shouldProcessAnnotations() {
        return (this._options & 1) == 1;
    }

    protected boolean shouldProcessCode() {
        return (this._options & 2) == 2;
    }

    @Override
    protected IMetadataScope getScope() {
        return this._scope;
    }

    @Override
    public MetadataParser getParser() {
        return this._parser;
    }

    @Override
    protected SourceAttribute readAttributeCore(String name, Buffer buffer, int originalOffset, int length) {
        VerifyArgument.notNull((Object)name, (String)"name");
        VerifyArgument.notNull((Object)buffer, (String)"buffer");
        VerifyArgument.isNonNegative((int)length, (String)"length");
        switch (name) {
            case "Code": {
                int maxStack = buffer.readUnsignedShort();
                int maxLocals = buffer.readUnsignedShort();
                int codeLength = buffer.readInt();
                int codeOffset = buffer.position();
                byte[] code = new byte[codeLength];
                buffer.read(code, 0, codeLength);
                int exceptionTableLength = buffer.readUnsignedShort();
                ExceptionTableEntry[] exceptionTable = new ExceptionTableEntry[exceptionTableLength];
                for (int k = 0; k < exceptionTableLength; ++k) {
                    int startOffset = buffer.readUnsignedShort();
                    int endOffset = buffer.readUnsignedShort();
                    int handlerOffset = buffer.readUnsignedShort();
                    int catchTypeToken = buffer.readUnsignedShort();
                    TypeReference catchType = catchTypeToken == 0 ? null : this._scope.lookupType(catchTypeToken);
                    exceptionTable[k] = new ExceptionTableEntry(startOffset, endOffset, handlerOffset, catchType);
                }
                int attributeCount = buffer.readUnsignedShort();
                SourceAttribute[] attributes = new SourceAttribute[attributeCount];
                this.readAttributes(buffer, attributes);
                if (this.shouldProcessCode()) {
                    return new CodeAttribute(length, maxStack, maxLocals, codeOffset, codeLength, buffer, exceptionTable, attributes);
                }
                return new CodeAttribute(length, originalOffset + codeOffset, codeLength, maxStack, maxLocals, exceptionTable, attributes);
            }
            case "InnerClasses": {
                Object[] entries = new InnerClassEntry[buffer.readUnsignedShort()];
                for (int i = 0; i < entries.length; ++i) {
                    int innerClassIndex = buffer.readUnsignedShort();
                    int outerClassIndex = buffer.readUnsignedShort();
                    int shortNameIndex = buffer.readUnsignedShort();
                    int accessFlags = buffer.readUnsignedShort();
                    ConstantPool.TypeInfoEntry innerClass = (ConstantPool.TypeInfoEntry)this._constantPool.getEntry(innerClassIndex);
                    ConstantPool.TypeInfoEntry outerClass = outerClassIndex != 0 ? (ConstantPool.TypeInfoEntry)this._constantPool.getEntry(outerClassIndex) : null;
                    entries[i] = new InnerClassEntry(innerClass.getName(), outerClass != null ? outerClass.getName() : null, shortNameIndex != 0 ? (String)this._constantPool.lookupConstant(shortNameIndex) : null, accessFlags);
                }
                return new InnerClassesAttribute(length, ArrayUtilities.asUnmodifiableList((Object[])entries));
            }
            case "Record": {
                int componentCount = buffer.readUnsignedShort();
                Object[] components = new RecordComponentInfo[componentCount];
                for (int i = 0; i < components.length; ++i) {
                    List componentAttributes;
                    TypeReference componentType;
                    String componentName = (String)this._scope.lookupConstant(buffer.readUnsignedShort());
                    String componentDescriptor = (String)this._scope.lookupConstant(buffer.readUnsignedShort());
                    int componentAttributeCount = buffer.readUnsignedShort();
                    try {
                        componentType = this.getParser().parseTypeSignature(componentDescriptor);
                    }
                    catch (Error | Exception ignored) {
                        componentType = BuiltinTypes.Object;
                    }
                    if (componentAttributeCount > 0) {
                        Object[] cAttr = new SourceAttribute[componentAttributeCount];
                        for (int j = 0; j < cAttr.length; ++j) {
                            cAttr[j] = this.readAttribute(buffer);
                        }
                        componentAttributes = ArrayUtilities.asUnmodifiableList((Object[])cAttr);
                    } else {
                        componentAttributes = Collections.emptyList();
                    }
                    components[i] = new RecordComponentInfo(componentName, componentDescriptor, componentType, componentAttributes);
                }
                this._scope._typeDefinition.setFlags(this._scope._typeDefinition.getFlags() | 0x2000000000000000L);
                return new RecordAttribute(length, ArrayUtilities.asUnmodifiableList((Object[])components));
            }
            case "Module": {
                String moduleName = (String)this._scope.lookupConstant(buffer.readUnsignedShort());
                int flags = buffer.readUnsignedShort();
                int versionIndex = buffer.readUnsignedShort();
                String moduleVersion = versionIndex > 0 ? (String)this._scope.lookupConstant(versionIndex) : null;
                int requiresCount = buffer.readUnsignedShort();
                ModuleDependency[] requires = requiresCount > 0 ? new ModuleDependency[requiresCount] : ModuleDependency.EMPTY;
                for (int i = 0; i < requiresCount; ++i) {
                    requires[i] = this.readModuleDependency(buffer);
                }
                int exportsCount = buffer.readUnsignedShort();
                PackageInfo[] exports = exportsCount > 0 ? new PackageInfo[exportsCount] : PackageInfo.EMPTY;
                for (int i = 0; i < exportsCount; ++i) {
                    exports[i] = this.readPackageInfo(buffer);
                }
                int opensCount = buffer.readUnsignedShort();
                PackageInfo[] opens = opensCount > 0 ? new PackageInfo[opensCount] : PackageInfo.EMPTY;
                for (int i = 0; i < opensCount; ++i) {
                    opens[i] = this.readPackageInfo(buffer);
                }
                int usesCount = buffer.readUnsignedShort();
                TypeReference[] uses = usesCount > 0 ? new TypeReference[usesCount] : TypeReference.EMPTY_REFERENCES;
                for (int i = 0; i < usesCount; ++i) {
                    uses[i] = this._scope.lookupType(buffer.readUnsignedShort());
                }
                int providesCount = buffer.readUnsignedShort();
                ServiceInfo[] provides = providesCount > 0 ? new ServiceInfo[providesCount] : ServiceInfo.EMPTY;
                for (int i = 0; i < providesCount; ++i) {
                    provides[i] = this.readServiceInfo(buffer);
                }
                return new ModuleAttribute(length, moduleName, moduleVersion, flags, requires, exports, opens, uses, provides);
            }
            case "ModulePackages": {
                int packageCount = buffer.readUnsignedShort();
                String[] packages = packageCount > 0 ? new String[packageCount] : EmptyArrayCache.EMPTY_STRING_ARRAY;
                for (int i = 0; i < packageCount; ++i) {
                    packages[i] = (String)this._scope.lookupConstant(buffer.readUnsignedShort());
                }
                return new ModulePackagesAttribute(packages);
            }
            case "ModuleMainClass": {
                return new ModuleMainClassAttribute(this._scope.lookupType(buffer.readUnsignedShort()));
            }
            case "ModuleTarget": {
                return new ModuleTargetAttribute((String)this._scope.lookupConstant(buffer.readUnsignedShort()));
            }
            case "PermittedSubclasses": {
                TypeReference[] permittedSubclasses = new TypeReference[buffer.readUnsignedShort()];
                for (int i = 0; i < permittedSubclasses.length; ++i) {
                    permittedSubclasses[i] = this._scope.lookupType(buffer.readUnsignedShort());
                }
                return new PermittedSubclassesAttribute(permittedSubclasses);
            }
        }
        return super.readAttributeCore(name, buffer, originalOffset, length);
    }

    protected final ModuleDependency readModuleDependency(Buffer buffer) {
        String name = (String)this._scope.lookupConstant(buffer.readUnsignedShort());
        int flags = buffer.readUnsignedShort();
        int versionIndex = buffer.readUnsignedShort();
        String version = versionIndex > 0 ? (String)this._scope.lookupConstant(versionIndex) : null;
        return new ModuleDependency(name, version, flags);
    }

    protected final PackageInfo readPackageInfo(Buffer buffer) {
        String name = (String)this._scope.lookupConstant(buffer.readUnsignedShort());
        int flags = buffer.readUnsignedShort();
        int moduleCount = buffer.readUnsignedShort();
        String[] modules = moduleCount > 0 ? new String[moduleCount] : EmptyArrayCache.EMPTY_STRING_ARRAY;
        for (int i = 0; i < moduleCount; ++i) {
            modules[i] = (String)this._scope.lookupConstant(buffer.readUnsignedShort());
        }
        return new PackageInfo(name, flags, modules);
    }

    protected final ServiceInfo readServiceInfo(Buffer buffer) {
        TypeReference serviceInterface = this._scope.lookupType(buffer.readUnsignedShort());
        int implementationCount = buffer.readUnsignedShort();
        TypeReference[] implementations = implementationCount > 0 ? new TypeReference[implementationCount] : TypeReference.EMPTY_REFERENCES;
        for (int i = 0; i < implementationCount; ++i) {
            implementations[i] = this._scope.lookupType(buffer.readUnsignedShort());
        }
        return new ServiceInfo(serviceInterface, implementations);
    }

    private void readAttributesPhaseOne(Buffer buffer, SourceAttribute[] attributes) {
        block18: for (int i = 0; i < attributes.length; ++i) {
            String name;
            int nameIndex = buffer.readUnsignedShort();
            int length = buffer.readInt();
            IMetadataScope scope = this.getScope();
            switch (name = (String)scope.lookupConstant(nameIndex)) {
                case "SourceFile": {
                    int token = buffer.readUnsignedShort();
                    String sourceFile = (String)scope.lookupConstant(token);
                    attributes[i] = new SourceFileAttribute(sourceFile);
                    continue block18;
                }
                case "ConstantValue": {
                    int token = buffer.readUnsignedShort();
                    Object constantValue = scope.lookupConstant(token);
                    attributes[i] = new ConstantValueAttribute(constantValue);
                    continue block18;
                }
                case "LineNumberTable": {
                    int entryCount = buffer.readUnsignedShort();
                    LineNumberTableEntry[] entries = new LineNumberTableEntry[entryCount];
                    for (int j = 0; j < entries.length; ++j) {
                        entries[j] = new LineNumberTableEntry(buffer.readUnsignedShort(), buffer.readUnsignedShort());
                    }
                    attributes[i] = new LineNumberTableAttribute(entries);
                    continue block18;
                }
                case "Signature": {
                    int token = buffer.readUnsignedShort();
                    String signature = (String)scope.lookupConstant(token);
                    attributes[i] = new SignatureAttribute(signature);
                    continue block18;
                }
                case "MethodParameters": {
                    attributes[i] = this.readAttributeCore(name, buffer, buffer.position(), length);
                    continue block18;
                }
                case "InnerClasses": {
                    attributes[i] = this.readAttributeCore(name, buffer, buffer.position(), length);
                    continue block18;
                }
                case "PermittedSubclasses": {
                    attributes[i] = this.readAttributeCore(name, buffer, buffer.position(), length);
                    continue block18;
                }
                default: {
                    int offset = buffer.position();
                    byte[] blob = new byte[length];
                    buffer.read(blob, 0, blob.length);
                    attributes[i] = new BlobAttribute(name, blob, offset);
                    continue block18;
                }
            }
        }
    }

    public static TypeDefinition readClass(IMetadataResolver resolver, Buffer b) {
        return ClassFileReader.readClass(1, resolver, b);
    }

    public static TypeDefinition readClass(int options, IMetadataResolver resolver, Buffer b) {
        long magic = (long)b.readInt() & 0xFFFFFFFFL;
        if (magic != 3405691582L) {
            throw new IllegalStateException("Wrong magic number: " + magic);
        }
        int minorVersion = b.readUnsignedShort();
        int majorVersion = b.readUnsignedShort();
        ConstantPool constantPool = ConstantPool.read(b);
        int accessFlags = b.readUnsignedShort();
        ConstantPool.TypeInfoEntry thisClass = (ConstantPool.TypeInfoEntry)constantPool.get(b.readUnsignedShort(), ConstantPool.Tag.TypeInfo);
        int baseClassToken = b.readUnsignedShort();
        ConstantPool.TypeInfoEntry baseClass = baseClassToken == 0 ? null : (ConstantPool.TypeInfoEntry)constantPool.getEntry(baseClassToken);
        ConstantPool.TypeInfoEntry[] interfaces = new ConstantPool.TypeInfoEntry[b.readUnsignedShort()];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaces[i] = (ConstantPool.TypeInfoEntry)constantPool.get(b.readUnsignedShort(), ConstantPool.Tag.TypeInfo);
        }
        return new ClassFileReader(options, resolver, majorVersion, minorVersion, b, constantPool, accessFlags, thisClass, baseClass, interfaces).readClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TypeDefinition readClass() {
        this._parser.pushGenericContext(this._typeDefinition);
        try {
            this._resolver.pushFrame(this._resolverFrame);
            try {
                MethodReference declaringMethod;
                this.populateMemberInfo();
                Object enclosingMethod = SourceAttribute.find("EnclosingMethod", this._attributes);
                try {
                    if (enclosingMethod instanceof BlobAttribute) {
                        enclosingMethod = this.inflateAttribute((SourceAttribute)enclosingMethod);
                    }
                    if (enclosingMethod instanceof EnclosingMethodAttribute) {
                        MethodReference method = ((EnclosingMethodAttribute)enclosingMethod).getEnclosingMethod();
                        if (method != null) {
                            MethodDefinition resolvedMethod = method.resolve();
                            if (resolvedMethod != null) {
                                method = resolvedMethod;
                                AnonymousLocalTypeCollection enclosedTypes = resolvedMethod.getDeclaredTypesInternal();
                                if (!enclosedTypes.contains(this._typeDefinition)) {
                                    enclosedTypes.add(this._typeDefinition);
                                }
                            }
                            this._typeDefinition.setDeclaringMethod(method);
                        }
                        declaringMethod = method;
                    } else {
                        declaringMethod = null;
                    }
                }
                catch (Exception e) {
                    throw ExceptionUtilities.asRuntimeException((Throwable)e);
                }
                if (declaringMethod != null) {
                    this._parser.popGenericContext();
                    this._parser.pushGenericContext(declaringMethod);
                    this._parser.pushGenericContext(this._typeDefinition);
                }
                try {
                    this.populateDeclaringType();
                    this.populateBaseTypes();
                    this.visitAttributes();
                    this.visitFields();
                    this.defineMethods();
                    this.populateNamedInnerTypes();
                    this.populateAnonymousInnerTypes();
                    this.checkEnclosingMethodAttributes();
                    this.checkModuleAttribute();
                }
                finally {
                    if (declaringMethod != null) {
                        this._parser.popGenericContext();
                    }
                }
            }
            finally {
                this._resolver.popFrame();
            }
            TypeDefinition typeDefinition = this._typeDefinition;
            return typeDefinition;
        }
        finally {
            this._parser.popGenericContext();
        }
    }

    private void checkModuleAttribute() {
        ModuleAttribute moduleAttribute = (ModuleAttribute)SourceAttribute.find("Module", this._attributes);
        if (moduleAttribute != null && this._typeDefinition.getDeclaredMethods().isEmpty() && this._typeDefinition.getDeclaredFields().isEmpty() && this._typeDefinition.getDeclaredTypes().isEmpty()) {
            this._typeDefinition.setFlags(this._typeDefinition.getFlags() | 0x8000000000000L);
        }
    }

    private void checkEnclosingMethodAttributes() {
        InnerClassesAttribute innerClasses = (InnerClassesAttribute)SourceAttribute.find("InnerClasses", this._attributes);
        if (innerClasses == null) {
            return;
        }
        for (InnerClassEntry entry : innerClasses.getEntries()) {
            MethodReference method;
            Object rawEnclosingMethodAttribute;
            EnclosingMethodAttribute enclosingMethodAttribute;
            TypeReference innerType;
            TypeDefinition resolvedInnerType;
            String outerClassName = entry.getOuterClassName();
            String innerClassName = entry.getInnerClassName();
            if (outerClassName != null || !StringUtilities.startsWith((CharSequence)innerClassName, (CharSequence)(this._internalName + "$")) || (resolvedInnerType = (innerType = this._parser.parseTypeDescriptor(innerClassName)).resolve()) == null || resolvedInnerType.getDeclaringMethod() != null || (enclosingMethodAttribute = (rawEnclosingMethodAttribute = SourceAttribute.find("EnclosingMethod", resolvedInnerType.getSourceAttributes())) instanceof EnclosingMethodAttribute ? (EnclosingMethodAttribute)rawEnclosingMethodAttribute : null) == null || (method = enclosingMethodAttribute.getEnclosingMethod()) == null) continue;
            MethodDefinition resolvedMethod = method.resolve();
            if (resolvedMethod != null) {
                method = resolvedMethod;
                AnonymousLocalTypeCollection enclosedTypes = resolvedMethod.getDeclaredTypesInternal();
                if (!enclosedTypes.contains(this._typeDefinition)) {
                    enclosedTypes.add(this._typeDefinition);
                }
            }
            resolvedInnerType.setDeclaringMethod(method);
        }
    }

    private void populateMemberInfo() {
        int fieldCount = this._buffer.readUnsignedShort();
        for (int i = 0; i < fieldCount; ++i) {
            SourceAttribute[] attributes;
            int accessFlags = this._buffer.readUnsignedShort();
            String name = this._constantPool.lookupUtf8Constant(this._buffer.readUnsignedShort());
            String descriptor = this._constantPool.lookupUtf8Constant(this._buffer.readUnsignedShort());
            int attributeCount = this._buffer.readUnsignedShort();
            if (attributeCount > 0) {
                attributes = new SourceAttribute[attributeCount];
                this.readAttributesPhaseOne(this._buffer, attributes);
            } else {
                attributes = (SourceAttribute[])EmptyArrayCache.fromElementType(SourceAttribute.class);
            }
            FieldInfo field = new FieldInfo(accessFlags, name, descriptor, attributes);
            this._fields.add(field);
        }
        int methodCount = this._buffer.readUnsignedShort();
        for (int i = 0; i < methodCount; ++i) {
            SourceAttribute[] attributes;
            int accessFlags = this._buffer.readUnsignedShort();
            String name = this._constantPool.lookupUtf8Constant(this._buffer.readUnsignedShort());
            String descriptor = this._constantPool.lookupUtf8Constant(this._buffer.readUnsignedShort());
            int attributeCount = this._buffer.readUnsignedShort();
            if (attributeCount > 0) {
                attributes = new SourceAttribute[attributeCount];
                this.readAttributesPhaseOne(this._buffer, attributes);
            } else {
                attributes = (SourceAttribute[])EmptyArrayCache.fromElementType(SourceAttribute.class);
            }
            MethodInfo method = new MethodInfo(accessFlags, name, descriptor, attributes);
            this._methods.add(method);
        }
        int typeAttributeCount = this._buffer.readUnsignedShort();
        if (typeAttributeCount > 0) {
            SourceAttribute[] typeAttributes = new SourceAttribute[typeAttributeCount];
            this.readAttributesPhaseOne(this._buffer, typeAttributes);
            Collections.addAll(this._attributes, typeAttributes);
        }
    }

    private void populateDeclaringType() {
        InnerClassesAttribute innerClasses = (InnerClassesAttribute)SourceAttribute.find("InnerClasses", this._attributes);
        if (innerClasses == null) {
            return;
        }
        for (InnerClassEntry entry : innerClasses.getEntries()) {
            String innerClassName = entry.getInnerClassName();
            String shortName = entry.getShortName();
            String outerClassName = entry.getOuterClassName();
            if (!Comparer.equals((Object)innerClassName, (Object)this._internalName)) continue;
            if (outerClassName == null) {
                int delimiterIndex = innerClassName.lastIndexOf(36);
                if (delimiterIndex < 0) continue;
                outerClassName = innerClassName.substring(0, delimiterIndex);
            }
            if (StringUtilities.isNullOrEmpty((String)shortName)) {
                this._typeDefinition.setFlags(this._typeDefinition.getFlags() | 0x100000000000L);
            } else {
                this._typeDefinition.setSimpleName(shortName);
            }
            this._typeDefinition.setFlags(this._typeDefinition.getFlags() & 0xFFFFFFFFFFFFFFF8L | (long)entry.getAccessFlags());
            TypeReference outerType = this._parser.parseTypeDescriptor(outerClassName);
            TypeDefinition resolvedOuterType = outerType.resolve();
            if (resolvedOuterType != null) {
                if (this._typeDefinition.getDeclaringType() == null) {
                    this._typeDefinition.setDeclaringType(resolvedOuterType);
                    Collection<TypeDefinition> declaredTypes = resolvedOuterType.getDeclaredTypesInternal();
                    if (!declaredTypes.contains(this._typeDefinition)) {
                        declaredTypes.add(this._typeDefinition);
                    }
                }
            } else if (this._typeDefinition.getDeclaringType() == null) {
                this._typeDefinition.setDeclaringType(outerType);
            }
            return;
        }
    }

    private void populateBaseTypes() {
        TypeReference baseType;
        String genericSignature;
        SignatureAttribute signature = (SignatureAttribute)SourceAttribute.find("Signature", this._attributes);
        String[] interfaceNames = new String[this._interfaceEntries.length];
        for (int i = 0; i < this._interfaceEntries.length; ++i) {
            interfaceNames[i] = this._interfaceEntries[i].getName();
        }
        Collection<TypeReference> explicitInterfaces = this._typeDefinition.getExplicitInterfacesInternal();
        String string = genericSignature = signature != null ? signature.getSignature() : null;
        if (StringUtilities.isNullOrEmpty((String)genericSignature)) {
            baseType = this._baseClassEntry != null ? this._parser.parseTypeDescriptor(this._baseClassEntry.getName()) : null;
            for (String interfaceName : interfaceNames) {
                explicitInterfaces.add(this._parser.parseTypeDescriptor(interfaceName));
            }
        } else {
            IClassSignature classSignature = this._parser.parseClassSignature(genericSignature);
            baseType = classSignature.getBaseType();
            explicitInterfaces.addAll(classSignature.getExplicitInterfaces());
            this._typeDefinition.getGenericParametersInternal().addAll(classSignature.getGenericParameters());
        }
        this._typeDefinition.setBaseType(baseType);
    }

    private void populatePermittedSubclasses() {
        PermittedSubclassesAttribute permittedSubclassesAttribute = (PermittedSubclassesAttribute)SourceAttribute.find("PermittedSubclasses", this._attributes);
        if (permittedSubclassesAttribute != null) {
            this._typeDefinition.setFlags(this._typeDefinition.getFlags() | 0x4000000000000000L);
            this._typeDefinition.getPermittedSubclassesInternal().addAll(permittedSubclassesAttribute.getPermittedSubclasses());
        } else if (!this._typeDefinition.isFinal()) {
            boolean unsealed;
            boolean bl = unsealed = this.checkSealed0(this._typeDefinition.getBaseType()) || CollectionUtilities.any(this._typeDefinition.getExplicitInterfaces(), (Predicate)new Predicate<TypeReference>(){

                public boolean test(TypeReference type) {
                    return ClassFileReader.this.checkSealed0(type);
                }
            });
            if (unsealed) {
                this._typeDefinition.setFlags(this._typeDefinition.getFlags() | Long.MIN_VALUE);
            }
        }
    }

    private boolean checkSealed0(TypeReference type) {
        TypeDefinition resolved = type != null ? type.resolve() : null;
        boolean isSealed = resolved != null && resolved.isSealed();
        return isSealed;
    }

    private void populateNamedInnerTypes() {
        InnerClassesAttribute innerClasses = (InnerClassesAttribute)SourceAttribute.find("InnerClasses", this._attributes);
        if (innerClasses == null) {
            return;
        }
        Collection<TypeDefinition> declaredTypes = this._typeDefinition.getDeclaredTypesInternal();
        for (InnerClassEntry entry : innerClasses.getEntries()) {
            TypeReference innerType;
            TypeDefinition resolvedInnerType;
            String innerClassName;
            String outerClassName = entry.getOuterClassName();
            if (outerClassName == null || Comparer.equals((Object)this._internalName, (Object)(innerClassName = entry.getInnerClassName())) || (resolvedInnerType = (innerType = this._parser.parseTypeDescriptor(innerClassName)).resolve()) == null || !Comparer.equals((Object)this._internalName, (Object)outerClassName) || declaredTypes.contains(resolvedInnerType)) continue;
            declaredTypes.add(resolvedInnerType);
            resolvedInnerType.setFlags(resolvedInnerType.getFlags() | (long)entry.getAccessFlags());
        }
    }

    private void populateAnonymousInnerTypes() {
        TypeReference innerType;
        TypeDefinition resolvedInnerType;
        String innerClassName;
        String outerClassName;
        InnerClassesAttribute innerClasses = (InnerClassesAttribute)SourceAttribute.find("InnerClasses", this._attributes);
        if (innerClasses == null) {
            return;
        }
        Collection<TypeDefinition> declaredTypes = this._typeDefinition.getDeclaredTypesInternal();
        for (InnerClassEntry entry : innerClasses.getEntries()) {
            String simpleName = entry.getShortName();
            if (!StringUtilities.isNullOrEmpty((String)simpleName)) continue;
            outerClassName = entry.getOuterClassName();
            innerClassName = entry.getInnerClassName();
            if (outerClassName == null || Comparer.equals((Object)innerClassName, (Object)this._internalName) || !((resolvedInnerType = (innerType = this._parser.parseTypeDescriptor(innerClassName)).resolve()) instanceof TypeDefinition) || !Comparer.equals((Object)this._internalName, (Object)outerClassName) || declaredTypes.contains(resolvedInnerType)) continue;
            declaredTypes.add(resolvedInnerType);
        }
        TypeReference self = this._parser.getResolver().lookupType(this._internalName);
        if (self != null && self.isNested()) {
            return;
        }
        for (InnerClassEntry entry : innerClasses.getEntries()) {
            outerClassName = entry.getOuterClassName();
            if (outerClassName != null || Comparer.equals((Object)(innerClassName = entry.getInnerClassName()), (Object)this._internalName) || (resolvedInnerType = (innerType = this._parser.parseTypeDescriptor(innerClassName)).resolve()) == null || !Comparer.equals((Object)this._internalName, (Object)outerClassName) || declaredTypes.contains(resolvedInnerType)) continue;
            declaredTypes.add(resolvedInnerType);
        }
    }

    private void visitFields() {
        Collection<FieldDefinition> declaredFields = this._typeDefinition.getDeclaredFieldsInternal();
        for (FieldInfo field : this._fields) {
            SignatureAttribute signature = (SignatureAttribute)SourceAttribute.find("Signature", field.attributes);
            TypeReference fieldType = this.tryParseTypeSignature(signature != null ? signature.getSignature() : null, field.descriptor);
            FieldDefinition fieldDefinition = new FieldDefinition(fieldType);
            fieldDefinition.setDeclaringType(this._typeDefinition);
            fieldDefinition.setFlags(Flags.fromStandardFlags(field.accessFlags, Flags.Kind.Field));
            fieldDefinition.setName(field.name);
            declaredFields.add(fieldDefinition);
            this.inflateAttributes(field.attributes);
            ConstantValueAttribute constantValueAttribute = (ConstantValueAttribute)SourceAttribute.find("ConstantValue", field.attributes);
            if (constantValueAttribute != null) {
                SourceAttribute[] constantValue = constantValueAttribute.getValue();
                if (constantValue instanceof Number) {
                    Number number = (Number)constantValue;
                    JvmType jvmType = fieldDefinition.getFieldType().getSimpleType();
                    switch (jvmType) {
                        case Boolean: {
                            fieldDefinition.setConstantValue(number.longValue() != 0L);
                            break;
                        }
                        case Byte: {
                            fieldDefinition.setConstantValue(number.byteValue());
                            break;
                        }
                        case Character: {
                            fieldDefinition.setConstantValue(Character.valueOf((char)number.longValue()));
                            break;
                        }
                        case Short: {
                            fieldDefinition.setConstantValue(number.shortValue());
                            break;
                        }
                        case Integer: {
                            fieldDefinition.setConstantValue(number.intValue());
                            break;
                        }
                        case Long: {
                            fieldDefinition.setConstantValue(number.longValue());
                            break;
                        }
                        case Float: {
                            fieldDefinition.setConstantValue(Float.valueOf(number.floatValue()));
                            break;
                        }
                        case Double: {
                            fieldDefinition.setConstantValue(number.doubleValue());
                            break;
                        }
                        default: {
                            fieldDefinition.setConstantValue(constantValue);
                            break;
                        }
                    }
                } else {
                    fieldDefinition.setConstantValue(constantValue);
                }
            }
            if (SourceAttribute.find("Synthetic", field.attributes) != null) {
                fieldDefinition.setFlags(fieldDefinition.getFlags() | 0x1000L);
            }
            if (SourceAttribute.find("Deprecated", field.attributes) != null) {
                fieldDefinition.setFlags(fieldDefinition.getFlags() | 0x20000L);
            }
            for (SourceAttribute attribute : field.attributes) {
                fieldDefinition.getSourceAttributesInternal().add(attribute);
            }
            if (!this.shouldProcessAnnotations()) continue;
            Collection<CustomAnnotation> annotations = fieldDefinition.getAnnotationsInternal();
            AnnotationsAttribute visibleAnnotations = (AnnotationsAttribute)SourceAttribute.find("RuntimeVisibleAnnotations", field.attributes);
            AnnotationsAttribute invisibleAnnotations = (AnnotationsAttribute)SourceAttribute.find("RuntimeInvisibleAnnotations", field.attributes);
            if (visibleAnnotations != null) {
                Collections.addAll(annotations, visibleAnnotations.getAnnotations());
            }
            if (invisibleAnnotations == null) continue;
            Collections.addAll(annotations, invisibleAnnotations.getAnnotations());
        }
    }

    private TypeReference tryParseTypeSignature(String signature, String fallback) {
        try {
            if (signature != null) {
                return this._parser.parseTypeSignature(signature);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this._parser.parseTypeSignature(fallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defineMethods() {
        try (SafeCloseable ignored = this._parser.suppressTypeResolution();){
            for (MethodInfo method : this._methods) {
                IMethodSignature methodDescriptor = this._parser.parseMethodSignature(method.descriptor);
                MethodDefinition methodDefinition = new MethodDefinition();
                methodDefinition.setName(method.name);
                methodDefinition.setFlags(Flags.fromStandardFlags(method.accessFlags, Flags.Kind.Method));
                methodDefinition.setDeclaringType(this._typeDefinition);
                if (this._typeDefinition.isInterface() && !Flags.testAny(method.accessFlags, 1024)) {
                    methodDefinition.setFlags(methodDefinition.getFlags() | 0x80000000000L);
                }
                this._typeDefinition.getDeclaredMethodsInternal().add(methodDefinition);
                this._parser.pushGenericContext(methodDefinition);
                try {
                    int i;
                    ExceptionsAttribute exceptions;
                    MethodParametersAttribute methodParameters;
                    SignatureAttribute signature = (SignatureAttribute)SourceAttribute.find("Signature", method.attributes);
                    IMethodSignature methodSignature = this.tryParseMethodSignature(signature != null ? signature.getSignature() : null, methodDescriptor);
                    List<ParameterDefinition> signatureParameters = methodSignature.getParameters();
                    List<ParameterDefinition> descriptorParameters = methodDescriptor.getParameters();
                    ParameterDefinitionCollection parameters = methodDefinition.getParametersInternal();
                    methodDefinition.setReturnType(methodSignature.getReturnType());
                    parameters.addAll(signatureParameters);
                    methodDefinition.getGenericParametersInternal().addAll(methodSignature.getGenericParameters());
                    methodDefinition.getThrownTypesInternal().addAll(methodSignature.getThrownTypes());
                    int missingParameters = descriptorParameters.size() - signatureParameters.size();
                    for (int i2 = 0; i2 < missingParameters; ++i2) {
                        ParameterDefinition parameter = descriptorParameters.get(i2);
                        parameter.setFlags(parameter.getFlags() | 0x1000L);
                        parameters.add(i2, parameter);
                    }
                    int slot = 0;
                    if (!Flags.testAny(methodDefinition.getFlags(), 8L)) {
                        ++slot;
                    }
                    List<MethodParameterEntry> parameterEntries = (methodParameters = (MethodParametersAttribute)SourceAttribute.find("MethodParameters", method.attributes)) != null ? methodParameters.getEntries() : null;
                    List<ParameterDefinition> parametersList = methodDefinition.getParameters();
                    for (int i3 = 0; i3 < parametersList.size(); ++i3) {
                        ParameterDefinition parameter = parametersList.get(i3);
                        parameter.setSlot(slot);
                        slot += parameter.getSize();
                        if (parameterEntries == null || i3 >= parameterEntries.size()) continue;
                        MethodParameterEntry entry = parameterEntries.get(i3);
                        String parameterName = entry.getName();
                        if (!StringUtilities.isNullOrWhitespace((String)parameterName)) {
                            parameter.setName(parameterName);
                        }
                        parameter.setFlags(entry.getFlags());
                    }
                    this.inflateAttributes(method.attributes);
                    Collections.addAll(methodDefinition.getSourceAttributesInternal(), method.attributes);
                    method.codeAttribute = SourceAttribute.find("Code", method.attributes);
                    if (method.codeAttribute != null) {
                        methodDefinition.getSourceAttributesInternal().addAll(((CodeAttribute)method.codeAttribute).getAttributes());
                    }
                    if ((exceptions = (ExceptionsAttribute)SourceAttribute.find("Exceptions", method.attributes)) != null) {
                        Collection<TypeReference> thrownTypes = methodDefinition.getThrownTypesInternal();
                        for (TypeReference thrownType : exceptions.getExceptionTypes()) {
                            if (thrownTypes.contains(thrownType)) continue;
                            thrownTypes.add(thrownType);
                        }
                    }
                    if ("<init>".equals(method.name)) {
                        if (Flags.testAny(this._typeDefinition.getFlags(), 0x100000000000L)) {
                            methodDefinition.setFlags(methodDefinition.getFlags() | 0x20000000L | 0x1000L);
                        }
                        if (Flags.testAny(method.accessFlags, 2048)) {
                            this._typeDefinition.setFlags(this._typeDefinition.getFlags() | 0x800L);
                        }
                    }
                    this.readMethodBody(method, methodDefinition);
                    if (SourceAttribute.find("Synthetic", method.attributes) != null) {
                        methodDefinition.setFlags(methodDefinition.getFlags() | 0x1000L);
                    }
                    if (SourceAttribute.find("Deprecated", method.attributes) != null) {
                        methodDefinition.setFlags(methodDefinition.getFlags() | 0x20000L);
                    }
                    if (!this.shouldProcessAnnotations()) continue;
                    AnnotationsAttribute visibleAnnotations = (AnnotationsAttribute)SourceAttribute.find("RuntimeVisibleAnnotations", method.attributes);
                    AnnotationsAttribute invisibleAnnotations = (AnnotationsAttribute)SourceAttribute.find("RuntimeInvisibleAnnotations", method.attributes);
                    Collection<CustomAnnotation> annotations = methodDefinition.getAnnotationsInternal();
                    if (visibleAnnotations != null) {
                        Collections.addAll(annotations, visibleAnnotations.getAnnotations());
                    }
                    if (invisibleAnnotations != null) {
                        Collections.addAll(annotations, invisibleAnnotations.getAnnotations());
                    }
                    ParameterAnnotationsAttribute visibleParameterAnnotations = (ParameterAnnotationsAttribute)SourceAttribute.find("RuntimeVisibleParameterAnnotations", method.attributes);
                    ParameterAnnotationsAttribute invisibleParameterAnnotations = (ParameterAnnotationsAttribute)SourceAttribute.find("RuntimeInvisibleParameterAnnotations", method.attributes);
                    if (visibleParameterAnnotations != null) {
                        for (i = 0; i < visibleParameterAnnotations.getAnnotations().length && i < parameters.size(); ++i) {
                            Collections.addAll(((ParameterDefinition)parameters.get(i)).getAnnotationsInternal(), visibleParameterAnnotations.getAnnotations()[i]);
                        }
                    }
                    if (invisibleParameterAnnotations == null) continue;
                    for (i = 0; i < invisibleParameterAnnotations.getAnnotations().length && i < parameters.size(); ++i) {
                        Collections.addAll(((ParameterDefinition)parameters.get(i)).getAnnotationsInternal(), invisibleParameterAnnotations.getAnnotations()[i]);
                    }
                }
                finally {
                    this._parser.popGenericContext();
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtilities.asRuntimeException((Throwable)e);
        }
    }

    private IMethodSignature tryParseMethodSignature(String signature, IMethodSignature fallback) {
        try {
            if (signature != null) {
                return this._parser.parseMethodSignature(signature);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return fallback;
    }

    private void readMethodBody(MethodInfo methodInfo, MethodDefinition methodDefinition) {
        if (methodInfo.codeAttribute instanceof CodeAttribute) {
            if (Flags.testAny(this._options, 2)) {
                MethodReader reader = new MethodReader(methodDefinition, this._scope);
                MethodBody body = reader.readBody();
                methodDefinition.setBody(body);
                body.freeze();
            } else {
                CodeAttribute codeAttribute = (CodeAttribute)methodInfo.codeAttribute;
                LocalVariableTableAttribute localVariables = (LocalVariableTableAttribute)SourceAttribute.find("LocalVariableTable", codeAttribute.getAttributes());
                if (localVariables == null) {
                    return;
                }
                List<ParameterDefinition> parameters = methodDefinition.getParameters();
                for (LocalVariableTableEntry entry : localVariables.getEntries()) {
                    ParameterReference parameter = null;
                    for (int j = 0; j < parameters.size(); ++j) {
                        if (parameters.get(j).getSlot() != entry.getIndex()) continue;
                        parameter = parameters.get(j);
                        break;
                    }
                    if (parameter == null || parameter.hasName()) continue;
                    parameter.setName(entry.getName());
                }
            }
        }
    }

    private void visitAttributes() {
        this.inflateAttributes(this._attributes);
        if (this.shouldProcessAnnotations()) {
            AnnotationsAttribute visibleAnnotations = (AnnotationsAttribute)SourceAttribute.find("RuntimeVisibleAnnotations", this._attributes);
            AnnotationsAttribute invisibleAnnotations = (AnnotationsAttribute)SourceAttribute.find("RuntimeInvisibleAnnotations", this._attributes);
            Collection<CustomAnnotation> annotations = this._typeDefinition.getAnnotationsInternal();
            if (visibleAnnotations != null) {
                Collections.addAll(annotations, visibleAnnotations.getAnnotations());
            }
            if (invisibleAnnotations != null) {
                Collections.addAll(annotations, invisibleAnnotations.getAnnotations());
            }
        }
        this.populatePermittedSubclasses();
    }

    private final class ResolverFrame
    implements IResolverFrame {
        final HashMap<String, TypeReference> types = new HashMap();
        final HashMap<String, GenericParameter> typeVariables = new HashMap();

        private ResolverFrame() {
        }

        public void addType(TypeReference type) {
            VerifyArgument.notNull((Object)type, (String)"type");
            this.types.put(type.getInternalName(), type);
        }

        public void addTypeVariable(GenericParameter type) {
            VerifyArgument.notNull((Object)type, (String)"type");
            this.typeVariables.put(type.getName(), type);
        }

        public void removeType(TypeReference type) {
            VerifyArgument.notNull((Object)type, (String)"type");
            this.types.remove(type.getInternalName());
        }

        public void removeTypeVariable(GenericParameter type) {
            VerifyArgument.notNull((Object)type, (String)"type");
            this.typeVariables.remove(type.getName());
        }

        @Override
        public TypeReference findType(String descriptor) {
            TypeReference type = this.types.get(descriptor);
            if (type != null) {
                return type;
            }
            return null;
        }

        @Override
        public GenericParameter findTypeVariable(String name) {
            GenericParameter typeVariable = this.typeVariables.get(name);
            if (typeVariable != null) {
                return typeVariable;
            }
            for (String typeName : this.types.keySet()) {
                TypeReference t = this.types.get(typeName);
                if (!t.containsGenericParameters()) continue;
                for (GenericParameter p : t.getGenericParameters()) {
                    if (!StringUtilities.equals((String)p.getName(), (String)name)) continue;
                    return p;
                }
            }
            return null;
        }
    }

    static class Scope
    implements IMetadataScope {
        private final MetadataParser _parser;
        private final TypeDefinition _typeDefinition;
        private final ConstantPool _constantPool;

        Scope(MetadataParser parser, TypeDefinition typeDefinition, ConstantPool constantPool) {
            this._parser = parser;
            this._typeDefinition = typeDefinition;
            this._constantPool = constantPool;
        }

        @Override
        public TypeReference lookupType(int token) {
            ConstantPool.Entry entry = this._constantPool.get(token);
            if (entry instanceof ConstantPool.TypeInfoEntry) {
                ConstantPool.TypeInfoEntry typeInfo = (ConstantPool.TypeInfoEntry)entry;
                return this._parser.parseTypeDescriptor(typeInfo.getName());
            }
            String typeName = (String)this._constantPool.lookupConstant(token);
            return this._parser.parseTypeSignature(typeName);
        }

        @Override
        public FieldReference lookupField(int token) {
            ConstantPool.FieldReferenceEntry entry = (ConstantPool.FieldReferenceEntry)this._constantPool.getEntry(token);
            return this.lookupField(entry.typeInfoIndex, entry.nameAndTypeDescriptorIndex);
        }

        @Override
        public MethodReference lookupMethod(int token) {
            ConstantPool.ReferenceEntry reference;
            Object entry = this._constantPool.getEntry(token);
            if (entry instanceof ConstantPool.MethodHandleEntry) {
                ConstantPool.MethodHandleEntry methodHandle = (ConstantPool.MethodHandleEntry)entry;
                reference = (ConstantPool.ReferenceEntry)this._constantPool.getEntry(methodHandle.referenceIndex);
            } else {
                reference = (ConstantPool.ReferenceEntry)entry;
            }
            return this.lookupMethod(reference.typeInfoIndex, reference.nameAndTypeDescriptorIndex);
        }

        @Override
        public MethodHandle lookupMethodHandle(int token) {
            ConstantPool.MethodHandleEntry entry = (ConstantPool.MethodHandleEntry)this._constantPool.getEntry(token);
            ConstantPool.ReferenceEntry reference = (ConstantPool.ReferenceEntry)this._constantPool.getEntry(entry.referenceIndex);
            return new MethodHandle(this.lookupMethod(reference.typeInfoIndex, reference.nameAndTypeDescriptorIndex), METHOD_HANDLE_TYPES[entry.referenceKind.ordinal()]);
        }

        @Override
        public IMethodSignature lookupMethodType(int token) {
            ConstantPool.MethodTypeEntry entry = (ConstantPool.MethodTypeEntry)this._constantPool.getEntry(token);
            return this._parser.parseMethodSignature(entry.getType());
        }

        @Override
        public DynamicCallSite lookupDynamicCallSite(int token) {
            ConstantPool.InvokeDynamicInfoEntry entry = (ConstantPool.InvokeDynamicInfoEntry)this._constantPool.getEntry(token);
            BootstrapMethodsAttribute attribute = (BootstrapMethodsAttribute)SourceAttribute.find("BootstrapMethods", this._typeDefinition.getSourceAttributes());
            BootstrapMethodsTableEntry bootstrapMethod = attribute.getBootstrapMethods().get(entry.bootstrapMethodAttributeIndex);
            ConstantPool.NameAndTypeDescriptorEntry nameAndType = (ConstantPool.NameAndTypeDescriptorEntry)this._constantPool.getEntry(entry.nameAndTypeDescriptorIndex);
            return new DynamicCallSite(entry.bootstrapMethodAttributeIndex, bootstrapMethod.getMethodHandle(), bootstrapMethod.getArguments(), nameAndType.getName(), this._parser.parseMethodSignature(nameAndType.getType()));
        }

        @Override
        public FieldReference lookupField(int typeToken, int nameAndTypeToken) {
            ConstantPool.NameAndTypeDescriptorEntry nameAndDescriptor = (ConstantPool.NameAndTypeDescriptorEntry)this._constantPool.getEntry(nameAndTypeToken);
            return this._parser.parseField(this.lookupType(typeToken), nameAndDescriptor.getName(), nameAndDescriptor.getType());
        }

        @Override
        public MethodReference lookupMethod(int typeToken, int nameAndTypeToken) {
            ConstantPool.NameAndTypeDescriptorEntry nameAndDescriptor = (ConstantPool.NameAndTypeDescriptorEntry)this._constantPool.getEntry(nameAndTypeToken);
            return this._parser.parseMethod(this.lookupType(typeToken), nameAndDescriptor.getName(), nameAndDescriptor.getType());
        }

        @Override
        public <T> T lookupConstant(int token) {
            ConstantPool.Entry entry = this._constantPool.get(token);
            if (entry.getTag() == ConstantPool.Tag.TypeInfo) {
                return (T)this.lookupType(token);
            }
            return this._constantPool.lookupConstant(token);
        }

        @Override
        public Object lookup(int token) {
            ConstantPool.Entry entry = this._constantPool.get(token);
            if (entry == null) {
                return null;
            }
            switch (entry.getTag()) {
                case Utf8StringConstant: 
                case IntegerConstant: 
                case FloatConstant: 
                case LongConstant: 
                case DoubleConstant: 
                case StringConstant: {
                    return this.lookupConstant(token);
                }
                case TypeInfo: {
                    return this.lookupType(token);
                }
                case FieldReference: {
                    return this.lookupField(token);
                }
                case MethodReference: {
                    return this.lookupMethod(token);
                }
                case InterfaceMethodReference: {
                    return this.lookupMethod(token);
                }
                case MethodHandle: {
                    return this.lookupMethodHandle(token);
                }
                case MethodType: {
                    return this.lookupMethodType(token);
                }
                case InvokeDynamicInfo: {
                    return this.lookupDynamicCallSite(token);
                }
            }
            return null;
        }
    }

    final class MethodInfo {
        final int accessFlags;
        final String name;
        final String descriptor;
        final SourceAttribute[] attributes;
        SourceAttribute codeAttribute;

        MethodInfo(int accessFlags, String name, String descriptor, SourceAttribute[] attributes) {
            this.accessFlags = accessFlags;
            this.name = name;
            this.descriptor = descriptor;
            this.attributes = attributes;
            this.codeAttribute = SourceAttribute.find("Code", attributes);
        }
    }

    final class FieldInfo {
        final int accessFlags;
        final String name;
        final String descriptor;
        final SourceAttribute[] attributes;

        FieldInfo(int accessFlags, String name, String descriptor, SourceAttribute[] attributes) {
            this.accessFlags = accessFlags;
            this.name = name;
            this.descriptor = descriptor;
            this.attributes = attributes;
        }
    }
}

