/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.classpath.scanner;

import java.util.List;
import org.avaje.classpath.scanner.ClassFilter;
import org.avaje.classpath.scanner.Location;
import org.avaje.classpath.scanner.Resource;
import org.avaje.classpath.scanner.ResourceFilter;
import org.avaje.classpath.scanner.internal.EnvironmentDetection;
import org.avaje.classpath.scanner.internal.ResourceAndClassScanner;
import org.avaje.classpath.scanner.internal.scanner.classpath.ClassPathScanner;
import org.avaje.classpath.scanner.internal.scanner.classpath.android.AndroidScanner;
import org.avaje.classpath.scanner.internal.scanner.filesystem.FileSystemScanner;

public class Scanner
implements org.avaje.classpath.scanner.ClassPathScanner {
    private final ResourceAndClassScanner resourceAndClassScanner;
    private final FileSystemScanner fileSystemScanner = new FileSystemScanner();

    public Scanner(ClassLoader classLoader) {
        this.resourceAndClassScanner = EnvironmentDetection.isAndroid() ? new AndroidScanner(classLoader) : new ClassPathScanner(classLoader);
    }

    public List<Resource> scanForResources(Location location, ResourceFilter predicate) {
        if (location.isFileSystem()) {
            return this.fileSystemScanner.scanForResources(location, predicate);
        }
        return this.resourceAndClassScanner.scanForResources(location, predicate);
    }

    public List<Resource> scanForResources(String location, ResourceFilter predicate) {
        return this.scanForResources(new Location(location), predicate);
    }

    public List<Class<?>> scanForClasses(Location location, ClassFilter predicate) {
        return this.resourceAndClassScanner.scanForClasses(location, predicate);
    }

    public List<Class<?>> scanForClasses(String location, ClassFilter predicate) {
        return this.scanForClasses(new Location(location), predicate);
    }
}

