/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.config;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public final class AsyncHttpClientConfigHelper {
    @Nullable
    private static volatile Config config;

    private AsyncHttpClientConfigHelper() {
    }

    public static Config getAsyncHttpClientConfig() {
        if (config == null) {
            config = new Config();
        }
        return config;
    }

    public static void reloadProperties() {
        Config localInstance = config;
        if (localInstance != null) {
            localInstance.reload();
        }
    }

    public static class Config {
        public static final String DEFAULT_AHC_PROPERTIES = "ahc-default.properties";
        public static final String CUSTOM_AHC_PROPERTIES = "ahc.properties";
        private final ConcurrentHashMap<String, String> propsCache = new ConcurrentHashMap();
        private final Properties defaultProperties = this.parsePropertiesFile("ahc-default.properties", true);
        private volatile Properties customProperties = this.parsePropertiesFile("ahc.properties", false);

        public void reload() {
            this.customProperties = this.parsePropertiesFile(CUSTOM_AHC_PROPERTIES, false);
            this.propsCache.clear();
        }

        private Properties parsePropertiesFile(String file, boolean required) {
            Properties props;
            block12: {
                props = new Properties();
                try (InputStream is = this.getClass().getResourceAsStream(file);){
                    if (is != null) {
                        try {
                            props.load(is);
                            break block12;
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException("Can't parse config file " + file, e);
                        }
                    }
                    if (required) {
                        throw new IllegalArgumentException("Can't locate config file " + file);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return props;
        }

        public String getString(String key) {
            return this.propsCache.computeIfAbsent(key, k -> {
                String value = System.getProperty(k);
                if (value == null) {
                    value = this.customProperties.getProperty((String)k);
                }
                if (value == null) {
                    value = this.defaultProperties.getProperty((String)k);
                }
                return value;
            });
        }

        @Nullable
        public String[] getStringArray(String key) {
            String s = this.getString(key);
            if ((s = s.trim()).isEmpty()) {
                return null;
            }
            String[] rawArray = s.split(",");
            String[] array = new String[rawArray.length];
            for (int i = 0; i < rawArray.length; ++i) {
                array[i] = rawArray[i].trim();
            }
            return array;
        }

        public int getInt(String key) {
            return Integer.parseInt(this.getString(key));
        }

        public boolean getBoolean(String key) {
            return Boolean.parseBoolean(this.getString(key));
        }

        public Duration getDuration(String key) {
            return Duration.parse(this.getString(key));
        }
    }
}

