/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.assertj.core.presentation.DefaultToString;
import org.assertj.core.presentation.PredicateDescription;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.DateUtil;
import org.assertj.core.util.Strings;

public class StandardRepresentation
implements Representation {
    public static final StandardRepresentation STANDARD_REPRESENTATION = new StandardRepresentation();

    @Override
    public String toStringOf(Object object) {
        if (object instanceof Calendar) {
            return StandardRepresentation.toStringOf((Calendar)object);
        }
        if (object instanceof Class) {
            return StandardRepresentation.toStringOf((Class)object);
        }
        if (object instanceof Date) {
            return StandardRepresentation.toStringOf((Date)object);
        }
        if (object instanceof Number) {
            return StandardRepresentation.toStringOf((Number)object, this);
        }
        if (object instanceof File) {
            return StandardRepresentation.toStringOf((File)object);
        }
        if (object instanceof String) {
            return StandardRepresentation.toStringOf((String)object);
        }
        if (object instanceof Character) {
            return StandardRepresentation.toStringOf((Character)object);
        }
        if (object instanceof Comparator) {
            return StandardRepresentation.toStringOf((Comparator)object);
        }
        if (object instanceof SimpleDateFormat) {
            return StandardRepresentation.toStringOf((SimpleDateFormat)object);
        }
        if (object instanceof PredicateDescription) {
            return StandardRepresentation.toStringOf((PredicateDescription)object);
        }
        if (object instanceof CompletableFuture) {
            return this.toStringOf((CompletableFuture)object);
        }
        return DefaultToString.toStringOf(this, object);
    }

    private static String toStringOf(Number number, Representation representation) {
        if (number instanceof Float) {
            return StandardRepresentation.toStringOf((Float)number);
        }
        if (number instanceof Long) {
            return StandardRepresentation.toStringOf((Long)number);
        }
        return DefaultToString.toStringOf(representation, number);
    }

    private static String toStringOf(Comparator<?> comparator) {
        if (!comparator.toString().contains("@")) {
            return Strings.quote(comparator.toString());
        }
        String comparatorSimpleClassName = comparator.getClass().getSimpleName();
        if (comparatorSimpleClassName.length() == 0) {
            return Strings.quote("anonymous comparator class");
        }
        if (comparator.toString().contains(comparatorSimpleClassName + "@")) {
            return Strings.quote(comparatorSimpleClassName);
        }
        return Strings.quote(comparator.toString());
    }

    private static String toStringOf(Calendar c) {
        return DateUtil.formatAsDatetime(c);
    }

    private static String toStringOf(Class<?> c) {
        return c.getCanonicalName();
    }

    private static String toStringOf(String s) {
        return Strings.concat("\"", s, "\"");
    }

    private static String toStringOf(Character c) {
        return Strings.concat("'", c, "'");
    }

    private static String toStringOf(PredicateDescription p) {
        return p.isDefault() ? String.format("%s", p.description) : String.format("'%s'", p.description);
    }

    private static String toStringOf(Date d) {
        return DateUtil.formatAsDatetimeWithMs(d);
    }

    private static String toStringOf(Float f) {
        return String.format("%sf", f);
    }

    private static String toStringOf(Long l) {
        return String.format("%sL", l);
    }

    private static String toStringOf(File f) {
        return f.getAbsolutePath();
    }

    private static String toStringOf(SimpleDateFormat dateFormat) {
        return dateFormat.toPattern();
    }

    private String toStringOf(CompletableFuture<?> future) {
        String className = future.getClass().getSimpleName();
        if (!future.isDone()) {
            return Strings.concat(className, "[Incomplete]");
        }
        try {
            return Strings.concat(className, "[Completed: ", this.toStringOf(future.join()), "]");
        }
        catch (CompletionException e) {
            return Strings.concat(className, "[Failed: ", this.toStringOf(e.getCause()), "]");
        }
        catch (CancellationException e) {
            return Strings.concat(className, "[Cancelled]");
        }
    }
}

