/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.ArrayList;
import java.util.Comparator;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.data.Index;
import org.assertj.core.error.ShouldHaveAtLeastOneElementOfType;
import org.assertj.core.error.ShouldHaveOnlyElementsOfType;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Lists;
import org.assertj.core.util.VisibleForTesting;

public class ObjectArrays {
    private static final ObjectArrays INSTANCE = new ObjectArrays();
    private Arrays arrays = Arrays.instance();
    @VisibleForTesting
    Failures failures = Failures.instance();
    @VisibleForTesting
    Conditions conditions = Conditions.instance();

    public static ObjectArrays instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    ObjectArrays() {
        this(StandardComparisonStrategy.instance());
    }

    public ObjectArrays(ComparisonStrategy comparisonStrategy) {
        this.arrays = new Arrays(comparisonStrategy);
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        return this.arrays.getComparator();
    }

    @VisibleForTesting
    public ComparisonStrategy getComparisonStrategy() {
        return this.arrays.getComparisonStrategy();
    }

    public void assertNullOrEmpty(AssertionInfo info, Object[] actual) {
        this.arrays.assertNullOrEmpty(info, this.failures, actual);
    }

    public void assertEmpty(AssertionInfo info, Object[] actual) {
        this.arrays.assertEmpty(info, this.failures, actual);
    }

    public void assertNotEmpty(AssertionInfo info, Object[] actual) {
        this.arrays.assertNotEmpty(info, this.failures, actual);
    }

    public void assertHasSize(AssertionInfo info, Object[] actual, int expectedSize) {
        this.arrays.assertHasSize(info, this.failures, actual, expectedSize);
    }

    public void assertHasSameSizeAs(AssertionInfo info, Object[] actual, Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(info, (Object)actual, other);
    }

    public void assertHasSameSizeAs(AssertionInfo info, Object[] actual, Object other) {
        this.arrays.assertHasSameSizeAs(info, (Object)actual, other);
    }

    public void assertContains(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertContains(info, this.failures, actual, values);
    }

    public void assertContains(AssertionInfo info, Object[] actual, Object value, Index index) {
        this.arrays.assertContains(info, this.failures, actual, value, index);
    }

    public void assertDoesNotContain(AssertionInfo info, Object[] actual, Object value, Index index) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, value, index);
    }

    public void assertContainsOnly(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertContainsOnly(info, this.failures, actual, values);
    }

    public void assertContainsExactly(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertContainsExactly(info, this.failures, actual, values);
    }

    public void assertContainsOnlyOnce(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertContainsOnlyOnce(info, this.failures, actual, values);
    }

    public void assertContainsSequence(AssertionInfo info, Object[] actual, Object[] sequence) {
        this.arrays.assertContainsSequence(info, this.failures, actual, sequence);
    }

    public void assertContainsSubsequence(AssertionInfo info, Object[] actual, Object[] subsequence) {
        this.arrays.assertContainsSubsequence(info, this.failures, actual, subsequence);
    }

    public void assertDoesNotContain(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, values);
    }

    public <T> void assertDoesNotContainAnyElementsOf(AssertionInfo info, Object[] actual, Iterable<? extends T> iterable) {
        CommonValidations.checkIsNotNullAndNotEmpty(iterable);
        ArrayList<T> values = Lists.newArrayList(iterable);
        this.assertDoesNotContain(info, actual, values.toArray());
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info, Object[] actual) {
        this.arrays.assertDoesNotHaveDuplicates(info, this.failures, actual);
    }

    public void assertStartsWith(AssertionInfo info, Object[] actual, Object[] sequence) {
        this.arrays.assertStartsWith(info, this.failures, actual, sequence);
    }

    public void assertEndsWith(AssertionInfo info, Object[] actual, Object[] sequence) {
        this.arrays.assertEndsWith(info, this.failures, actual, sequence);
    }

    public void assertIsSubsetOf(AssertionInfo info, Object actual, Iterable<?> values) {
        this.arrays.assertIsSubsetOf(info, this.failures, actual, values);
    }

    public void assertContainsNull(AssertionInfo info, Object[] actual) {
        this.arrays.assertContainsNull(info, this.failures, actual);
    }

    public void assertDoesNotContainNull(AssertionInfo info, Object[] actual) {
        this.arrays.assertDoesNotContainNull(info, this.failures, actual);
    }

    public <E> void assertAre(AssertionInfo info, E[] actual, Condition<? super E> condition) {
        this.arrays.assertAre(info, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertAreNot(AssertionInfo info, E[] actual, Condition<? super E> condition) {
        this.arrays.assertAreNot(info, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertHave(AssertionInfo info, E[] actual, Condition<? super E> condition) {
        this.arrays.assertHave(info, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertDoNotHave(AssertionInfo info, E[] actual, Condition<? super E> condition) {
        this.arrays.assertHaveNot(info, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertAreAtLeast(AssertionInfo info, E[] actual, int n, Condition<? super E> condition) {
        this.arrays.assertAreAtLeast(info, this.failures, this.conditions, actual, n, condition);
    }

    public <E> void assertAreAtMost(AssertionInfo info, E[] actual, int n, Condition<? super E> condition) {
        this.arrays.assertAreAtMost(info, this.failures, this.conditions, actual, n, condition);
    }

    public <E> void assertAreExactly(AssertionInfo info, E[] actual, int n, Condition<? super E> condition) {
        this.arrays.assertAreExactly(info, this.failures, this.conditions, actual, n, condition);
    }

    public <E> void assertHaveAtLeast(AssertionInfo info, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertHaveAtLeast(info, this.failures, this.conditions, actual, times, condition);
    }

    public <E> void assertHaveAtMost(AssertionInfo info, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertHaveAtMost(info, this.failures, this.conditions, actual, times, condition);
    }

    public <E> void assertHaveExactly(AssertionInfo info, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertHaveExactly(info, this.failures, this.conditions, actual, times, condition);
    }

    public <E> void assertHasAtLeastOneElementOfType(AssertionInfo info, E[] actual, Class<?> type) {
        Objects.instance().assertNotNull(info, actual);
        boolean found = false;
        for (E o : actual) {
            if (!type.isInstance(o)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw this.failures.failure(info, ShouldHaveAtLeastOneElementOfType.shouldHaveAtLeastOneElementOfType(actual, type));
        }
    }

    public <E> void assertHasOnlyElementsOfType(AssertionInfo info, E[] actual, Class<?> type) {
        Objects.instance().assertNotNull(info, actual);
        for (E o : actual) {
            if (type.isInstance(o)) continue;
            throw this.failures.failure(info, ShouldHaveOnlyElementsOfType.shouldHaveOnlyElementsOfType(actual, type, o.getClass()));
        }
    }

    public void assertIsSorted(AssertionInfo info, Object[] actual) {
        this.arrays.assertIsSorted(info, this.failures, actual);
    }

    public <E> void assertIsSortedAccordingToComparator(AssertionInfo info, E[] actual, Comparator<? super E> comparator) {
        Arrays.assertIsSortedAccordingToComparator(info, this.failures, actual, comparator);
    }

    public <E> void assertContainsAll(AssertionInfo info, E[] actual, Iterable<? extends E> other) {
        this.arrays.assertcontainsAll(info, this.failures, actual, other);
    }
}

