/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.error.ConditionAndGroupGenericParameterTypeShouldBeTheSame;
import org.assertj.core.error.ElementsShouldBe;
import org.assertj.core.error.ElementsShouldBeAtLeast;
import org.assertj.core.error.ElementsShouldBeAtMost;
import org.assertj.core.error.ElementsShouldBeExactly;
import org.assertj.core.error.ElementsShouldHave;
import org.assertj.core.error.ElementsShouldHaveAtLeast;
import org.assertj.core.error.ElementsShouldHaveAtMost;
import org.assertj.core.error.ElementsShouldHaveExactly;
import org.assertj.core.error.ElementsShouldMatch;
import org.assertj.core.error.ElementsShouldNotBe;
import org.assertj.core.error.ElementsShouldNotHave;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldBeSubsetOf;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainExactly;
import org.assertj.core.error.ShouldContainNull;
import org.assertj.core.error.ShouldContainOnly;
import org.assertj.core.error.ShouldContainSequence;
import org.assertj.core.error.ShouldContainSubsequence;
import org.assertj.core.error.ShouldContainsOnlyOnce;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.error.ShouldNotContainNull;
import org.assertj.core.error.ShouldNotHaveDuplicates;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.Predicates;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.VisibleForTesting;

public class Iterables {
    private static final Iterables INSTANCE = new Iterables();
    private final ComparisonStrategy comparisonStrategy;
    @VisibleForTesting
    Failures failures = Failures.instance();
    @VisibleForTesting
    Conditions conditions = Conditions.instance();
    @VisibleForTesting
    Predicates predicates = Predicates.instance();

    public static Iterables instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Iterables() {
        this(StandardComparisonStrategy.instance());
    }

    public Iterables(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    @VisibleForTesting
    public ComparisonStrategy getComparisonStrategy() {
        return this.comparisonStrategy;
    }

    public void assertNullOrEmpty(AssertionInfo info, Iterable<?> actual) {
        if (!IterableUtil.isNullOrEmpty(actual)) {
            throw this.failures.failure(info, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(actual));
        }
    }

    public void assertEmpty(AssertionInfo info, Iterable<?> actual) {
        this.assertNotNull(info, actual);
        if (!IterableUtil.isNullOrEmpty(actual)) {
            throw this.failures.failure(info, ShouldBeEmpty.shouldBeEmpty(actual));
        }
    }

    public void assertNotEmpty(AssertionInfo info, Iterable<?> actual) {
        this.assertNotNull(info, actual);
        if (IterableUtil.isNullOrEmpty(actual)) {
            throw this.failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    public void assertHasSize(AssertionInfo info, Iterable<?> actual, int expectedSize) {
        this.assertNotNull(info, actual);
        CommonValidations.checkSizes(actual, IterableUtil.sizeOf(actual), expectedSize, info);
    }

    public void assertHasSameSizeAs(AssertionInfo info, Iterable<?> actual, Object other) {
        this.assertNotNull(info, actual);
        Arrays.assertIsArray(info, other);
        CommonValidations.hasSameSizeAsCheck(info, actual, other, IterableUtil.sizeOf(actual));
    }

    public void assertHasSameSizeAs(AssertionInfo info, Iterable<?> actual, Iterable<?> other) {
        this.assertNotNull(info, actual);
        CommonValidations.hasSameSizeAsCheck(info, actual, other, IterableUtil.sizeOf(actual));
    }

    public void assertContains(AssertionInfo info, Iterable<?> actual, Object[] values) {
        if (this.commonCheckThatIterableAssertionSucceeds(info, actual, values)) {
            return;
        }
        this.assertIterableContainsGivenValues(actual, values, info);
    }

    private void assertIterableContainsGivenValues(Iterable<?> actual, Object[] values, AssertionInfo info) {
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        for (Object value : values) {
            if (this.iterableContains(actual, value)) continue;
            notFound.add(value);
        }
        if (notFound.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldContain.shouldContain(actual, values, notFound, this.comparisonStrategy));
    }

    private boolean iterableContains(Iterable<?> actual, Object value) {
        return this.comparisonStrategy.iterableContains(actual, value);
    }

    private void iterableRemoves(Iterable<?> actual, Object value) {
        this.comparisonStrategy.iterableRemoves(actual, value);
    }

    public void assertContainsOnly(AssertionInfo info, Iterable<?> actual, Object[] values) {
        if (this.commonCheckThatIterableAssertionSucceeds(info, actual, values)) {
            return;
        }
        List<Object> notExpected = this.asListWithoutDuplicatesAccordingToComparisonStrategy(actual);
        List<Object> notFound = this.containsOnly(notExpected, values);
        if (!notExpected.isEmpty() || !notFound.isEmpty()) {
            throw this.failures.failure(info, ShouldContainOnly.shouldContainOnly(actual, values, notFound, notExpected, this.comparisonStrategy));
        }
    }

    private List<Object> containsOnly(Collection<Object> actual, Object[] values) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : this.listWithoutDuplicates(values)) {
            if (this.iterableContains(actual, o)) {
                this.iterableRemoves(actual, o);
                continue;
            }
            list.add(o);
        }
        return list;
    }

    private List<Object> listWithoutDuplicates(Object ... elements) {
        return elements == null ? null : this.asListWithoutDuplicatesAccordingToComparisonStrategy(java.util.Arrays.asList(elements));
    }

    private List<Object> asListWithoutDuplicatesAccordingToComparisonStrategy(Iterable<?> iterable) {
        if (iterable == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object e : iterable) {
            if (this.iterableContains(list, e)) continue;
            list.add(e);
        }
        return list;
    }

    public void assertContainsOnlyOnce(AssertionInfo info, Iterable<?> actual, Object[] values) {
        if (this.commonCheckThatIterableAssertionSucceeds(info, actual, values)) {
            return;
        }
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        LinkedHashSet<Object> notOnlyOnce = new LinkedHashSet<Object>();
        Iterable<?> actualDuplicates = this.comparisonStrategy.duplicatesFrom(actual);
        for (Object expectedOnlyOnce : values) {
            if (!this.iterableContains(actual, expectedOnlyOnce)) {
                notFound.add(expectedOnlyOnce);
                continue;
            }
            if (!this.iterableContains(actualDuplicates, expectedOnlyOnce)) continue;
            notOnlyOnce.add(expectedOnlyOnce);
        }
        if (!notFound.isEmpty() || !notOnlyOnce.isEmpty()) {
            throw this.failures.failure(info, ShouldContainsOnlyOnce.shouldContainsOnlyOnce(actual, values, notFound, notOnlyOnce, this.comparisonStrategy));
        }
    }

    public void assertContainsSequence(AssertionInfo info, Iterable<?> actual, Object[] sequence) {
        if (this.commonCheckThatIterableAssertionSucceeds(info, actual, sequence)) {
            return;
        }
        ArrayList<?> actualAsList = Lists.newArrayList(actual);
        for (int i = 0; i < actualAsList.size(); ++i) {
            if (!this.containsSequenceAtGivenIndex(actualAsList, sequence, i)) continue;
            return;
        }
        throw this.actualDoesNotContainSequence(info, actual, sequence);
    }

    public void assertContainsSubsequence(AssertionInfo info, Iterable<?> actual, Object[] subsequence) {
        if (this.commonCheckThatIterableAssertionSucceeds(info, actual, subsequence)) {
            return;
        }
        Iterator<?> actualIterator = actual.iterator();
        int subsequenceIndex = 0;
        while (actualIterator.hasNext() && subsequenceIndex < subsequence.length) {
            Object subsequenceNext;
            Object actualNext = actualIterator.next();
            if (!this.areEqual(actualNext, subsequenceNext = subsequence[subsequenceIndex])) continue;
            ++subsequenceIndex;
        }
        if (subsequenceIndex < subsequence.length) {
            throw this.actualDoesNotContainSubsequence(info, actual, subsequence);
        }
    }

    public void assertIsSubsetOf(AssertionInfo info, Iterable<?> actual, Iterable<?> values) {
        this.assertNotNull(info, actual);
        CommonValidations.checkIterableIsNotNull(info, values);
        ArrayList extra = Lists.newArrayList();
        for (Object actualElement : actual) {
            if (this.iterableContains(values, actualElement)) continue;
            extra.add(actualElement);
        }
        if (extra.size() > 0) {
            throw this.failures.failure(info, ShouldBeSubsetOf.shouldBeSubsetOf(actual, values, extra, this.comparisonStrategy));
        }
    }

    private boolean containsSequenceAtGivenIndex(List<?> actualAsList, Object[] sequence, int startingIndex) {
        if (actualAsList.size() - startingIndex < sequence.length) {
            return false;
        }
        for (int i = 0; i < sequence.length; ++i) {
            if (this.areEqual(actualAsList.get(startingIndex + i), sequence[i])) continue;
            return false;
        }
        return true;
    }

    private boolean areEqual(Object actual, Object other) {
        return this.comparisonStrategy.areEqual(actual, other);
    }

    private AssertionError actualDoesNotContainSequence(AssertionInfo info, Iterable<?> actual, Object[] sequence) {
        return this.failures.failure(info, ShouldContainSequence.shouldContainSequence(actual, sequence, this.comparisonStrategy));
    }

    private AssertionError actualDoesNotContainSubsequence(AssertionInfo info, Iterable<?> actual, Object[] subsequence) {
        return this.failures.failure(info, ShouldContainSubsequence.shouldContainSubsequence(actual, subsequence, this.comparisonStrategy));
    }

    public void assertDoesNotContain(AssertionInfo info, Iterable<?> actual, Object[] values) {
        CommonValidations.checkIsNotNullAndNotEmpty(values);
        this.assertNotNull(info, actual);
        LinkedHashSet<Object> found = new LinkedHashSet<Object>();
        for (Object o : values) {
            if (!this.iterableContains(actual, o)) continue;
            found.add(o);
        }
        if (!found.isEmpty()) {
            throw this.failures.failure(info, ShouldNotContain.shouldNotContain(actual, values, found, this.comparisonStrategy));
        }
    }

    public <T> void assertDoesNotContainAnyElementsOf(AssertionInfo info, Iterable<? extends T> actual, Iterable<? extends T> iterable) {
        CommonValidations.checkIsNotNullAndNotEmpty(iterable);
        ArrayList<T> values = Lists.newArrayList(iterable);
        this.assertDoesNotContain(info, actual, values.toArray());
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info, Iterable<?> actual) {
        this.assertNotNull(info, actual);
        Iterable<?> duplicates = this.comparisonStrategy.duplicatesFrom(actual);
        if (!IterableUtil.isNullOrEmpty(duplicates)) {
            throw this.failures.failure(info, ShouldNotHaveDuplicates.shouldNotHaveDuplicates(actual, duplicates, this.comparisonStrategy));
        }
    }

    public void assertStartsWith(AssertionInfo info, Iterable<?> actual, Object[] sequence) {
        if (this.commonCheckThatIterableAssertionSucceeds(info, actual, sequence)) {
            return;
        }
        int i = 0;
        for (Object actualCurrentElement : actual) {
            if (i >= sequence.length) break;
            if (this.areEqual(actualCurrentElement, sequence[i++])) continue;
            throw this.actualDoesNotStartWithSequence(info, actual, sequence);
        }
        if (sequence.length > i) {
            throw this.actualDoesNotStartWithSequence(info, actual, sequence);
        }
    }

    private AssertionError actualDoesNotStartWithSequence(AssertionInfo info, Iterable<?> actual, Object[] sequence) {
        return this.failures.failure(info, ShouldStartWith.shouldStartWith(actual, sequence, this.comparisonStrategy));
    }

    public void assertEndsWith(AssertionInfo info, Iterable<?> actual, Object[] sequence) {
        if (this.commonCheckThatIterableAssertionSucceeds(info, actual, sequence)) {
            return;
        }
        int sizeOfActual = IterableUtil.sizeOf(actual);
        if (sizeOfActual < sequence.length) {
            throw this.actualDoesNotEndWithSequence(info, actual, sequence);
        }
        int start = sizeOfActual - sequence.length;
        int sequenceIndex = 0;
        int indexOfActual = 0;
        for (Object actualElement : actual) {
            if (indexOfActual++ < start || this.areEqual(actualElement, sequence[sequenceIndex++])) continue;
            throw this.actualDoesNotEndWithSequence(info, actual, sequence);
        }
    }

    private boolean commonCheckThatIterableAssertionSucceeds(AssertionInfo info, Iterable<?> actual, Object[] sequence) {
        CommonValidations.checkIsNotNull(sequence);
        this.assertNotNull(info, actual);
        if (!actual.iterator().hasNext() && sequence.length == 0) {
            return true;
        }
        CommonValidations.failIfEmptySinceActualIsNotEmpty(sequence);
        return false;
    }

    public void assertContainsNull(AssertionInfo info, Iterable<?> actual) {
        this.assertNotNull(info, actual);
        if (!this.iterableContains(actual, null)) {
            throw this.failures.failure(info, ShouldContainNull.shouldContainNull(actual));
        }
    }

    public void assertDoesNotContainNull(AssertionInfo info, Iterable<?> actual) {
        this.assertNotNull(info, actual);
        if (this.iterableContains(actual, null)) {
            throw this.failures.failure(info, ShouldNotContainNull.shouldNotContainNull(actual));
        }
    }

    public <T> void assertAre(AssertionInfo info, Iterable<? extends T> actual, Condition<? super T> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<T> notSatisfiesCondition = this.notSatisfyingCondition(actual, condition);
            if (!notSatisfiesCondition.isEmpty()) {
                throw this.failures.failure(info, ElementsShouldBe.elementsShouldBe(actual, notSatisfiesCondition, condition));
            }
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertAreNot(AssertionInfo info, Iterable<? extends E> actual, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.satisfiesCondition(actual, condition);
            if (!satisfiesCondition.isEmpty()) {
                throw this.failures.failure(info, ElementsShouldNotBe.elementsShouldNotBe(actual, satisfiesCondition, condition));
            }
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertHave(AssertionInfo info, Iterable<? extends E> actual, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> notSatisfiesCondition = this.notSatisfyingCondition(actual, condition);
            if (!notSatisfiesCondition.isEmpty()) {
                throw this.failures.failure(info, ElementsShouldHave.elementsShouldHave(actual, notSatisfiesCondition, condition));
            }
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertDoNotHave(AssertionInfo info, Iterable<? extends E> actual, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.satisfiesCondition(actual, condition);
            if (!satisfiesCondition.isEmpty()) {
                throw this.failures.failure(info, ElementsShouldNotHave.elementsShouldNotHave(actual, satisfiesCondition, condition));
            }
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertAreAtLeast(AssertionInfo info, Iterable<? extends E> actual, int times, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            if (!this.conditionIsSatisfiedAtLeastNTimes(actual, times, condition)) {
                throw this.failures.failure(info, ElementsShouldBeAtLeast.elementsShouldBeAtLeast(actual, times, condition));
            }
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    private <E> boolean conditionIsSatisfiedAtLeastNTimes(Iterable<? extends E> actual, int n, Condition<? super E> condition) {
        List<E> satisfiesCondition = this.satisfiesCondition(actual, condition);
        return satisfiesCondition.size() >= n;
    }

    public <E> void assertAreAtMost(AssertionInfo info, Iterable<? extends E> actual, int n, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            if (!this.conditionIsSatisfiedAtMostNTimes(actual, condition, n)) {
                throw this.failures.failure(info, ElementsShouldBeAtMost.elementsShouldBeAtMost(actual, n, condition));
            }
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    private <E> boolean conditionIsSatisfiedAtMostNTimes(Iterable<? extends E> actual, Condition<? super E> condition, int n) {
        List<E> satisfiesCondition = this.satisfiesCondition(actual, condition);
        return satisfiesCondition.size() <= n;
    }

    public <E> void assertAreExactly(AssertionInfo info, Iterable<? extends E> actual, int times, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            if (!this.conditionIsSatisfiedNTimes(actual, condition, times)) {
                throw this.failures.failure(info, ElementsShouldBeExactly.elementsShouldBeExactly(actual, times, condition));
            }
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    private <E> boolean conditionIsSatisfiedNTimes(Iterable<? extends E> actual, Condition<? super E> condition, int times) {
        List<E> satisfiesCondition = this.satisfiesCondition(actual, condition);
        return satisfiesCondition.size() == times;
    }

    public <E> void assertHaveAtLeast(AssertionInfo info, Iterable<? extends E> actual, int times, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            if (!this.conditionIsSatisfiedAtLeastNTimes(actual, times, condition)) {
                throw this.failures.failure(info, ElementsShouldHaveAtLeast.elementsShouldHaveAtLeast(actual, times, condition));
            }
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertHaveAtMost(AssertionInfo info, Iterable<? extends E> actual, int times, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            if (!this.conditionIsSatisfiedAtMostNTimes(actual, condition, times)) {
                throw this.failures.failure(info, ElementsShouldHaveAtMost.elementsShouldHaveAtMost(actual, times, condition));
            }
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertHaveExactly(AssertionInfo info, Iterable<? extends E> actual, int times, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            if (!this.conditionIsSatisfiedNTimes(actual, condition, times)) {
                throw this.failures.failure(info, ElementsShouldHaveExactly.elementsShouldHaveExactly(actual, times, condition));
            }
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public void assertContainsAll(AssertionInfo info, Iterable<?> actual, Iterable<?> other) {
        if (other == null) {
            throw Iterables.iterableToLookForIsNull();
        }
        this.assertNotNull(info, actual);
        Object[] values = Lists.newArrayList(other).toArray();
        this.assertIterableContainsGivenValues(actual, values, info);
    }

    public void assertContainsExactly(AssertionInfo info, Iterable<?> actual, Object[] values) {
        CommonValidations.checkIsNotNull(values);
        this.assertNotNull(info, actual);
        int actualSize = IterableUtil.sizeOf(actual);
        if (values.length != actualSize) {
            throw this.failures.failure(info, ShouldContainExactly.shouldHaveSameSize(actual, values, actualSize, values.length, this.comparisonStrategy));
        }
        this.assertHasSameSizeAs(info, actual, values);
        List<Object> notExpected = this.asListWithoutDuplicatesAccordingToComparisonStrategy(actual);
        List<Object> notFound = this.containsOnly(notExpected, values);
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            int i = 0;
            for (Object elementFromActual : actual) {
                if (!this.areEqual(elementFromActual, values[i])) {
                    throw this.failures.failure(info, ShouldContainExactly.elementsDifferAtIndex(elementFromActual, values[i], i, this.comparisonStrategy));
                }
                ++i;
            }
            return;
        }
        throw this.failures.failure(info, ShouldContainExactly.shouldContainExactly(actual, (Object)values, notFound, notExpected, this.comparisonStrategy));
    }

    public <E> void assertAllMatch(AssertionInfo info, Iterable<? extends E> actual, Predicate<? super E> predicate) {
        this.assertNotNull(info, actual);
        this.predicates.assertIsNotNull(predicate);
        StreamSupport.stream(actual.spliterator(), false).filter(predicate.negate()).findFirst().ifPresent(e -> {
            throw this.failures.failure(info, ElementsShouldMatch.elementsShouldMatch(actual, e, predicate));
        });
    }

    private void assertNotNull(AssertionInfo info, Iterable<?> actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private AssertionError actualDoesNotEndWithSequence(AssertionInfo info, Iterable<?> actual, Object[] sequence) {
        return this.failures.failure(info, ShouldEndWith.shouldEndWith(actual, sequence, this.comparisonStrategy));
    }

    private <E> List<E> notSatisfyingCondition(Iterable<? extends E> actual, Condition<? super E> condition) {
        LinkedList<E> notSatisfiesCondition = new LinkedList<E>();
        for (E o : actual) {
            if (condition.matches(o)) continue;
            notSatisfiesCondition.add(o);
        }
        return notSatisfiesCondition;
    }

    private <E> List<E> satisfiesCondition(Iterable<? extends E> actual, Condition<? super E> condition) {
        LinkedList<E> satisfiesCondition = new LinkedList<E>();
        for (E o : actual) {
            if (!condition.matches(o)) continue;
            satisfiesCondition.add(o);
        }
        return satisfiesCondition;
    }

    public static NullPointerException iterableToLookForIsNull() {
        return new NullPointerException("The iterable to look for should not be null");
    }

    public static IllegalArgumentException iterableToLookForIsEmpty() {
        return new IllegalArgumentException("The iterable to look for should not be empty");
    }
}

