/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.StringJoiner;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ShouldHavePackage
extends BasicErrorMessageFactory {
    private static final String SHOULD_HAVE_PACKAGE = new StringJoiner("%n", "%n", "").add("Expecting").add("  <%s>").add("to have package:").add("  <%s>").toString();
    private static final String BUT_HAD_NONE = new StringJoiner("%n", "%n", "").add("but had none.").toString();
    private static final String BUT_HAD = new StringJoiner("%n", "%n", "").add("but had:").add("  <%s>").toString();

    public static ErrorMessageFactory shouldHavePackage(Class<?> actual, Package aPackage) {
        return ShouldHavePackage.shouldHavePackage(actual, aPackage.getName());
    }

    public static ErrorMessageFactory shouldHavePackage(Class<?> actual, String packageName) {
        Package actualPackage = actual.getPackage();
        return actualPackage == null ? new ShouldHavePackage(actual, packageName) : new ShouldHavePackage(actual, packageName, actualPackage.getName());
    }

    private ShouldHavePackage(Class<?> actual, String expectedPackage) {
        super(SHOULD_HAVE_PACKAGE + BUT_HAD_NONE, actual, expectedPackage);
    }

    private ShouldHavePackage(Class<?> actual, String expectedPackage, String actualPackage) {
        super(SHOULD_HAVE_PACKAGE + BUT_HAD, actual, expectedPackage, actualPackage);
    }
}

