/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.JoinDescription;
import org.assertj.core.util.Streams;
import org.assertj.core.util.VisibleForTesting;

public abstract class Join<T>
extends Condition<T> {
    @VisibleForTesting
    Collection<Condition<? super T>> conditions;

    @SafeVarargs
    protected Join(Condition<? super T> ... conditions) {
        this(Arrays.stream(Join.checkNotNullConditions(conditions)));
    }

    protected Join(Iterable<? extends Condition<? super T>> conditions) {
        this(Streams.stream(Join.checkNotNullConditions(conditions)));
    }

    private Join(Stream<? extends Condition<? super T>> stream) {
        this.conditions = stream.map(Join::notNull).collect(Collectors.toList());
        List<Description> descriptions = this.conditions.stream().map(Condition::description).collect(Collectors.toList());
        this.describedAs(new JoinDescription(this.descriptionPrefix() + ":[", "]", descriptions));
    }

    private static <T> T checkNotNullConditions(T conditions) {
        return Objects.requireNonNull(conditions, "The given conditions should not be null");
    }

    public abstract String descriptionPrefix();

    private static <T> T notNull(T condition) {
        return Objects.requireNonNull(condition, "The given conditions should not have null entries");
    }

    protected final Collection<Condition<? super T>> conditions() {
        return Collections.unmodifiableCollection(this.conditions);
    }
}

