/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.internal.Bytes;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractByteAssert<SELF extends AbstractByteAssert<SELF>>
extends AbstractComparableAssert<SELF, Byte>
implements NumberAssert<SELF, Byte> {
    @VisibleForTesting
    Bytes bytes = Bytes.instance();

    public AbstractByteAssert(Byte actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isEqualTo(byte expected) {
        this.bytes.assertEqual(this.info, this.actual, expected);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    public SELF isNotEqualTo(byte other) {
        this.bytes.assertNotEqual(this.info, this.actual, other);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isZero() {
        this.bytes.assertIsZero(this.info, (Number)this.actual);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isNotZero() {
        this.bytes.assertIsNotZero(this.info, (Number)this.actual);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isOne() {
        this.bytes.assertIsOne(this.info, (Number)this.actual);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isPositive() {
        this.bytes.assertIsPositive(this.info, (Number)this.actual);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isNegative() {
        this.bytes.assertIsNegative(this.info, (Number)this.actual);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isNotNegative() {
        this.bytes.assertIsNotNegative(this.info, (Number)this.actual);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isNotPositive() {
        this.bytes.assertIsNotPositive(this.info, (Number)this.actual);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isLessThan(byte other) {
        this.bytes.assertLessThan(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isLessThanOrEqualTo(byte other) {
        this.bytes.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isGreaterThan(byte other) {
        this.bytes.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isGreaterThanOrEqualTo(byte other) {
        this.bytes.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isBetween(Byte start, Byte end) {
        this.bytes.assertIsBetween(this.info, (Number)this.actual, start, end);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isStrictlyBetween(Byte start, Byte end) {
        this.bytes.assertIsStrictlyBetween(this.info, (Number)this.actual, start, end);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(byte expected, Offset<Byte> offset) {
        this.bytes.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(byte expected, Offset<Byte> offset) {
        this.bytes.assertIsNotCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Byte expected, Offset<Byte> offset) {
        this.bytes.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Byte expected, Offset<Byte> offset) {
        this.bytes.assertIsNotCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Byte expected, Percentage percentage) {
        this.bytes.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Byte expected, Percentage percentage) {
        this.bytes.assertIsNotCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(byte expected, Percentage percentage) {
        this.bytes.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(byte expected, Percentage percentage) {
        this.bytes.assertIsNotCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Byte> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Byte> customComparator, String customComparatorDescription) {
        super.usingComparator(customComparator, customComparatorDescription);
        this.bytes = new Bytes(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractByteAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        super.usingDefaultComparator();
        this.bytes = Bytes.instance();
        return (SELF)((AbstractByteAssert)this.myself);
    }
}

