/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.builder;

import java.util.Locale;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.IModuleDescription;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.util.IAttributeNamesConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.Compiler;
import org.aspectj.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.aspectj.org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SimpleSetOfCharArray;
import org.aspectj.org.eclipse.jdt.internal.core.CompilationGroup;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelStatus;
import org.aspectj.org.eclipse.jdt.internal.core.ModuleUpdater;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.aspectj.org.eclipse.jdt.internal.core.builder.NameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class ModuleInfoBuilder {
    public byte[] compileWithAttributes(IModuleDescription module, Map<String, String> classFileAttributes) throws JavaModelException {
        IJavaProject javaProject = module.getJavaProject();
        NameEnvironment nameEnvironment = new NameEnvironment(javaProject, CompilationGroup.MAIN);
        this.addModuleUpdates(module, nameEnvironment.moduleUpdater, classFileAttributes);
        ClasspathMultiDirectory sourceLocation = this.getSourceLocation(javaProject, nameEnvironment, module);
        IFile file = (IFile)module.getCompilationUnit().getCorrespondingResource();
        ICompilationUnit[] sourceUnits = new ICompilationUnit[]{new SourceFile(file, sourceLocation)};
        BytecodeCollector collector = new BytecodeCollector();
        Compiler newCompiler = new Compiler((INameEnvironment)nameEnvironment, DefaultErrorHandlingPolicies.exitOnFirstError(), new CompilerOptions(javaProject.getOptions(true)), (ICompilerRequestor)collector, (IProblemFactory)ProblemFactory.getProblemFactory(Locale.getDefault()));
        newCompiler.compile(sourceUnits);
        return collector.bytes;
    }

    private void addModuleUpdates(IModuleDescription module, ModuleUpdater moduleUpdater, Map<String, String> classFileAttributes) {
        String modulePackageNames;
        String mainClassName = classFileAttributes.remove(String.valueOf(IAttributeNamesConstants.MODULE_MAIN_CLASS));
        if (mainClassName != null) {
            moduleUpdater.addModuleUpdate(module.getElementName(), m -> m.setMainClassName(mainClassName.toCharArray()), IUpdatableModule.UpdateKind.MODULE);
        }
        if ((modulePackageNames = classFileAttributes.remove(String.valueOf(IAttributeNamesConstants.MODULE_PACKAGES))) != null) {
            SimpleSetOfCharArray namesSet = new SimpleSetOfCharArray();
            String[] providedNames = modulePackageNames.split(",");
            int i = 0;
            while (i < providedNames.length) {
                namesSet.add(providedNames[i].trim().toCharArray());
                ++i;
            }
            moduleUpdater.addModuleUpdate(module.getElementName(), m -> m.setPackageNames(namesSet), IUpdatableModule.UpdateKind.MODULE);
        }
        if (!classFileAttributes.isEmpty()) {
            throw new IllegalArgumentException("Unsupported key(s): " + classFileAttributes.keySet().toString());
        }
    }

    private ClasspathMultiDirectory getSourceLocation(IJavaProject javaProject, NameEnvironment nameEnvironment, IModuleDescription module) throws JavaModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)module.getAncestor(3);
        IResource rootResource = root.getCorrespondingResource();
        ClasspathMultiDirectory[] classpathMultiDirectoryArray = nameEnvironment.sourceLocations;
        int n = nameEnvironment.sourceLocations.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathMultiDirectory sourceLocation = classpathMultiDirectoryArray[n2];
            if (sourceLocation.sourceFolder.equals(rootResource)) {
                return sourceLocation;
            }
            ++n2;
        }
        throw new JavaModelException(new JavaModelStatus(1006, module));
    }

    static class BytecodeCollector
    implements ICompilerRequestor {
        byte[] bytes;

        BytecodeCollector() {
        }

        @Override
        public void acceptResult(CompilationResult result) {
            assert (this.bytes == null) : "duplicate result";
            ClassFile[] classFiles = result.getClassFiles();
            assert (classFiles.length == 1);
            this.bytes = classFiles[0].getBytes();
        }
    }
}

