/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl;
import org.apache.spark.streaming.receiver.StopReceiver$;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.ReceiverInfo;
import org.apache.spark.streaming.scheduler.ReceiverInfo$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverLauncher$;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.apache.spark.util.AkkaUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.SynchronizedMap;
import scala.collection.mutable.SynchronizedQueue;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t-c!B\u0001\u0003\u0001\u0011a!a\u0004*fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0004gN\u001c7\u0001\u0001\t\u00037qi\u0011\u0001B\u0005\u0003;\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u000b}\u0001A\u0011\u0001\u0011\u0002\rqJg.\u001b;?)\t\t3\u0005\u0005\u0002#\u00015\t!\u0001C\u0003\u0019=\u0001\u0007!\u0004C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\u0002)I,7-Z5wKJLe\u000e];u'R\u0014X-Y7t+\u00059\u0003c\u0001\b)U%\u0011\u0011f\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0019\u0003WM\u00022\u0001L\u00182\u001b\u0005i#B\u0001\u0018\u0005\u0003\u001d!7\u000f\u001e:fC6L!\u0001M\u0017\u0003)I+7-Z5wKJLe\u000e];u\tN#(/Z1n!\t\u00114\u0007\u0004\u0001\u0005\u0013Q\u0002\u0011\u0011!A\u0001\u0006\u0003Y$aA0%m%\u0011agN\u0001\tI\u0005twN\u001c4v]&\u0011\u0001(O\u0001\u0018O\u0016$(+Z2fSZ,'/\u00138qkR\u001cFO]3b[NL!A\u000f\u0003\u0003\u0019\u0011\u001bFO]3b[\u001e\u0013\u0018\r\u001d5\u0012\u0005qz\u0004C\u0001\b>\u0013\tqtBA\u0004O_RD\u0017N\\4\u0011\u00059\u0001\u0015BA!\u0010\u0005\r\te.\u001f\u0005\u0007\u0007\u0002\u0001\u000b\u0011B\u0014\u0002+I,7-Z5wKJLe\u000e];u'R\u0014X-Y7tA!9Q\t\u0001b\u0001\n\u00031\u0015A\u0006:fG\u0016Lg/\u001a:J]B,Ho\u0015;sK\u0006lW*\u00199\u0016\u0003\u001d\u0003$\u0001S+\u0011\t%s\u0005kU\u0007\u0002\u0015*\u00111\nT\u0001\nS6lW\u000f^1cY\u0016T!!T\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002P\u0015\n\u0019Q*\u00199\u0011\u00059\t\u0016B\u0001*\u0010\u0005\rIe\u000e\u001e\t\u0004Y=\"\u0006C\u0001\u001aV\t%!d+!A\u0001\u0002\u000b\u00051\b\u0003\u0004X\u0001\u0001\u0006IaR\u0001\u0018e\u0016\u001cW-\u001b<fe&s\u0007/\u001e;TiJ,\u0017-\\'ba\u0002Bq!\u0017\u0001C\u0002\u0013\u0005!,\u0001\tsK\u000e,\u0017N^3s\u000bb,7-\u001e;peV\t1\f\u0005\u0002];6\t\u0001A\u0002\u0003_\u0001\u0001y&\u0001\u0005*fG\u0016Lg/\u001a:MCVt7\r[3s'\tiV\u0002C\u0003 ;\u0012\u0005\u0011\rF\u0001\\\u0011\u0015\u0019W\f\"\u0001e\u0003\u0015\u0019H/\u0019:u)\u0005)\u0007C\u0001\bg\u0013\t9wB\u0001\u0003V]&$\b\"B5^\t\u0003!\u0017\u0001B:u_BDQa[/\u0005\n\u0011\fab\u001d;beR\u0014VmY3jm\u0016\u00148\u000fC\u0003n;\u0012%A-A\u0007ti>\u0004(+Z2fSZ,'o\u001d\u0005\b_v\u0013\r\u0011\"\u0001q\u0003\r)gN^\u000b\u0002cB\u0011AC]\u0005\u0003g\u001a\u0011\u0001b\u00159be.,eN\u001e\u0005\u0007kv\u0003\u000b\u0011B9\u0002\t\u0015tg\u000f\t\u0015\u0003i^\u0004\"A\u0004=\n\u0005e|!!\u0003;sC:\u001c\u0018.\u001a8u\u0011\u001dYXL1A\u0005\u0002q\fa\u0001\u001e5sK\u0006$W#A?\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000b\tAA[1wC&\u0019\u0011\u0011B@\u0003\rQC'/Z1e\u0011\u001d\ti!\u0018Q\u0001\nu\fq\u0001\u001e5sK\u0006$\u0007\u0005K\u0002\u0002\f]Dq!a\u0005\u0001A\u0003%1,A\tsK\u000e,\u0017N^3s\u000bb,7-\u001e;pe\u0002B\u0011\"a\u0006\u0001\u0005\u0004%\t!!\u0007\u0002\u0019I,7-Z5wKJLeNZ8\u0016\u0005\u0005m!CBA\u000f\u0003K\t9DB\u0004\u0002 \u0005\u0005\u0002!a\u0007\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \t\u0011\u0005\r\u0002\u0001)A\u0005\u00037\tQB]3dK&4XM]%oM>\u0004\u0003cBA\u0014\u0003[\u0001\u0016\u0011G\u0007\u0003\u0003SQ1!a\u000bM\u0003\u001diW\u000f^1cY\u0016LA!a\f\u0002*\t9\u0001*Y:i\u001b\u0006\u0004\bc\u0001\u0012\u00024%\u0019\u0011Q\u0007\u0002\u0003\u0019I+7-Z5wKJLeNZ8\u0011\u000f\u0005\u001d\u0012\u0011\b)\u00022%!\u00111HA\u0015\u0005=\u0019\u0016P\\2ie>t\u0017N_3e\u001b\u0006\u0004\b\"CA \u0001\t\u0007I\u0011AA!\u0003E\u0011XmY3jm\u0016$'\t\\8dW&sgm\\\u000b\u0003\u0003\u0007\u0012b!!\u0012\u0002L\u0005ecaBA\u0010\u0003\u000f\u0002\u00111\t\u0005\t\u0003\u0013\u0002\u0001\u0015!\u0003\u0002D\u0005\u0011\"/Z2fSZ,GM\u00117pG.LeNZ8!!\u001d\t9#!\fQ\u0003\u001b\u0002b!a\n\u0002P\u0005M\u0013\u0002BA)\u0003S\u0011\u0011cU=oG\"\u0014xN\\5{K\u0012\fV/Z;f!\r\u0011\u0013QK\u0005\u0004\u0003/\u0012!!\u0005*fG\u0016Lg/\u001a3CY>\u001c7.\u00138g_B9\u0011qEA\u001d!\u00065\u0003\"CA/\u0001\t\u0007I\u0011AA0\u0003\u001d!\u0018.\\3pkR,\"!!\u0019\u0011\t\u0005\r\u0014QN\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005AA-\u001e:bi&|gNC\u0002\u0002l=\t!bY8oGV\u0014(/\u001a8u\u0013\u0011\ty'!\u001a\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"A\u00111\u000f\u0001!\u0002\u0013\t\t'\u0001\u0005uS6,w.\u001e;!\u0011%\t9\b\u0001b\u0001\n\u0003\tI(A\u0006mSN$XM\\3s\u0005V\u001cXCAA>!\r\u0011\u0013QP\u0005\u0004\u0003\u007f\u0012!\u0001F*ue\u0016\fW.\u001b8h\u0019&\u001cH/\u001a8fe\n+8\u000f\u0003\u0005\u0002\u0004\u0002\u0001\u000b\u0011BA>\u00031a\u0017n\u001d;f]\u0016\u0014()^:!\u0011%\t9\t\u0001a\u0001\n\u0003\tI)A\u0003bGR|'/\u0006\u0002\u0002\fB!\u0011QRAK\u001b\t\tyI\u0003\u0003\u0002\b\u0006E%BAAJ\u0003\u0011\t7n[1\n\t\u0005]\u0015q\u0012\u0002\t\u0003\u000e$xN\u001d*fM\"I\u00111\u0014\u0001A\u0002\u0013\u0005\u0011QT\u0001\nC\u000e$xN]0%KF$2!ZAP\u0011)\t\t+!'\u0002\u0002\u0003\u0007\u00111R\u0001\u0004q\u0012\n\u0004\u0002CAS\u0001\u0001\u0006K!a#\u0002\r\u0005\u001cGo\u001c:!\u0011%\tI\u000b\u0001a\u0001\n\u0003\tY+A\u0006dkJ\u0014XM\u001c;US6,WCAAW!\rY\u0012qV\u0005\u0004\u0003c#!\u0001\u0002+j[\u0016D\u0011\"!.\u0001\u0001\u0004%\t!a.\u0002\u001f\r,(O]3oiRKW.Z0%KF$2!ZA]\u0011)\t\t+a-\u0002\u0002\u0003\u0007\u0011Q\u0016\u0005\t\u0003{\u0003\u0001\u0015)\u0003\u0002.\u0006a1-\u001e:sK:$H+[7fA!)1\r\u0001C\u0001I\")\u0011\u000e\u0001C\u0001I\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0017\u0001F4fiJ+7-Z5wK\u0012\u0014En\\2l\u0013:4w\u000e\u0006\u0003\u0002J\u0006-\u0007\u0003\u0002\b)\u0003'Bq!!4\u0002D\u0002\u0007\u0001+\u0001\u0005tiJ,\u0017-\\%e\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'\f\u0011dZ3u%\u0016\u001cW-\u001b<fI\ncwnY6J]\u001a|\u0017+^3vKR!\u0011QJAk\u0011\u001d\ti-a4A\u0002ACq!!7\u0001\t\u0003\tY.\u0001\tsK\u001eL7\u000f^3s%\u0016\u001cW-\u001b<feRYQ-!8\u0002`\u0006E\u0018Q_A}\u0011\u001d\ti-a6A\u0002AC\u0001\"!9\u0002X\u0002\u0007\u00111]\u0001\u0004if\u0004\b\u0003BAs\u0003Wt1ADAt\u0013\r\tIoD\u0001\u0007!J,G-\u001a4\n\t\u00055\u0018q\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%x\u0002\u0003\u0005\u0002t\u0006]\u0007\u0019AAr\u0003\u0011Awn\u001d;\t\u0011\u0005]\u0018q\u001ba\u0001\u0003\u0017\u000bQB]3dK&4XM]!di>\u0014\b\u0002CA~\u0003/\u0004\r!a#\u0002\rM,g\u000eZ3s\u0011\u001d\ty\u0010\u0001C\u0001\u0005\u0003\t!\u0003Z3sK\u001eL7\u000f^3s%\u0016\u001cW-\u001b<feR9QMa\u0001\u0003\u0006\t%\u0001bBAg\u0003{\u0004\r\u0001\u0015\u0005\t\u0005\u000f\ti\u00101\u0001\u0002d\u00069Q.Z:tC\u001e,\u0007\u0002\u0003B\u0006\u0003{\u0004\r!a9\u0002\u000b\u0015\u0014(o\u001c:\t\u000f\t=\u0001\u0001\"\u0001\u0003\u0012\u0005I\u0011\r\u001a3CY>\u001c7n\u001d\u000b\u0004K\nM\u0001\u0002CA \u0005\u001b\u0001\r!a\u0015\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a\u0005Y!/\u001a9peR,%O]8s)\u001d)'1\u0004B\u000f\u0005?Aq!!4\u0003\u0016\u0001\u0007\u0001\u000b\u0003\u0005\u0003\b\tU\u0001\u0019AAr\u0011!\u0011YA!\u0006A\u0002\u0005\r\bb\u0002B\u0012\u0001\u0011\u0005!QE\u0001\u0018Q\u0006\u001cXj\u001c:f%\u0016\u001cW-\u001b<fI\ncwnY6JIN,\"Aa\n\u0011\u00079\u0011I#C\u0002\u0003,=\u0011qAQ8pY\u0016\fgN\u0002\u0004\u00030\u0001!!\u0011\u0007\u0002\u0015%\u0016\u001cW-\u001b<feR\u0013\u0018mY6fe\u0006\u001bGo\u001c:\u0014\u000b\t5RBa\r\u0011\t\u00055%QG\u0005\u0005\u0005o\tyIA\u0003BGR|'\u000fC\u0004 \u0005[!\tAa\u000f\u0015\u0005\tu\u0002c\u0001/\u0003.!A!\u0011\tB\u0017\t\u0003\u0011\u0019%A\u0004sK\u000e,\u0017N^3\u0016\u0005\t\u0015\u0003#\u0002\b\u0003H}*\u0017b\u0001B%\u001f\ty\u0001+\u0019:uS\u0006dg)\u001e8di&|g\u000e")
public class ReceiverTracker
implements Logging {
    public final StreamingContext org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc;
    private final ReceiverInputDStream<?>[] receiverInputStreams;
    private final Map<Object, ReceiverInputDStream<Object>> receiverInputStreamMap;
    private final ReceiverLauncher receiverExecutor;
    private final HashMap<Object, ReceiverInfo> receiverInfo;
    private final HashMap<Object, SynchronizedQueue<ReceivedBlockInfo>> receivedBlockInfo;
    private final FiniteDuration timeout;
    private final StreamingListenerBus listenerBus;
    private ActorRef actor;
    private Time currentTime;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ReceiverInputDStream<?>[] receiverInputStreams() {
        return this.receiverInputStreams;
    }

    public Map<Object, ReceiverInputDStream<Object>> receiverInputStreamMap() {
        return this.receiverInputStreamMap;
    }

    public ReceiverLauncher receiverExecutor() {
        return this.receiverExecutor;
    }

    public HashMap<Object, ReceiverInfo> receiverInfo() {
        return this.receiverInfo;
    }

    public HashMap<Object, SynchronizedQueue<ReceivedBlockInfo>> receivedBlockInfo() {
        return this.receivedBlockInfo;
    }

    public FiniteDuration timeout() {
        return this.timeout;
    }

    public StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    public ActorRef actor() {
        return this.actor;
    }

    public void actor_$eq(ActorRef x$1) {
        this.actor = x$1;
    }

    public Time currentTime() {
        return this.currentTime;
    }

    public void currentTime_$eq(Time x$1) {
        this.currentTime = x$1;
    }

    public synchronized void start() {
        if (this.actor() == null) {
            if (!Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).isEmpty()) {
                this.actor_$eq(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().actorSystem().actorOf(Props$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReceiverTracker $outer;

                    public final ReceiverTrackerActor apply() {
                        return this.$outer.new ReceiverTrackerActor();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(ReceiverTrackerActor.class)), "ReceiverTracker"));
                this.receiverExecutor().start();
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "ReceiverTracker started";
                    }
                });
            }
            return;
        }
        throw new SparkException("ReceiverTracker already started");
    }

    public synchronized void stop() {
        if (!Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).isEmpty() && this.actor() != null) {
            this.receiverExecutor().stop();
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().actorSystem().stop(this.actor());
            this.actor_$eq(null);
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "ReceiverTracker stopped";
                }
            });
        }
    }

    public ReceivedBlockInfo[] getReceivedBlockInfo(int streamId) {
        scala.collection.mutable.Seq receivedBlockInfo = this.getReceivedBlockInfoQueue(streamId).dequeueAll((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ReceivedBlockInfo x) {
                return true;
            }
        });
        this.logInfo((Function0<String>)new Serializable(this, streamId, receivedBlockInfo){
            public static final long serialVersionUID = 0L;
            private final int streamId$1;
            private final scala.collection.mutable.Seq receivedBlockInfo$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Stream ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId$1)).append((Object)" received ").append((Object)BoxesRunTime.boxToInteger((int)this.receivedBlockInfo$1.size())).append((Object)" blocks").toString();
            }
            {
                this.streamId$1 = streamId$1;
                this.receivedBlockInfo$1 = receivedBlockInfo$1;
            }
        });
        return (ReceivedBlockInfo[])receivedBlockInfo.toArray(ClassTag$.MODULE$.apply(ReceivedBlockInfo.class));
    }

    private SynchronizedQueue<ReceivedBlockInfo> getReceivedBlockInfoQueue(int streamId) {
        return (SynchronizedQueue)((SynchronizedMap)this.receivedBlockInfo()).getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)streamId), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SynchronizedQueue<ReceivedBlockInfo> apply() {
                return new SynchronizedQueue();
            }
        });
    }

    public void registerReceiver(int streamId, String typ, String host, ActorRef receiverActor, ActorRef sender) {
        if (this.receiverInputStreamMap().contains((Object)BoxesRunTime.boxToInteger((int)streamId))) {
            ((SynchronizedMap)this.receiverInfo()).update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)new ReceiverInfo(streamId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typ, BoxesRunTime.boxToInteger((int)streamId)})), receiverActor, true, host, ReceiverInfo$.MODULE$.apply$default$6(), ReceiverInfo$.MODULE$.apply$default$7()));
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().listenerBus().post(new StreamingListenerReceiverStarted((ReceiverInfo)((SynchronizedMap)this.receiverInfo()).apply((Object)BoxesRunTime.boxToInteger((int)streamId))));
            this.logInfo((Function0<String>)new Serializable(this, streamId, sender){
                public static final long serialVersionUID = 0L;
                private final int streamId$2;
                private final ActorRef sender$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Registered receiver for stream ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId$2)).append((Object)" from ").append((Object)this.sender$1.path().address()).toString();
                }
                {
                    this.streamId$2 = streamId$2;
                    this.sender$1 = sender$1;
                }
            });
            return;
        }
        throw new Exception(new StringBuilder().append((Object)"Register received for unexpected id ").append((Object)BoxesRunTime.boxToInteger((int)streamId)).toString());
    }

    public void deregisterReceiver(int streamId, String message, String error) {
        Option option;
        block4: {
            ReceiverInfo receiverInfo;
            block3: {
                block2: {
                    option = ((SynchronizedMap)this.receiverInfo()).get((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ReceiverInfo oldInfo = (ReceiverInfo)some.x();
                    Object x$8 = null;
                    boolean x$9 = false;
                    String x$10 = message;
                    String x$11 = error;
                    int x$12 = oldInfo.copy$default$1();
                    String x$13 = oldInfo.copy$default$2();
                    String x$14 = oldInfo.copy$default$5();
                    receiverInfo = oldInfo.copy(x$12, x$13, null, x$9, x$14, x$10, x$11);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No prior receiver info";
                    }
                });
                receiverInfo = new ReceiverInfo(streamId, "", null, false, "", message, error);
            }
            ReceiverInfo newReceiverInfo = receiverInfo;
            ((SynchronizedMap)this.receiverInfo()).update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverInfo);
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().listenerBus().post(new StreamingListenerReceiverStopped((ReceiverInfo)((SynchronizedMap)this.receiverInfo()).apply((Object)BoxesRunTime.boxToInteger((int)streamId))));
            String messageWithError = error == null || error.isEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, error}));
            this.logError((Function0<String>)new Serializable(this, streamId, messageWithError){
                public static final long serialVersionUID = 0L;
                private final int streamId$3;
                private final String messageWithError$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deregistered receiver for stream ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId$3), this.messageWithError$1}));
                }
                {
                    this.streamId$3 = streamId$3;
                    this.messageWithError$1 = messageWithError$1;
                }
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    public void addBlocks(ReceivedBlockInfo receivedBlockInfo) {
        this.getReceivedBlockInfoQueue(receivedBlockInfo.streamId()).$plus$eq((Object)receivedBlockInfo);
        this.logDebug((Function0<String>)new Serializable(this, receivedBlockInfo){
            public static final long serialVersionUID = 0L;
            private final ReceivedBlockInfo receivedBlockInfo$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Stream ").append((Object)BoxesRunTime.boxToInteger((int)this.receivedBlockInfo$2.streamId())).append((Object)" received new blocks: ").append((Object)this.receivedBlockInfo$2.blockId()).toString();
            }
            {
                this.receivedBlockInfo$2 = receivedBlockInfo$2;
            }
        });
    }

    public void reportError(int streamId, String message, String error) {
        Option option;
        block4: {
            ReceiverInfo receiverInfo;
            block3: {
                block2: {
                    option = ((SynchronizedMap)this.receiverInfo()).get((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ReceiverInfo oldInfo = (ReceiverInfo)some.x();
                    String x$15 = message;
                    String x$16 = error;
                    int x$17 = oldInfo.copy$default$1();
                    String x$18 = oldInfo.copy$default$2();
                    ActorRef x$19 = oldInfo.copy$default$3();
                    boolean x$20 = oldInfo.copy$default$4();
                    String x$21 = oldInfo.copy$default$5();
                    receiverInfo = oldInfo.copy(x$17, x$18, x$19, x$20, x$21, x$15, x$16);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No prior receiver info";
                    }
                });
                receiverInfo = new ReceiverInfo(streamId, "", null, false, "", message, error);
            }
            ReceiverInfo newReceiverInfo = receiverInfo;
            ((SynchronizedMap)this.receiverInfo()).update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverInfo);
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().listenerBus().post(new StreamingListenerReceiverError((ReceiverInfo)((SynchronizedMap)this.receiverInfo()).apply((Object)BoxesRunTime.boxToInteger((int)streamId))));
            String messageWithError = error == null || error.isEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, error}));
            this.logWarning((Function0<String>)new Serializable(this, streamId, messageWithError){
                public static final long serialVersionUID = 0L;
                private final int streamId$4;
                private final String messageWithError$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reported by receiver for stream ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId$4), this.messageWithError$2}));
                }
                {
                    this.streamId$4 = streamId$4;
                    this.messageWithError$2 = messageWithError$2;
                }
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    public boolean hasMoreReceivedBlockIds() {
        return !((SynchronizedMap)this.receivedBlockInfo()).values().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(SynchronizedQueue<ReceivedBlockInfo> x$1) {
                return x$1.isEmpty();
            }
        });
    }

    public ReceiverTracker(StreamingContext ssc) {
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc = ssc;
        Logging.class.$init$((Logging)this);
        this.receiverInputStreams = ssc.graph().getReceiverInputStreams();
        this.receiverInputStreamMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).map((Function1)new $anonfun$1(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))));
        this.receiverExecutor = new ReceiverLauncher();
        this.receiverInfo = new $anon$1(this);
        this.receivedBlockInfo = new $anon$2(this);
        this.timeout = AkkaUtils$.MODULE$.askTimeout(ssc.conf());
        this.listenerBus = ssc.scheduler().listenerBus();
        this.actor = null;
        this.currentTime = null;
    }

    public class ReceiverLauncher {
        private final transient SparkEnv env;
        private final transient Thread thread;

        public SparkEnv env() {
            return this.env;
        }

        public Thread thread() {
            return this.thread;
        }

        public void start() {
            this.thread().start();
        }

        public void stop() {
            this.stopReceivers();
            this.thread().join(10000L);
            if (((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().receiverInfo()).isEmpty()) {
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "All of the receivers have deregistered successfully";
                    }
                });
            } else {
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReceiverLauncher $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"All of the receivers have not deregistered, ").append(this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().receiverInfo()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }

        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$startReceivers() {
            RDD rDD;
            Receiver[] receivers = (Receiver[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().receiverInputStreams()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 */
                public final Receiver<?> apply(ReceiverInputDStream<?> nis) {
                    void var2_2;
                    Receiver<?> rcvr = nis.getReceiver();
                    rcvr.setReceiverId(nis.id());
                    return var2_2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Receiver.class)));
            boolean hasLocationPreferences = BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.booleanArrayOps((boolean[])Predef$.MODULE$.refArrayOps((Object[])receivers).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Receiver<?> x$2) {
                    return x$2.preferredLocation().isDefined();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()))).reduce((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(boolean x$3, boolean x$4) {
                    return x$3 && x$4;
                }
            }));
            if (hasLocationPreferences) {
                Tuple2[] receiversWithPreferences = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])receivers).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Receiver<Object>, Seq<String>> apply(Receiver<?> r) {
                        return new Tuple2(r, (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)r.preferredLocation().get()})));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Predef$.MODULE$.wrapRefArray((Object[])receiversWithPreferences), ClassTag$.MODULE$.apply(Receiver.class));
            } else {
                rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Predef$.MODULE$.wrapRefArray((Object[])receivers), Predef$.MODULE$.refArrayOps((Object[])receivers).size(), ClassTag$.MODULE$.apply(Receiver.class));
            }
            RDD tempRDD = rDD;
            Serializable startReceiver2 = new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterator<Receiver<?>> iterator) {
                    if (iterator.hasNext()) {
                        Receiver receiver = (Receiver)iterator.next();
                        ReceiverSupervisorImpl executor2 = new ReceiverSupervisorImpl(receiver, SparkEnv$.MODULE$.get());
                        executor2.start();
                        executor2.awaitTermination();
                        return;
                    }
                    throw new SparkException("Could not start receiver as object not found.");
                }
            };
            Object object = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().isLocal() ? BoxedUnit.UNIT : SparkContext$.MODULE$.rddToPairRDDFunctions(this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50), 50, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(int x) {
                    return new Tuple2.mcII.sp(x, 1);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$5, int x$6) {
                    return this.apply$mcIII$sp(x$5, x$6);
                }

                public int apply$mcIII$sp(int x$5, int x$6) {
                    return x$5 + x$6;
                }
            }, 20).collect();
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this, receivers){
                public static final long serialVersionUID = 0L;
                private final Receiver[] receivers$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Starting ").append((Object)BoxesRunTime.boxToInteger((int)this.receivers$1.length)).append((Object)" receivers").toString();
                }
                {
                    this.receivers$1 = receivers$1;
                }
            });
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().runJob(tempRDD, (Function1)startReceiver2, ClassTag$.MODULE$.Unit());
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "All of the receivers have been terminated";
                }
            });
        }

        private void stopReceivers() {
            ((IterableLike)((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().receiverInfo()).values().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<ActorRef> apply(ReceiverInfo info) {
                    return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)info.actor()));
                }
            }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ActorRef x$7) {
                    ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(x$7);
                    StopReceiver$ x$22 = StopReceiver$.MODULE$;
                    ActorRef x$23 = qual$1.$bang$default$2((Object)x$22);
                    qual$1.$bang((Object)x$22, x$23);
                }
            });
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverLauncher $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Sent stop signal to all ").append((Object)BoxesRunTime.boxToInteger((int)((SynchronizedMap)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().receiverInfo()).size())).append((Object)" receivers").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ ReceiverTracker org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer() {
            return ReceiverTracker.this;
        }

        public ReceiverLauncher() {
            if (ReceiverTracker.this == null) {
                throw new NullPointerException();
            }
            this.env = ReceiverTracker.this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env();
            this.thread = new ReceiverLauncher$$anon$3(this);
        }
    }

    public class ReceiverTrackerActor
    implements Actor {
        private final ActorContext context;
        private final ActorRef self;

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
            this.context = x$1;
        }

        public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
            this.self = x$1;
        }

        public final ActorRef sender() {
            return Actor.class.sender((Actor)this);
        }

        public SupervisorStrategy supervisorStrategy() {
            return Actor.class.supervisorStrategy((Actor)this);
        }

        public void preStart() throws Exception {
            Actor.class.preStart((Actor)this);
        }

        public void postStop() throws Exception {
            Actor.class.postStop((Actor)this);
        }

        public void preRestart(Throwable reason, Option<Object> message) throws Exception {
            Actor.class.preRestart((Actor)this, (Throwable)reason, message);
        }

        public void postRestart(Throwable reason) throws Exception {
            Actor.class.postRestart((Actor)this, (Throwable)reason);
        }

        public void unhandled(Object message) {
            Actor.class.unhandled((Actor)this, (Object)message);
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerActor $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof RegisterReceiver) {
                        RegisterReceiver registerReceiver2 = (RegisterReceiver)A1;
                        int streamId = registerReceiver2.streamId();
                        String typ = registerReceiver2.typ();
                        String host = registerReceiver2.host();
                        ActorRef receiverActor = registerReceiver2.receiverActor();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer().registerReceiver(streamId, typ, host, receiverActor, this.$outer.sender());
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)BoxesRunTime.boxToBoolean((boolean)true), this.$outer.self());
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof AddBlock) {
                        AddBlock addBlock = (AddBlock)A1;
                        ReceivedBlockInfo receivedBlockInfo = addBlock.receivedBlockInfo();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer().addBlocks(receivedBlockInfo);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ReportError) {
                        ReportError reportError2 = (ReportError)A1;
                        int streamId = reportError2.streamId();
                        String message = reportError2.message();
                        String error = reportError2.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer().reportError(streamId, message, error);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof DeregisterReceiver) {
                        DeregisterReceiver deregisterReceiver2 = (DeregisterReceiver)A1;
                        int streamId = deregisterReceiver2.streamId();
                        String message = deregisterReceiver2.msg();
                        String error = deregisterReceiver2.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer().deregisterReceiver(streamId, message, error);
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)BoxesRunTime.boxToBoolean((boolean)true), this.$outer.self());
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof RegisterReceiver ? true : (object instanceof AddBlock ? true : (object instanceof ReportError ? true : object instanceof DeregisterReceiver));
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
        }

        public /* synthetic */ ReceiverTracker org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer() {
            return ReceiverTracker.this;
        }

        public ReceiverTrackerActor() {
            if (ReceiverTracker.this == null) {
                throw new NullPointerException();
            }
            Actor.class.$init$((Actor)this);
        }
    }
}

