/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedValuesReader;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;

public class VectorizedPlainValuesReader
extends ValuesReader
implements VectorizedValuesReader {
    private ByteBufferInputStream in = null;
    private int bitOffset;
    private byte currentByte = 0;

    public void initFromPage(int valueCount, ByteBufferInputStream in) throws IOException {
        this.in = in;
    }

    public void skip() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void readBooleans(int total, WritableColumnVector c, int rowId) {
        for (int i = 0; i < total; ++i) {
            c.putBoolean(rowId + i, this.readBoolean());
        }
    }

    @Override
    public final void skipBooleans(int total) {
        for (int i = 0; i < total; ++i) {
            this.readBoolean();
        }
    }

    private ByteBuffer getBuffer(int length) {
        try {
            return this.in.slice(length).order(ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read " + length + " bytes", (Throwable)e);
        }
    }

    @Override
    public final void readIntegers(int total, WritableColumnVector c, int rowId) {
        int requiredBytes = total * 4;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            c.putIntsLittleEndian(rowId, total, buffer.array(), offset);
        } else {
            for (int i = 0; i < total; ++i) {
                c.putInt(rowId + i, buffer.getInt());
            }
        }
    }

    @Override
    public void skipIntegers(int total) {
        this.in.skip((long)total * 4L);
    }

    @Override
    public final void readUnsignedIntegers(int total, WritableColumnVector c, int rowId) {
        int requiredBytes = total * 4;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        for (int i = 0; i < total; ++i) {
            c.putLong(rowId + i, Integer.toUnsignedLong(buffer.getInt()));
        }
    }

    @Override
    public final void readIntegersWithRebase(int total, WritableColumnVector c, int rowId, boolean failIfRebase) {
        int i;
        int requiredBytes = total * 4;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        boolean rebase = false;
        for (i = 0; i < total; ++i) {
            rebase |= buffer.getInt(buffer.position() + i * 4) < RebaseDateTime.lastSwitchJulianDay();
        }
        if (rebase) {
            if (failIfRebase) {
                throw DataSourceUtils.newRebaseExceptionInRead("Parquet");
            }
            for (i = 0; i < total; ++i) {
                c.putInt(rowId + i, RebaseDateTime.rebaseJulianToGregorianDays((int)buffer.getInt()));
            }
        } else if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            c.putIntsLittleEndian(rowId, total, buffer.array(), offset);
        } else {
            for (i = 0; i < total; ++i) {
                c.putInt(rowId + i, buffer.getInt());
            }
        }
    }

    @Override
    public final void readLongs(int total, WritableColumnVector c, int rowId) {
        int requiredBytes = total * 8;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            c.putLongsLittleEndian(rowId, total, buffer.array(), offset);
        } else {
            for (int i = 0; i < total; ++i) {
                c.putLong(rowId + i, buffer.getLong());
            }
        }
    }

    @Override
    public void skipLongs(int total) {
        this.in.skip((long)total * 8L);
    }

    @Override
    public final void readUnsignedLongs(int total, WritableColumnVector c, int rowId) {
        int requiredBytes = total * 8;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        for (int i = 0; i < total; ++i) {
            c.putByteArray(rowId + i, new BigInteger(Long.toUnsignedString(buffer.getLong())).toByteArray());
        }
    }

    @Override
    public final void readLongsWithRebase(int total, WritableColumnVector c, int rowId, boolean failIfRebase) {
        int i;
        int requiredBytes = total * 8;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        boolean rebase = false;
        for (i = 0; i < total; ++i) {
            rebase |= buffer.getLong(buffer.position() + i * 8) < RebaseDateTime.lastSwitchJulianTs();
        }
        if (rebase) {
            if (failIfRebase) {
                throw DataSourceUtils.newRebaseExceptionInRead("Parquet");
            }
            for (i = 0; i < total; ++i) {
                c.putLong(rowId + i, RebaseDateTime.rebaseJulianToGregorianMicros((long)buffer.getLong()));
            }
        } else if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            c.putLongsLittleEndian(rowId, total, buffer.array(), offset);
        } else {
            for (i = 0; i < total; ++i) {
                c.putLong(rowId + i, buffer.getLong());
            }
        }
    }

    @Override
    public final void readFloats(int total, WritableColumnVector c, int rowId) {
        int requiredBytes = total * 4;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            c.putFloatsLittleEndian(rowId, total, buffer.array(), offset);
        } else {
            for (int i = 0; i < total; ++i) {
                c.putFloat(rowId + i, buffer.getFloat());
            }
        }
    }

    @Override
    public void skipFloats(int total) {
        this.in.skip((long)total * 4L);
    }

    @Override
    public final void readDoubles(int total, WritableColumnVector c, int rowId) {
        int requiredBytes = total * 8;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            c.putDoublesLittleEndian(rowId, total, buffer.array(), offset);
        } else {
            for (int i = 0; i < total; ++i) {
                c.putDouble(rowId + i, buffer.getDouble());
            }
        }
    }

    @Override
    public void skipDoubles(int total) {
        this.in.skip((long)total * 8L);
    }

    @Override
    public final void readBytes(int total, WritableColumnVector c, int rowId) {
        int requiredBytes = total * 4;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        for (int i = 0; i < total; ++i) {
            c.putByte(rowId + i, buffer.get());
            buffer.position(buffer.position() + 3);
        }
    }

    @Override
    public final void skipBytes(int total) {
        this.in.skip((long)total * 4L);
    }

    @Override
    public final void readShorts(int total, WritableColumnVector c, int rowId) {
        int requiredBytes = total * 4;
        ByteBuffer buffer = this.getBuffer(requiredBytes);
        for (int i = 0; i < total; ++i) {
            c.putShort(rowId + i, (short)buffer.getInt());
        }
    }

    @Override
    public void skipShorts(int total) {
        this.in.skip((long)total * 4L);
    }

    @Override
    public final boolean readBoolean() {
        if (this.bitOffset == 0) {
            try {
                this.currentByte = (byte)this.in.read();
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Failed to read a byte", (Throwable)e);
            }
        }
        boolean v = (this.currentByte & 1 << this.bitOffset) != 0;
        ++this.bitOffset;
        if (this.bitOffset == 8) {
            this.bitOffset = 0;
        }
        return v;
    }

    @Override
    public final int readInteger() {
        return this.getBuffer(4).getInt();
    }

    @Override
    public final long readLong() {
        return this.getBuffer(8).getLong();
    }

    @Override
    public final byte readByte() {
        return (byte)this.readInteger();
    }

    @Override
    public short readShort() {
        return (short)this.readInteger();
    }

    @Override
    public final float readFloat() {
        return this.getBuffer(4).getFloat();
    }

    @Override
    public final double readDouble() {
        return this.getBuffer(8).getDouble();
    }

    @Override
    public final void readBinary(int total, WritableColumnVector v, int rowId) {
        for (int i = 0; i < total; ++i) {
            int len = this.readInteger();
            ByteBuffer buffer = this.getBuffer(len);
            if (buffer.hasArray()) {
                v.putByteArray(rowId + i, buffer.array(), buffer.arrayOffset() + buffer.position(), len);
                continue;
            }
            byte[] bytes = new byte[len];
            buffer.get(bytes);
            v.putByteArray(rowId + i, bytes);
        }
    }

    @Override
    public void skipBinary(int total) {
        for (int i = 0; i < total; ++i) {
            int len = this.readInteger();
            this.in.skip((long)len);
        }
    }

    @Override
    public final Binary readBinary(int len) {
        ByteBuffer buffer = this.getBuffer(len);
        if (buffer.hasArray()) {
            return Binary.fromConstantByteArray((byte[])buffer.array(), (int)(buffer.arrayOffset() + buffer.position()), (int)len);
        }
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return Binary.fromConstantByteArray((byte[])bytes);
    }

    @Override
    public void skipFixedLenByteArray(int total, int len) {
        this.in.skip((long)total * (long)len);
    }
}

