/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.ShuffledRDD;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Row;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.trees.UnaryNode;
import org.apache.spark.sql.execution.Limit$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkSqlSerializer;
import org.apache.spark.sql.execution.UnaryNode;
import org.apache.spark.sql.execution.UnaryNode$class;
import org.apache.spark.util.MutablePair;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001B\u0001\u0003\u00016\u0011Q\u0001T5nSRT!a\u0001\u0003\u0002\u0013\u0015DXmY;uS>t'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011#\u0002\u0001\u000f%UY\u0002CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005%\u0019\u0006/\u0019:l!2\fg\u000e\u0005\u0002\u0010'%\u0011AC\u0001\u0002\n+:\f'/\u001f(pI\u0016\u0004\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u00179%\u0011Qd\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t?\u0001\u0011)\u001a!C\u0001A\u0005)A.[7jiV\t\u0011\u0005\u0005\u0002\u0017E%\u00111e\u0006\u0002\u0004\u0013:$\b\u0002C\u0013\u0001\u0005#\u0005\u000b\u0011B\u0011\u0002\r1LW.\u001b;!\u0011!9\u0003A!f\u0001\n\u0003A\u0013!B2iS2$W#\u0001\b\t\u0011)\u0002!\u0011#Q\u0001\n9\taa\u00195jY\u0012\u0004\u0003\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\bF\u0002/_A\u0002\"a\u0004\u0001\t\u000b}Y\u0003\u0019A\u0011\t\u000b\u001dZ\u0003\u0019\u0001\b\t\u000bI\u0002A\u0011I\u001a\u0002\r=,H\u000f];u+\u0005!\u0004cA\u001b>\u0001:\u0011ag\u000f\b\u0003oij\u0011\u0001\u000f\u0006\u0003s1\ta\u0001\u0010:p_Rt\u0014\"\u0001\r\n\u0005q:\u0012a\u00029bG.\fw-Z\u0005\u0003}}\u00121aU3r\u0015\tat\u0003\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)E!\u0001\u0005dCR\fG._:u\u0013\t9%IA\u0005BiR\u0014\u0018NY;uK\")\u0011\n\u0001C!\u0015\u0006qQ\r_3dkR,7i\u001c7mK\u000e$H#A&\u0011\u0007Yae*\u0003\u0002N/\t)\u0011I\u001d:bsB\u0011\u0011iT\u0005\u0003!\n\u00131AU8x\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0003\u001d)\u00070Z2vi\u0016$\u0012\u0001\u0016\t\u0004+bsU\"\u0001,\u000b\u0005]3\u0011a\u0001:eI&\u0011\u0011L\u0016\u0002\u0004%\u0012#\u0005bB.\u0001\u0003\u0003%\t\u0001X\u0001\u0005G>\u0004\u0018\u0010F\u0002/;zCqa\b.\u0011\u0002\u0003\u0007\u0011\u0005C\u0004(5B\u0005\t\u0019\u0001\b\t\u000f\u0001\u0004\u0011\u0013!C\u0001C\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00012+\u0005\u0005\u001a7&\u00013\u0011\u0005\u0015TW\"\u00014\u000b\u0005\u001dD\u0017!C;oG\",7m[3e\u0015\tIw#\u0001\u0006b]:|G/\u0019;j_:L!a\u001b4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004n\u0001E\u0005I\u0011\u00018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\tqN\u000b\u0002\u000fG\"9\u0011\u000fAA\u0001\n\u0003\u0012\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001t!\t!\u00180D\u0001v\u0015\t1x/\u0001\u0003mC:<'\"\u0001=\u0002\t)\fg/Y\u0005\u0003uV\u0014aa\u0015;sS:<\u0007b\u0002?\u0001\u0003\u0003%\t\u0001I\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\b}\u0002\t\t\u0011\"\u0001\u0000\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0001\u0002\bA\u0019a#a\u0001\n\u0007\u0005\u0015qCA\u0002B]fD\u0001\"!\u0003~\u0003\u0003\u0005\r!I\u0001\u0004q\u0012\n\u0004\"CA\u0007\u0001\u0005\u0005I\u0011IA\b\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\t!\u0019\t\u0019\"!\u0007\u0002\u00025\u0011\u0011Q\u0003\u0006\u0004\u0003/9\u0012AC2pY2,7\r^5p]&!\u00111DA\u000b\u0005!IE/\u001a:bi>\u0014\b\"CA\u0010\u0001\u0005\u0005I\u0011AA\u0011\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0012\u0003S\u00012AFA\u0013\u0013\r\t9c\u0006\u0002\b\u0005>|G.Z1o\u0011)\tI!!\b\u0002\u0002\u0003\u0007\u0011\u0011\u0001\u0005\n\u0003[\u0001\u0011\u0011!C!\u0003_\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002C!I\u00111\u0007\u0001\u0002\u0002\u0013\u0005\u0013QG\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\u0012q\u0007\u0005\u000b\u0003\u0013\t\t$!AA\u0002\u0005\u0005\u0001f\u0001\u0001\u0002<A!\u0011QHA!\u001b\t\tyD\u0003\u0002j\r%!\u00111IA \u00051!UM^3m_B,'/\u00119j\u000f%\t9EAA\u0001\u0012\u0003\tI%A\u0003MS6LG\u000fE\u0002\u0010\u0003\u00172\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QJ\n\u0006\u0003\u0017\nye\u0007\t\b\u0003#\n9&\t\b/\u001b\t\t\u0019FC\u0002\u0002V]\tqA];oi&lW-\u0003\u0003\u0002Z\u0005M#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9A&a\u0013\u0005\u0002\u0005uCCAA%\u0011)\t\t'a\u0013\u0002\u0002\u0013\u0015\u00131M\u0001\ti>\u001cFO]5oOR\t1\u000f\u0003\u0006\u0002h\u0005-\u0013\u0011!CA\u0003S\nQ!\u00199qYf$RALA6\u0003[BaaHA3\u0001\u0004\t\u0003BB\u0014\u0002f\u0001\u0007a\u0002\u0003\u0006\u0002r\u0005-\u0013\u0011!CA\u0003g\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002v\u0005\u0005\u0005#\u0002\f\u0002x\u0005m\u0014bAA=/\t1q\n\u001d;j_:\u0004RAFA?C9I1!a \u0018\u0005\u0019!V\u000f\u001d7fe!I\u00111QA8\u0003\u0003\u0005\rAL\u0001\u0004q\u0012\u0002\u0004BCAD\u0003\u0017\n\t\u0011\"\u0003\u0002\n\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\tE\u0002u\u0003\u001bK1!a$v\u0005\u0019y%M[3di\u0002")
public class Limit
extends SparkPlan
implements UnaryNode,
Product {
    private final int limit;
    private final SparkPlan child;

    public static Function1<Tuple2<Object, SparkPlan>, Limit> tupled() {
        return Limit$.MODULE$.tupled();
    }

    public static Function1<Object, Function1<SparkPlan, Limit>> curried() {
        return Limit$.MODULE$.curried();
    }

    @Override
    public Partitioning outputPartitioning() {
        return UnaryNode$class.outputPartitioning(this);
    }

    public List<SparkPlan> children() {
        return UnaryNode.class.children((org.apache.spark.sql.catalyst.trees.UnaryNode)this);
    }

    public int limit() {
        return this.limit;
    }

    public SparkPlan child() {
        return this.child;
    }

    public Seq<Attribute> output() {
        return this.child().output();
    }

    @Override
    public Row[] executeCollect() {
        int numPartsToTry;
        if (this.limit() == 0) {
            return new Row[0];
        }
        RDD childRDD = this.child().execute().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Row x$3) {
                return x$3.copy();
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        ArrayBuffer buf = new ArrayBuffer();
        int totalParts = childRDD.partitions().length;
        for (int partsScanned = 0; buf.size() < this.limit() && partsScanned < totalParts; partsScanned += numPartsToTry) {
            numPartsToTry = 1;
            if (partsScanned > 0) {
                numPartsToTry = buf.size() == 0 ? totalParts - 1 : (int)(1.5 * (double)this.limit() * (double)partsScanned / (double)buf.size());
            }
            numPartsToTry = package$.MODULE$.max(0, numPartsToTry);
            int left = this.limit() - buf.size();
            Range p = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(partsScanned), package$.MODULE$.min(partsScanned + numPartsToTry, totalParts));
            SparkContext sc = this.sqlContext().sparkContext();
            Row[][] res = (Row[][])sc.runJob(childRDD, (Function1)new Serializable(this, left){
                public static final long serialVersionUID = 0L;
                private final int left$1;

                public final Row[] apply(Iterator<Row> it) {
                    return (Row[])it.take(this.left$1).toArray(ClassTag$.MODULE$.apply(Row.class));
                }
                {
                    this.left$1 = left$1;
                }
            }, (Seq)p, false, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Row.class)));
            Predef$.MODULE$.refArrayOps((Object[])res).foreach((Function1)new Serializable(this, buf){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Limit $outer;
                private final ArrayBuffer buf$1;

                public final ArrayBuffer<Row> apply(Row[] x$4) {
                    return this.buf$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])x$4).take(this.$outer.limit() - this.buf$1.size())));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.buf$1 = buf$1;
                }
            });
        }
        return (Row[])buf.toArray(ClassTag$.MODULE$.apply(Row.class));
    }

    @Override
    public RDD<Row> execute() {
        RDD<Row> qual$3 = this.child().execute();
        Serializable x$22 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Limit $outer;

            public final Iterator<MutablePair<Object, Row>> apply(Iterator<Row> iter) {
                MutablePair mutablePair = new MutablePair();
                return iter.take(this.$outer.limit()).map((Function1)new Serializable(this, mutablePair){
                    public static final long serialVersionUID = 0L;
                    private final MutablePair mutablePair$1;

                    public final MutablePair<Object, Row> apply(Row row) {
                        return this.mutablePair$1.update((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)row);
                    }
                    {
                        this.mutablePair$1 = mutablePair$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        boolean x$23 = qual$3.mapPartitions$default$2();
        RDD rdd = qual$3.mapPartitions((Function1)x$22, x$23, ClassTag$.MODULE$.apply(MutablePair.class));
        HashPartitioner part = new HashPartitioner(1);
        ShuffledRDD shuffled = new ShuffledRDD(rdd, (Partitioner)part);
        shuffled.setSerializer((Serializer)new SparkSqlSerializer(new SparkConf(false)));
        return shuffled.mapPartitions((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Limit $outer;

            public final Iterator<Row> apply(Iterator<Tuple2<Object, Row>> x$5) {
                return x$5.take(this.$outer.limit()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Row apply(Tuple2<Object, Row> x$6) {
                        return (Row)x$6._2();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, shuffled.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
    }

    public Limit copy(int limit, SparkPlan child) {
        return new Limit(limit, child);
    }

    public int copy$default$1() {
        return this.limit();
    }

    public SparkPlan copy$default$2() {
        return this.child();
    }

    public String productPrefix() {
        return "Limit";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.child();
                break;
            }
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.limit());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Limit;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.limit());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)((Object)this.child())));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Limit)) return false;
        boolean bl = true;
        if (!bl) return false;
        Limit limit = (Limit)x$1;
        if (this.limit() != limit.limit()) return false;
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = limit.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!((Object)((Object)sparkPlan)).equals((Object)sparkPlan2)) return false;
        if (!limit.canEqual(this)) return false;
        return true;
    }

    public Limit(int limit, SparkPlan child) {
        this.limit = limit;
        this.child = child;
        UnaryNode.class.$init$((org.apache.spark.sql.catalyst.trees.UnaryNode)this);
        UnaryNode$class.$init$(this);
        Product.class.$init$((Product)this);
    }
}

