/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar;

import java.sql.Timestamp;
import org.apache.spark.sql.catalyst.expressions.Row;
import org.apache.spark.sql.catalyst.types.TimestampType$;
import org.apache.spark.sql.columnar.BasicColumnStats;
import org.apache.spark.sql.columnar.TIMESTAMP$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001m3Q!\u0001\u0002\u0001\t1\u0011A\u0003V5nKN$\u0018-\u001c9D_2,XN\\*uCR\u001c(BA\u0002\u0005\u0003!\u0019w\u000e\\;n]\u0006\u0014(BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0004\u001d=\tR\"\u0001\u0002\n\u0005A\u0011!\u0001\u0005\"bg&\u001c7i\u001c7v[:\u001cF/\u0019;t\u001d\t\u0011r#D\u0001\u0014\u0015\t!R#A\u0003usB,7O\u0003\u0002\u0017\t\u0005A1-\u0019;bYf\u001cH/\u0003\u0002\u0019'\u0005iA+[7fgR\fW\u000e\u001d+za\u0016DQA\u0007\u0001\u0005\u0002q\ta\u0001P5oSRt4\u0001\u0001\u000b\u0002;A\u0011a\u0002\u0001\u0005\u0006?\u0001!\t\u0005I\u0001\u000eS:LG/[1m\u0005>,h\u000eZ:\u0016\u0003\u0005\u0002BAI\u0013(O5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004UkBdWM\r\t\u0003E!J!!K\u0012\u0003\t9+H\u000e\u001c\u0005\u0006W\u0001!\t\u0005L\u0001\fO\u0006$\b.\u001a:Ti\u0006$8\u000fF\u0002.a\u0011\u0003\"A\t\u0018\n\u0005=\u001a#\u0001B+oSRDQ!\r\u0016A\u0002I\n1A]8x!\t\u0019\u0014I\u0004\u00025\u007f9\u0011QG\u0010\b\u0003mur!a\u000e\u001f\u000f\u0005aZT\"A\u001d\u000b\u0005iZ\u0012A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0001\u0012\tq\u0001]1dW\u0006<W-\u0003\u0002C\u0007\n\u0019!k\\<\u000b\u0005\u0001#\u0001\"B#+\u0001\u00041\u0015aB8sI&t\u0017\r\u001c\t\u0003E\u001dK!\u0001S\u0012\u0003\u0007%sG\u000fC\u0003K\u0001\u0011\u00053*\u0001\u0005d_:$\u0018-\u001b8t)\rau\n\u0015\t\u0003E5K!AT\u0012\u0003\u000f\t{w\u000e\\3b]\")\u0011'\u0013a\u0001e!)Q)\u0013a\u0001\r\")!\u000b\u0001C!'\u00069\u0011n]!c_Z,Gc\u0001'U+\")\u0011'\u0015a\u0001e!)Q)\u0015a\u0001\r\")q\u000b\u0001C!1\u00069\u0011n\u001d\"fY><Hc\u0001'Z5\")\u0011G\u0016a\u0001e!)QI\u0016a\u0001\r\u0002")
public class TimestampColumnStats
extends BasicColumnStats<TimestampType$> {
    @Override
    public Tuple2<Null$, Null$> initialBounds() {
        return new Tuple2(null, null);
    }

    @Override
    public void gatherStats(Row row, int ordinal) {
        Timestamp field = (Timestamp)this.columnType().getField(row, ordinal);
        if (this.upperBound() == null || field.compareTo((Timestamp)this.upperBound()) > 0) {
            this._upper_$eq(field);
        }
        if (this.lowerBound() == null || field.compareTo((Timestamp)this.lowerBound()) < 0) {
            this._lower_$eq(field);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(Row row, int ordinal) {
        if (this.upperBound() == null) return false;
        Timestamp field = (Timestamp)this.columnType().getField(row, ordinal);
        if (((Timestamp)this.lowerBound()).compareTo(field) > 0) return false;
        if (field.compareTo((Timestamp)this.upperBound()) > 0) return false;
        return true;
    }

    @Override
    public boolean isAbove(Row row, int ordinal) {
        Timestamp field;
        return this.lowerBound() != null && (field = (Timestamp)this.columnType().getField(row, ordinal)).compareTo((Timestamp)this.upperBound()) < 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isBelow(Row row, int ordinal) {
        if (this.lowerBound() == null) return false;
        Timestamp field = (Timestamp)this.columnType().getField(row, ordinal);
        if (((Timestamp)this.lowerBound()).compareTo(field) >= 0) return false;
        return true;
    }

    public TimestampColumnStats() {
        super(TIMESTAMP$.MODULE$);
    }
}

