/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.GeneralizedLinearRegression;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$FamilyAndLink$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionBase;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionSummary;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r5b\u0001\u0002\u001f>\u0001!C\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0005\u001a\u0005\tw\u0002\u0011\t\u0011)A\u0005K\"AQ\u0010\u0001BC\u0002\u0013\u0005a\u0010C\u0005\u0002\u0002\u0001\u0011\t\u0011)A\u0005\u001b\"Q\u0011Q\u0001\u0001\u0003\u0006\u0004%\t!a\u0002\t\u0015\u0005M\u0001A!A!\u0002\u0013\tI\u0001\u0003\u0005\u0002\u0018\u0001!\taPA\r\u0011\u001d\t9\u0003\u0001C\u0001\u0003SA!\"a\r\u0001\u0011\u000b\u0007I\u0011BA\u001b\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!!\u0012\u0001\t\u0013\ti\u0005C\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`!9\u0011q\u0015\u0001\u0005R\u0005%\u0006bBA\\\u0001\u0011\u0005\u0013\u0011\u0018\u0005\b\u0003{\u0003A\u0011AA`\u0011\u001d\t)\u000e\u0001C!\u0003/Dq!a;\u0001\t\u0003\ni\u000fC\u0005\u0002x\u0002\u0011\r\u0011\"\u0011\u0002z\"A!\u0011\u0001\u0001!\u0002\u0013\tY\u0010C\u0004\u0003\u0004\u0001!\tE!\u0002\b\u000f\t=Q\b#\u0001\u0003\u0012\u00191A(\u0010E\u0001\u0005'Aq!a\u0006\u0018\t\u0003\u00119\u0003C\u0004\u0003*]!\tEa\u000b\t\u000f\tUr\u0003\"\u0011\u00038\u00199!qH\f\u0001/\t\u0005\u0003\"\u0003B(7\t\u0005\t\u0015!\u0003T\u0011\u001d\t9b\u0007C\u0001\u0005#2aA!\u0017\u001c\t\nm\u0003BCA\u0003=\tU\r\u0011\"\u0001\u0002\b!Q\u00111\u0003\u0010\u0003\u0012\u0003\u0006I!!\u0003\t\u0011ut\"Q3A\u0005\u0002yD\u0011\"!\u0001\u001f\u0005#\u0005\u000b\u0011B'\t\u000f\u0005]a\u0004\"\u0001\u0003d!I\u0011Q\u001b\u0010\u0002\u0002\u0013\u0005!Q\u000e\u0005\n\u0005gr\u0012\u0013!C\u0001\u0005kB\u0011B!#\u001f#\u0003%\tAa#\t\u0013\t=e$!A\u0005B\tE\u0005\"\u0003BQ=\u0005\u0005I\u0011AA}\u0011%\u0011\u0019KHA\u0001\n\u0003\u0011)\u000bC\u0005\u0003,z\t\t\u0011\"\u0011\u0003.\"I!1\u0018\u0010\u0002\u0002\u0013\u0005!Q\u0018\u0005\n\u0005\u000ft\u0012\u0011!C!\u0005\u0013D\u0011Ba\u0001\u001f\u0003\u0003%\tEa3\t\u0013\t5g$!A\u0005B\t=w!\u0003Bj7\u0005\u0005\t\u0012\u0002Bk\r%\u0011IfGA\u0001\u0012\u0013\u00119\u000eC\u0004\u0002\u0018A\"\tA!:\t\u0013\t\r\u0001'!A\u0005F\t-\u0007\"\u0003Bta\u0005\u0005I\u0011\u0011Bu\u0011%\u0011y\u000fMA\u0001\n\u0003\u0013\t\u0010C\u0004\u0004\u0004m!\tf!\u0002\u0007\r\r=q\u0003BB\t\u0011\u001d\t9B\u000eC\u0001\u0007'A\u0011ba\u00067\u0005\u0004%IA!%\t\u0011\rea\u0007)A\u0005\u0005'CqA!\u000e7\t\u0003\u001aY\u0002C\u0005\u0004 ]\t\t\u0011\"\u0003\u0004\"\t\u0001s)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:lu\u000eZ3m\u0015\tqt(\u0001\u0006sK\u001e\u0014Xm]:j_:T!\u0001Q!\u0002\u00055d'B\u0001\"D\u0003\u0015\u0019\b/\u0019:l\u0015\t!U)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\r\u0006\u0019qN]4\u0004\u0001M)\u0001!\u0013+X;B!!jS'T\u001b\u0005i\u0014B\u0001'>\u0005=\u0011Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001(R\u001b\u0005y%B\u0001)@\u0003\u0019a\u0017N\\1mO&\u0011!k\u0014\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005)\u0003\u0001C\u0001&V\u0013\t1VHA\u0010HK:,'/\u00197ju\u0016$G*\u001b8fCJ\u0014Vm\u001a:fgNLwN\u001c\"bg\u0016\u0004\"\u0001W.\u000e\u0003eS!AW \u0002\tU$\u0018\u000e\\\u0005\u00039f\u0013!\"\u0014'Xe&$\u0018M\u00197f!\rAf\fY\u0005\u0003?f\u0013!\u0003S1t)J\f\u0017N\\5oON+X.\\1ssB\u0011!*Y\u0005\u0003Ev\u0012!fR3oKJ\fG.\u001b>fI2Kg.Z1s%\u0016<'/Z:tS>tGK]1j]&twmU;n[\u0006\u0014\u00180A\u0002vS\u0012,\u0012!\u001a\t\u0003M>t!aZ7\u0011\u0005!\\W\"A5\u000b\u0005)<\u0015A\u0002\u001fs_>$hHC\u0001m\u0003\u0015\u00198-\u00197b\u0013\tq7.\u0001\u0004Qe\u0016$WMZ\u0005\u0003aF\u0014aa\u0015;sS:<'B\u00018lQ\r\t1/\u001f\t\u0003i^l\u0011!\u001e\u0006\u0003m\u0006\u000b!\"\u00198o_R\fG/[8o\u0013\tAXOA\u0003TS:\u001cW-I\u0001{\u0003\u0015\u0011d\u0006\r\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\t\u0019\u00180\u0001\u0007d_\u00164g-[2jK:$8/F\u0001NQ\r\u00191/_\u0001\u000eG>,gMZ5dS\u0016tGo\u001d\u0011)\u0007\u0011\u0019\u00180A\u0005j]R,'oY3qiV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\ti!D\u0001l\u0013\r\tya\u001b\u0002\u0007\t>,(\r\\3)\u0007\u0015\u0019\u00180\u0001\u0006j]R,'oY3qi\u0002B3AB:z\u0003\u0019a\u0014N\\5u}Q91+a\u0007\u0002 \u0005\r\u0002\"B2\b\u0001\u0004)\u0007\u0006BA\u000egfDQ!`\u0004A\u00025CC!a\bts\"9\u0011QA\u0004A\u0002\u0005%\u0001\u0006BA\u0012gf\fAc]3u\u0019&t7\u000e\u0015:fI&\u001cG/[8o\u0007>dG\u0003BA\u0016\u0003[i\u0011\u0001\u0001\u0005\u0007\u0003_A\u0001\u0019A3\u0002\u000bY\fG.^3)\u0007!\u0019\u00180A\u0007gC6LG._!oI2Kgn[\u000b\u0003\u0003o\u0001B!!\u000f\u0002@9\u0019!*a\u000f\n\u0007\u0005uR(A\u000eHK:,'/\u00197ju\u0016$G*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\\u0005\u0005\u0003\u0003\n\u0019EA\u0007GC6LG._!oI2Kgn\u001b\u0006\u0004\u0003{i\u0014a\u00029sK\u0012L7\r\u001e\u000b\u0005\u0003\u0013\tI\u0005\u0003\u0004\u0002L)\u0001\r!T\u0001\tM\u0016\fG/\u001e:fgR1\u0011\u0011BA(\u0003#Ba!a\u0013\f\u0001\u0004i\u0005bBA*\u0017\u0001\u0007\u0011\u0011B\u0001\u0007_\u001a47/\u001a;\u0002\u0017A\u0014X\rZ5di2Kgn\u001b\u000b\u0007\u0003\u0013\tI&a\u0017\t\r\u0005-C\u00021\u0001N\u0011\u001d\t\u0019\u0006\u0004a\u0001\u0003\u0013\t\u0011\u0002\u001e:b]N4wN]7\u0015\t\u0005\u0005\u00141\u0011\t\u0005\u0003G\niH\u0004\u0003\u0002f\u0005]d\u0002BA4\u0003grA!!\u001b\u0002r9!\u00111NA8\u001d\rA\u0017QN\u0005\u0002\r&\u0011A)R\u0005\u0003\u0005\u000eK1!!\u001eB\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003s\nY(A\u0004qC\u000e\\\u0017mZ3\u000b\u0007\u0005U\u0014)\u0003\u0003\u0002\u0000\u0005\u0005%!\u0003#bi\u00064%/Y7f\u0015\u0011\tI(a\u001f\t\u000f\u0005\u0015U\u00021\u0001\u0002\b\u00069A-\u0019;bg\u0016$\b\u0007BAE\u0003+\u0003b!a#\u0002\u000e\u0006EUBAA>\u0013\u0011\ty)a\u001f\u0003\u000f\u0011\u000bG/Y:fiB!\u00111SAK\u0019\u0001!A\"a&\u0002\u0004\u0006\u0005\t\u0011!B\u0001\u00033\u00131a\u0018\u00133#\u0011\tY*!)\u0011\t\u0005-\u0011QT\u0005\u0004\u0003?['a\u0002(pi\"Lgn\u001a\t\u0005\u0003\u0017\t\u0019+C\u0002\u0002&.\u00141!\u00118z\u00035!(/\u00198tM>\u0014X.S7qYR!\u0011\u0011MAV\u0011\u001d\t)I\u0004a\u0001\u0003[\u0003D!a,\u00024B1\u00111RAG\u0003c\u0003B!a%\u00024\u0012a\u0011QWAV\u0003\u0003\u0005\tQ!\u0001\u0002\u001a\n\u0019q\fJ\u001a\u0002\u000fM,X.\\1ssV\t\u0001\rK\u0002\u0010gf\f\u0001\"\u001a<bYV\fG/\u001a\u000b\u0005\u0003\u0003\f9\rE\u0002K\u0003\u0007L1!!2>\u0005\t:UM\\3sC2L'0\u001a3MS:,\u0017M\u001d*fOJ,7o]5p]N+X.\\1ss\"9\u0011Q\u0011\tA\u0002\u0005%\u0007\u0007BAf\u0003\u001f\u0004b!a#\u0002\u000e\u00065\u0007\u0003BAJ\u0003\u001f$A\"!5\u0002H\u0006\u0005\t\u0011!B\u0001\u00033\u00131a\u0018\u00135Q\r\u00012/_\u0001\u0005G>\u0004\u0018\u0010F\u0002T\u00033Dq!a7\u0012\u0001\u0004\ti.A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002`\u0006\u0015XBAAq\u0015\r\t\u0019oP\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003O\f\tO\u0001\u0005QCJ\fW.T1qQ\r\t2/_\u0001\u0006oJLG/Z\u000b\u0003\u0003_\u00042\u0001WAy\u0013\r\t\u00190\u0017\u0002\t\u001b2;&/\u001b;fe\"\u001a!c]=\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0003\u0003w\u0004B!a\u0003\u0002~&\u0019\u0011q`6\u0003\u0007%sG/\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b%\u0001\u0005u_N#(/\u001b8h)\u0005)\u0007\u0006B\u000bt\u0005\u0013\t#Aa\u0003\u0002\u000bMr\u0003G\f\u0019)\u0007\u0001\u0019\u00180\u0001\u0011HK:,'/\u00197ju\u0016$G*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001&\u0018'\u001d9\"Q\u0003B\u000e\u0005C\u0001B!a\u0003\u0003\u0018%\u0019!\u0011D6\u0003\r\u0005s\u0017PU3g!\u0011A&QD*\n\u0007\t}\u0011L\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u0004B!a\u0003\u0003$%\u0019!QE6\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\tE\u0011\u0001\u0002:fC\u0012,\"A!\f\u0011\ta\u0013ycU\u0005\u0004\u0005cI&\u0001C'M%\u0016\fG-\u001a:)\u0007e\u0019\u00180\u0001\u0003m_\u0006$GcA*\u0003:!1!1\b\u000eA\u0002\u0015\fA\u0001]1uQ\"\u001a!d]=\u0003M\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'OU3he\u0016\u001c8/[8o\u001b>$W\r\\,sSR,'oE\u0003\u001c\u0003_\u0014\u0019\u0005\u0005\u0003\u0003F\t-SB\u0001B$\u0015\r\u0011I%Q\u0001\tS:$XM\u001d8bY&!!Q\nB$\u0005\u001daunZ4j]\u001e\f\u0001\"\u001b8ti\u0006t7-\u001a\u000b\u0005\u0005'\u00129\u0006E\u0002\u0003Vmi\u0011a\u0006\u0005\u0007\u0005\u001fj\u0002\u0019A*\u0003\t\u0011\u000bG/Y\n\b=\tU!Q\fB\u0011!\u0011\tYAa\u0018\n\u0007\t\u00054NA\u0004Qe>$Wo\u0019;\u0015\r\t\u0015$\u0011\u000eB6!\r\u00119GH\u0007\u00027!9\u0011QA\u0012A\u0002\u0005%\u0001\"B?$\u0001\u0004iEC\u0002B3\u0005_\u0012\t\bC\u0005\u0002\u0006\u0011\u0002\n\u00111\u0001\u0002\n!9Q\u0010\nI\u0001\u0002\u0004i\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005oRC!!\u0003\u0003z-\u0012!1\u0010\t\u0005\u0005{\u0012))\u0004\u0002\u0003\u0000)!!\u0011\u0011BB\u0003%)hn\u00195fG.,GM\u0003\u0002wW&!!q\u0011B@\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iIK\u0002N\u0005s\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001BJ!\u0011\u0011)Ja(\u000e\u0005\t]%\u0002\u0002BM\u00057\u000bA\u0001\\1oO*\u0011!QT\u0001\u0005U\u00064\u0018-C\u0002q\u0005/\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\"\n\u001d\u0006\"\u0003BUS\u0005\u0005\t\u0019AA~\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0016\t\u0007\u0005c\u00139,!)\u000e\u0005\tM&b\u0001B[W\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\te&1\u0017\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003@\n\u0015\u0007\u0003BA\u0006\u0005\u0003L1Aa1l\u0005\u001d\u0011un\u001c7fC:D\u0011B!+,\u0003\u0003\u0005\r!!)\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a?\u0015\u0005\tM\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0003@\nE\u0007\"\u0003BU]\u0005\u0005\t\u0019AAQ\u0003\u0011!\u0015\r^1\u0011\u0007\t\u001d\u0004gE\u00031\u00053\u0014\t\u0003E\u0005\u0003\\\n\u0005\u0018\u0011B'\u0003f5\u0011!Q\u001c\u0006\u0004\u0005?\\\u0017a\u0002:v]RLW.Z\u0005\u0005\u0005G\u0014iNA\tBEN$(/Y2u\rVt7\r^5p]J\"\"A!6\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\t\u0015$1\u001eBw\u0011\u001d\t)a\ra\u0001\u0003\u0013AQ!`\u001aA\u00025\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003t\n}\bCBA\u0006\u0005k\u0014I0C\u0002\u0003x.\u0014aa\u00149uS>t\u0007cBA\u0006\u0005w\fI!T\u0005\u0004\u0005{\\'A\u0002+va2,'\u0007C\u0005\u0004\u0002Q\n\t\u00111\u0001\u0003f\u0005\u0019\u0001\u0010\n\u0019\u0002\u0011M\fg/Z%na2$Baa\u0002\u0004\u000eA!\u00111BB\u0005\u0013\r\u0019Ya\u001b\u0002\u0005+:LG\u000f\u0003\u0004\u0003<U\u0002\r!\u001a\u0002'\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8N_\u0012,GNU3bI\u0016\u00148c\u0001\u001c\u0003.Q\u00111Q\u0003\t\u0004\u0005+2\u0014!C2mCN\u001ch*Y7f\u0003)\u0019G.Y:t\u001d\u0006lW\r\t\u000b\u0004'\u000eu\u0001B\u0002B\u001eu\u0001\u0007Q-A\u0006sK\u0006$'+Z:pYZ,GCAB\u0012!\u0011\u0011)j!\n\n\t\r\u001d\"q\u0013\u0002\u0007\u001f\nTWm\u0019;)\u0007]\u0019\u0018\u0010K\u0002\u0017gf\u0004")
public class GeneralizedLinearRegressionModel
extends RegressionModel<Vector, GeneralizedLinearRegressionModel>
implements GeneralizedLinearRegressionBase,
MLWritable,
HasTrainingSummary<GeneralizedLinearRegressionTrainingSummary> {
    private GeneralizedLinearRegression.FamilyAndLink familyAndLink;
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final int numFeatures;
    private Option<GeneralizedLinearRegressionTrainingSummary> trainingSummary;
    private final Param<String> family;
    private final DoubleParam variancePower;
    private final Param<String> link;
    private final DoubleParam linkPower;
    private final Param<String> linkPredictionCol;
    private final Param<String> offsetCol;
    private final Param<String> solver;
    private final IntParam aggregationDepth;
    private final Param<String> weightCol;
    private final DoubleParam regParam;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final BooleanParam fitIntercept;
    private volatile boolean bitmap$0;

    public static GeneralizedLinearRegressionModel load(String string) {
        return GeneralizedLinearRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<GeneralizedLinearRegressionModel> read() {
        return GeneralizedLinearRegressionModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<GeneralizedLinearRegressionTrainingSummary> setSummary(Option<GeneralizedLinearRegressionTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return GeneralizedLinearRegressionBase.getFamily$(this);
    }

    @Override
    public double getVariancePower() {
        return GeneralizedLinearRegressionBase.getVariancePower$(this);
    }

    @Override
    public String getLink() {
        return GeneralizedLinearRegressionBase.getLink$(this);
    }

    @Override
    public double getLinkPower() {
        return GeneralizedLinearRegressionBase.getLinkPower$(this);
    }

    @Override
    public String getLinkPredictionCol() {
        return GeneralizedLinearRegressionBase.getLinkPredictionCol$(this);
    }

    @Override
    public String getOffsetCol() {
        return GeneralizedLinearRegressionBase.getOffsetCol$(this);
    }

    @Override
    public boolean hasWeightCol() {
        return GeneralizedLinearRegressionBase.hasWeightCol$(this);
    }

    @Override
    public boolean hasOffsetCol() {
        return GeneralizedLinearRegressionBase.hasOffsetCol$(this);
    }

    @Override
    public boolean hasLinkPredictionCol() {
        return GeneralizedLinearRegressionBase.hasLinkPredictionCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return GeneralizedLinearRegressionBase.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final Option<GeneralizedLinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<GeneralizedLinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public final DoubleParam variancePower() {
        return this.variancePower;
    }

    @Override
    public final Param<String> link() {
        return this.link;
    }

    @Override
    public final DoubleParam linkPower() {
        return this.linkPower;
    }

    @Override
    public final Param<String> linkPredictionCol() {
        return this.linkPredictionCol;
    }

    @Override
    public final Param<String> offsetCol() {
        return this.offsetCol;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$variancePower_$eq(DoubleParam x$1) {
        this.variancePower = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$link_$eq(Param<String> x$1) {
        this.link = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPower_$eq(DoubleParam x$1) {
        this.linkPower = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPredictionCol_$eq(Param<String> x$1) {
        this.linkPredictionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$offsetCol_$eq(Param<String> x$1) {
        this.offsetCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public GeneralizedLinearRegressionModel setLinkPredictionCol(String value) {
        return (GeneralizedLinearRegressionModel)this.set(this.linkPredictionCol(), value);
    }

    private GeneralizedLinearRegression.FamilyAndLink familyAndLink$lzycompute() {
        GeneralizedLinearRegressionModel generalizedLinearRegressionModel = this;
        synchronized (generalizedLinearRegressionModel) {
            if (!this.bitmap$0) {
                this.familyAndLink = GeneralizedLinearRegression$FamilyAndLink$.MODULE$.apply(this);
                this.bitmap$0 = true;
            }
        }
        return this.familyAndLink;
    }

    private GeneralizedLinearRegression.FamilyAndLink familyAndLink() {
        return !this.bitmap$0 ? this.familyAndLink$lzycompute() : this.familyAndLink;
    }

    @Override
    public double predict(Vector features) {
        return this.predict(features, 0.0);
    }

    private double predict(Vector features, double offset) {
        double eta = this.predictLink(features, offset);
        return this.familyAndLink().fitted(eta);
    }

    private double predictLink(Vector features, double offset) {
        return BLAS$.MODULE$.dot(features, this.coefficients()) + this.intercept() + offset;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema());
        return this.transformImpl(dataset);
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        Dataset outputData;
        block4: {
            StructType outputSchema = this.transformSchema(dataset.schema(), true);
            Column offset2 = !this.hasOffsetCol() ? functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0)) : functions$.MODULE$.col(this.$(this.offsetCol())).cast((DataType)DoubleType$.MODULE$);
            outputData = dataset;
            int numColsOutput = 0;
            if (this.hasLinkPredictionCol()) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModel.class.getClassLoader());
                public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1(GeneralizedLinearRegressionModel $outer) {
                    }
                }
                UserDefinedFunction predLinkUDF = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(features, offset) -> BoxesRunTime.boxToDouble((double)this.predictLink(features, BoxesRunTime.unboxToDouble((Object)offset))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
                outputData = outputData.withColumn(this.$(this.linkPredictionCol()), predLinkUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol())), offset2})), outputSchema.apply(this.$(this.linkPredictionCol())).metadata());
                ++numColsOutput;
            }
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
                if (this.hasLinkPredictionCol()) {
                    UserDefinedFunction predUDF = functions$.MODULE$.udf((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)eta -> this.familyAndLink().fitted(eta), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
                    outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.linkPredictionCol()))})), outputSchema.apply(this.$(this.predictionCol())).metadata());
                } else {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1(GeneralizedLinearRegressionModel $outer) {
                        }
                    }
                    UserDefinedFunction predUDF = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(features, offset) -> BoxesRunTime.boxToDouble((double)this.predict(features, BoxesRunTime.unboxToDouble((Object)offset))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
                    outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol())), offset2})), outputSchema.apply(this.$(this.predictionCol())).metadata());
                }
                ++numColsOutput;
            }
            if (numColsOutput != false) break block4;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(95).append(this.uid()).append(": GeneralizedLinearRegressionModel.transform() does nothing").append(" because no output columns were set.").toString());
        }
        return outputData.toDF();
    }

    @Override
    public GeneralizedLinearRegressionTrainingSummary summary() {
        return (GeneralizedLinearRegressionTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public GeneralizedLinearRegressionSummary evaluate(Dataset<?> dataset) {
        return new GeneralizedLinearRegressionSummary(dataset, this);
    }

    @Override
    public GeneralizedLinearRegressionModel copy(ParamMap extra) {
        GeneralizedLinearRegressionModel copied = this.copyValues(new GeneralizedLinearRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        return (GeneralizedLinearRegressionModel)((Model)((Object)copied.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new GeneralizedLinearRegressionModelWriter(this);
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public String toString() {
        return new StringBuilder(68).append("GeneralizedLinearRegressionModel: uid=").append(this.uid()).append(", family=").append((Object)this.$(this.family())).append(", link=").append((Object)this.$(this.link())).append(", ").append("numFeatures=").append(this.numFeatures()).toString();
    }

    public GeneralizedLinearRegressionModel(String uid, Vector coefficients, double intercept) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        HasFitIntercept.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasRegParam.$init$(this);
        HasWeightCol.$init$(this);
        HasSolver.$init$(this);
        HasAggregationDepth.$init$(this);
        GeneralizedLinearRegressionBase.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        this.numFeatures = coefficients.size();
    }

    private static class GeneralizedLinearRegressionModelReader
    extends MLReader<GeneralizedLinearRegressionModel> {
        private final String className = GeneralizedLinearRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public GeneralizedLinearRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row data = (Row)this.sparkSession().read().parquet(dataPath).select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).head();
            double intercept = data.getDouble(0);
            Vector coefficients = (Vector)data.getAs(1);
            GeneralizedLinearRegressionModel model = new GeneralizedLinearRegressionModel(metadata.uid(), coefficients, intercept);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GeneralizedLinearRegressionModelWriter
    extends MLWriter {
        private volatile GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ Data$module;
        private final GeneralizedLinearRegressionModel instance;

        private GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.intercept(), this.instance.coefficients());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.GeneralizedLinearRegressionModel.GeneralizedLinearRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.GeneralizedLinearRegressionModel.GeneralizedLinearRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator1$2(GeneralizedLinearRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)new .colon.colon((Object)data, (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator1$2(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            GeneralizedLinearRegressionModelWriter generalizedLinearRegressionModelWriter = this;
            synchronized (generalizedLinearRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$(this);
                }
            }
        }

        public GeneralizedLinearRegressionModelWriter(GeneralizedLinearRegressionModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        scala.Serializable {
            private final double intercept;
            private final Vector coefficients;
            public final /* synthetic */ GeneralizedLinearRegressionModelWriter $outer;

            public double intercept() {
                return this.intercept;
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public Data copy(double intercept, Vector coefficients) {
                return new Data(this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer(), intercept, coefficients);
            }

            public double copy$default$1() {
                return this.intercept();
            }

            public Vector copy$default$2() {
                return this.coefficients();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 1: {
                        object = this.coefficients();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(Integer.toString(x$1));
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.intercept() != data.intercept()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ GeneralizedLinearRegressionModelWriter org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(GeneralizedLinearRegressionModelWriter $outer, double intercept, Vector coefficients) {
                this.intercept = intercept;
                this.coefficients = coefficients;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

