/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.LeastSquaresGradient;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionWithSGD$;
import org.apache.spark.rdd.RDD;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u00015\u0011aCU5eO\u0016\u0014Vm\u001a:fgNLwN\\,ji\"\u001cv\t\u0012\u0006\u0003\u0007\u0011\t!B]3he\u0016\u001c8/[8o\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0016!\ry\u0001CE\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u001b\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014\u0018\t\\4pe&$\b.\u001c\t\u0003\u001fMI!\u0001\u0006\u0002\u0003)IKGmZ3SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!a\u0002A!a\u0001\n\u0013i\u0012\u0001C:uKB\u001c\u0016N_3\u0016\u0003y\u0001\"AF\u0010\n\u0005\u0001:\"A\u0002#pk\ndW\r\u0003\u0005#\u0001\t\u0005\r\u0011\"\u0003$\u00031\u0019H/\u001a9TSj,w\fJ3r)\t!s\u0005\u0005\u0002\u0017K%\u0011ae\u0006\u0002\u0005+:LG\u000fC\u0004)C\u0005\u0005\t\u0019\u0001\u0010\u0002\u0007a$\u0013\u0007\u0003\u0005+\u0001\t\u0005\t\u0015)\u0003\u001f\u0003%\u0019H/\u001a9TSj,\u0007\u0005\u0003\u0005-\u0001\t\u0005\r\u0011\"\u0003.\u00035qW/\\%uKJ\fG/[8ogV\ta\u0006\u0005\u0002\u0017_%\u0011\u0001g\u0006\u0002\u0004\u0013:$\b\u0002\u0003\u001a\u0001\u0005\u0003\u0007I\u0011B\u001a\u0002#9,X.\u0013;fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002%i!9\u0001&MA\u0001\u0002\u0004q\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0018\u0002\u001d9,X.\u0013;fe\u0006$\u0018n\u001c8tA!A\u0001\b\u0001BA\u0002\u0013%Q$\u0001\u0005sK\u001e\u0004\u0016M]1n\u0011!Q\u0004A!a\u0001\n\u0013Y\u0014\u0001\u0004:fOB\u000b'/Y7`I\u0015\fHC\u0001\u0013=\u0011\u001dA\u0013(!AA\u0002yA\u0001B\u0010\u0001\u0003\u0002\u0003\u0006KAH\u0001\ne\u0016<\u0007+\u0019:b[\u0002B\u0001\u0002\u0011\u0001\u0003\u0002\u0004%I!H\u0001\u0012[&t\u0017NQ1uG\"4%/Y2uS>t\u0007\u0002\u0003\"\u0001\u0005\u0003\u0007I\u0011B\"\u0002+5Lg.\u001b\"bi\u000eDgI]1di&|gn\u0018\u0013fcR\u0011A\u0005\u0012\u0005\bQ\u0005\u000b\t\u00111\u0001\u001f\u0011!1\u0005A!A!B\u0013q\u0012AE7j]&\u0014\u0015\r^2i\rJ\f7\r^5p]\u0002BQ\u0001\u0013\u0001\u0005\n%\u000ba\u0001P5oSRtD#\u0002&L\u00196s\u0005CA\b\u0001\u0011\u0015ar\t1\u0001\u001f\u0011\u0015as\t1\u0001/\u0011\u0015At\t1\u0001\u001f\u0011\u0015\u0001u\t1\u0001\u001f\u0011\u001d\u0001\u0006A1A\u0005\nE\u000b\u0001b\u001a:bI&,g\u000e^\u000b\u0002%B\u00111KV\u0007\u0002)*\u0011Q\u000bB\u0001\r_B$\u0018.\\5{CRLwN\\\u0005\u0003/R\u0013A\u0003T3bgR\u001c\u0016/^1sKN<%/\u00193jK:$\bBB-\u0001A\u0003%!+A\u0005he\u0006$\u0017.\u001a8uA!91\f\u0001b\u0001\n\u0013a\u0016aB;qI\u0006$XM]\u000b\u0002;B\u00111KX\u0005\u0003?R\u0013\u0001cU9vCJ,G\r\u0014\u001aVa\u0012\fG/\u001a:\t\r\u0005\u0004\u0001\u0015!\u0003^\u0003!)\b\u000fZ1uKJ\u0004\u0003bB2\u0001\u0005\u0004%\t\u0005Z\u0001\n_B$\u0018.\\5{KJ,\u0012!\u001a\t\u0003'\u001aL!a\u001a+\u0003\u001f\u001d\u0013\u0018\rZ5f]R$Um]2f]RDa!\u001b\u0001!\u0002\u0013)\u0017AC8qi&l\u0017N_3sA!)\u0001\n\u0001C\u0001WR\t!\nC\u0003n\u0001\u0011Ec.A\u0006de\u0016\fG/Z'pI\u0016dGc\u0001\npo\")\u0001\u000f\u001ca\u0001c\u00069q/Z5hQR\u001c\bC\u0001:v\u001b\u0005\u0019(B\u0001;\u0005\u0003\u0019a\u0017N\\1mO&\u0011ao\u001d\u0002\u0007-\u0016\u001cGo\u001c:\t\u000bad\u0007\u0019\u0001\u0010\u0002\u0013%tG/\u001a:dKB$x!\u0002>\u0003\u0011\u0003Y\u0018A\u0006*jI\u001e,'+Z4sKN\u001c\u0018n\u001c8XSRD7k\u0012#\u0011\u0005=ah!B\u0001\u0003\u0011\u0003i8c\u0001?\u007f+A\u0011ac`\u0005\u0004\u0003\u00039\"AB!osJ+g\r\u0003\u0004Iy\u0012\u0005\u0011Q\u0001\u000b\u0002w\"9\u0011\u0011\u0002?\u0005\u0002\u0005-\u0011!\u0002;sC&tG#\u0004\n\u0002\u000e\u0005\r\u0012QEA\u0014\u0003S\tY\u0003\u0003\u0005\u0002\u0010\u0005\u001d\u0001\u0019AA\t\u0003\u0015Ig\u000e];u!\u0019\t\u0019\"!\u0007\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0004\u0003/1\u0011a\u0001:eI&!\u00111DA\u000b\u0005\r\u0011F\t\u0012\t\u0004\u001f\u0005}\u0011bAA\u0011\u0005\taA*\u00192fY\u0016$\u0007k\\5oi\"1A&a\u0002A\u00029Ba\u0001HA\u0004\u0001\u0004q\u0002B\u0002\u001d\u0002\b\u0001\u0007a\u0004\u0003\u0004A\u0003\u000f\u0001\rA\b\u0005\b\u0003[\t9\u00011\u0001r\u00039Ig.\u001b;jC2<V-[4iiNDq!!\u0003}\t\u0003\t\t\u0004F\u0006\u0013\u0003g\t)$a\u000e\u0002:\u0005m\u0002\u0002CA\b\u0003_\u0001\r!!\u0005\t\r1\ny\u00031\u0001/\u0011\u0019a\u0012q\u0006a\u0001=!1\u0001(a\fA\u0002yAa\u0001QA\u0018\u0001\u0004q\u0002bBA\u0005y\u0012\u0005\u0011q\b\u000b\n%\u0005\u0005\u00131IA#\u0003\u000fB\u0001\"a\u0004\u0002>\u0001\u0007\u0011\u0011\u0003\u0005\u0007Y\u0005u\u0002\u0019\u0001\u0018\t\rq\ti\u00041\u0001\u001f\u0011\u0019A\u0014Q\ba\u0001=!9\u0011\u0011\u0002?\u0005\u0002\u0005-C#\u0002\n\u0002N\u0005=\u0003\u0002CA\b\u0003\u0013\u0002\r!!\u0005\t\r1\nI\u00051\u0001/\u0011%\t\u0019\u0006`A\u0001\n\u0013\t)&A\u0006sK\u0006$'+Z:pYZ,GCAA,!\u0011\tI&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\nA\u0001\\1oO*\u0011\u0011\u0011M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002f\u0005m#AB(cU\u0016\u001cG\u000f")
public class RidgeRegressionWithSGD
extends GeneralizedLinearAlgorithm<RidgeRegressionModel>
implements Serializable {
    private double stepSize;
    private int numIterations;
    private double regParam;
    private double miniBatchFraction;
    private final LeastSquaresGradient gradient;
    private final SquaredL2Updater updater;
    private final GradientDescent optimizer;

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, d3);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3, Vector vector) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, d3, vector);
    }

    private double stepSize() {
        return this.stepSize;
    }

    private void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private double regParam() {
        return this.regParam;
    }

    private void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private LeastSquaresGradient gradient() {
        return this.gradient;
    }

    private SquaredL2Updater updater() {
        return this.updater;
    }

    @Override
    public GradientDescent optimizer() {
        return this.optimizer;
    }

    @Override
    public RidgeRegressionModel createModel(Vector weights, double intercept) {
        return new RidgeRegressionModel(weights, intercept);
    }

    public RidgeRegressionWithSGD(double stepSize, int numIterations, double regParam, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.regParam = regParam;
        this.miniBatchFraction = miniBatchFraction;
        this.gradient = new LeastSquaresGradient();
        this.updater = new SquaredL2Updater();
        this.optimizer = new GradientDescent(this.gradient(), this.updater()).setStepSize(this.stepSize()).setNumIterations(this.numIterations()).setRegParam(this.regParam()).setMiniBatchFraction(this.miniBatchFraction());
    }

    public RidgeRegressionWithSGD() {
        this(1.0, 100, 1.0, 1.0);
    }
}

