/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.L1Updater;
import org.apache.spark.mllib.optimization.LeastSquaresGradient;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LassoModel;
import org.apache.spark.mllib.regression.LassoWithSGD$;
import org.apache.spark.rdd.RDD;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u00015\u0011A\u0002T1tg><\u0016\u000e\u001e5T\u000f\u0012S!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qQ\u0003E\u0002\u0010!Ii\u0011AA\u0005\u0003#\t\u0011!dR3oKJ\fG.\u001b>fI2Kg.Z1s\u00032<wN]5uQ6\u0004\"aD\n\n\u0005Q\u0011!A\u0003'bgN|Wj\u001c3fYB\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\ta1+\u001a:jC2L'0\u00192mK\"AA\u0004\u0001BA\u0002\u0013%Q$\u0001\u0005ti\u0016\u00048+\u001b>f+\u0005q\u0002C\u0001\f \u0013\t\u0001sC\u0001\u0004E_V\u0014G.\u001a\u0005\tE\u0001\u0011\t\u0019!C\u0005G\u0005a1\u000f^3q'&TXm\u0018\u0013fcR\u0011Ae\n\t\u0003-\u0015J!AJ\f\u0003\tUs\u0017\u000e\u001e\u0005\bQ\u0005\n\t\u00111\u0001\u001f\u0003\rAH%\r\u0005\tU\u0001\u0011\t\u0011)Q\u0005=\u0005I1\u000f^3q'&TX\r\t\u0005\tY\u0001\u0011\t\u0019!C\u0005[\u0005ia.^7Ji\u0016\u0014\u0018\r^5p]N,\u0012A\f\t\u0003-=J!\u0001M\f\u0003\u0007%sG\u000f\u0003\u00053\u0001\t\u0005\r\u0011\"\u00034\u0003EqW/\\%uKJ\fG/[8og~#S-\u001d\u000b\u0003IQBq\u0001K\u0019\u0002\u0002\u0003\u0007a\u0006\u0003\u00057\u0001\t\u0005\t\u0015)\u0003/\u00039qW/\\%uKJ\fG/[8og\u0002B\u0001\u0002\u000f\u0001\u0003\u0002\u0004%I!H\u0001\te\u0016<\u0007+\u0019:b[\"A!\b\u0001BA\u0002\u0013%1(\u0001\u0007sK\u001e\u0004\u0016M]1n?\u0012*\u0017\u000f\u0006\u0002%y!9\u0001&OA\u0001\u0002\u0004q\u0002\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0010\u0002\u0013I,w\rU1sC6\u0004\u0003\u0002\u0003!\u0001\u0005\u0003\u0007I\u0011B\u000f\u0002#5Lg.\u001b\"bi\u000eDgI]1di&|g\u000e\u0003\u0005C\u0001\t\u0005\r\u0011\"\u0003D\u0003Ui\u0017N\\5CCR\u001c\u0007N\u0012:bGRLwN\\0%KF$\"\u0001\n#\t\u000f!\n\u0015\u0011!a\u0001=!Aa\t\u0001B\u0001B\u0003&a$\u0001\nnS:L')\u0019;dQ\u001a\u0013\u0018m\u0019;j_:\u0004\u0003\"\u0002%\u0001\t\u0013I\u0015A\u0002\u001fj]&$h\bF\u0003K\u00172ke\n\u0005\u0002\u0010\u0001!)Ad\u0012a\u0001=!)Af\u0012a\u0001]!)\u0001h\u0012a\u0001=!)\u0001i\u0012a\u0001=!9\u0001\u000b\u0001b\u0001\n\u0013\t\u0016\u0001C4sC\u0012LWM\u001c;\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS!!\u0016\u0003\u0002\u0019=\u0004H/[7ju\u0006$\u0018n\u001c8\n\u0005]#&\u0001\u0006'fCN$8+];be\u0016\u001cxI]1eS\u0016tG\u000f\u0003\u0004Z\u0001\u0001\u0006IAU\u0001\nOJ\fG-[3oi\u0002Bqa\u0017\u0001C\u0002\u0013%A,A\u0004va\u0012\fG/\u001a:\u0016\u0003u\u0003\"a\u00150\n\u0005}#&!\u0003'2+B$\u0017\r^3s\u0011\u0019\t\u0007\u0001)A\u0005;\u0006AQ\u000f\u001d3bi\u0016\u0014\b\u0005C\u0004d\u0001\t\u0007I\u0011\t3\u0002\u0013=\u0004H/[7ju\u0016\u0014X#A3\u0011\u0005M3\u0017BA4U\u0005=9%/\u00193jK:$H)Z:dK:$\bBB5\u0001A\u0003%Q-\u0001\u0006paRLW.\u001b>fe\u0002BQ\u0001\u0013\u0001\u0005\u0002-$\u0012A\u0013\u0005\u0006[\u0002!\tF\\\u0001\fGJ,\u0017\r^3N_\u0012,G\u000eF\u0002\u0013_^DQ\u0001\u001d7A\u0002E\fqa^3jO\"$8\u000f\u0005\u0002sk6\t1O\u0003\u0002u\t\u00051A.\u001b8bY\u001eL!A^:\u0003\rY+7\r^8s\u0011\u0015AH\u000e1\u0001\u001f\u0003%Ig\u000e^3sG\u0016\u0004HoB\u0003{\u0005!\u000510\u0001\u0007MCN\u001cxnV5uQN;E\t\u0005\u0002\u0010y\u001a)\u0011A\u0001E\u0001{N\u0019AP`\u000b\u0011\u0005Yy\u0018bAA\u0001/\t1\u0011I\\=SK\u001aDa\u0001\u0013?\u0005\u0002\u0005\u0015A#A>\t\u000f\u0005%A\u0010\"\u0001\u0002\f\u0005)AO]1j]Ri!#!\u0004\u0002$\u0005\u0015\u0012qEA\u0015\u0003WA\u0001\"a\u0004\u0002\b\u0001\u0007\u0011\u0011C\u0001\u0006S:\u0004X\u000f\u001e\t\u0007\u0003'\tI\"!\b\u000e\u0005\u0005U!bAA\f\r\u0005\u0019!\u000f\u001a3\n\t\u0005m\u0011Q\u0003\u0002\u0004%\u0012#\u0005cA\b\u0002 %\u0019\u0011\u0011\u0005\u0002\u0003\u00191\u000b'-\u001a7fIB{\u0017N\u001c;\t\r1\n9\u00011\u0001/\u0011\u0019a\u0012q\u0001a\u0001=!1\u0001(a\u0002A\u0002yAa\u0001QA\u0004\u0001\u0004q\u0002bBA\u0017\u0003\u000f\u0001\r!]\u0001\u000fS:LG/[1m/\u0016Lw\r\u001b;t\u0011\u001d\tI\u0001 C\u0001\u0003c!2BEA\u001a\u0003k\t9$!\u000f\u0002<!A\u0011qBA\u0018\u0001\u0004\t\t\u0002\u0003\u0004-\u0003_\u0001\rA\f\u0005\u00079\u0005=\u0002\u0019\u0001\u0010\t\ra\ny\u00031\u0001\u001f\u0011\u0019\u0001\u0015q\u0006a\u0001=!9\u0011\u0011\u0002?\u0005\u0002\u0005}B#\u0003\n\u0002B\u0005\r\u0013QIA$\u0011!\ty!!\u0010A\u0002\u0005E\u0001B\u0002\u0017\u0002>\u0001\u0007a\u0006\u0003\u0004\u001d\u0003{\u0001\rA\b\u0005\u0007q\u0005u\u0002\u0019\u0001\u0010\t\u000f\u0005%A\u0010\"\u0001\u0002LQ)!#!\u0014\u0002P!A\u0011qBA%\u0001\u0004\t\t\u0002\u0003\u0004-\u0003\u0013\u0002\rA\f\u0005\n\u0003'b\u0018\u0011!C\u0005\u0003+\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u000b\t\u0005\u00033\n\u0019'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0014\u0001\u00026bm\u0006LA!!\u001a\u0002\\\t1qJ\u00196fGR\u0004")
public class LassoWithSGD
extends GeneralizedLinearAlgorithm<LassoModel>
implements Serializable {
    private double stepSize;
    private int numIterations;
    private double regParam;
    private double miniBatchFraction;
    private final LeastSquaresGradient gradient;
    private final L1Updater updater;
    private final GradientDescent optimizer;

    public static LassoModel train(RDD<LabeledPoint> rDD, int n) {
        return LassoWithSGD$.MODULE$.train(rDD, n);
    }

    public static LassoModel train(RDD<LabeledPoint> rDD, int n, double d, double d2) {
        return LassoWithSGD$.MODULE$.train(rDD, n, d, d2);
    }

    public static LassoModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3) {
        return LassoWithSGD$.MODULE$.train(rDD, n, d, d2, d3);
    }

    public static LassoModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3, Vector vector) {
        return LassoWithSGD$.MODULE$.train(rDD, n, d, d2, d3, vector);
    }

    private double stepSize() {
        return this.stepSize;
    }

    private void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private double regParam() {
        return this.regParam;
    }

    private void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private LeastSquaresGradient gradient() {
        return this.gradient;
    }

    private L1Updater updater() {
        return this.updater;
    }

    @Override
    public GradientDescent optimizer() {
        return this.optimizer;
    }

    @Override
    public LassoModel createModel(Vector weights, double intercept) {
        return new LassoModel(weights, intercept);
    }

    public LassoWithSGD(double stepSize, int numIterations, double regParam, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.regParam = regParam;
        this.miniBatchFraction = miniBatchFraction;
        this.gradient = new LeastSquaresGradient();
        this.updater = new L1Updater();
        this.optimizer = new GradientDescent(this.gradient(), this.updater()).setStepSize(this.stepSize()).setNumIterations(this.numIterations()).setRegParam(this.regParam()).setMiniBatchFraction(this.miniBatchFraction());
    }

    public LassoWithSGD() {
        this(1.0, 100, 1.0, 1.0);
    }
}

