/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.feature.StandardScaler;
import org.apache.spark.mllib.feature.StandardScalerModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Optimizer;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c!B\u0001\u0003\u0003\u0003i!AG$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3be\u0006cwm\u001c:ji\"l'BA\u0002\u0005\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001+\tq1e\u0005\u0003\u0001\u001fUI\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0017/5\ta!\u0003\u0002\u0019\r\t9Aj\\4hS:<\u0007C\u0001\t\u001b\u0013\tY\u0012C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0019\u0001\u0005A\u0011\u000e\u0003\t\u0001\"AI\u0012\r\u0001\u0011)A\u0005\u0001b\u0001K\t\tQ*\u0005\u0002'SA\u0011\u0001cJ\u0005\u0003QE\u0011qAT8uQ&tw\r\u0005\u0002!U%\u00111F\u0001\u0002\u0017\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014Xj\u001c3fY\"9Q\u0006\u0001b\u0001\n#q\u0013A\u0003<bY&$\u0017\r^8sgV\tq\u0006E\u00021qmr!!\r\u001c\u000f\u0005I*T\"A\u001a\u000b\u0005Qb\u0011A\u0002\u001fs_>$h(C\u0001\u0013\u0013\t9\u0014#A\u0004qC\u000e\\\u0017mZ3\n\u0005eR$aA*fc*\u0011q'\u0005\t\u0005!qrt)\u0003\u0002>#\tIa)\u001e8di&|g.\r\t\u0004\u007f\t#U\"\u0001!\u000b\u0005\u00053\u0011a\u0001:eI&\u00111\t\u0011\u0002\u0004%\u0012#\u0005C\u0001\u0011F\u0013\t1%A\u0001\u0007MC\n,G.\u001a3Q_&tG\u000f\u0005\u0002\u0011\u0011&\u0011\u0011*\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019Y\u0005\u0001)A\u0005_\u0005Ya/\u00197jI\u0006$xN]:!\u0011\u0015i\u0005A\"\u0001O\u0003%y\u0007\u000f^5nSj,'/F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011F!\u0001\u0007paRLW.\u001b>bi&|g.\u0003\u0002U#\nIq\n\u001d;j[&TXM\u001d\u0005\b-\u0002\u0001\r\u0011\"\u0005X\u00031\tG\rZ%oi\u0016\u00148-\u001a9u+\u00059\u0005bB-\u0001\u0001\u0004%\tBW\u0001\u0011C\u0012$\u0017J\u001c;fe\u000e,\u0007\u000f^0%KF$\"a\u00170\u0011\u0005Aa\u0016BA/\u0012\u0005\u0011)f.\u001b;\t\u000f}C\u0016\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010J\u0019\t\r\u0005\u0004\u0001\u0015)\u0003H\u00035\tG\rZ%oi\u0016\u00148-\u001a9uA!91\r\u0001a\u0001\n#9\u0016\u0001\u0004<bY&$\u0017\r^3ECR\f\u0007bB3\u0001\u0001\u0004%\tBZ\u0001\u0011m\u0006d\u0017\u000eZ1uK\u0012\u000bG/Y0%KF$\"aW4\t\u000f}#\u0017\u0011!a\u0001\u000f\"1\u0011\u000e\u0001Q!\n\u001d\u000bQB^1mS\u0012\fG/\u001a#bi\u0006\u0004\u0003bB6\u0001\u0001\u0004%IaV\u0001\u0012kN,g)Z1ukJ,7kY1mS:<\u0007bB7\u0001\u0001\u0004%IA\\\u0001\u0016kN,g)Z1ukJ,7kY1mS:<w\fJ3r)\tYv\u000eC\u0004`Y\u0006\u0005\t\u0019A$\t\rE\u0004\u0001\u0015)\u0003H\u0003I)8/\u001a$fCR,(/Z*dC2Lgn\u001a\u0011\t\rM\u0004A\u0011\u0001\u0003u\u0003E\u0019X\r\u001e$fCR,(/Z*dC2Lgn\u001a\u000b\u0003kZl\u0011\u0001\u0001\u0005\u0006WJ\u0004\ra\u0012\u0005\u0006q\u00021\t\"_\u0001\fGJ,\u0017\r^3N_\u0012,G\u000e\u0006\u0003\"u\u0006\u0015\u0001\"B>x\u0001\u0004a\u0018aB<fS\u001eDGo\u001d\t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}$\u0011A\u00027j]\u0006dw-C\u0002\u0002\u0004y\u0014aAV3di>\u0014\bbBA\u0004o\u0002\u0007\u0011\u0011B\u0001\nS:$XM]2faR\u00042\u0001EA\u0006\u0013\r\ti!\u0005\u0002\u0007\t>,(\r\\3\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014\u0005a1/\u001a;J]R,'oY3qiR\u0019Q/!\u0006\t\rY\u000by\u00011\u0001H\u0011\u001d\tI\u0002\u0001C\u0001\u00037\tqb]3u-\u0006d\u0017\u000eZ1uK\u0012\u000bG/\u0019\u000b\u0004k\u0006u\u0001BB2\u0002\u0018\u0001\u0007q\tC\u0004\u0002\"\u0001!\t!a\t\u0002\u0007I,h\u000eF\u0002\"\u0003KAq!a\n\u0002 \u0001\u0007a(A\u0003j]B,H\u000fC\u0004\u0002\"\u0001!\t!a\u000b\u0015\u000b\u0005\ni#a\f\t\u000f\u0005\u001d\u0012\u0011\u0006a\u0001}!9\u0011\u0011GA\u0015\u0001\u0004a\u0018AD5oSRL\u0017\r\\,fS\u001eDGo\u001d\u0015\u0004\u0001\u0005U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005mb!\u0001\u0006b]:|G/\u0019;j_:LA!a\u0010\u0002:\taA)\u001a<fY>\u0004XM]!qS\u0002")
public abstract class GeneralizedLinearAlgorithm<M extends GeneralizedLinearModel>
implements Logging,
Serializable {
    private final Seq<Function1<RDD<LabeledPoint>, Object>> validators;
    private boolean addIntercept;
    private boolean validateData;
    private boolean useFeatureScaling;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Seq<Function1<RDD<LabeledPoint>, Object>> validators() {
        return this.validators;
    }

    public abstract Optimizer optimizer();

    public boolean addIntercept() {
        return this.addIntercept;
    }

    public void addIntercept_$eq(boolean x$1) {
        this.addIntercept = x$1;
    }

    public boolean validateData() {
        return this.validateData;
    }

    public void validateData_$eq(boolean x$1) {
        this.validateData = x$1;
    }

    private boolean useFeatureScaling() {
        return this.useFeatureScaling;
    }

    private void useFeatureScaling_$eq(boolean x$1) {
        this.useFeatureScaling = x$1;
    }

    public GeneralizedLinearAlgorithm<M> setFeatureScaling(boolean useFeatureScaling) {
        this.useFeatureScaling_$eq(useFeatureScaling);
        return this;
    }

    public abstract M createModel(Vector var1, double var2);

    public GeneralizedLinearAlgorithm<M> setIntercept(boolean addIntercept) {
        this.addIntercept_$eq(addIntercept);
        return this;
    }

    public GeneralizedLinearAlgorithm<M> setValidateData(boolean validateData) {
        this.validateData_$eq(validateData);
        return this;
    }

    public M run(RDD<LabeledPoint> input) {
        int numFeatures = ((LabeledPoint)input.first()).features().size();
        Vector initialWeights = Vectors$.MODULE$.dense(new double[numFeatures]);
        return this.run(input, initialWeights);
    }

    public M run(RDD<LabeledPoint> input, Vector initialWeights) {
        Vector weights;
        StandardScalerModel scaler;
        if (this.validateData() && !this.validators().forall((Function1)new Serializable(this, input){
            public static final long serialVersionUID = 0L;
            private final RDD input$1;

            public final boolean apply(Function1<RDD<LabeledPoint>, Object> func) {
                return BoxesRunTime.unboxToBoolean((Object)func.apply((Object)this.input$1));
            }
            {
                this.input$1 = input$1;
            }
        })) {
            throw new SparkException("Input validation failed.");
        }
        StandardScalerModel standardScalerModel = this.useFeatureScaling() ? new StandardScaler().fit((RDD<Vector>)input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(LabeledPoint x) {
                return x.features();
            }
        }, ClassTag$.MODULE$.apply(Vector.class))) : (scaler = null);
        RDD data = this.addIntercept() ? (this.useFeatureScaling() ? input.map((Function1)new Serializable(this, scaler){
            public static final long serialVersionUID = 0L;
            private final StandardScalerModel scaler$1;

            public final Tuple2<Object, Vector> apply(LabeledPoint labeledPoint) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)labeledPoint.label()), (Object)MLUtils$.MODULE$.appendBias(this.scaler$1.transform(labeledPoint.features())));
            }
            {
                this.scaler$1 = scaler$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)) : input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint labeledPoint) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)labeledPoint.label()), (Object)MLUtils$.MODULE$.appendBias(labeledPoint.features()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class))) : (this.useFeatureScaling() ? input.map((Function1)new Serializable(this, scaler){
            public static final long serialVersionUID = 0L;
            private final StandardScalerModel scaler$1;

            public final Tuple2<Object, Vector> apply(LabeledPoint labeledPoint) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)labeledPoint.label()), (Object)this.scaler$1.transform(labeledPoint.features()));
            }
            {
                this.scaler$1 = scaler$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)) : input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint labeledPoint) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)labeledPoint.label()), (Object)labeledPoint.features());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
        Vector initialWeightsWithIntercept = this.addIntercept() ? MLUtils$.MODULE$.appendBias(initialWeights) : initialWeights;
        Vector weightsWithIntercept = this.optimizer().optimize((RDD<Tuple2<Object, Vector>>)data, initialWeightsWithIntercept);
        double intercept = this.addIntercept() ? weightsWithIntercept.apply(weightsWithIntercept.size() - 1) : 0.0;
        Vector vector = weights = this.addIntercept() ? Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(weightsWithIntercept.toArray()).slice(0, weightsWithIntercept.size() - 1)) : weightsWithIntercept;
        if (this.useFeatureScaling()) {
            weights = scaler.transform(weights);
        }
        return this.createModel(weights, intercept);
    }

    public GeneralizedLinearAlgorithm() {
        Logging.class.$init$((Logging)this);
        this.validators = Nil$.MODULE$;
        this.addIntercept = false;
        this.validateData = true;
        this.useFeatureScaling = false;
    }
}

