/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.rdd;

import org.apache.spark.Partition;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.rdd.RandomRDD$;
import org.apache.spark.mllib.rdd.RandomRDDPartition;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Serializable;
import scala.collection.Iterator;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

public final class RandomRDD$
implements Serializable {
    public static final RandomRDD$ MODULE$;

    static {
        new RandomRDD$();
    }

    public <T> Partition[] getPartitions(long size, int numPartitions, RandomDataGenerator<T> rng, long seed) {
        RandomRDDPartition[] partitions = new RandomRDDPartition[numPartitions];
        long start = 0L;
        long end = 0L;
        Random random = new Random(seed);
        for (int i = 0; i < numPartitions; ++i) {
            end = (long)(i + 1) * size / (long)numPartitions;
            partitions[i] = new RandomRDDPartition<T>(i, (int)(end - start), rng, random.nextLong());
            start = end;
        }
        return partitions;
    }

    public <T> Iterator<T> getPointIterator(RandomRDDPartition<T> partition, ClassTag<T> evidence$2) {
        RandomDataGenerator<T> generator = partition.generator().copy();
        generator.setSeed(partition.seed());
        return package$.MODULE$.Iterator().fill(partition.size(), (Function0)new Serializable(generator){
            public static final long serialVersionUID = 0L;
            private final RandomDataGenerator generator$1;

            public final T apply() {
                return this.generator$1.nextValue();
            }
            {
                this.generator$1 = generator$1;
            }
        });
    }

    public Iterator<Vector> getVectorIterator(RandomRDDPartition<Object> partition, int vectorSize) {
        RandomDataGenerator<Object> generator = partition.generator().copy();
        generator.setSeed(partition.seed());
        return package$.MODULE$.Iterator().fill(partition.size(), (Function0)new Serializable(vectorSize, generator){
            public static final long serialVersionUID = 0L;
            private final int vectorSize$1;
            public final RandomDataGenerator generator$2;

            public final DenseVector apply() {
                return new DenseVector((double[])Array$.MODULE$.fill(this.vectorSize$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getVectorIterator.1 $outer;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return BoxesRunTime.unboxToDouble(this.$outer.generator$2.nextValue());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Double()));
            }
            {
                this.vectorSize$1 = vectorSize$1;
                this.generator$2 = generator$2;
            }
        });
    }

    public <T> long $lessinit$greater$default$5() {
        return Utils$.MODULE$.random().nextLong();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RandomRDD$() {
        MODULE$ = this;
    }
}

