/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.rdd;

import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.mllib.rdd.RDDFunctions$;
import org.apache.spark.mllib.rdd.SlidingRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db!B\u0001\u0003\u0001\u0011a!\u0001\u0004*E\t\u001a+hn\u0019;j_:\u001c(BA\u0002\u0005\u0003\r\u0011H\r\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u000b\u0003\u001by\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!A!\u0002\u00139\u0012\u0001B:fY\u001a\u001c\u0001\u0001E\u0002\u00195qi\u0011!\u0007\u0006\u0003\u0007\u0019I!aG\r\u0003\u0007I#E\t\u0005\u0002\u001e=1\u0001A!B\u0010\u0001\u0005\u0004\u0001#!\u0001+\u0012\u0005\u0005\"\u0003CA\b#\u0013\t\u0019\u0003CA\u0004O_RD\u0017N\\4\u0011\u0005=)\u0013B\u0001\u0014\u0011\u0005\r\te.\u001f\u0005\tQ\u0001\u0011\u0019\u0011)A\u0006S\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u0007)jC$D\u0001,\u0015\ta\u0003#A\u0004sK\u001adWm\u0019;\n\u00059Z#\u0001C\"mCN\u001cH+Y4\t\u000bA\u0002A\u0011A\u0019\u0002\rqJg.\u001b;?)\t\u0011d\u0007\u0006\u00024kA\u0019A\u0007\u0001\u000f\u000e\u0003\tAQ\u0001K\u0018A\u0004%BQ!F\u0018A\u0002]AQ\u0001\u000f\u0001\u0005\u0002e\nqa\u001d7jI&tw\r\u0006\u0002;\u000fB\u0019\u0001DG\u001e\u0011\u0007q\"ED\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001IF\u0001\u0007yI|w\u000e\u001e \n\u0003EI!a\u0011\t\u0002\u000fA\f7m[1hK&\u0011QI\u0012\u0002\u0004'\u0016\f(BA\"\u0011\u0011\u0015Au\u00071\u0001J\u0003)9\u0018N\u001c3poNK'0\u001a\t\u0003\u001f)K!a\u0013\t\u0003\u0007%sG\u000fC\u0003N\u0001\u0011\u0005a*\u0001\u0006ue\u0016,'+\u001a3vG\u0016$2\u0001H(U\u0011\u0015\u0001F\n1\u0001R\u0003\u00051\u0007#B\bS9qa\u0012BA*\u0011\u0005%1UO\\2uS>t'\u0007C\u0004V\u0019B\u0005\t\u0019A%\u0002\u000b\u0011,\u0007\u000f\u001e5\t\u000b]\u0003A\u0011\u0001-\u0002\u001bQ\u0014X-Z!hOJ,w-\u0019;f+\tIV\f\u0006\u0002[SR!1LY3i)\tav\f\u0005\u0002\u001e;\u0012)aL\u0016b\u0001A\t\tQ\u000bC\u0004a-\u0006\u0005\t9A1\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0002+[qCQa\u0019,A\u0002\u0011\fQa]3r\u001fB\u0004Ra\u0004*]9qCQA\u001a,A\u0002\u001d\faaY8nE>\u0003\b#B\bS9rc\u0006bB+W!\u0003\u0005\r!\u0013\u0005\u0006UZ\u0003\r\u0001X\u0001\nu\u0016\u0014xNV1mk\u0016Dq\u0001\u001c\u0001\u0012\u0002\u0013\u0005Q.A\fue\u0016,\u0017iZ4sK\u001e\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011an\u001f\u000b\u0003_fT#!\u00139,\u0003E\u0004\"A]<\u000e\u0003MT!\u0001^;\u0002\u0013Ut7\r[3dW\u0016$'B\u0001<\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0003qN\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u0015Q7\u000e1\u0001{!\ti2\u0010B\u0003_W\n\u0007\u0001\u0005C\u0004~\u0001E\u0005I\u0011\u0001@\u0002)Q\u0014X-\u001a*fIV\u001cW\r\n3fM\u0006,H\u000e\u001e\u00133+\u0005yw\u0001CA\u0001\u0005!\u0005A!a\u0001\u0002\u0019I#EIR;oGRLwN\\:\u0011\u0007Q\n)AB\u0004\u0002\u0005!\u0005A!a\u0002\u0014\u0007\u0005\u0015a\u0002C\u00041\u0003\u000b!\t!a\u0003\u0015\u0005\u0005\r\u0001\u0002CA\b\u0003\u000b!\u0019!!\u0005\u0002\u000f\u0019\u0014x.\u001c*E\tV!\u00111CA\u000e)\u0011\t)\"a\t\u0015\t\u0005]\u0011Q\u0004\t\u0005i\u0001\tI\u0002E\u0002\u001e\u00037!aaHA\u0007\u0005\u0004\u0001\u0003BCA\u0010\u0003\u001b\t\t\u0011q\u0001\u0002\"\u0005QQM^5eK:\u001cW\rJ\u001a\u0011\t)j\u0013\u0011\u0004\u0005\b\u0007\u00055\u0001\u0019AA\u0013!\u0011A\"$!\u0007")
public class RDDFunctions<T> {
    private final RDD<T> self;
    private final ClassTag<T> evidence$1;

    public static <T> RDDFunctions<T> fromRDD(RDD<T> rDD, ClassTag<T> classTag) {
        return RDDFunctions$.MODULE$.fromRDD(rDD, classTag);
    }

    public RDD<Seq<T>> sliding(int windowSize) {
        Predef$.MODULE$.require(windowSize > 0, (Function0)new Serializable(this, windowSize){
            public static final long serialVersionUID = 0L;
            private final int windowSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sliding window size must be positive, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.windowSize$1)}));
            }
            {
                this.windowSize$1 = windowSize$1;
            }
        });
        return windowSize == 1 ? this.self.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<T> apply(T x$1) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x$1}));
            }
        }, ClassTag$.MODULE$.apply(Seq.class)) : new SlidingRDD(this.self, windowSize, this.evidence$1);
    }

    public T treeReduce(Function2<T, T, T> f, int depth) {
        Predef$.MODULE$.require(depth >= 1, (Function0)new Serializable(this, depth){
            public static final long serialVersionUID = 0L;
            private final int depth$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Depth must be greater than or equal to 1 but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.depth$2)}));
            }
            {
                this.depth$2 = depth$2;
            }
        });
        SparkContext qual$1 = this.self.context();
        Function2<T, T, T> x$3 = f;
        boolean x$4 = qual$1.clean$default$2();
        Function2 cleanF = (Function2)qual$1.clean(x$3, x$4);
        Serializable reducePartition = new Serializable(this, cleanF){
            public static final long serialVersionUID = 0L;
            private final Function2 cleanF$1;

            public final Option<T> apply(Iterator<T> iter) {
                return iter.hasNext() ? new Some(iter.reduceLeft(this.cleanF$1)) : None$.MODULE$;
            }
            {
                this.cleanF$1 = cleanF$1;
            }
        };
        RDD partiallyReduced = this.self.mapPartitions((Function1)new Serializable(this, (Function1)reducePartition){
            public static final long serialVersionUID = 0L;
            private final Function1 reducePartition$1;

            public final Iterator<Option<T>> apply(Iterator<T> it) {
                return scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{(Option)this.reducePartition$1.apply(it)}));
            }
            {
                this.reducePartition$1 = reducePartition$1;
            }
        }, this.self.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Option.class));
        Serializable op = new Serializable(this, cleanF){
            public static final long serialVersionUID = 0L;
            private final Function2 cleanF$1;

            public final Option<T> apply(Option<T> c, Option<T> x) {
                return c.isDefined() && x.isDefined() ? new Some(this.cleanF$1.apply(c.get(), x.get())) : (c.isDefined() ? c : (x.isDefined() ? x : None$.MODULE$));
            }
            {
                this.cleanF$1 = cleanF$1;
            }
        };
        return (T)RDDFunctions$.MODULE$.fromRDD(partiallyReduced, ClassTag$.MODULE$.apply(Option.class)).treeAggregate((U)Option$.MODULE$.empty(), (Function2<U, T, U>)op, (Function2<U, U, U>)((Function2)op), depth, (ClassTag<U>)ClassTag$.MODULE$.apply(Option.class)).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new UnsupportedOperationException("empty collection");
            }
        });
    }

    public int treeReduce$default$2() {
        return 2;
    }

    public <U> U treeAggregate(U zeroValue, Function2<U, T, U> seqOp, Function2<U, U, U> combOp, int depth, ClassTag<U> evidence$2) {
        Predef$.MODULE$.require(depth >= 1, (Function0)new Serializable(this, depth){
            public static final long serialVersionUID = 0L;
            private final int depth$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Depth must be greater than or equal to 1 but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.depth$1)}));
            }
            {
                this.depth$1 = depth$1;
            }
        });
        if (Predef$.MODULE$.refArrayOps((Object[])this.self.partitions()).size() == 0) {
            return (U)Utils$.MODULE$.clone(zeroValue, this.self.context().env().closureSerializer().newInstance(), evidence$2);
        }
        SparkContext qual$2 = this.self.context();
        Function2<U, T, U> x$5 = seqOp;
        boolean x$6 = qual$2.clean$default$2();
        Function2 cleanSeqOp = (Function2)qual$2.clean(x$5, x$6);
        SparkContext qual$3 = this.self.context();
        Function2<U, U, U> x$7 = combOp;
        boolean x$8 = qual$3.clean$default$2();
        Function2 cleanCombOp = (Function2)qual$3.clean(x$7, x$8);
        Serializable aggregatePartition = new Serializable(this, zeroValue, cleanSeqOp, cleanCombOp){
            public static final long serialVersionUID = 0L;
            private final Object zeroValue$1;
            private final Function2 cleanSeqOp$1;
            private final Function2 cleanCombOp$1;

            public final U apply(Iterator<T> it) {
                return (U)it.aggregate(this.zeroValue$1, this.cleanSeqOp$1, this.cleanCombOp$1);
            }
            {
                void var4_4;
                void var3_3;
                this.zeroValue$1 = zeroValue$1;
                this.cleanSeqOp$1 = var3_3;
                this.cleanCombOp$1 = var4_4;
            }
        };
        RDD partiallyAggregated = this.self.mapPartitions((Function1)new Serializable(this, (Function1)aggregatePartition){
            public static final long serialVersionUID = 0L;
            private final Function1 aggregatePartition$1;

            public final Iterator<U> apply(Iterator<T> it) {
                return scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.aggregatePartition$1.apply(it)}));
            }
            {
                this.aggregatePartition$1 = aggregatePartition$1;
            }
        }, this.self.mapPartitions$default$2(), evidence$2);
        int numPartitions = Predef$.MODULE$.refArrayOps((Object[])partiallyAggregated.partitions()).size();
        int scale = package$.MODULE$.max((int)package$.MODULE$.ceil(package$.MODULE$.pow((double)numPartitions, 1.0 / (double)depth)), 2);
        while (numPartitions > scale + numPartitions / scale) {
            int curNumPartitions = numPartitions /= scale;
            RDD qual$4 = partiallyAggregated;
            Serializable x$9 = new Serializable(this, curNumPartitions){
                public static final long serialVersionUID = 0L;
                public final int curNumPartitions$1;

                public final Iterator<Tuple2<Object, U>> apply(int i, Iterator<U> iter) {
                    return iter.map((Function1)new Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$6 $outer;
                        private final int i$1;

                        public final Tuple2<Object, U> apply(U x$2) {
                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)(this.i$1 % this.$outer.curNumPartitions$1)), x$2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.i$1 = i$1;
                        }
                    });
                }
                {
                    this.curNumPartitions$1 = curNumPartitions$1;
                }
            };
            boolean x$10 = qual$4.mapPartitionsWithIndex$default$2();
            partiallyAggregated = SparkContext$.MODULE$.rddToPairRDDFunctions(SparkContext$.MODULE$.rddToPairRDDFunctions(qual$4.mapPartitionsWithIndex((Function2)x$9, x$10, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), evidence$2, (Ordering)Ordering.Int$.MODULE$).reduceByKey((Partitioner)new HashPartitioner(curNumPartitions), cleanCombOp), ClassTag$.MODULE$.Int(), evidence$2, (Ordering)Ordering.Int$.MODULE$).values();
        }
        return (U)partiallyAggregated.reduce(cleanCombOp);
    }

    public <U> int treeAggregate$default$4(U zeroValue) {
        return 2;
    }

    public RDDFunctions(RDD<T> self, ClassTag<T> evidence$1) {
        this.self = self;
        this.evidence$1 = evidence$1;
    }
}

