/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.feature.VectorTransformer;
import org.apache.spark.mllib.feature.VectorTransformer$class;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001\u001b\t\u00192\u000b^1oI\u0006\u0014HmU2bY\u0016\u0014Xj\u001c3fY*\u00111\u0001B\u0001\bM\u0016\fG/\u001e:f\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0012-\u0016\u001cGo\u001c:Ue\u0006t7OZ8s[\u0016\u0014\b\u0002C\r\u0001\u0005\u000b\u0007I\u0011\u0001\u000e\u0002\u0011]LG\u000f['fC:,\u0012a\u0007\t\u0003\u001fqI!!\b\t\u0003\u000f\t{w\u000e\\3b]\"Aq\u0004\u0001B\u0001B\u0003%1$A\u0005xSRDW*Z1oA!A\u0011\u0005\u0001BC\u0002\u0013\u0005!$A\u0004xSRD7\u000b\u001e3\t\u0011\r\u0002!\u0011!Q\u0001\nm\t\u0001b^5uQN#H\r\t\u0005\tK\u0001\u0011)\u0019!C\u0001M\u0005!Q.Z1o+\u00059\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0005\u0003\u0019a\u0017N\\1mO&\u0011A&\u000b\u0002\u0007-\u0016\u001cGo\u001c:\t\u00119\u0002!\u0011!Q\u0001\n\u001d\nQ!\\3b]\u0002B\u0001\u0002\r\u0001\u0003\u0006\u0004%\tAJ\u0001\tm\u0006\u0014\u0018.\u00198dK\"A!\u0007\u0001B\u0001B\u0003%q%A\u0005wCJL\u0017M\\2fA!1A\u0007\u0001C\u0001\tU\na\u0001P5oSRtD#\u0002\u001c8qeR\u0004CA\u000b\u0001\u0011\u0015I2\u00071\u0001\u001c\u0011\u0015\t3\u00071\u0001\u001c\u0011\u0015)3\u00071\u0001(\u0011\u0015\u00014\u00071\u0001(\u0011!a\u0004\u0001#b\u0001\n\u0013i\u0014A\u00024bGR|'/F\u0001?!\ry4)R\u0007\u0002\u0001*\u0011!&\u0011\u0006\u0002\u0005\u00061!M]3fu\u0016L!\u0001\u0012!\u0003\u0017\u0011+gn]3WK\u000e$xN\u001d\t\u0003\u001f\u0019K!a\u0012\t\u0003\r\u0011{WO\u00197f\u0011!I\u0005\u0001#A!B\u0013q\u0014a\u00024bGR|'\u000f\t\u0005\u0006\u0017\u0002!\t\u0005T\u0001\niJ\fgn\u001d4pe6$\"aJ'\t\u000b9S\u0005\u0019A\u0014\u0002\rY,7\r^8sQ\t\u0001\u0001\u000b\u0005\u0002R)6\t!K\u0003\u0002T\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005U\u0013&\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006d\u0007")
public class StandardScalerModel
implements VectorTransformer {
    private final boolean withMean;
    private final boolean withStd;
    private final Vector mean;
    private final Vector variance;
    private DenseVector<Object> factor;
    private volatile boolean bitmap$0;

    /*
     * WARNING - void declaration
     */
    private DenseVector factor$lzycompute() {
        StandardScalerModel standardScalerModel = this;
        synchronized (standardScalerModel) {
            if (!this.bitmap$0) {
                void var2_2;
                DenseVector f = DenseVector$.MODULE$.zeros$mDc$sp(this.variance().size(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                for (int i = 0; i < f.size(); ++i) {
                    f.update$mcD$sp(i, this.variance().apply(i) != 0.0 ? 1.0 / package$.MODULE$.sqrt(this.variance().apply(i)) : 0.0);
                }
                this.factor = var2_2;
                this.bitmap$0 = true;
            }
            return this.factor;
        }
    }

    @Override
    public RDD<Vector> transform(RDD<Vector> data) {
        return VectorTransformer$class.transform(this, data);
    }

    public boolean withMean() {
        return this.withMean;
    }

    public boolean withStd() {
        return this.withStd;
    }

    public Vector mean() {
        return this.mean;
    }

    public Vector variance() {
        return this.variance;
    }

    private DenseVector<Object> factor() {
        return this.bitmap$0 ? this.factor : this.factor$lzycompute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Vector transform(Vector vector) {
        Vector vector2;
        Predef$.MODULE$.require(this.mean().size() == vector.size());
        if (this.withMean()) {
            Vector vector3;
            breeze.linalg.Vector<Object> vector4 = vector.toBreeze();
            if (!(vector4 instanceof DenseVector)) throw new IllegalArgumentException(new StringBuilder().append((Object)"Do not support vector type ").append(vector4.getClass()).toString());
            breeze.linalg.Vector output = vector.toBreeze().copy();
            for (int i = 0; i < output.length(); ++i) {
                output.update$mcID$sp(i, (output.apply$mcID$sp(i) - this.mean().apply(i)) * (this.withStd() ? this.factor().apply$mcD$sp(i) : 1.0));
            }
            vector2 = vector3 = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)output);
            return vector2;
        } else if (this.withStd()) {
            Vector vector5;
            breeze.linalg.Vector<Object> vector6 = vector.toBreeze();
            if (vector6 instanceof DenseVector) {
                DenseVector denseVector = (DenseVector)vector6;
                vector5 = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)((breeze.linalg.Vector)denseVector.$colon$times(this.factor(), DenseVector$.MODULE$.dv_dv_Op_Double_OpMulScalar())));
            } else {
                if (!(vector6 instanceof SparseVector)) throw new IllegalArgumentException(new StringBuilder().append((Object)"Do not support vector type ").append(vector6.getClass()).toString());
                SparseVector sparseVector = (SparseVector)vector6;
                SparseVector.mcD.sp output = new SparseVector.mcD.sp(sparseVector.index(), (double[])sparseVector.data$mcD$sp().clone(), sparseVector.length(), (Zero)Zero.DoubleZero$.MODULE$);
                for (int i = 0; i < output.data$mcD$sp().length; ++i) {
                    double[] dArray = output.data$mcD$sp();
                    int n = i;
                    dArray[n] = dArray[n] * this.factor().apply$mcD$sp(output.index()[i]);
                }
                vector5 = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)output);
            }
            vector2 = vector5;
            return vector2;
        } else {
            vector2 = vector;
        }
        return vector2;
    }

    public StandardScalerModel(boolean withMean, boolean withStd, Vector mean2, Vector variance2) {
        this.withMean = withMean;
        this.withStd = withStd;
        this.mean = mean2;
        this.variance = variance2;
        VectorTransformer$class.$init$(this);
        Predef$.MODULE$.require(mean2.size() == variance2.size());
    }
}

