/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.DatabaseAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.PartitionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011\ra\u0001B&M\u0001eC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005U\")\u0011\u000f\u0001C\u0001e\u001a!a\u000f\u0001\u0003x\u0011!AHA!a\u0001\n\u0003I\b\u0002C?\u0005\u0005\u0003\u0007I\u0011\u0001@\t\u0013\u0005%AA!A!B\u0013Q\bBB9\u0005\t\u0003\tY\u0001C\u0005\u0002\u0014\u0011\u0011\r\u0011\"\u0001\u0002\u0016!A\u00111\b\u0003!\u0002\u0013\t9B\u0002\u0004\u0002>\u0001!\u0011q\b\u0005\u000b\u0003\u0003Z!\u00111A\u0005\u0002\u0005\r\u0003BCA&\u0017\t\u0005\r\u0011\"\u0001\u0002N!Q\u0011\u0011K\u0006\u0003\u0002\u0003\u0006K!!\u0012\t\rE\\A\u0011AA*\u0011%\tIf\u0003b\u0001\n\u0003\tY\u0006\u0003\u0005\u0002v-\u0001\u000b\u0011BA/\u0011%\t9h\u0003b\u0001\n\u0003\tI\b\u0003\u0005\u0002\u0004.\u0001\u000b\u0011BA>\u0011!i\u0005A1A\u0005\n\u0005\u0015\u0005\u0002CAE\u0001\u0001\u0006I!a\"\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005bBAS\u0001\u0011%\u0011q\u0015\u0005\b\u0003\u0007\u0004A\u0011BAc\u0011\u001d\ti\r\u0001C\u0005\u0003\u001fDq!a=\u0001\t\u0013\t)\u0010C\u0004\u0002N\u0002!I!!?\t\u000f\t\u0005\u0001\u0001\"\u0011\u0003\u0004!9!Q\u0002\u0001\u0005B\t=\u0001b\u0002B\u000e\u0001\u0011\u0005#Q\u0004\u0005\b\u0005C\u0001A\u0011\tB\u0012\u0011\u001d\u00119\u0003\u0001C!\u0005SAqA!\f\u0001\t\u0003\u0012y\u0003C\u0004\u0003.\u0001!\tEa\r\t\u000f\te\u0002\u0001\"\u0011\u0003<!9!q\b\u0001\u0005B\t\u0005\u0003b\u0002B%\u0001\u0011\u0005#1\n\u0005\b\u0005/\u0002A\u0011\tB-\u0011\u001d\u0011)\u0007\u0001C!\u0005OBqAa\u001b\u0001\t\u0003\u0012i\u0007C\u0004\u0003\u0004\u0002!\tE!\"\t\u000f\tm\u0005\u0001\"\u0011\u0003\u001e\"9!1\u0015\u0001\u0005B\t\u0015\u0006b\u0002BW\u0001\u0011\u0005#q\u0016\u0005\b\u0005k\u0003A\u0011\tB\\\u0011\u001d\u0011)\f\u0001C!\u0005wCqA!1\u0001\t\u0003\u0012\u0019\rC\u0004\u0003J\u0002!\tEa3\t\u000f\tu\u0007\u0001\"\u0011\u0003`\"9!1\u001f\u0001\u0005B\tU\bbBB\u0007\u0001\u0011\u00053q\u0002\u0005\b\u00077\u0001A\u0011IB\u000f\u0011\u001d\u0019i\u0003\u0001C!\u0007_Aqa!\u0010\u0001\t\u0003\u001ay\u0004C\u0004\u0004J\u0001!\tea\u0013\t\u000f\rU\u0003\u0001\"\u0011\u0004X!91\u0011\r\u0001\u0005B\r\r\u0004\"CB7\u0001E\u0005I\u0011AB8\u0011\u001d\u0019)\t\u0001C!\u0007\u000fC\u0011b!%\u0001#\u0003%\taa\u001c\t\u000f\rM\u0005\u0001\"\u0011\u0004\u0016\"91\u0011\u0017\u0001\u0005B\rM\u0006bBB^\u0001\u0011\u00053Q\u0018\u0005\b\u0007\u000b\u0004A\u0011IBd\u0011\u001d\u0019i\r\u0001C!\u0007\u001fDqaa6\u0001\t\u0003\u001aI\u000eC\u0004\u0004`\u0002!\te!9\t\u000f\r\u001d\b\u0001\"\u0011\u0004j\u001eI1q\u001e'\u0002\u0002#\u00051\u0011\u001f\u0004\t\u00172\u000b\t\u0011#\u0001\u0004t\"1\u0011o\u0012C\u0001\u0007kD\u0011ba>H#\u0003%\ta!?\t\u0013\rux)%A\u0005\u0002\r}(aD%o\u001b\u0016lwN]=DCR\fGn\\4\u000b\u00055s\u0015aB2bi\u0006dwn\u001a\u0006\u0003\u001fB\u000b\u0001bY1uC2L8\u000f\u001e\u0006\u0003#J\u000b1a]9m\u0015\t\u0019F+A\u0003ta\u0006\u00148N\u0003\u0002V-\u00061\u0011\r]1dQ\u0016T\u0011aV\u0001\u0004_J<7\u0001A\n\u0004\u0001i\u0003\u0007CA._\u001b\u0005a&\"A/\u0002\u000bM\u001c\u0017\r\\1\n\u0005}c&AB!osJ+g\r\u0005\u0002bE6\tA*\u0003\u0002d\u0019\nyQ\t\u001f;fe:\fGnQ1uC2|w-\u0001\u0003d_:4\u0007C\u00014h\u001b\u0005\u0011\u0016B\u00015S\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0007iC\u0012|w\u000e]\"p]\u001aLw\r\u0005\u0002l_6\tAN\u0003\u0002e[*\u0011a\u000eV\u0001\u0007Q\u0006$wn\u001c9\n\u0005Ad'!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004gR,\bCA1\u0001\u0011\u001d!7\u0001%AA\u0002\u0015Dq![\u0002\u0011\u0002\u0003\u0007!NA\u0005UC\ndW\rR3tGN\u0011AAW\u0001\u0006i\u0006\u0014G.Z\u000b\u0002uB\u0011\u0011m_\u0005\u0003y2\u0013AbQ1uC2|w\rV1cY\u0016\f\u0011\u0002^1cY\u0016|F%Z9\u0015\u0007}\f)\u0001E\u0002\\\u0003\u0003I1!a\u0001]\u0005\u0011)f.\u001b;\t\u0011\u0005\u001da!!AA\u0002i\f1\u0001\u001f\u00132\u0003\u0019!\u0018M\u00197fAQ!\u0011QBA\t!\r\ty\u0001B\u0007\u0002\u0001!)\u0001\u0010\u0003a\u0001u\u0006Q\u0001/\u0019:uSRLwN\\:\u0016\u0005\u0005]\u0001\u0003CA\r\u0003G\t9#!\u000e\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tq!\\;uC\ndWMC\u0002\u0002\"q\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)#a\u0007\u0003\u000f!\u000b7\u000f['baB!\u0011\u0011FA\u0018\u001d\r\t\u00171F\u0005\u0004\u0003[a\u0015\u0001D\"bi\u0006dwn\u001a+za\u0016\u001c\u0018\u0002BA\u0019\u0003g\u0011!\u0003V1cY\u0016\u0004\u0016M\u001d;ji&|gn\u00159fG*\u0019\u0011Q\u0006'\u0011\u0007\u0005\f9$C\u0002\u0002:1\u0013QcQ1uC2|w\rV1cY\u0016\u0004\u0016M\u001d;ji&|g.A\u0006qCJ$\u0018\u000e^5p]N\u0004#\u0001\u0004#bi\u0006\u0014\u0017m]3EKN\u001c7CA\u0006[\u0003\t!'-\u0006\u0002\u0002FA\u0019\u0011-a\u0012\n\u0007\u0005%CJA\bDCR\fGn\\4ECR\f'-Y:f\u0003\u0019!'m\u0018\u0013fcR\u0019q0a\u0014\t\u0013\u0005\u001dQ\"!AA\u0002\u0005\u0015\u0013a\u00013cAQ!\u0011QKA,!\r\tya\u0003\u0005\b\u0003\u0003z\u0001\u0019AA#\u0003\u0019!\u0018M\u00197fgV\u0011\u0011Q\f\t\t\u00033\t\u0019#a\u0018\u0002\u000eA!\u0011\u0011MA8\u001d\u0011\t\u0019'a\u001b\u0011\u0007\u0005\u0015D,\u0004\u0002\u0002h)\u0019\u0011\u0011\u000e-\u0002\rq\u0012xn\u001c;?\u0013\r\ti\u0007X\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00141\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055D,A\u0004uC\ndWm\u001d\u0011\u0002\u0013\u0019,hn\u0019;j_:\u001cXCAA>!!\tI\"a\t\u0002`\u0005u\u0004cA1\u0002\u0000%\u0019\u0011\u0011\u0011'\u0003\u001f\r\u000bG/\u00197pO\u001a+hn\u0019;j_:\f!BZ;oGRLwN\\:!+\t\t9\t\u0005\u0005\u0002\u001a\u0005\r\u0012qLA+\u0003!\u0019\u0017\r^1m_\u001e\u0004\u0013a\u00049beRLG/[8o\u000bbL7\u000f^:\u0015\u0011\u0005=\u0015QSAL\u00033\u00032aWAI\u0013\r\t\u0019\n\u0018\u0002\b\u0005>|G.Z1o\u0011\u001d\t\tE\u0006a\u0001\u0003?Ba\u0001\u001f\fA\u0002\u0005}\u0003bBAN-\u0001\u0007\u0011qE\u0001\u0005gB,7-A\u000bsKF,\u0018N]3UC\ndWMT8u\u000bbL7\u000f^:\u0015\u000b}\f\t+a)\t\u000f\u0005\u0005s\u00031\u0001\u0002`!1\u0001p\u0006a\u0001\u0003?\naC]3rk&\u0014X\rU1si&$\u0018n\u001c8t\u000bbL7\u000f\u001e\u000b\b\u007f\u0006%\u00161VAW\u0011\u001d\t\t\u0005\u0007a\u0001\u0003?Ba\u0001\u001f\rA\u0002\u0005}\u0003bBAX1\u0001\u0007\u0011\u0011W\u0001\u0006gB,7m\u001d\t\u0007\u0003g\u000bi,a\n\u000f\t\u0005U\u0016\u0011\u0018\b\u0005\u0003K\n9,C\u0001^\u0013\r\tY\fX\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty,!1\u0003\u0007M+\u0017OC\u0002\u0002<r\u000b\u0011D]3rk&\u0014X\rU1si&$\u0018n\u001c8t\u001d>$X\t_5tiR9q0a2\u0002J\u0006-\u0007bBA!3\u0001\u0007\u0011q\f\u0005\u0007qf\u0001\r!a\u0018\t\u000f\u0005=\u0016\u00041\u0001\u00022\u00061Bo\\\"bi\u0006dwn\u001a)beRLG/[8o'B,7-\u0006\u0002\u0002RB91,a5\u0002X\u0006]\u0017bAAk9\nIa)\u001e8di&|g.\r\t\u0005\u00033\fyC\u0004\u0003\u0002\\\u0006-b\u0002BAo\u0003ctA!a8\u0002p:!\u0011\u0011]Aw\u001d\u0011\t\u0019/a;\u000f\t\u0005\u0015\u0018\u0011\u001e\b\u0005\u0003K\n9/C\u0001X\u0013\t)f+\u0003\u0002T)&\u0011\u0011KU\u0005\u0003\u001fBK!!\u0014(\u0002/Q|7)\u0019;bY><\u0007+\u0019:uSRLwN\\*qK\u000e\u001cH\u0003BAY\u0003oDq!a,\u001c\u0001\u0004\t\t\f\u0006\u0003\u0002|\u0006u\bCBAZ\u0003{\u000b)\u0004C\u0004\u0002\u0000r\u0001\r!a?\u0002\u000bA\f'\u000f^:\u0002\u001d\r\u0014X-\u0019;f\t\u0006$\u0018MY1tKR)qP!\u0002\u0003\n!9!qA\u000fA\u0002\u0005\u0015\u0013\u0001\u00043c\t\u00164\u0017N\\5uS>t\u0007b\u0002B\u0006;\u0001\u0007\u0011qR\u0001\u000fS\u001etwN]3JM\u0016C\u0018n\u001d;t\u00031!'o\u001c9ECR\f'-Y:f)\u001dy(\u0011\u0003B\n\u0005/Aq!!\u0011\u001f\u0001\u0004\ty\u0006C\u0004\u0003\u0016y\u0001\r!a$\u0002#%<gn\u001c:f\u0013\u001atu\u000e^#ySN$8\u000fC\u0004\u0003\u001ay\u0001\r!a$\u0002\u000f\r\f7oY1eK\u0006i\u0011\r\u001c;fe\u0012\u000bG/\u00192bg\u0016$2a B\u0010\u0011\u001d\u00119a\ba\u0001\u0003\u000b\n1bZ3u\t\u0006$\u0018MY1tKR!\u0011Q\tB\u0013\u0011\u001d\t\t\u0005\ta\u0001\u0003?\na\u0002Z1uC\n\f7/Z#ySN$8\u000f\u0006\u0003\u0002\u0010\n-\u0002bBA!C\u0001\u0007\u0011qL\u0001\u000eY&\u001cH\u000fR1uC\n\f7/Z:\u0015\u0005\tE\u0002CBAZ\u0003{\u000by\u0006\u0006\u0003\u00032\tU\u0002b\u0002B\u001cG\u0001\u0007\u0011qL\u0001\ba\u0006$H/\u001a:o\u0003I\u0019X\r^\"veJ,g\u000e\u001e#bi\u0006\u0014\u0017m]3\u0015\u0007}\u0014i\u0004C\u0004\u0002B\u0011\u0002\r!a\u0018\u0002\u0017\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u000b\u0006\u007f\n\r#q\t\u0005\u0007\u0005\u000b*\u0003\u0019\u0001>\u0002\u001fQ\f'\r\\3EK\u001aLg.\u001b;j_:DqAa\u0003&\u0001\u0004\ty)A\u0005ee>\u0004H+\u00192mKRIqP!\u0014\u0003P\tE#1\u000b\u0005\b\u0003\u00032\u0003\u0019AA0\u0011\u0019Ah\u00051\u0001\u0002`!9!Q\u0003\u0014A\u0002\u0005=\u0005b\u0002B+M\u0001\u0007\u0011qR\u0001\u0006aV\u0014x-Z\u0001\fe\u0016t\u0017-\\3UC\ndW\rF\u0004\u0000\u00057\u0012iF!\u0019\t\u000f\u0005\u0005s\u00051\u0001\u0002`!9!qL\u0014A\u0002\u0005}\u0013aB8mI:\u000bW.\u001a\u0005\b\u0005G:\u0003\u0019AA0\u0003\u001dqWm\u001e(b[\u0016\f!\"\u00197uKJ$\u0016M\u00197f)\ry(\u0011\u000e\u0005\u0007\u0005\u000bB\u0003\u0019\u0001>\u0002)\u0005dG/\u001a:UC\ndW\rR1uCN\u001b\u0007.Z7b)\u001dy(q\u000eB9\u0005gBq!!\u0011*\u0001\u0004\ty\u0006\u0003\u0004yS\u0001\u0007\u0011q\f\u0005\b\u0005kJ\u0003\u0019\u0001B<\u00035qWm\u001e#bi\u0006\u001c6\r[3nCB!!\u0011\u0010B@\u001b\t\u0011YHC\u0002\u0003~A\u000bQ\u0001^=qKNLAA!!\u0003|\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u001f\u0005dG/\u001a:UC\ndWm\u0015;biN$ra BD\u0005\u0013\u0013Y\tC\u0004\u0002B)\u0002\r!a\u0018\t\raT\u0003\u0019AA0\u0011\u001d\u0011iI\u000ba\u0001\u0005\u001f\u000bQa\u001d;biN\u0004Ra\u0017BI\u0005+K1Aa%]\u0005\u0019y\u0005\u000f^5p]B\u0019\u0011Ma&\n\u0007\teEJA\tDCR\fGn\\4Ti\u0006$\u0018n\u001d;jGN\f\u0001bZ3u)\u0006\u0014G.\u001a\u000b\u0006u\n}%\u0011\u0015\u0005\b\u0003\u0003Z\u0003\u0019AA0\u0011\u0019A8\u00061\u0001\u0002`\u0005yq-\u001a;UC\ndWm\u001d\"z\u001d\u0006lW\r\u0006\u0004\u0003(\n%&1\u0016\t\u0006\u0003g\u000biL\u001f\u0005\b\u0003\u0003b\u0003\u0019AA0\u0011\u001d\tI\u0006\fa\u0001\u0005c\t1\u0002^1cY\u0016,\u00050[:ugR1\u0011q\u0012BY\u0005gCq!!\u0011.\u0001\u0004\ty\u0006\u0003\u0004y[\u0001\u0007\u0011qL\u0001\u000bY&\u001cH\u000fV1cY\u0016\u001cH\u0003\u0002B\u0019\u0005sCq!!\u0011/\u0001\u0004\ty\u0006\u0006\u0004\u00032\tu&q\u0018\u0005\b\u0003\u0003z\u0003\u0019AA0\u0011\u001d\u00119d\fa\u0001\u0003?\n\u0011\u0002\\5tiZKWm^:\u0015\r\tE\"Q\u0019Bd\u0011\u001d\t\t\u0005\ra\u0001\u0003?BqAa\u000e1\u0001\u0004\ty&A\u0005m_\u0006$G+\u00192mKRYqP!4\u0003P\nE'Q\u001bBm\u0011\u001d\t\t%\ra\u0001\u0003?Ba\u0001_\u0019A\u0002\u0005}\u0003b\u0002Bjc\u0001\u0007\u0011qL\u0001\tY>\fG\rU1uQ\"9!q[\u0019A\u0002\u0005=\u0015aC5t\u001fZ,'o\u001e:ji\u0016DqAa72\u0001\u0004\ty)\u0001\u0006jgN\u00138\rT8dC2\fQ\u0002\\8bIB\u000b'\u000f^5uS>tGcD@\u0003b\n\r(Q\u001dBt\u0005W\u0014iO!=\t\u000f\u0005\u0005#\u00071\u0001\u0002`!1\u0001P\ra\u0001\u0003?BqAa53\u0001\u0004\ty\u0006C\u0004\u0003jJ\u0002\r!a\n\u0002\u0013A\f'\u000f^5uS>t\u0007b\u0002Ble\u0001\u0007\u0011q\u0012\u0005\b\u0005_\u0014\u0004\u0019AAH\u0003EIg\u000e[3sSR$\u0016M\u00197f'B,7m\u001d\u0005\b\u00057\u0014\u0004\u0019AAH\u0003Uaw.\u00193Es:\fW.[2QCJ$\u0018\u000e^5p]N$Rb B|\u0005s\u0014YP!@\u0003\u0000\u000e\r\u0001bBA!g\u0001\u0007\u0011q\f\u0005\u0007qN\u0002\r!a\u0018\t\u000f\tM7\u00071\u0001\u0002`!9!\u0011^\u001aA\u0002\u0005\u001d\u0002bBB\u0001g\u0001\u0007\u0011qR\u0001\be\u0016\u0004H.Y2f\u0011\u001d\u0019)a\ra\u0001\u0007\u000f\tQA\\;n\tB\u00032aWB\u0005\u0013\r\u0019Y\u0001\u0018\u0002\u0004\u0013:$\u0018\u0001E2sK\u0006$X\rU1si&$\u0018n\u001c8t)%y8\u0011CB\n\u0007+\u0019I\u0002C\u0004\u0002BQ\u0002\r!a\u0018\t\ra$\u0004\u0019AA0\u0011\u001d\u00199\u0002\u000ea\u0001\u0003w\f\u0001B\\3x!\u0006\u0014Ho\u001d\u0005\b\u0005\u0017!\u0004\u0019AAH\u00039!'o\u001c9QCJ$\u0018\u000e^5p]N$Rb`B\u0010\u0007C\u0019\u0019c!\n\u0004(\r%\u0002bBA!k\u0001\u0007\u0011q\f\u0005\u0007qV\u0002\r!a\u0018\t\u000f\u0005}X\u00071\u0001\u00022\"9!QC\u001bA\u0002\u0005=\u0005b\u0002B+k\u0001\u0007\u0011q\u0012\u0005\b\u0007W)\u0004\u0019AAH\u0003)\u0011X\r^1j]\u0012\u000bG/Y\u0001\u0011e\u0016t\u0017-\\3QCJ$\u0018\u000e^5p]N$\u0012b`B\u0019\u0007g\u0019)d!\u000f\t\u000f\u0005\u0005c\u00071\u0001\u0002`!1\u0001P\u000ea\u0001\u0003?Bqaa\u000e7\u0001\u0004\t\t,A\u0005ge>l7\u000b]3dg\"911\b\u001cA\u0002\u0005E\u0016a\u0002;p'B,7m]\u0001\u0010C2$XM\u001d)beRLG/[8ogR9qp!\u0011\u0004D\r\u0015\u0003bBA!o\u0001\u0007\u0011q\f\u0005\u0007q^\u0002\r!a\u0018\t\u000f\r\u001ds\u00071\u0001\u0002|\u0006Q\u0011\r\u001c;feB\u000b'\u000f^:\u0002\u0019\u001d,G\u000fU1si&$\u0018n\u001c8\u0015\u0011\u0005U2QJB(\u0007#Bq!!\u00119\u0001\u0004\ty\u0006\u0003\u0004yq\u0001\u0007\u0011q\f\u0005\b\u0007'B\u0004\u0019AA\u0014\u0003!\u0001\u0018M\u001d;Ta\u0016\u001c\u0017AE4fiB\u000b'\u000f^5uS>tw\n\u001d;j_:$\u0002b!\u0017\u0004\\\ru3q\f\t\u00067\nE\u0015Q\u0007\u0005\b\u0003\u0003J\u0004\u0019AA0\u0011\u0019A\u0018\b1\u0001\u0002`!911K\u001dA\u0002\u0005\u001d\u0012A\u00057jgR\u0004\u0016M\u001d;ji&|gNT1nKN$\u0002B!\r\u0004f\r\u001d4\u0011\u000e\u0005\b\u0003\u0003R\u0004\u0019AA0\u0011\u0019A(\b1\u0001\u0002`!I11\u000b\u001e\u0011\u0002\u0003\u000711\u000e\t\u00067\nE\u0015qE\u0001\u001dY&\u001cH\u000fU1si&$\u0018n\u001c8OC6,7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019\tH\u000b\u0003\u0004l\rM4FAB;!\u0011\u00199h!!\u000e\u0005\re$\u0002BB>\u0007{\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r}D,\u0001\u0006b]:|G/\u0019;j_:LAaa!\u0004z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d1L7\u000f\u001e)beRLG/[8ogRA\u00111`BE\u0007\u0017\u001bi\tC\u0004\u0002Bq\u0002\r!a\u0018\t\rad\u0004\u0019AA0\u0011%\u0019y\t\u0010I\u0001\u0002\u0004\u0019Y'A\u0006qCJ$\u0018.\u00197Ta\u0016\u001c\u0017\u0001\u00077jgR\u0004\u0016M\u001d;ji&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u00051B.[:u!\u0006\u0014H/\u001b;j_:\u001c()\u001f$jYR,'\u000f\u0006\u0006\u0002|\u000e]5\u0011TBN\u0007[Cq!!\u0011?\u0001\u0004\ty\u0006\u0003\u0004y}\u0001\u0007\u0011q\f\u0005\b\u0007;s\u0004\u0019ABP\u0003)\u0001(/\u001a3jG\u0006$Xm\u001d\t\u0007\u0003g\u000bil!)\u0011\t\r\r6\u0011V\u0007\u0003\u0007KS1aa*O\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\r-6Q\u0015\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007bBBX}\u0001\u0007\u0011qL\u0001\u0012I\u00164\u0017-\u001e7u)&lWMW8oK&#\u0017AD2sK\u0006$XMR;oGRLwN\u001c\u000b\u0006\u007f\u000eU6q\u0017\u0005\b\u0003\u0003z\u0004\u0019AA0\u0011\u001d\u0019Il\u0010a\u0001\u0003{\nAAZ;oG\u0006aAM]8q\rVt7\r^5p]R)qpa0\u0004B\"9\u0011\u0011\t!A\u0002\u0005}\u0003bBBb\u0001\u0002\u0007\u0011qL\u0001\tMVt7MT1nK\u0006i\u0011\r\u001c;fe\u001a+hn\u0019;j_:$Ra`Be\u0007\u0017Dq!!\u0011B\u0001\u0004\ty\u0006C\u0004\u0004:\u0006\u0003\r!! \u0002\u001dI,g.Y7f\rVt7\r^5p]R9qp!5\u0004T\u000eU\u0007bBA!\u0005\u0002\u0007\u0011q\f\u0005\b\u0005?\u0012\u0005\u0019AA0\u0011\u001d\u0011\u0019G\u0011a\u0001\u0003?\n1bZ3u\rVt7\r^5p]R1\u0011QPBn\u0007;Dq!!\u0011D\u0001\u0004\ty\u0006C\u0004\u0004D\u000e\u0003\r!a\u0018\u0002\u001d\u0019,hn\u0019;j_:,\u00050[:ugR1\u0011qRBr\u0007KDq!!\u0011E\u0001\u0004\ty\u0006C\u0004\u0004D\u0012\u0003\r!a\u0018\u0002\u001b1L7\u000f\u001e$v]\u000e$\u0018n\u001c8t)\u0019\u0011\tda;\u0004n\"9\u0011\u0011I#A\u0002\u0005}\u0003b\u0002B\u001c\u000b\u0002\u0007\u0011qL\u0001\u0010\u0013:lU-\\8ss\u000e\u000bG/\u00197pOB\u0011\u0011mR\n\u0003\u000fj#\"a!=\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019YPK\u0002f\u0007g\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TC\u0001C\u0001U\rQ71\u000f")
public class InMemoryCatalog
implements ExternalCatalog {
    private final Configuration hadoopConfig;
    private final HashMap<String, DatabaseDesc> catalog;

    public static Configuration $lessinit$greater$default$2() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$2();
    }

    public static SparkConf $lessinit$greater$default$1() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public void requireDbExists(String db) {
        ExternalCatalog.requireDbExists$(this, db);
    }

    @Override
    public void requireTableExists(String db, String table) {
        ExternalCatalog.requireTableExists$(this, db, table);
    }

    @Override
    public void requireFunctionExists(String db, String funcName) {
        ExternalCatalog.requireFunctionExists$(this, db, funcName);
    }

    @Override
    public void requireFunctionNotExists(String db, String funcName) {
        ExternalCatalog.requireFunctionNotExists$(this, db, funcName);
    }

    private HashMap<String, DatabaseDesc> catalog() {
        return this.catalog;
    }

    private boolean partitionExists(String db, String table, Map<String, String> spec) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().contains(spec);
    }

    private void requireTableNotExists(String db, String table) {
        if (this.tableExists(db, table)) {
            throw new TableAlreadyExistsException(db, table);
        }
    }

    private void requirePartitionsExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1 & Serializable & scala.Serializable)s -> {
            InMemoryCatalog.$anonfun$requirePartitionsExist$1(this, db, table, s);
            return BoxedUnit.UNIT;
        });
    }

    private void requirePartitionsNotExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1 & Serializable & scala.Serializable)s -> {
            InMemoryCatalog.$anonfun$requirePartitionsNotExist$1(this, db, table, s);
            return BoxedUnit.UNIT;
        });
    }

    private Function1<Map<String, String>, Map<String, String>> toCatalogPartitionSpec() {
        return (Function1 & Serializable & scala.Serializable)x$1 -> ExternalCatalogUtils$.MODULE$.convertNullPartitionValues((Map<String, String>)x$1);
    }

    private Seq<Map<String, String>> toCatalogPartitionSpecs(Seq<Map<String, String>> specs) {
        return (Seq)specs.map(this.toCatalogPartitionSpec(), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<CatalogTablePartition> toCatalogPartitionSpec(Seq<CatalogTablePartition> parts) {
        return (Seq)parts.map((Function1 & Serializable & scala.Serializable)part -> part.copy((Map<String, String>)((Map)this.toCatalogPartitionSpec().apply(part.spec())), part.copy$default$2(), part.copy$default$3(), part.copy$default$4(), part.copy$default$5(), part.copy$default$6()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public void createDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            if (this.catalog().contains((Object)dbDefinition.name())) {
                if (!ignoreIfExists) {
                    throw new DatabaseAlreadyExistsException(dbDefinition.name());
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.liftedTree1$1(dbDefinition);
                boxedUnit = this.catalog().put((Object)dbDefinition.name(), (Object)new DatabaseDesc(this, dbDefinition));
            }
        }
    }

    @Override
    public void dropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            if (this.catalog().contains((Object)db)) {
                if (!cascade) {
                    if (((DatabaseDesc)this.catalog().apply((Object)db)).tables().nonEmpty()) {
                        throw QueryCompilationErrors$.MODULE$.databaseNotEmptyError(db, "tables");
                    }
                    if (((DatabaseDesc)this.catalog().apply((Object)db)).functions().nonEmpty()) {
                        throw QueryCompilationErrors$.MODULE$.databaseNotEmptyError(db, "functions");
                    }
                }
                CatalogDatabase dbDefinition = ((DatabaseDesc)this.catalog().apply((Object)db)).db();
                this.liftedTree2$1(dbDefinition);
                boxedUnit = this.catalog().remove((Object)db);
            } else {
                if (!ignoreIfNotExists) {
                    throw new NoSuchDatabaseException(db);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public synchronized void alterDatabase(CatalogDatabase dbDefinition) {
        this.requireDbExists(dbDefinition.name());
        ((DatabaseDesc)this.catalog().apply((Object)dbDefinition.name())).db_$eq(dbDefinition);
    }

    @Override
    public synchronized CatalogDatabase getDatabase(String db) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).db();
    }

    @Override
    public synchronized boolean databaseExists(String db) {
        return this.catalog().contains((Object)db);
    }

    @Override
    public synchronized Seq<String> listDatabases() {
        return (Seq)this.catalog().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listDatabases(String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listDatabases(), pattern);
    }

    @Override
    public void setCurrentDatabase(String db) {
    }

    @Override
    public void createTable(CatalogTable tableDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
            String db = (String)tableDefinition.identifier().database().get();
            this.requireDbExists(db);
            String table = tableDefinition.identifier().table();
            if (this.tableExists(db, table)) {
                if (!ignoreIfExists) {
                    throw new TableAlreadyExistsException(db, table);
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Map tableProp;
                CatalogTable catalogTable;
                boolean needDefaultTableLocation;
                CatalogTableType catalogTableType = tableDefinition.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                boolean bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null) && tableDefinition.storage().locationUri().isEmpty() ? true : (needDefaultTableLocation = false);
                if (needDefaultTableLocation) {
                    Path defaultTableLocation = new Path(new Path(((DatabaseDesc)this.catalog().apply((Object)db)).db().locationUri()), table);
                    this.liftedTree3$1(defaultTableLocation, table);
                    catalogTable = tableDefinition.withNewStorage((Option<URI>)new Some((Object)defaultTableLocation.toUri()), tableDefinition.withNewStorage$default$2(), tableDefinition.withNewStorage$default$3(), tableDefinition.withNewStorage$default$4(), tableDefinition.withNewStorage$default$5(), tableDefinition.withNewStorage$default$6());
                } else {
                    catalogTable = tableDefinition;
                }
                CatalogTable tableWithLocation = catalogTable;
                Map x$1 = tableProp = (Map)tableWithLocation.properties().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$createTable$1(x$2)));
                TableIdentifier x$22 = tableWithLocation.copy$default$1();
                CatalogTableType x$3 = tableWithLocation.copy$default$2();
                CatalogStorageFormat x$4 = tableWithLocation.copy$default$3();
                StructType x$5 = tableWithLocation.copy$default$4();
                Option<String> x$6 = tableWithLocation.copy$default$5();
                Seq<String> x$7 = tableWithLocation.copy$default$6();
                Option<BucketSpec> x$8 = tableWithLocation.copy$default$7();
                String x$9 = tableWithLocation.copy$default$8();
                long x$10 = tableWithLocation.copy$default$9();
                long x$11 = tableWithLocation.copy$default$10();
                String x$12 = tableWithLocation.copy$default$11();
                Option<CatalogStatistics> x$13 = tableWithLocation.copy$default$13();
                Option<String> x$14 = tableWithLocation.copy$default$14();
                Option<String> x$15 = tableWithLocation.copy$default$15();
                Seq<String> x$16 = tableWithLocation.copy$default$16();
                boolean x$17 = tableWithLocation.copy$default$17();
                boolean x$18 = tableWithLocation.copy$default$18();
                Map<String, String> x$19 = tableWithLocation.copy$default$19();
                Option<String> x$20 = tableWithLocation.copy$default$20();
                boxedUnit = ((DatabaseDesc)this.catalog().apply((Object)db)).tables().put((Object)table, (Object)new TableDesc(this, tableWithLocation.copy(x$22, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<String, String>)x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20)));
            }
        }
    }

    @Override
    public void dropTable(String db, String table, boolean ignoreIfNotExists, boolean purge) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            this.requireDbExists(db);
            if (this.tableExists(db, table)) {
                Object object;
                CatalogTable tableMeta = this.getTable(db, table);
                CatalogTableType catalogTableType = tableMeta.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                    Seq locationAllParts = (Seq)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.location(), Seq$.MODULE$.canBuildFrom());
                    locationAllParts.foreach((Function1 & Serializable & scala.Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$dropTable$2(this, loc)));
                    Predef$.MODULE$.assert(tableMeta.storage().locationUri().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.");
                    Path dir = new Path(tableMeta.location());
                    object = BoxesRunTime.boxToBoolean((boolean)this.liftedTree4$1(dir, table));
                } else {
                    object = BoxedUnit.UNIT;
                }
                boxedUnit = ((DatabaseDesc)this.catalog().apply((Object)db)).tables().remove((Object)table);
            } else {
                if (!ignoreIfNotExists) {
                    throw new NoSuchTableException(db, table);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void renameTable(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireTableExists(db, oldName);
            this.requireTableNotExists(db, newName);
            TableDesc oldDesc = (TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)oldName);
            CatalogTable qual$1 = oldDesc.table();
            TableIdentifier x$1 = new TableIdentifier(newName, (Option<String>)new Some((Object)db));
            CatalogTableType x$2 = qual$1.copy$default$2();
            CatalogStorageFormat x$3 = qual$1.copy$default$3();
            StructType x$4 = qual$1.copy$default$4();
            Option<String> x$5 = qual$1.copy$default$5();
            Seq<String> x$6 = qual$1.copy$default$6();
            Option<BucketSpec> x$7 = qual$1.copy$default$7();
            String x$8 = qual$1.copy$default$8();
            long x$9 = qual$1.copy$default$9();
            long x$10 = qual$1.copy$default$10();
            String x$11 = qual$1.copy$default$11();
            Map<String, String> x$12 = qual$1.copy$default$12();
            Option<CatalogStatistics> x$13 = qual$1.copy$default$13();
            Option<String> x$14 = qual$1.copy$default$14();
            Option<String> x$15 = qual$1.copy$default$15();
            Seq<String> x$16 = qual$1.copy$default$16();
            boolean x$17 = qual$1.copy$default$17();
            boolean x$18 = qual$1.copy$default$18();
            Map<String, String> x$19 = qual$1.copy$default$19();
            Option<String> x$20 = qual$1.copy$default$20();
            oldDesc.table_$eq(qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
            CatalogTableType catalogTableType = oldDesc.table().tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                Predef$.MODULE$.assert(oldDesc.table().storage().locationUri().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.");
                Path oldDir = new Path(oldDesc.table().location());
                Path newDir = new Path(new Path(((DatabaseDesc)this.catalog().apply((Object)db)).db().locationUri()), newName);
                this.liftedTree5$1(oldDir, newDir, oldName, newName);
                CatalogTable qual$2 = oldDesc.table();
                Some x$21 = new Some((Object)newDir.toUri());
                Option<String> x$22 = qual$2.withNewStorage$default$2();
                Option<String> x$23 = qual$2.withNewStorage$default$3();
                boolean x$24 = qual$2.withNewStorage$default$4();
                Option<String> x$25 = qual$2.withNewStorage$default$5();
                Map<String, String> x$26 = qual$2.withNewStorage$default$6();
                oldDesc.table_$eq(qual$2.withNewStorage((Option<URI>)x$21, x$22, x$23, x$24, x$25, x$26));
            }
            ((DatabaseDesc)this.catalog().apply((Object)db)).tables().put((Object)newName, (Object)oldDesc);
            ((DatabaseDesc)this.catalog().apply((Object)db)).tables().remove((Object)oldName);
        }
    }

    @Override
    public synchronized void alterTable(CatalogTable tableDefinition) {
        Map updatedProperties;
        Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
        String db = (String)tableDefinition.identifier().database().get();
        this.requireTableExists(db, tableDefinition.identifier().table());
        Map x$1 = updatedProperties = (Map)tableDefinition.properties().filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$alterTable$1(kv)));
        TableIdentifier x$2 = tableDefinition.copy$default$1();
        CatalogTableType x$3 = tableDefinition.copy$default$2();
        CatalogStorageFormat x$4 = tableDefinition.copy$default$3();
        StructType x$5 = tableDefinition.copy$default$4();
        Option<String> x$6 = tableDefinition.copy$default$5();
        Seq<String> x$7 = tableDefinition.copy$default$6();
        Option<BucketSpec> x$8 = tableDefinition.copy$default$7();
        String x$9 = tableDefinition.copy$default$8();
        long x$10 = tableDefinition.copy$default$9();
        long x$11 = tableDefinition.copy$default$10();
        String x$12 = tableDefinition.copy$default$11();
        Option<CatalogStatistics> x$13 = tableDefinition.copy$default$13();
        Option<String> x$14 = tableDefinition.copy$default$14();
        Option<String> x$15 = tableDefinition.copy$default$15();
        Seq<String> x$16 = tableDefinition.copy$default$16();
        boolean x$17 = tableDefinition.copy$default$17();
        boolean x$18 = tableDefinition.copy$default$18();
        Map<String, String> x$19 = tableDefinition.copy$default$19();
        Option<String> x$20 = tableDefinition.copy$default$20();
        CatalogTable newTableDefinition = tableDefinition.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<String, String>)x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)tableDefinition.identifier().table())).table_$eq(newTableDefinition);
    }

    @Override
    public synchronized void alterTableDataSchema(String db, String table, StructType newDataSchema) {
        StructType newSchema;
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        StructType x$1 = newSchema = StructType$.MODULE$.apply((Seq<StructField>)((Seq)newDataSchema.$plus$plus(origTable.partitionSchema(), Seq$.MODULE$.canBuildFrom())));
        TableIdentifier x$2 = origTable.copy$default$1();
        CatalogTableType x$3 = origTable.copy$default$2();
        CatalogStorageFormat x$4 = origTable.copy$default$3();
        Option<String> x$5 = origTable.copy$default$5();
        Seq<String> x$6 = origTable.copy$default$6();
        Option<BucketSpec> x$7 = origTable.copy$default$7();
        String x$8 = origTable.copy$default$8();
        long x$9 = origTable.copy$default$9();
        long x$10 = origTable.copy$default$10();
        String x$11 = origTable.copy$default$11();
        Map<String, String> x$12 = origTable.copy$default$12();
        Option<CatalogStatistics> x$13 = origTable.copy$default$13();
        Option<String> x$14 = origTable.copy$default$14();
        Option<String> x$15 = origTable.copy$default$15();
        Seq<String> x$16 = origTable.copy$default$16();
        boolean x$17 = origTable.copy$default$17();
        boolean x$18 = origTable.copy$default$18();
        Map<String, String> x$19 = origTable.copy$default$19();
        Option<String> x$20 = origTable.copy$default$20();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
    }

    @Override
    public synchronized void alterTableStats(String db, String table, Option<CatalogStatistics> stats) {
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        Option<CatalogStatistics> x$1 = stats;
        TableIdentifier x$2 = origTable.copy$default$1();
        CatalogTableType x$3 = origTable.copy$default$2();
        CatalogStorageFormat x$4 = origTable.copy$default$3();
        StructType x$5 = origTable.copy$default$4();
        Option<String> x$6 = origTable.copy$default$5();
        Seq<String> x$7 = origTable.copy$default$6();
        Option<BucketSpec> x$8 = origTable.copy$default$7();
        String x$9 = origTable.copy$default$8();
        long x$10 = origTable.copy$default$9();
        long x$11 = origTable.copy$default$10();
        String x$12 = origTable.copy$default$11();
        Map<String, String> x$13 = origTable.copy$default$12();
        Option<String> x$14 = origTable.copy$default$14();
        Option<String> x$15 = origTable.copy$default$15();
        Seq<String> x$16 = origTable.copy$default$16();
        boolean x$17 = origTable.copy$default$17();
        boolean x$18 = origTable.copy$default$18();
        Map<String, String> x$19 = origTable.copy$default$19();
        Option<String> x$20 = origTable.copy$default$20();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$1, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
    }

    @Override
    public synchronized CatalogTable getTable(String db, String table) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
    }

    @Override
    public Seq<CatalogTable> getTablesByName(String db, Seq<String> tables) {
        this.requireDbExists(db);
        HashMap<String, TableDesc> hashMap = ((DatabaseDesc)this.catalog().apply((Object)db)).tables();
        return (Seq)((TraversableLike)tables.flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(hashMap.get(key)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.table(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public synchronized boolean tableExists(String db, String table) {
        return this.catalog().contains((Object)db) && ((DatabaseDesc)this.catalog().apply((Object)db)).tables().contains((Object)table);
    }

    @Override
    public synchronized Seq<String> listTables(String db) {
        this.requireDbExists(db);
        return (Seq)((DatabaseDesc)this.catalog().apply((Object)db)).tables().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listTables(String db, String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listTables(db), pattern);
    }

    @Override
    public synchronized Seq<String> listViews(String db, String pattern) {
        this.requireDbExists(db);
        Set views = ((HashMap)((DatabaseDesc)this.catalog().apply((Object)db)).tables().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$listViews$1(x$5)))).keySet();
        return StringUtils$.MODULE$.filterPattern((Seq<String>)((Seq)views.toSeq().sorted((Ordering)Ordering.String$.MODULE$)), pattern);
    }

    @Override
    public void loadTable(String db, String table, String loadPath, boolean isOverwrite, boolean isSrcLocal) {
        throw QueryExecutionErrors$.MODULE$.methodNotImplementedError("loadTable");
    }

    @Override
    public void loadPartition(String db, String table, String loadPath, Map<String, String> partition, boolean isOverwrite, boolean inheritTableSpecs, boolean isSrcLocal) {
        throw QueryExecutionErrors$.MODULE$.methodNotImplementedError("loadPartition");
    }

    @Override
    public void loadDynamicPartitions(String db, String table, String loadPath, Map<String, String> partition, boolean replace, int numDP) {
        throw QueryExecutionErrors$.MODULE$.methodNotImplementedError("loadDynamicPartitions");
    }

    @Override
    public synchronized void createPartitions(String db, String table, Seq<CatalogTablePartition> newParts, boolean ignoreIfExists) {
        Seq dupSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        Seq<CatalogTablePartition> parts = this.toCatalogPartitionSpec(newParts);
        if (!ignoreIfExists && (dupSpecs = (Seq)parts.collect((PartialFunction)new scala.Serializable(null, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$1;

            public final <A1 extends CatalogTablePartition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.existingParts$1.contains(A1.spec()) ? A1.spec() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(CatalogTablePartition x1) {
                CatalogTablePartition catalogTablePartition = x1;
                boolean bl = this.existingParts$1.contains(catalogTablePartition.spec());
                return bl;
            }
            {
                this.existingParts$1 = existingParts$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new PartitionsAlreadyExistException(db, table, (Seq<Map<String, String>>)dupSpecs);
        }
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        parts.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Path partitionPath = (Path)p.storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$6 -> new Path(x$6)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ExternalCatalogUtils$.MODULE$.generatePartitionPath(p.spec(), partitionColumnNames, tablePath));
            try {
                FileSystem fs = tablePath.getFileSystem($this.hadoopConfig);
                Object object = !fs.exists(partitionPath) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(partitionPath)) : BoxedUnit.UNIT;
            }
            catch (IOException e) {
                throw QueryExecutionErrors$.MODULE$.unableToCreatePartitionPathError(partitionPath, e);
            }
            CatalogStorageFormat x$1 = p.storage().copy((Option<URI>)new Some((Object)partitionPath.toUri()), p.storage().copy$default$2(), p.storage().copy$default$3(), p.storage().copy$default$4(), p.storage().copy$default$5(), p.storage().copy$default$6());
            Map<String, String> x$2 = p.copy$default$1();
            Map<String, String> x$3 = p.copy$default$3();
            long x$4 = p.copy$default$4();
            long x$5 = p.copy$default$5();
            Option<CatalogStatistics> x$62 = p.copy$default$6();
            return existingParts.put(p.spec(), (Object)p.copy(x$2, x$1, x$3, x$4, x$5, x$62));
        });
    }

    @Override
    public synchronized void dropPartitions(String db, String table, Seq<Map<String, String>> parts, boolean ignoreIfNotExists, boolean purge, boolean retainData) {
        boolean bl;
        Seq missingSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        Seq<Map<String, String>> partSpecs = this.toCatalogPartitionSpecs(parts);
        if (!ignoreIfNotExists && (missingSpecs = (Seq)partSpecs.collect((PartialFunction)new scala.Serializable(null, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$2;

            public final <A1 extends Map<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = !this.existingParts$2.contains(A1) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Map<String, String> x1) {
                Map<String, String> map = x1;
                boolean bl = !this.existingParts$2.contains(map);
                return bl;
            }
            {
                this.existingParts$2 = existingParts$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new NoSuchPartitionsException(db, table, (Seq<Map<String, String>>)missingSpecs);
        }
        if (retainData) {
            bl = false;
        } else {
            CatalogTableType catalogTableType = this.getTable(db, table).tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        }
        boolean shouldRemovePartitionLocation = bl;
        partSpecs.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Object object;
            if (existingParts.contains(p) && shouldRemovePartitionLocation) {
                boolean bl;
                Path partitionPath = new Path(((CatalogTablePartition)existingParts.apply(p)).location());
                try {
                    FileSystem fs = partitionPath.getFileSystem($this.hadoopConfig);
                    bl = fs.delete(partitionPath, true);
                }
                catch (IOException e) {
                    throw QueryExecutionErrors$.MODULE$.unableToDeletePartitionPathError(partitionPath, e);
                }
                object = BoxesRunTime.boxToBoolean((boolean)bl);
            } else {
                object = BoxedUnit.UNIT;
            }
            return existingParts.remove(p);
        });
    }

    @Override
    public synchronized void renamePartitions(String db, String table, Seq<Map<String, String>> fromSpecs, Seq<Map<String, String>> toSpecs) {
        Seq<Map<String, String>> specs = this.toCatalogPartitionSpecs(fromSpecs);
        Seq<Map<String, String>> newSpecs = this.toCatalogPartitionSpecs(toSpecs);
        Predef$.MODULE$.require(specs.size() == newSpecs.size(), (Function0 & Serializable & scala.Serializable)() -> "number of old and new partition specs differ");
        this.requirePartitionsExist(db, table, specs);
        this.requirePartitionsNotExist(db, table, newSpecs);
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        CatalogTableType catalogTableType = this.getTable(db, table).tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
        boolean shouldUpdatePartitionLocation = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        ((IterableLike)specs.zip(newSpecs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CatalogTablePartition catalogTablePartition;
            Map newSpec;
            Map oldSpec;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                oldSpec = (Map)tuple2._1();
                newSpec = (Map)tuple2._2();
                CatalogTablePartition oldPartition = this.getPartition(db, table, (Map<String, String>)oldSpec);
                if (shouldUpdatePartitionLocation) {
                    Path oldPartPath = new Path(oldPartition.location());
                    Path newPartPath = ExternalCatalogUtils$.MODULE$.generatePartitionPath((Map<String, String>)newSpec, partitionColumnNames, tablePath);
                    try {
                        FileSystem fs = tablePath.getFileSystem($this.hadoopConfig);
                        fs.mkdirs(newPartPath);
                        if (!fs.rename(oldPartPath, newPartPath)) {
                            throw new IOException(new StringBuilder(48).append("Renaming partition path from ").append(oldPartPath).append(" to ").append(newPartPath).append(" returned false").toString());
                        }
                    }
                    catch (IOException e) {
                        throw QueryExecutionErrors$.MODULE$.unableToRenamePartitionPathError(oldPartPath, e);
                    }
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.storage().copy((Option<URI>)new Some((Object)newPartPath.toUri()), oldPartition.storage().copy$default$2(), oldPartition.storage().copy$default$3(), oldPartition.storage().copy$default$4(), oldPartition.storage().copy$default$5(), oldPartition.storage().copy$default$6()), oldPartition.copy$default$3(), oldPartition.copy$default$4(), oldPartition.copy$default$5(), oldPartition.copy$default$6());
                } else {
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.copy$default$2(), oldPartition.copy$default$3(), oldPartition.copy$default$4(), oldPartition.copy$default$5(), oldPartition.copy$default$6());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CatalogTablePartition newPartition = catalogTablePartition;
            existingParts.remove((Object)oldSpec);
            Option option = existingParts.put((Object)newSpec, (Object)newPartition);
            return option;
        });
    }

    @Override
    public synchronized void alterPartitions(String db, String table, Seq<CatalogTablePartition> alterParts) {
        Seq<CatalogTablePartition> parts = this.toCatalogPartitionSpec(alterParts);
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)parts.map((Function1 & Serializable & scala.Serializable)p -> p.spec(), Seq$.MODULE$.canBuildFrom())));
        parts.foreach((Function1 & Serializable & scala.Serializable)p -> ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().put(p.spec(), p));
    }

    @Override
    public synchronized CatalogTablePartition getPartition(String db, String table, Map<String, String> partSpec) {
        Map spec = (Map)this.toCatalogPartitionSpec().apply(partSpec);
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)new .colon.colon((Object)spec, (List)Nil$.MODULE$)));
        return (CatalogTablePartition)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply((Object)spec);
    }

    @Override
    public synchronized Option<CatalogTablePartition> getPartitionOption(String db, String table, Map<String, String> partSpec) {
        Map spec = (Map)this.toCatalogPartitionSpec().apply(partSpec);
        return !this.partitionExists(db, table, (Map<String, String>)spec) ? None$.MODULE$ : Option$.MODULE$.apply(((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply((Object)spec));
    }

    @Override
    public synchronized Seq<String> listPartitionNames(String db, String table, Option<Map<String, String>> partSpec) {
        Seq<String> partitionColumnNames = this.getTable(db, table).partitionColumnNames();
        Option partialSpec = partSpec.map(this.toCatalogPartitionSpec());
        return (Seq)((SeqLike)this.listPartitions(db, table, (Option<Map<String, String>>)partialSpec).map((Function1 & Serializable & scala.Serializable)partition -> ((TraversableOnce)partitionColumnNames.map((Function1 & Serializable & scala.Serializable)name -> {
            String partValue = partition.spec().apply(name) == null ? ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME() : ExternalCatalogUtils$.MODULE$.escapePathName((String)partition.spec().apply(name));
            return new StringBuilder(1).append(ExternalCatalogUtils$.MODULE$.escapePathName((String)name)).append("=").append(partValue).toString();
        }, Seq$.MODULE$.canBuildFrom())).mkString("/"), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Option<Map<String, String>> listPartitionNames$default$3() {
        return None$.MODULE$;
    }

    @Override
    public synchronized Seq<CatalogTablePartition> listPartitions(String db, String table, Option<Map<String, String>> partialSpec) {
        Seq seq;
        this.requireTableExists(db, table);
        Option option = partialSpec.map(this.toCatalogPartitionSpec());
        if (None$.MODULE$.equals(option)) {
            seq = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Map partial = (Map)some.value();
            seq = (Seq)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().toSeq().collect((PartialFunction)new scala.Serializable(null, partial){
                public static final long serialVersionUID = 0L;
                private final Map partial$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Map<String, String>, CatalogTablePartition>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        Map spec = (Map)A1._1();
                        CatalogTablePartition partition = (CatalogTablePartition)A1._2();
                        if (ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)spec)) {
                            object = partition;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<Map<String, String>, CatalogTablePartition> x1) {
                    Map spec;
                    Tuple2<Map<String, String>, CatalogTablePartition> tuple2 = x1;
                    boolean bl = tuple2 != null && ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)(spec = (Map)tuple2._1()));
                    return bl;
                }
                {
                    this.partial$1 = partial$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)option);
        }
        return seq;
    }

    @Override
    public Option<Map<String, String>> listPartitions$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Seq<CatalogTablePartition> listPartitionsByFilter(String db, String table, Seq<Expression> predicates, String defaultTimeZoneId) {
        CatalogTable catalogTable = this.getTable(db, table);
        Seq<CatalogTablePartition> allPartitions = this.listPartitions(db, table, this.listPartitions$default$3());
        return ExternalCatalogUtils$.MODULE$.prunePartitionsByFilter(catalogTable, allPartitions, predicates, defaultTimeZoneId);
    }

    @Override
    public void createFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionNotExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
        }
    }

    @Override
    public void dropFunction(String db, String funcName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, funcName);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().remove((Object)funcName);
        }
    }

    @Override
    public void alterFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
        }
    }

    @Override
    public void renameFunction(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, oldName);
            this.requireFunctionNotExists(db, newName);
            CatalogFunction qual$1 = this.getFunction(db, oldName);
            FunctionIdentifier x$1 = new FunctionIdentifier(newName, (Option<String>)new Some((Object)db));
            String x$2 = qual$1.copy$default$2();
            Seq<FunctionResource> x$3 = qual$1.copy$default$3();
            CatalogFunction newFunc = qual$1.copy(x$1, x$2, x$3);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().remove((Object)oldName);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)newName, (Object)newFunc);
        }
    }

    @Override
    public synchronized CatalogFunction getFunction(String db, String funcName) {
        this.requireFunctionExists(db, funcName);
        return (CatalogFunction)((DatabaseDesc)this.catalog().apply((Object)db)).functions().apply((Object)funcName);
    }

    @Override
    public synchronized boolean functionExists(String db, String funcName) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).functions().contains((Object)funcName);
    }

    @Override
    public synchronized Seq<String> listFunctions(String db, String pattern) {
        this.requireDbExists(db);
        return StringUtils$.MODULE$.filterPattern((Seq<String>)((DatabaseDesc)this.catalog().apply((Object)db)).functions().keysIterator().toSeq(), pattern);
    }

    public static final /* synthetic */ void $anonfun$requirePartitionsExist$1(InMemoryCatalog $this, String db$1, String table$1, Map s) {
        if (!$this.partitionExists(db$1, table$1, (Map<String, String>)s)) {
            throw new NoSuchPartitionException(db$1, table$1, (Map<String, String>)s);
        }
    }

    public static final /* synthetic */ void $anonfun$requirePartitionsNotExist$1(InMemoryCatalog $this, String db$2, String table$2, Map s) {
        if ($this.partitionExists(db$2, table$2, (Map<String, String>)s)) {
            throw new PartitionAlreadyExistsException(db$2, table$2, (Map<String, String>)s);
        }
    }

    private final /* synthetic */ boolean liftedTree1$1(CatalogDatabase dbDefinition$1) {
        boolean bl;
        try {
            Path location = new Path(dbDefinition$1.locationUri());
            FileSystem fs = location.getFileSystem(this.hadoopConfig);
            bl = fs.mkdirs(location);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToCreateDatabaseAsFailedToCreateDirectoryError(dbDefinition$1, e);
        }
        return bl;
    }

    private final /* synthetic */ boolean liftedTree2$1(CatalogDatabase dbDefinition$2) {
        boolean bl;
        try {
            Path location = new Path(dbDefinition$2.locationUri());
            FileSystem fs = location.getFileSystem(this.hadoopConfig);
            bl = fs.delete(location, true);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToDropDatabaseAsFailedToDeleteDirectoryError(dbDefinition$2, e);
        }
        return bl;
    }

    private final /* synthetic */ boolean liftedTree3$1(Path defaultTableLocation$1, String table$3) {
        boolean bl;
        try {
            FileSystem fs = defaultTableLocation$1.getFileSystem(this.hadoopConfig);
            bl = fs.mkdirs(defaultTableLocation$1);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToCreateTableAsFailedToCreateDirectoryError(table$3, defaultTableLocation$1, e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createTable$1(Tuple2 x$2) {
        Object object = x$2._1();
        String string = "comment";
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$dropTable$2(InMemoryCatalog $this, URI loc) {
        boolean bl;
        Path partitionPath = new Path(loc);
        try {
            FileSystem fs = partitionPath.getFileSystem($this.hadoopConfig);
            bl = fs.delete(partitionPath, true);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToDeletePartitionPathError(partitionPath, e);
        }
        return bl;
    }

    private final /* synthetic */ boolean liftedTree4$1(Path dir$1, String table$4) {
        boolean bl;
        try {
            FileSystem fs = dir$1.getFileSystem(this.hadoopConfig);
            bl = fs.delete(dir$1, true);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToDropTableAsFailedToDeleteDirectoryError(table$4, dir$1, e);
        }
        return bl;
    }

    private final /* synthetic */ boolean liftedTree5$1(Path oldDir$1, Path newDir$1, String oldName$1, String newName$1) {
        boolean bl;
        try {
            FileSystem fs = oldDir$1.getFileSystem(this.hadoopConfig);
            bl = fs.rename(oldDir$1, newDir$1);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToRenameTableAsFailedToRenameDirectoryError(oldName$1, newName$1, oldDir$1, e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$alterTable$1(Tuple2 kv) {
        Object object = kv._1();
        String string = "comment";
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listViews$1(Tuple2 x$5) {
        CatalogTableType catalogTableType = ((TableDesc)x$5._2()).table().tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        return !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
    }

    public InMemoryCatalog(SparkConf conf, Configuration hadoopConfig) {
        this.hadoopConfig = hadoopConfig;
        ExternalCatalog.$init$(this);
        this.catalog = new HashMap();
    }

    private class DatabaseDesc {
        private CatalogDatabase db;
        private final HashMap<String, TableDesc> tables;
        private final HashMap<String, CatalogFunction> functions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogDatabase db() {
            return this.db;
        }

        public void db_$eq(CatalogDatabase x$1) {
            this.db = x$1;
        }

        public HashMap<String, TableDesc> tables() {
            return this.tables;
        }

        public HashMap<String, CatalogFunction> functions() {
            return this.functions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$DatabaseDesc$$$outer() {
            return this.$outer;
        }

        public DatabaseDesc(InMemoryCatalog $outer, CatalogDatabase db) {
            this.db = db;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.tables = new HashMap();
            this.functions = new HashMap();
        }
    }

    private class TableDesc {
        private CatalogTable table;
        private final HashMap<Map<String, String>, CatalogTablePartition> partitions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogTable table() {
            return this.table;
        }

        public void table_$eq(CatalogTable x$1) {
            this.table = x$1;
        }

        public HashMap<Map<String, String>, CatalogTablePartition> partitions() {
            return this.partitions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$TableDesc$$$outer() {
            return this.$outer;
        }

        public TableDesc(InMemoryCatalog $outer, CatalogTable table) {
            this.table = table;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.partitions = new HashMap();
        }
    }
}

