/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.remove;

import java.io.File;
import java.net.URI;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.remove.AbstractRemoveCommand;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.remove.GitRemoveConsumer;
import org.apache.maven.scm.provider.git.gitexe.command.status.GitStatusCommand;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitRemoveCommand
extends AbstractRemoveCommand
implements GitCommand {
    protected ScmResult executeRemoveCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message) throws ScmException {
        CommandLineUtils.StringStreamConsumer stderr;
        URI relativeRepositoryPath;
        GitRemoveConsumer consumer;
        if (fileSet.getFileList().isEmpty()) {
            throw new ScmException("You must provide at least one file/directory to remove");
        }
        Commandline cl = GitRemoveCommand.createCommandLine(fileSet.getBasedir(), fileSet.getFileList());
        int exitCode = GitCommandLineUtils.execute(cl, (StreamConsumer)(consumer = new GitRemoveConsumer(relativeRepositoryPath = GitStatusCommand.getRelativeCWD(this.logger, fileSet))), stderr = new CommandLineUtils.StringStreamConsumer());
        if (exitCode != 0) {
            return new RemoveScmResult(cl.toString(), "The git command failed.", stderr.getOutput(), false);
        }
        return new RemoveScmResult(cl.toString(), consumer.getRemovedFiles());
    }

    public static Commandline createCommandLine(File workingDirectory, List<File> files) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "rm");
        for (File file : files) {
            if (file.isAbsolute()) {
                if (!file.isDirectory()) continue;
                cl.createArg().setValue("-r");
                break;
            }
            File absFile = new File(workingDirectory, file.getPath());
            if (!absFile.isDirectory()) continue;
            cl.createArg().setValue("-r");
            break;
        }
        cl.createArg().setValue("--");
        GitCommandLineUtils.addTarget(cl, files);
        return cl;
    }
}

