/*
 * $Id$
 */

package org.apache.maven.plugin.registry;

/**
 * Root element of the plugin registry file.
 * 
 * @version $Revision$ $Date$
 */
public class PluginRegistry extends TrackableBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field updateInterval
     */
    private String updateInterval = "never";

    /**
     * Field autoUpdate
     */
    private String autoUpdate;

    /**
     * Field checkLatest
     */
    private String checkLatest;

    /**
     * Field plugins
     */
    private java.util.List plugins;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPlugin
     * 
     * @param plugin
     */
    public void addPlugin(Plugin plugin)
    {
        getPlugins().add( plugin );
    } //-- void addPlugin(Plugin) 

    /**
     * Get Specifies whether the user should be prompted to update
     * plugins.
     */
    public String getAutoUpdate()
    {
        return this.autoUpdate;
    } //-- String getAutoUpdate() 

    /**
     * Get Whether to resolve plugin versions using LATEST metadata.
     */
    public String getCheckLatest()
    {
        return this.checkLatest;
    } //-- String getCheckLatest() 

    /**
     * Method getPlugins
     */
    public java.util.List getPlugins()
    {
        if ( this.plugins == null )
        {
            this.plugins = new java.util.ArrayList();
        }
        
        return this.plugins;
    } //-- java.util.List getPlugins() 

    /**
     * Get 
     *             Specifies how often to check for plugin updates.
     * Valid values are: never, always, interval:XXX.
     *             For the interval specification, XXX denotes a
     * terse interval specification, such as 4h.
     *             Where h=hours, m=minutes, d=days, w=weeks. The
     * interval period should be specified in descending
     *             order of granularity, like this: '[n]w [n]d [n]h
     * [n]m'. Any omitted level of granularity will be
     *             assumed to be a zero value.
     *           
     */
    public String getUpdateInterval()
    {
        return this.updateInterval;
    } //-- String getUpdateInterval() 

    /**
     * Method removePlugin
     * 
     * @param plugin
     */
    public void removePlugin(Plugin plugin)
    {
        getPlugins().remove( plugin );
    } //-- void removePlugin(Plugin) 

    /**
     * Set Specifies whether the user should be prompted to update
     * plugins.
     * 
     * @param autoUpdate
     */
    public void setAutoUpdate(String autoUpdate)
    {
        this.autoUpdate = autoUpdate;
    } //-- void setAutoUpdate(String) 

    /**
     * Set Whether to resolve plugin versions using LATEST
     * metadata.
     * 
     * @param checkLatest
     */
    public void setCheckLatest(String checkLatest)
    {
        this.checkLatest = checkLatest;
    } //-- void setCheckLatest(String) 

    /**
     * Set Specified plugin update policy information.
     * 
     * @param plugins
     */
    public void setPlugins(java.util.List plugins)
    {
        this.plugins = plugins;
    } //-- void setPlugins(java.util.List) 

    /**
     * Set 
     *             Specifies how often to check for plugin updates.
     * Valid values are: never, always, interval:XXX.
     *             For the interval specification, XXX denotes a
     * terse interval specification, such as 4h.
     *             Where h=hours, m=minutes, d=days, w=weeks. The
     * interval period should be specified in descending
     *             order of granularity, like this: '[n]w [n]d [n]h
     * [n]m'. Any omitted level of granularity will be
     *             assumed to be a zero value.
     *           
     * 
     * @param updateInterval
     */
    public void setUpdateInterval(String updateInterval)
    {
        this.updateInterval = updateInterval;
    } //-- void setUpdateInterval(String) 


    private java.util.Map pluginsByKey;
    
    public java.util.Map getPluginsByKey()
    {
        if ( pluginsByKey == null )
        {
            pluginsByKey = new java.util.HashMap();
            
            for ( java.util.Iterator it = getPlugins().iterator(); it.hasNext(); )
            {
                Plugin plugin = (Plugin) it.next();
            
                pluginsByKey.put( plugin.getKey(), plugin );
            }
        }
        
        return pluginsByKey;
    }
    
    public void flushPluginsByKey()
    {
        this.pluginsByKey = null;
    }
    
    private RuntimeInfo runtimeInfo;
    
    public void setRuntimeInfo( RuntimeInfo runtimeInfo )
    {
        this.runtimeInfo = runtimeInfo;
    }
    
    public RuntimeInfo getRuntimeInfo()
    {
        return runtimeInfo;
    }
        
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
