/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         This elements describes all that pertains to
 * distribution for a project.
 *         It is primarily used for deployment of artifacts and the
 * site
 *         produced by the build.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class DistributionManagement implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field repository
     */
    private DeploymentRepository repository;

    /**
     * Field snapshotRepository
     */
    private DeploymentRepository snapshotRepository;

    /**
     * Field site
     */
    private Site site;

    /**
     * Field downloadUrl
     */
    private String downloadUrl;

    /**
     * Field relocation
     */
    private Relocation relocation;

    /**
     * Field status
     */
    private String status;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The URL of the project's download page. If not
     * given users will be referred to the homepage given by
     *             <code>url</code>. This is given to assist in
     * locating artifacts that are not in the repository due to
     *             licensing restrictions.
     *           
     */
    public String getDownloadUrl()
    {
        return this.downloadUrl;
    } //-- String getDownloadUrl() 

    /**
     * Get 
     *             Relocation information of the artifact if it has
     * been moved to a new group ID and/or artifact ID.
     *           
     */
    public Relocation getRelocation()
    {
        return this.relocation;
    } //-- Relocation getRelocation() 

    /**
     * Get 
     *             Information needed to deploy the artifacts
     * generated by the project to a remote repository.
     *           
     */
    public DeploymentRepository getRepository()
    {
        return this.repository;
    } //-- DeploymentRepository getRepository() 

    /**
     * Get 
     *             Information needed for deploying the web site of
     * the project.
     *           
     */
    public Site getSite()
    {
        return this.site;
    } //-- Site getSite() 

    /**
     * Get 
     *             Where to deploy snapshots of artifacts to. If
     * not given, it defaults to the <code>repository</code>
     * element.
     *           
     */
    public DeploymentRepository getSnapshotRepository()
    {
        return this.snapshotRepository;
    } //-- DeploymentRepository getSnapshotRepository() 

    /**
     * Get 
     *             Gives the status of this artifact in the remote
     * repository. This must not be set in your local
     *             project, as it is updated by tools placing it in
     * the reposiory. Valid values are: <code>none</code>
     * (default),
     *             <code>converted</code> (repository manager
     * converted this from an Maven 1 POM), <code>partner</code>
     *             (directly synced from a partner Maven 2
     * repository), <code>deployed</code> (was deployed from a
     * Maven 2
     *             instance), <code>verified</code> (has been hand
     * verified as correct and final).
     *           
     */
    public String getStatus()
    {
        return this.status;
    } //-- String getStatus() 

    /**
     * Set 
     *             The URL of the project's download page. If not
     * given users will be referred to the homepage given by
     *             <code>url</code>. This is given to assist in
     * locating artifacts that are not in the repository due to
     *             licensing restrictions.
     *           
     * 
     * @param downloadUrl
     */
    public void setDownloadUrl(String downloadUrl)
    {
        this.downloadUrl = downloadUrl;
    } //-- void setDownloadUrl(String) 

    /**
     * Set 
     *             Relocation information of the artifact if it has
     * been moved to a new group ID and/or artifact ID.
     *           
     * 
     * @param relocation
     */
    public void setRelocation(Relocation relocation)
    {
        this.relocation = relocation;
    } //-- void setRelocation(Relocation) 

    /**
     * Set 
     *             Information needed to deploy the artifacts
     * generated by the project to a remote repository.
     *           
     * 
     * @param repository
     */
    public void setRepository(DeploymentRepository repository)
    {
        this.repository = repository;
    } //-- void setRepository(DeploymentRepository) 

    /**
     * Set 
     *             Information needed for deploying the web site of
     * the project.
     *           
     * 
     * @param site
     */
    public void setSite(Site site)
    {
        this.site = site;
    } //-- void setSite(Site) 

    /**
     * Set 
     *             Where to deploy snapshots of artifacts to. If
     * not given, it defaults to the <code>repository</code>
     * element.
     *           
     * 
     * @param snapshotRepository
     */
    public void setSnapshotRepository(DeploymentRepository snapshotRepository)
    {
        this.snapshotRepository = snapshotRepository;
    } //-- void setSnapshotRepository(DeploymentRepository) 

    /**
     * Set 
     *             Gives the status of this artifact in the remote
     * repository. This must not be set in your local
     *             project, as it is updated by tools placing it in
     * the reposiory. Valid values are: <code>none</code>
     * (default),
     *             <code>converted</code> (repository manager
     * converted this from an Maven 1 POM), <code>partner</code>
     *             (directly synced from a partner Maven 2
     * repository), <code>deployed</code> (was deployed from a
     * Maven 2
     *             instance), <code>verified</code> (has been hand
     * verified as correct and final).
     *           
     * 
     * @param status
     */
    public void setStatus(String status)
    {
        this.status = status;
    } //-- void setStatus(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
