/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.RepositoryBase;
import org.apache.maven.api.model.RepositoryPolicy;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Repository
extends RepositoryBase
implements Serializable,
InputLocationTracker {
    final RepositoryPolicy releases;
    final RepositoryPolicy snapshots;
    final Map<Object, InputLocation> locations;

    protected Repository(Builder builder) {
        super(builder);
        RepositoryPolicy repositoryPolicy = builder.releases != null ? builder.releases : (this.releases = builder.base != null ? builder.base.releases : null);
        this.snapshots = builder.snapshots != null ? builder.snapshots : (builder.base != null ? builder.base.snapshots : null);
        Map newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<Object, InputLocation> mutableLocations = new HashMap<Object, InputLocation>(((RepositoryBase)this).locations);
        mutableLocations.put("releases", newlocs.containsKey("releases") ? (InputLocation)newlocs.get("releases") : (InputLocation)oldlocs.get("releases"));
        mutableLocations.put("snapshots", newlocs.containsKey("snapshots") ? (InputLocation)newlocs.get("snapshots") : (InputLocation)oldlocs.get("snapshots"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Repository)) {
            return false;
        }
        Repository that = (Repository)o;
        return Objects.equals(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id);
    }

    public RepositoryPolicy getReleases() {
        return this.releases;
    }

    public RepositoryPolicy getSnapshots() {
        return this.snapshots;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Override
    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Repository.newBuilder(this);
    }

    @Override
    @Nonnull
    public Repository withId(String id) {
        return Repository.newBuilder(this, true).id(id).build();
    }

    @Override
    @Nonnull
    public Repository withName(String name) {
        return Repository.newBuilder(this, true).name(name).build();
    }

    @Override
    @Nonnull
    public Repository withUrl(String url) {
        return Repository.newBuilder(this, true).url(url).build();
    }

    @Override
    @Nonnull
    public Repository withLayout(String layout) {
        return Repository.newBuilder(this, true).layout(layout).build();
    }

    @Nonnull
    public Repository withReleases(RepositoryPolicy releases) {
        return Repository.newBuilder(this, true).releases(releases).build();
    }

    @Nonnull
    public Repository withSnapshots(RepositoryPolicy snapshots) {
        return Repository.newBuilder(this, true).snapshots(snapshots).build();
    }

    @Nonnull
    public static Repository newInstance() {
        return Repository.newInstance(true);
    }

    @Nonnull
    public static Repository newInstance(boolean withDefaults) {
        return Repository.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Repository.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Repository from) {
        return Repository.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Repository from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends RepositoryBase.Builder {
        Repository base;
        RepositoryPolicy releases;
        RepositoryPolicy snapshots;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Repository base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.releases = base.releases;
                this.snapshots = base.snapshots;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        @Nonnull
        public Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Nonnull
        public Builder releases(RepositoryPolicy releases) {
            this.releases = releases;
            return this;
        }

        @Nonnull
        public Builder snapshots(RepositoryPolicy snapshots) {
            this.snapshots = snapshots;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public Repository build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.name != null && this.name != this.base.name || this.url != null && this.url != this.base.url || this.layout != null && this.layout != this.base.layout || this.releases != null && this.releases != this.base.releases || this.snapshots != null && this.snapshots != this.base.snapshots)) {
                return this.base;
            }
            return new Repository(this);
        }
    }
}

