/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginContainer;
import org.apache.maven.api.model.PluginManagement;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PluginConfiguration
extends PluginContainer
implements Serializable,
InputLocationTracker {
    final PluginManagement pluginManagement;
    final Map<Object, InputLocation> locations;

    protected PluginConfiguration(Builder builder) {
        super(builder);
        this.pluginManagement = builder.pluginManagement != null ? builder.pluginManagement : (builder.base != null ? builder.base.pluginManagement : null);
        Map newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<Object, InputLocation> mutableLocations = new HashMap<Object, InputLocation>(((PluginContainer)this).locations);
        mutableLocations.put("pluginManagement", newlocs.containsKey("pluginManagement") ? (InputLocation)newlocs.get("pluginManagement") : (InputLocation)oldlocs.get("pluginManagement"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public PluginManagement getPluginManagement() {
        return this.pluginManagement;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Override
    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    @Nonnull
    public Builder with() {
        return PluginConfiguration.newBuilder(this);
    }

    @Override
    @Nonnull
    public PluginConfiguration withPlugins(Collection<Plugin> plugins) {
        return ((Builder)PluginConfiguration.newBuilder(this, true).plugins((Collection)plugins)).build();
    }

    @Nonnull
    public PluginConfiguration withPluginManagement(PluginManagement pluginManagement) {
        return PluginConfiguration.newBuilder(this, true).pluginManagement(pluginManagement).build();
    }

    @Nonnull
    public static PluginConfiguration newInstance() {
        return PluginConfiguration.newInstance(true);
    }

    @Nonnull
    public static PluginConfiguration newInstance(boolean withDefaults) {
        return PluginConfiguration.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PluginConfiguration.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PluginConfiguration from) {
        return PluginConfiguration.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PluginConfiguration from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @Override
    public String toString() {
        return "PluginConfiguration {" + super.toString() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends PluginContainer.Builder {
        PluginConfiguration base;
        PluginManagement pluginManagement;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(PluginConfiguration base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.pluginManagement = base.pluginManagement;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Builder pluginManagement(PluginManagement pluginManagement) {
            this.pluginManagement = pluginManagement;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public PluginConfiguration build() {
            if (!(this.base == null || this.plugins != null && this.plugins != this.base.plugins || this.pluginManagement != null && this.pluginManagement != this.base.pluginManagement)) {
                return this.base;
            }
            return new PluginConfiguration(this);
        }
    }
}

