/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class License
implements Serializable,
InputLocationTracker {
    final String name;
    final String url;
    final String distribution;
    final String comments;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected License(Builder builder) {
        String string = builder.name != null ? builder.name : (this.name = builder.base != null ? builder.base.name : null);
        String string2 = builder.url != null ? builder.url : (this.url = builder.base != null ? builder.base.url : null);
        String string3 = builder.distribution != null ? builder.distribution : (this.distribution = builder.base != null ? builder.base.distribution : null);
        this.comments = builder.comments != null ? builder.comments : (builder.base != null ? builder.base.comments : null);
        Map<Object, Object> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<String, InputLocation> mutableLocations = new HashMap<String, InputLocation>();
        this.importedFrom = builder.importedFrom;
        mutableLocations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
        mutableLocations.put("name", newlocs.containsKey("name") ? (InputLocation)newlocs.get("name") : (InputLocation)oldlocs.get("name"));
        mutableLocations.put("url", newlocs.containsKey("url") ? (InputLocation)newlocs.get("url") : (InputLocation)oldlocs.get("url"));
        mutableLocations.put("distribution", newlocs.containsKey("distribution") ? (InputLocation)newlocs.get("distribution") : (InputLocation)oldlocs.get("distribution"));
        mutableLocations.put("comments", newlocs.containsKey("comments") ? (InputLocation)newlocs.get("comments") : (InputLocation)oldlocs.get("comments"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public String getComments() {
        return this.comments;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return License.newBuilder(this);
    }

    @Nonnull
    public License withName(String name) {
        return License.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public License withUrl(String url) {
        return License.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public License withDistribution(String distribution) {
        return License.newBuilder(this, true).distribution(distribution).build();
    }

    @Nonnull
    public License withComments(String comments) {
        return License.newBuilder(this, true).comments(comments).build();
    }

    @Nonnull
    public static License newInstance() {
        return License.newInstance(true);
    }

    @Nonnull
    public static License newInstance(boolean withDefaults) {
        return License.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return License.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(License from) {
        return License.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(License from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        return "License {name=" + this.getName() + ", url=" + this.getUrl() + "}";
    }

    @NotThreadSafe
    public static class Builder {
        License base;
        String name;
        String url;
        String distribution;
        String comments;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(License base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.url = base.url;
                this.distribution = base.distribution;
                this.comments = base.comments;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder distribution(String distribution) {
            this.distribution = distribution;
            return this;
        }

        @Nonnull
        public Builder comments(String comments) {
            this.comments = comments;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public License build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.url != null && this.url != this.base.url || this.distribution != null && this.distribution != this.base.distribution || this.comments != null && this.comments != this.base.comments)) {
                return this.base;
            }
            return new License(this);
        }
    }
}

