/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.nio.file.Path;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.model.PathTranslator;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.api.services.model.RootLocator;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

@Named
@Singleton
public class ProfileActivationFilePathInterpolator {
    private final PathTranslator pathTranslator;
    private final RootLocator rootLocator;

    @Inject
    public ProfileActivationFilePathInterpolator(PathTranslator pathTranslator, RootLocator rootLocator) {
        this.pathTranslator = pathTranslator;
        this.rootLocator = rootLocator;
    }

    public String interpolate(String path, ProfileActivationContext context) throws InterpolationException {
        if (path == null) {
            return null;
        }
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        final Path basedir = context.getProjectDirectory();
        if (basedir != null) {
            interpolator.addValueSource((ValueSource)new AbstractValueSource(false){

                public Object getValue(String expression) {
                    if ("basedir".equals(expression) || "project.basedir".equals(expression)) {
                        return basedir.toAbsolutePath().toString();
                    }
                    return null;
                }
            });
        } else if (path.contains("${basedir}")) {
            return null;
        }
        interpolator.addValueSource((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                if ("project.rootDirectory".equals(expression)) {
                    Path root = ProfileActivationFilePathInterpolator.this.rootLocator.findMandatoryRoot(basedir);
                    return root.toFile().getAbsolutePath();
                }
                return null;
            }
        });
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(context.getProjectProperties()));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(context.getUserProperties()));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(context.getSystemProperties()));
        String absolutePath = interpolator.interpolate(path, "");
        return this.pathTranslator.alignToBaseDirectory(absolutePath, basedir);
    }
}

