/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.logging.log4j.plugins.validation;

import java.lang.annotation.*;

/**
 * Meta annotation to mark an annotation as a validation constraint. This annotation must specify a
 * {@link ConstraintValidator} implementation class that has a default constructor.
 *
 * @since 2.1
 */
@Documented
@Target(ElementType.ANNOTATION_TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Constraint {

    /**
     * {@link ConstraintValidator} class that implements the validation logic for the annotated constraint annotation.
     * @return the class that implements the validation logic.
     */
    Class<? extends ConstraintValidator<? extends Annotation>> value();
}
