/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public final class TypeUtil {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_BOXED_TYPES = Map.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class);

    private TypeUtil() {
    }

    public static boolean isAssignable(Type lhs, Type rhs) {
        Objects.requireNonNull(lhs, "No left hand side type provided");
        Objects.requireNonNull(rhs, "No right hand side type provided");
        if (lhs.equals(rhs)) {
            return true;
        }
        if (Object.class.equals((Object)lhs)) {
            return true;
        }
        if (lhs instanceof Class) {
            Class lhsClass = (Class)lhs;
            if (rhs instanceof Class) {
                Class rhsClass = (Class)rhs;
                return TypeUtil.isAssignable(lhsClass, rhsClass);
            }
            if (rhs instanceof ParameterizedType) {
                return TypeUtil.isAssignable(lhsClass, TypeUtil.getRawType(rhs));
            }
            if (lhsClass.isArray() && rhs instanceof GenericArrayType) {
                return TypeUtil.isAssignable(lhsClass.getComponentType(), ((GenericArrayType)rhs).getGenericComponentType());
            }
            if (rhs instanceof TypeVariable) {
                for (Type bound : ((TypeVariable)rhs).getBounds()) {
                    if (!TypeUtil.isAssignable(lhs, bound)) continue;
                    return true;
                }
            } else {
                return false;
            }
        }
        if (lhs instanceof ParameterizedType) {
            ParameterizedType lhsType = (ParameterizedType)lhs;
            if (rhs instanceof Class) {
                return TypeUtil.isAssignable(TypeUtil.getRawType(lhs), (Class)rhs);
            }
            if (rhs instanceof ParameterizedType) {
                Type[] rhsType = (Type[])rhs;
                return TypeUtil.isParameterizedAssignable(lhsType, (ParameterizedType)rhsType);
            }
            if (rhs instanceof TypeVariable) {
                for (Type bound : ((TypeVariable)rhs).getBounds()) {
                    if (!TypeUtil.isAssignable(lhsType, bound)) continue;
                    return true;
                }
            } else {
                return false;
            }
        }
        if (lhs instanceof GenericArrayType) {
            Type lhsComponentType = ((GenericArrayType)lhs).getGenericComponentType();
            if (rhs instanceof Class) {
                Type[] rhsClass = (Type[])rhs;
                if (rhsClass.isArray()) {
                    return TypeUtil.isAssignable(lhsComponentType, rhsClass.getComponentType());
                }
            } else if (rhs instanceof GenericArrayType) {
                return TypeUtil.isAssignable(lhsComponentType, ((GenericArrayType)rhs).getGenericComponentType());
            }
        }
        if (lhs instanceof WildcardType) {
            return TypeUtil.isWildcardAssignable((WildcardType)lhs, rhs);
        }
        return false;
    }

    private static boolean isAssignable(Class<?> lhs, Class<?> rhs) {
        return TypeUtil.getReferenceType(lhs).isAssignableFrom(TypeUtil.getReferenceType(rhs));
    }

    private static boolean isParameterizedAssignable(ParameterizedType lhs, ParameterizedType rhs) {
        int size;
        if (lhs.equals(rhs)) {
            return true;
        }
        Type[] lhsTypeArguments = lhs.getActualTypeArguments();
        Type[] rhsTypeArguments = rhs.getActualTypeArguments();
        if (rhsTypeArguments.length != (size = lhsTypeArguments.length)) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Type lhsArgument = lhsTypeArguments[i];
            Type rhsArgument = rhsTypeArguments[i];
            if (lhsArgument.equals(rhsArgument) || lhsArgument instanceof WildcardType && TypeUtil.isWildcardAssignable((WildcardType)lhsArgument, rhsArgument)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWildcardAssignable(WildcardType lhs, Type rhs) {
        Type[] lhsUpperBounds = TypeUtil.getEffectiveUpperBounds(lhs);
        Type[] lhsLowerBounds = TypeUtil.getEffectiveLowerBounds(lhs);
        if (rhs instanceof WildcardType) {
            WildcardType rhsType = (WildcardType)rhs;
            Type[] rhsUpperBounds = TypeUtil.getEffectiveUpperBounds(rhsType);
            Type[] rhsLowerBounds = TypeUtil.getEffectiveLowerBounds(rhsType);
            for (Type lhsUpperBound : lhsUpperBounds) {
                for (Type rhsUpperBound : rhsUpperBounds) {
                    if (TypeUtil.isBoundAssignable(lhsUpperBound, rhsUpperBound)) continue;
                    return false;
                }
                for (Type rhsLowerBound : rhsLowerBounds) {
                    if (TypeUtil.isBoundAssignable(lhsUpperBound, rhsLowerBound)) continue;
                    return false;
                }
            }
            for (Type lhsLowerBound : lhsLowerBounds) {
                for (Type rhsUpperBound : rhsUpperBounds) {
                    if (TypeUtil.isBoundAssignable(rhsUpperBound, lhsLowerBound)) continue;
                    return false;
                }
                for (Type rhsLowerBound : rhsLowerBounds) {
                    if (TypeUtil.isBoundAssignable(rhsLowerBound, lhsLowerBound)) continue;
                    return false;
                }
            }
        } else {
            for (Type lhsUpperBound : lhsUpperBounds) {
                if (TypeUtil.isBoundAssignable(lhsUpperBound, rhs)) continue;
                return false;
            }
            for (Type lhsLowerBound : lhsLowerBounds) {
                if (TypeUtil.isBoundAssignable(lhsLowerBound, rhs)) continue;
                return false;
            }
        }
        return true;
    }

    private static Type[] getEffectiveUpperBounds(WildcardType type) {
        Type[] typeArray;
        Type[] upperBounds = type.getUpperBounds();
        if (upperBounds.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = Object.class;
        } else {
            typeArray = upperBounds;
        }
        return typeArray;
    }

    private static Type[] getEffectiveLowerBounds(WildcardType type) {
        Type[] typeArray;
        Type[] lowerBounds = type.getLowerBounds();
        if (lowerBounds.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = null;
        } else {
            typeArray = lowerBounds;
        }
        return typeArray;
    }

    private static boolean isBoundAssignable(Type lhs, Type rhs) {
        return rhs == null || lhs != null && TypeUtil.isAssignable(lhs, rhs);
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtil.getRawType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(TypeUtil.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof WildcardType) {
            Type[] bounds = ((WildcardType)type).getUpperBounds();
            return bounds.length > 0 ? TypeUtil.getRawType(bounds[0]) : Object.class;
        }
        if (type instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)type).getBounds();
            return bounds.length > 0 ? TypeUtil.getRawType(bounds[0]) : Object.class;
        }
        return Object.class;
    }

    public static Class<?> getReferenceType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return PRIMITIVE_BOXED_TYPES.get(clazz);
        }
        return clazz;
    }

    public static Type getSuperclassTypeParameter(Class<?> type) {
        Type genericSuperclass = type.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            return ((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
        }
        throw new IllegalArgumentException(type + " does not have type parameters");
    }

    public static boolean isEqual(Type first, Type second) {
        if (first == second) {
            return true;
        }
        if (first instanceof Class) {
            return first.equals(second);
        }
        if (first instanceof ParameterizedType) {
            if (!(second instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType firstType = (ParameterizedType)first;
            ParameterizedType secondType = (ParameterizedType)second;
            return Objects.equals(firstType.getOwnerType(), secondType.getOwnerType()) && firstType.getRawType().equals(secondType.getRawType()) && Arrays.equals(firstType.getActualTypeArguments(), secondType.getActualTypeArguments());
        }
        if (first instanceof GenericArrayType) {
            if (!(second instanceof GenericArrayType)) {
                return false;
            }
            return TypeUtil.isEqual(((GenericArrayType)first).getGenericComponentType(), ((GenericArrayType)second).getGenericComponentType());
        }
        if (first instanceof WildcardType) {
            if (!(second instanceof WildcardType)) {
                return false;
            }
            WildcardType firstType = (WildcardType)first;
            WildcardType secondType = (WildcardType)second;
            return Arrays.equals(firstType.getUpperBounds(), secondType.getUpperBounds()) && Arrays.equals(firstType.getLowerBounds(), secondType.getLowerBounds());
        }
        if (first instanceof TypeVariable) {
            if (!(second instanceof TypeVariable)) {
                return false;
            }
            TypeVariable firstType = (TypeVariable)first;
            TypeVariable secondType = (TypeVariable)second;
            return firstType.getName().equals(secondType.getName()) && firstType.getGenericDeclaration().equals(secondType.getGenericDeclaration());
        }
        return false;
    }
}

