/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.junit.UsingThreadContextMap;
import org.apache.logging.log4j.spi.DefaultThreadContextMap;
import org.apache.logging.log4j.spi.ThreadContextMapFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

@UsingThreadContextMap
public class DefaultThreadContextMapTest {
    @Test
    public void testEqualsVsSameKind() {
        DefaultThreadContextMap map1 = this.createMap();
        DefaultThreadContextMap map2 = this.createMap();
        Assertions.assertEquals((Object)map1, (Object)map1);
        Assertions.assertEquals((Object)map2, (Object)map2);
        Assertions.assertEquals((Object)map1, (Object)map2);
        Assertions.assertEquals((Object)map2, (Object)map1);
    }

    @Test
    public void testHashCodeVsSameKind() {
        DefaultThreadContextMap map1 = this.createMap();
        DefaultThreadContextMap map2 = this.createMap();
        Assertions.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
    }

    @Test
    public void testDoesNothingIfConstructedWithUseMapIsFalse() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(false);
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertFalse((boolean)map.containsKey("key"));
        map.put("key", "value");
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertFalse((boolean)map.containsKey("key"));
        Assertions.assertNull((Object)map.get("key"));
    }

    @Test
    public void testPut() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertFalse((boolean)map.containsKey("key"));
        map.put("key", "value");
        Assertions.assertFalse((boolean)map.isEmpty());
        Assertions.assertTrue((boolean)map.containsKey("key"));
        Assertions.assertEquals((Object)"value", (Object)map.get("key"));
    }

    @Test
    public void testPutAll() {
        int i;
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertFalse((boolean)map.containsKey("key"));
        int mapSize = 10;
        HashMap<String, String> newMap = new HashMap<String, String>(10);
        for (i = 1; i <= 10; ++i) {
            newMap.put("key" + i, "value" + i);
        }
        map.putAll(newMap);
        Assertions.assertFalse((boolean)map.isEmpty());
        for (i = 1; i <= 10; ++i) {
            Assertions.assertTrue((boolean)map.containsKey("key" + i));
            Assertions.assertEquals((Object)("value" + i), (Object)map.get("key" + i));
        }
    }

    @Test
    public void testRemove() {
        DefaultThreadContextMap map = this.createMap();
        Assertions.assertEquals((Object)"value", (Object)map.get("key"));
        Assertions.assertEquals((Object)"value2", (Object)map.get("key2"));
        map.remove("key");
        Assertions.assertFalse((boolean)map.containsKey("key"));
        Assertions.assertEquals((Object)"value2", (Object)map.get("key2"));
    }

    @Test
    public void testClear() {
        DefaultThreadContextMap map = this.createMap();
        map.clear();
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertFalse((boolean)map.containsKey("key"));
        Assertions.assertFalse((boolean)map.containsKey("key2"));
    }

    private DefaultThreadContextMap createMap() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        Assertions.assertTrue((boolean)map.isEmpty());
        map.put("key", "value");
        map.put("key2", "value2");
        Assertions.assertEquals((Object)"value", (Object)map.get("key"));
        Assertions.assertEquals((Object)"value2", (Object)map.get("key2"));
        return map;
    }

    @Test
    public void testGetCopyReturnsMutableMap() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        Assertions.assertTrue((boolean)map.isEmpty());
        Map copy = map.getCopy();
        Assertions.assertTrue((boolean)copy.isEmpty());
        copy.put("key", "value");
        Assertions.assertEquals((Object)"value", copy.get("key"));
        Assertions.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testGetCopyReturnsMutableCopy() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        map.put("key1", "value1");
        Assertions.assertFalse((boolean)map.isEmpty());
        Map copy = map.getCopy();
        Assertions.assertEquals((Object)"value1", copy.get("key1"));
        copy.put("key", "value");
        Assertions.assertEquals((Object)"value", copy.get("key"));
        Assertions.assertFalse((boolean)map.containsKey("key"));
        map.clear();
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertFalse((boolean)copy.isEmpty());
    }

    @Test
    public void testGetImmutableMapReturnsNullIfEmpty() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertNull((Object)map.getImmutableMapOrNull());
    }

    @Test
    public void testGetImmutableMapReturnsImmutableMapIfNonEmpty() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        map.put("key1", "value1");
        Assertions.assertFalse((boolean)map.isEmpty());
        Map immutable = map.getImmutableMapOrNull();
        Assertions.assertEquals((Object)"value1", immutable.get("key1"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> immutable.put("key", "value"));
    }

    @Test
    public void testGetImmutableMapCopyNotAffectdByContextMapChanges() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        map.put("key1", "value1");
        Assertions.assertFalse((boolean)map.isEmpty());
        Map immutable = map.getImmutableMapOrNull();
        Assertions.assertEquals((Object)"value1", immutable.get("key1"));
        map.clear();
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertFalse((boolean)immutable.isEmpty());
    }

    @Test
    public void testToStringShowsMapContext() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        Assertions.assertEquals((Object)"{}", (Object)map.toString());
        map.put("key1", "value1");
        Assertions.assertEquals((Object)"{key1=value1}", (Object)map.toString());
        map.remove("key1");
        map.put("key2", "value2");
        Assertions.assertEquals((Object)"{key2=value2}", (Object)map.toString());
    }

    @Test
    @ResourceLock(value="java.lang.System.properties")
    public void testThreadLocalNotInheritableByDefault() {
        System.clearProperty("isThreadContextMapInheritable");
        ThreadLocal threadLocal = DefaultThreadContextMap.createThreadLocalMap((boolean)true);
        Assertions.assertFalse((boolean)(threadLocal instanceof InheritableThreadLocal));
    }

    @Test
    @ResourceLock(value="java.lang.System.properties")
    public void testThreadLocalInheritableIfConfigured() {
        System.setProperty("isThreadContextMapInheritable", "true");
        ThreadContextMapFactory.init();
        try {
            ThreadLocal threadLocal = DefaultThreadContextMap.createThreadLocalMap((boolean)true);
            Assertions.assertTrue((boolean)(threadLocal instanceof InheritableThreadLocal));
        }
        finally {
            System.clearProperty("isThreadContextMapInheritable");
        }
    }
}

