/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.io.Closeable;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.spi.LoggerContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceAccessMode;
import org.junit.jupiter.api.parallel.ResourceLock;

@ResourceLock(value="log4j2.LoggerContextFactory", mode=ResourceAccessMode.READ)
public class LogManagerTest {
    @Test
    public void testGetLogger() {
        Logger logger = LogManager.getLogger();
        Assertions.assertNotNull((Object)logger, (String)"No Logger returned");
        Assertions.assertEquals((Object)LogManagerTest.class.getName(), (Object)logger.getName(), (String)("Incorrect Logger name: " + logger.getName()));
        logger = LogManager.getLogger((MessageFactory)ParameterizedMessageFactory.INSTANCE);
        Assertions.assertNotNull((Object)logger, (String)"No Logger returned");
        Assertions.assertEquals((Object)LogManagerTest.class.getName(), (Object)logger.getName(), (String)("Incorrect Logger name: " + logger.getName()));
        logger = LogManager.getLogger((Class)null);
        Assertions.assertNotNull((Object)logger, (String)"No Logger returned");
        Assertions.assertEquals((Object)LogManagerTest.class.getName(), (Object)logger.getName(), (String)("Incorrect Logger name: " + logger.getName()));
        logger = LogManager.getLogger((Class)null, (MessageFactory)ParameterizedMessageFactory.INSTANCE);
        Assertions.assertNotNull((Object)logger, (String)"No Logger returned");
        Assertions.assertEquals((Object)LogManagerTest.class.getName(), (Object)logger.getName(), (String)("Incorrect Logger name: " + logger.getName()));
        logger = LogManager.getLogger((String)null);
        Assertions.assertNotNull((Object)logger, (String)"No Logger returned");
        Assertions.assertEquals((Object)LogManagerTest.class.getName(), (Object)logger.getName(), (String)("Incorrect Logger name: " + logger.getName()));
        logger = LogManager.getLogger((String)null, (MessageFactory)ParameterizedMessageFactory.INSTANCE);
        Assertions.assertNotNull((Object)logger, (String)"No Logger returned");
        Assertions.assertEquals((Object)LogManagerTest.class.getName(), (Object)logger.getName(), (String)("Incorrect Logger name: " + logger.getName()));
        logger = LogManager.getLogger(null);
        Assertions.assertNotNull((Object)logger, (String)"No Logger returned");
        Assertions.assertEquals((Object)LogManagerTest.class.getName(), (Object)logger.getName(), (String)("Incorrect Logger name: " + logger.getName()));
        logger = LogManager.getLogger(null, (MessageFactory)ParameterizedMessageFactory.INSTANCE);
        Assertions.assertNotNull((Object)logger, (String)"No Logger returned");
        Assertions.assertEquals((Object)LogManagerTest.class.getName(), (Object)logger.getName(), (String)("Incorrect Logger name: " + logger.getName()));
    }

    @Test
    public void testGetLoggerForAnonymousInnerClass1() throws IOException {
        Closeable closeable = new Closeable(){
            final Logger LOGGER = LogManager.getLogger();

            @Override
            public void close() throws IOException {
                Assertions.assertEquals((Object)"org.apache.logging.log4j.LogManagerTest$1", (Object)this.LOGGER.getName());
            }
        };
        closeable.close();
    }

    @Test
    public void testGetLoggerForAnonymousInnerClass2() throws IOException {
        Closeable closeable = new Closeable(){
            final Logger LOGGER = LogManager.getLogger(this.getClass());

            @Override
            public void close() throws IOException {
                Assertions.assertEquals((Object)"org.apache.logging.log4j.LogManagerTest$2", (Object)this.LOGGER.getName());
            }
        };
        closeable.close();
    }

    @Test
    public void testGetLoggerForInner() {
        Assertions.assertEquals((Object)"org.apache.logging.log4j.LogManagerTest.Inner", (Object)(LogManagerTest)this.new Inner().LOGGER.getName());
    }

    @Test
    public void testGetLoggerForInnerByClass() {
        Assertions.assertEquals((Object)"org.apache.logging.log4j.LogManagerTest.InnerByClass", (Object)(LogManagerTest)this.new InnerByClass().LOGGER.getName());
    }

    @Test
    public void testGetLoggerForStaticInner() {
        Assertions.assertEquals((Object)"org.apache.logging.log4j.LogManagerTest.StaticInner", (Object)StaticInner.LOGGER.getName());
    }

    @Test
    public void testGetLoggerForStaticInnerByClass() {
        Assertions.assertEquals((Object)"org.apache.logging.log4j.LogManagerTest.StaticInnerByClass", (Object)StaticInnerByClass.LOGGER.getName());
    }

    @Test
    public void testShutdown() {
        LoggerContext loggerContext = LogManager.getContext((boolean)false);
    }

    static class StaticInnerByClass {
        static final Logger LOGGER = LogManager.getLogger(StaticInnerByClass.class);

        StaticInnerByClass() {
        }
    }

    static class StaticInner {
        static final Logger LOGGER = LogManager.getLogger();

        StaticInner() {
        }
    }

    class InnerByClass {
        final Logger LOGGER = LogManager.getLogger(InnerByClass.class);

        InnerByClass() {
        }
    }

    class Inner {
        final Logger LOGGER = LogManager.getLogger();

        Inner() {
        }
    }
}

