/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.parser.ASTNot;
import org.apache.cayenne.exp.parser.ConditionNode;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.commons.collections.Transformer;

public abstract class AggregateConditionNode
extends SimpleNode {
    private static final long serialVersionUID = -636699350691988809L;

    AggregateConditionNode(int i) {
        super(i);
    }

    @Override
    protected boolean pruneNodeForPrunedChild(Object prunedChild) {
        return false;
    }

    @Override
    protected Object transformExpression(Transformer transformer) {
        Object transformed = super.transformExpression(transformer);
        if (!(transformed instanceof AggregateConditionNode)) {
            return transformed;
        }
        AggregateConditionNode condition = (AggregateConditionNode)transformed;
        switch (condition.getOperandCount()) {
            case 1: {
                if (condition instanceof ASTNot) {
                    return condition;
                }
                return condition.getOperand(0);
            }
            case 0: {
                return PRUNED_NODE;
            }
        }
        return condition;
    }

    @Override
    public void jjtSetParent(Node n) {
        if (!(n instanceof AggregateConditionNode)) {
            String label = n instanceof SimpleNode ? ((SimpleNode)n).expName() : String.valueOf(n);
            throw new ExpressionException(this.expName() + ": invalid parent - " + label, new Object[0]);
        }
        super.jjtSetParent(n);
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (!(n instanceof ConditionNode) && !(n instanceof AggregateConditionNode)) {
            String label = n instanceof SimpleNode ? ((SimpleNode)n).expName() : String.valueOf(n);
            throw new ExpressionException(this.expName() + ": invalid child - " + label, new Object[0]);
        }
        super.jjtAddChild(n, i);
    }
}

