/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;

class ColumnFamilyStoreMBeanIterator
implements Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> {
    private Iterator<ObjectName> resIter;
    private MBeanServerConnection mbeanServerConn;

    public ColumnFamilyStoreMBeanIterator(MBeanServerConnection mbeanServerConn) throws MalformedObjectNameException, NullPointerException, IOException {
        ObjectName query = new ObjectName("org.apache.cassandra.db:type=ColumnFamilies,*");
        this.resIter = mbeanServerConn.queryNames(query, null).iterator();
        this.mbeanServerConn = mbeanServerConn;
    }

    @Override
    public boolean hasNext() {
        return this.resIter.hasNext();
    }

    @Override
    public Map.Entry<String, ColumnFamilyStoreMBean> next() {
        ObjectName objectName = this.resIter.next();
        String tableName = objectName.getKeyProperty("keyspace");
        ColumnFamilyStoreMBean cfsProxy = JMX.newMBeanProxy(this.mbeanServerConn, objectName, ColumnFamilyStoreMBean.class);
        return new AbstractMap.SimpleImmutableEntry<String, ColumnFamilyStoreMBean>(tableName, cfsProxy);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

