/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.thrift.ConsistencyLevel;

class CounterMutationSerializer
implements ICompactSerializer<CounterMutation> {
    CounterMutationSerializer() {
    }

    @Override
    public void serialize(CounterMutation cm, DataOutputStream dos, int version) throws IOException {
        RowMutation.serializer().serialize(cm.rowMutation(), dos, version);
        dos.writeUTF(cm.consistency().name());
    }

    @Override
    public CounterMutation deserialize(DataInputStream dis, int version) throws IOException {
        RowMutation rm = RowMutation.serializer().deserialize(dis, version);
        ConsistencyLevel consistency = Enum.valueOf(ConsistencyLevel.class, dis.readUTF());
        return new CounterMutation(rm, consistency);
    }
}

