/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.ht;

import java.io.Serializable;
import weka.classifiers.trees.ht.Split;
import weka.core.Attribute;
import weka.core.Instance;

public class UnivariateNumericBinarySplit
extends Split
implements Serializable {
    private static final long serialVersionUID = -7392204582942741097L;
    protected double m_splitPoint;

    public UnivariateNumericBinarySplit(String attName, double splitPoint) {
        this.m_splitAttNames.add(attName);
        this.m_splitPoint = splitPoint;
    }

    @Override
    public String branchForInstance(Instance inst) {
        Attribute att = inst.dataset().attribute((String)this.m_splitAttNames.get(0));
        if (att == null || inst.isMissing(att)) {
            return null;
        }
        if (inst.value(att) <= this.m_splitPoint) {
            return "left";
        }
        return "right";
    }

    @Override
    public String conditionForBranch(String branch) {
        String result = (String)this.m_splitAttNames.get(0);
        result = branch.equalsIgnoreCase("left") ? result + " <= " : result + " > ";
        result = result + String.format("%-9.3f", this.m_splitPoint);
        return result;
    }
}

