/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.util;

import java.io.File;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import no.finn.unleash.CustomHttpHeadersProvider;
import no.finn.unleash.DefaultCustomHttpHeadersProviderImpl;
import no.finn.unleash.DefaultUnleash;
import no.finn.unleash.UnleashContextProvider;
import no.finn.unleash.event.NoOpSubscriber;
import no.finn.unleash.event.UnleashSubscriber;
import no.finn.unleash.lang.Nullable;
import no.finn.unleash.repository.ToggleBootstrapProvider;
import no.finn.unleash.strategy.Strategy;
import no.finn.unleash.util.UnleashScheduledExecutor;
import no.finn.unleash.util.UnleashScheduledExecutorImpl;
import no.finn.unleash.util.UnleashURLs;

public class UnleashConfig {
    static final String UNLEASH_APP_NAME_HEADER = "UNLEASH-APPNAME";
    static final String UNLEASH_INSTANCE_ID_HEADER = "UNLEASH-INSTANCEID";
    private final URI unleashAPI;
    private final UnleashURLs unleashURLs;
    private final Map<String, String> customHttpHeaders;
    private final CustomHttpHeadersProvider customHttpHeadersProvider;
    private final String appName;
    private final String environment;
    private final String instanceId;
    private final String sdkVersion;
    private final String backupFile;
    @Nullable
    private final String projectName;
    @Nullable
    private final String namePrefix;
    private final long fetchTogglesInterval;
    private final long sendMetricsInterval;
    private final boolean disableMetrics;
    private final boolean isProxyAuthenticationByJvmProperties;
    private final UnleashContextProvider contextProvider;
    private final boolean synchronousFetchOnInitialisation;
    private final UnleashScheduledExecutor unleashScheduledExecutor;
    private final UnleashSubscriber unleashSubscriber;
    @Nullable
    private final Strategy fallbackStrategy;
    @Nullable
    private final ToggleBootstrapProvider toggleBootstrapProvider;
    @Nullable
    private final Proxy proxy;

    private UnleashConfig(@Nullable URI unleashAPI, Map<String, String> customHttpHeaders, CustomHttpHeadersProvider customHttpHeadersProvider, @Nullable String appName, String environment, @Nullable String instanceId, String sdkVersion, String backupFile, @Nullable String projectName, @Nullable String namePrefix, long fetchTogglesInterval, long sendMetricsInterval, boolean disableMetrics, UnleashContextProvider contextProvider, boolean isProxyAuthenticationByJvmProperties, boolean synchronousFetchOnInitialisation, @Nullable UnleashScheduledExecutor unleashScheduledExecutor, @Nullable UnleashSubscriber unleashSubscriber, @Nullable Strategy fallbackStrategy, @Nullable ToggleBootstrapProvider unleashBootstrapProvider, @Nullable Proxy proxy, @Nullable Authenticator proxyAuthenticator) {
        if (appName == null) {
            throw new IllegalStateException("You are required to specify the unleash appName");
        }
        if (instanceId == null) {
            throw new IllegalStateException("You are required to specify the unleash instanceId");
        }
        if (unleashAPI == null) {
            throw new IllegalStateException("You are required to specify the unleashAPI url");
        }
        if (unleashScheduledExecutor == null) {
            throw new IllegalStateException("You are required to specify a scheduler");
        }
        if (unleashSubscriber == null) {
            throw new IllegalStateException("You are required to specify a subscriber");
        }
        this.fallbackStrategy = fallbackStrategy == null ? DefaultUnleash.UNKNOWN_STRATEGY : fallbackStrategy;
        if (isProxyAuthenticationByJvmProperties && proxyAuthenticator == null) {
            this.enableProxyAuthentication();
        } else if (proxyAuthenticator != null) {
            Authenticator.setDefault(proxyAuthenticator);
        }
        this.unleashAPI = unleashAPI;
        this.customHttpHeaders = customHttpHeaders;
        this.customHttpHeadersProvider = customHttpHeadersProvider;
        this.unleashURLs = new UnleashURLs(unleashAPI);
        this.appName = appName;
        this.environment = environment;
        this.instanceId = instanceId;
        this.sdkVersion = sdkVersion;
        this.backupFile = backupFile;
        this.projectName = projectName;
        this.namePrefix = namePrefix;
        this.fetchTogglesInterval = fetchTogglesInterval;
        this.sendMetricsInterval = sendMetricsInterval;
        this.disableMetrics = disableMetrics;
        this.contextProvider = contextProvider;
        this.isProxyAuthenticationByJvmProperties = isProxyAuthenticationByJvmProperties;
        this.synchronousFetchOnInitialisation = synchronousFetchOnInitialisation;
        this.unleashScheduledExecutor = unleashScheduledExecutor;
        this.unleashSubscriber = unleashSubscriber;
        this.toggleBootstrapProvider = unleashBootstrapProvider;
        this.proxy = proxy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void setRequestProperties(HttpURLConnection connection, UnleashConfig config) {
        connection.setRequestProperty(UNLEASH_APP_NAME_HEADER, config.getAppName());
        connection.setRequestProperty(UNLEASH_INSTANCE_ID_HEADER, config.getInstanceId());
        connection.setRequestProperty("User-Agent", config.getAppName());
        config.getCustomHttpHeaders().forEach(connection::setRequestProperty);
        config.customHttpHeadersProvider.getCustomHeaders().forEach(connection::setRequestProperty);
    }

    private void enableProxyAuthentication() {
        Authenticator.setDefault(new SystemProxyAuthenticator());
    }

    public URI getUnleashAPI() {
        return this.unleashAPI;
    }

    public Map<String, String> getCustomHttpHeaders() {
        return this.customHttpHeaders;
    }

    public CustomHttpHeadersProvider getCustomHttpHeadersProvider() {
        return this.customHttpHeadersProvider;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    @Nullable
    public String getProjectName() {
        return this.projectName;
    }

    public long getFetchTogglesInterval() {
        return this.fetchTogglesInterval;
    }

    public long getSendMetricsInterval() {
        return this.sendMetricsInterval;
    }

    public UnleashURLs getUnleashURLs() {
        return this.unleashURLs;
    }

    public boolean isDisableMetrics() {
        return this.disableMetrics;
    }

    public String getBackupFile() {
        return this.backupFile;
    }

    public boolean isSynchronousFetchOnInitialisation() {
        return this.synchronousFetchOnInitialisation;
    }

    public UnleashContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public UnleashScheduledExecutor getScheduledExecutor() {
        return this.unleashScheduledExecutor;
    }

    public UnleashSubscriber getSubscriber() {
        return this.unleashSubscriber;
    }

    public boolean isProxyAuthenticationByJvmProperties() {
        return this.isProxyAuthenticationByJvmProperties;
    }

    @Nullable
    public Strategy getFallbackStrategy() {
        return this.fallbackStrategy;
    }

    @Nullable
    public ToggleBootstrapProvider getToggleBootstrapProvider() {
        return this.toggleBootstrapProvider;
    }

    @Nullable
    public String getNamePrefix() {
        return this.namePrefix;
    }

    @Nullable
    public Proxy getProxy() {
        return this.proxy;
    }

    public static class Builder {
        @Nullable
        private URI unleashAPI;
        private Map<String, String> customHttpHeaders = new HashMap<String, String>();
        private CustomHttpHeadersProvider customHttpHeadersProvider = new DefaultCustomHttpHeadersProviderImpl();
        @Nullable
        private String appName;
        private String environment = "default";
        private String instanceId = Builder.getDefaultInstanceId();
        private final String sdkVersion = this.getDefaultSdkVersion();
        @Nullable
        private String backupFile;
        @Nullable
        private String projectName;
        @Nullable
        private String namePrefix;
        private long fetchTogglesInterval = 10L;
        private long sendMetricsInterval = 60L;
        private boolean disableMetrics = false;
        private UnleashContextProvider contextProvider = UnleashContextProvider.getDefaultProvider();
        private boolean synchronousFetchOnInitialisation = false;
        @Nullable
        private UnleashScheduledExecutor scheduledExecutor;
        @Nullable
        private UnleashSubscriber unleashSubscriber;
        private boolean isProxyAuthenticationByJvmProperties;
        @Nullable
        private Strategy fallbackStrategy;
        @Nullable
        private ToggleBootstrapProvider toggleBootstrapProvider;
        @Nullable
        private Proxy proxy;
        @Nullable
        private Authenticator proxyAuthenticator;

        private static String getHostname() {
            String hostName = System.getProperty("hostname");
            if (hostName == null || hostName.length() == 0) {
                try {
                    hostName = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            return hostName + "-";
        }

        static String getDefaultInstanceId() {
            return Builder.getHostname() + "generated-" + Math.round(Math.random() * 1000000.0);
        }

        public Builder unleashAPI(URI unleashAPI) {
            this.unleashAPI = unleashAPI;
            return this;
        }

        public Builder unleashAPI(String unleashAPI) {
            this.unleashAPI = URI.create(unleashAPI);
            return this;
        }

        public Builder customHttpHeader(String name, String value) {
            this.customHttpHeaders.put(name, value);
            return this;
        }

        public Builder customHttpHeadersProvider(CustomHttpHeadersProvider provider) {
            this.customHttpHeadersProvider = provider;
            return this;
        }

        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public Builder fetchTogglesInterval(long fetchTogglesInterval) {
            this.fetchTogglesInterval = fetchTogglesInterval;
            return this;
        }

        public Builder sendMetricsInterval(long sendMetricsInterval) {
            this.sendMetricsInterval = sendMetricsInterval;
            return this;
        }

        public Builder disableMetrics() {
            this.disableMetrics = true;
            return this;
        }

        public Builder backupFile(String backupFile) {
            this.backupFile = backupFile;
            return this;
        }

        public Builder enableProxyAuthenticationByJvmProperties() {
            this.isProxyAuthenticationByJvmProperties = true;
            return this;
        }

        public Builder unleashContextProvider(UnleashContextProvider contextProvider) {
            this.contextProvider = contextProvider;
            return this;
        }

        public Builder synchronousFetchOnInitialisation(boolean enable) {
            this.synchronousFetchOnInitialisation = enable;
            return this;
        }

        public Builder scheduledExecutor(UnleashScheduledExecutor scheduledExecutor) {
            this.scheduledExecutor = scheduledExecutor;
            return this;
        }

        public Builder subscriber(UnleashSubscriber unleashSubscriber) {
            this.unleashSubscriber = unleashSubscriber;
            return this;
        }

        public Builder fallbackStrategy(@Nullable Strategy fallbackStrategy) {
            this.fallbackStrategy = fallbackStrategy;
            return this;
        }

        public Builder toggleBootstrapProvider(@Nullable ToggleBootstrapProvider toggleBootstrapProvider) {
            this.toggleBootstrapProvider = toggleBootstrapProvider;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxy(Proxy proxy, @Nullable String proxyUser, @Nullable String proxyPassword) {
            this.proxy = proxy;
            if (proxyUser != null && proxyPassword != null) {
                this.proxyAuthenticator = new CustomProxyAuthenticator(proxy, proxyUser, proxyPassword);
            }
            return this;
        }

        private String getBackupFile() {
            if (this.backupFile != null) {
                return this.backupFile;
            }
            String fileName = "unleash-" + this.appName + "-repo.json";
            return System.getProperty("java.io.tmpdir") + File.separatorChar + fileName;
        }

        public UnleashConfig build() {
            return new UnleashConfig(this.unleashAPI, this.customHttpHeaders, this.customHttpHeadersProvider, this.appName, this.environment, this.instanceId, this.sdkVersion, this.getBackupFile(), this.projectName, this.namePrefix, this.fetchTogglesInterval, this.sendMetricsInterval, this.disableMetrics, this.contextProvider, this.isProxyAuthenticationByJvmProperties, this.synchronousFetchOnInitialisation, Optional.ofNullable(this.scheduledExecutor).orElseGet(UnleashScheduledExecutorImpl::getInstance), Optional.ofNullable(this.unleashSubscriber).orElseGet(NoOpSubscriber::new), this.fallbackStrategy, this.toggleBootstrapProvider, this.proxy, this.proxyAuthenticator);
        }

        public String getDefaultSdkVersion() {
            String version = Optional.ofNullable(this.getClass().getPackage().getImplementationVersion()).orElse("development");
            return "unleash-client-java:" + version;
        }
    }

    static class CustomProxyAuthenticator
    extends Authenticator {
        private final Proxy proxy;
        private final String proxyUser;
        private final String proxyPassword;

        public CustomProxyAuthenticator(Proxy proxy, String proxyUser, String proxyPassword) {
            this.proxy = proxy;
            this.proxyUser = proxyUser;
            this.proxyPassword = proxyPassword;
        }

        @Override
        @Nullable
        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.proxy.type() == Proxy.Type.HTTP && this.proxy.address() instanceof InetSocketAddress) {
                String proxyHost = ((InetSocketAddress)this.proxy.address()).getHostName();
                int proxyPort = ((InetSocketAddress)this.proxy.address()).getPort();
                if (this.getRequestingHost().equalsIgnoreCase(proxyHost) && proxyPort == this.getRequestingPort()) {
                    return new PasswordAuthentication(this.proxyUser, this.proxyPassword.toCharArray());
                }
            }
            return null;
        }
    }

    static class SystemProxyAuthenticator
    extends Authenticator {
        SystemProxyAuthenticator() {
        }

        @Override
        @Nullable
        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                String proto = this.getRequestingProtocol().toLowerCase();
                String proxyHost = System.getProperty(proto + ".proxyHost", "");
                String proxyPort = System.getProperty(proto + ".proxyPort", "");
                String proxyUser = System.getProperty(proto + ".proxyUser", "");
                String proxyPassword = System.getProperty(proto + ".proxyPassword", "");
                if (this.getRequestingHost().equalsIgnoreCase(proxyHost) && Integer.parseInt(proxyPort) == this.getRequestingPort()) {
                    return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                }
            }
            return null;
        }
    }
}

